/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ContainerListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.plaf.AquaEditorTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabPainter;
import org.netbeans.swing.tabcontrol.plaf.TabState;
import org.openide.awt.HtmlRenderer;

public abstract class AbstractTabCellRenderer
extends JLabel
implements TabCellRenderer {
    private int state = 64;
    TabPainter leftBorder;
    TabPainter rightBorder;
    TabPainter normalBorder;
    private Dimension padding;
    private boolean showClose = true;
    private Rectangle scratch = new Rectangle();

    public AbstractTabCellRenderer(TabPainter tabPainter, TabPainter tabPainter2, TabPainter tabPainter3, Dimension dimension) {
        this.setOpaque(false);
        this.setFocusable(false);
        this.setBorder(tabPainter2);
        this.normalBorder = tabPainter2;
        this.leftBorder = tabPainter;
        this.rightBorder = tabPainter3;
        this.padding = dimension;
    }

    public AbstractTabCellRenderer(TabPainter tabPainter, Dimension dimension) {
        this(tabPainter, tabPainter, tabPainter, dimension);
    }

    @Override
    public final void setShowCloseButton(boolean bl) {
        this.showClose = bl;
    }

    @Override
    public final boolean isShowCloseButton() {
        return this.showClose;
    }

    @Override
    public String getCommandAtPoint(Point point, int n, Rectangle rectangle) {
        Object object;
        this.setBounds(rectangle);
        this.setState(n);
        if (this.supportsCloseButton(this.getBorder()) && this.isShowCloseButton()) {
            object = (TabPainter)this.getBorder();
            object.getCloseButtonRectangle(this, this.scratch, rectangle);
            if (this.getClass() != AquaEditorTabCellRenderer.class) {
                this.scratch.x -= 3;
                this.scratch.y -= 3;
                this.scratch.width += 6;
                this.scratch.height += 6;
            }
            if (this.scratch.contains(point)) {
                return "close";
            }
        }
        if (((Polygon)(object = this.getTabShape(n, rectangle))).contains(point)) {
            return "select";
        }
        return null;
    }

    @Override
    public String getCommandAtPoint(Point point, int n, Rectangle rectangle, int n2, int n3, int n4) {
        String string = null;
        string = n2 == 2 && n3 == 502 ? "close" : this.getCommandAtPoint(point, n, rectangle);
        if (string != null) {
            if ("select" == string) {
                boolean bl;
                boolean bl2 = bl = this.isClipLeft() || this.isClipRight();
                if (bl && n3 == 502 && n2 == 1 || !bl && n3 == 501 && n2 == 1) {
                    return string;
                }
            } else if ("close" == string && n3 == 502 && this.isShowCloseButton()) {
                if ((n4 & 0x40) != 0) {
                    return "closeAll";
                }
                if ((n4 & 0x200) != 0 && n2 != 2) {
                    return "closeAllButThis";
                }
                return string;
            }
        }
        return null;
    }

    protected final boolean isArmed() {
        return this.isPressed() || (this.state & 4) != 0;
    }

    protected final boolean isActive() {
        return (this.state & 0x20) != 0;
    }

    protected final boolean isPressed() {
        return (this.state & 8) != 0;
    }

    protected final boolean isSelected() {
        return (this.state & 0x10) != 0;
    }

    protected final boolean isClipRight() {
        return (this.state & 1) != 0;
    }

    protected final boolean isClipLeft() {
        return (this.state & 2) != 0;
    }

    protected final boolean isLeftmost() {
        return (this.state & 0x80) != 0;
    }

    protected final boolean isRightmost() {
        return (this.state & 0x100) != 0;
    }

    protected final boolean isAttention() {
        return (this.state & 0x4000) != 0;
    }

    protected final boolean isNextTabSelected() {
        return (this.state & 0x400) != 0;
    }

    protected final boolean isNextTabArmed() {
        return (this.state & 0x8000) != 0;
    }

    protected final boolean isPreviousTabSelected() {
        return (this.state & 0x800) != 0;
    }

    @Override
    public Dimension getPadding() {
        return new Dimension(this.padding);
    }

    protected final void setState(int n) {
        boolean bl;
        boolean bl2 = bl = this.state != n;
        if (bl) {
            int n2 = this.state;
            this.state = n;
            int n3 = this.stateChanged(n2, n);
            if ((n3 & this.state) != n) {
                this.state = n;
                throw new IllegalStateException("StateChanged may add, but not remove bits from the state bitmask.  Expected state: " + TabState.stateToString(n) + " but got " + TabState.stateToString(this.state));
            }
            this.state = n3;
        }
    }

    public final int getState() {
        return this.state;
    }

    @Override
    public final JComponent getRendererComponent(TabData tabData, Rectangle rectangle, int n) {
        this.setBounds(rectangle);
        this.setText(tabData.getText());
        this.setIcon(tabData.getIcon());
        this.setState(n);
        return this;
    }

    protected int stateChanged(int n, int n2) {
        Color color;
        Color color2;
        Color color3 = this.isSelected() ? (this.isActive() ? this.getSelectedActivatedBackground() : this.getSelectedBackground()) : (color2 = UIManager.getColor("control"));
        Color color4 = this.isSelected() ? (this.isActive() ? this.getSelectedActivatedForeground() : this.getSelectedForeground()) : (color = UIManager.getColor("textText"));
        if (this.isArmed() && this.isPressed() && (this.isClipLeft() || this.isClipRight())) {
            color2 = this.getSelectedActivatedBackground();
            color = this.getSelectedActivatedForeground();
        }
        if (this.isClipLeft()) {
            this.setIcon(null);
            this.setBorder(this.leftBorder);
        } else if (this.isClipRight()) {
            this.setBorder(this.rightBorder);
        } else {
            this.setBorder(this.normalBorder);
        }
        this.setBackground(color2);
        this.setForeground(color);
        return n2;
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void validate() {
    }

    @Override
    public void repaint(long l) {
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    protected final void firePropertyChange(String string, Object object, Object object2) {
    }

    @Override
    public final void addHierarchyBoundsListener(HierarchyBoundsListener hierarchyBoundsListener) {
    }

    @Override
    public final void addHierarchyListener(HierarchyListener hierarchyListener) {
    }

    @Override
    public final void addContainerListener(ContainerListener containerListener) {
    }

    @Override
    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        if (this.getBorder() instanceof TabPainter) {
            ((TabPainter)this.getBorder()).paintInterior(graphics, this);
        }
        this.paintIconAndText(graphics);
    }

    protected int getCaptionYAdjustment() {
        return -1;
    }

    protected int getIconYAdjustment() {
        return -1;
    }

    protected void paintIconAndText(Graphics graphics) {
        int n;
        int n2;
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
        int n3 = fontMetrics.getHeight();
        Insets insets = this.getInsets();
        int n4 = this.getHeight() - (insets.top + insets.bottom);
        int n5 = n4 > n3 ? n3 + insets.top + (n4 / 2 - n3 / 2) - 3 : n3 + insets.top;
        int n6 = this.getPixelsToAddToSelection() != 0 ? this.getPixelsToAddToSelection() / 2 : 0;
        Icon icon = this.getIcon();
        if (!this.isClipLeft() && icon != null && icon.getIconWidth() > 0 && icon.getIconHeight() > 0) {
            n2 = n4 > icon.getIconHeight() ? insets.top + (n4 / 2 - icon.getIconHeight() / 2) + 2 : insets.top + 2;
            int n7 = insets.left + n6;
            icon.paintIcon(this, graphics, n7, n2 += this.getIconYAdjustment());
            n = n7 + icon.getIconWidth() + this.getIconTextGap();
        } else {
            n = insets.left + n6;
        }
        if (icon != null && icon.getIconWidth() == 0) {
            n += 5;
        }
        n5 += this.getCaptionYAdjustment();
        n2 = this.getWidth() - (n + insets.right);
        if (this.isClipLeft()) {
            String string = AbstractTabCellRenderer.preTruncateString(this.getText(), graphics, n2 - 4);
            Graphics2D graphics2D = null;
            Shape shape = null;
            if (graphics instanceof Graphics2D) {
                graphics2D = (Graphics2D)graphics;
                shape = graphics2D.getClip();
                graphics2D.clipRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
            }
            n2 = (int)HtmlRenderer.renderString((String)string, (Graphics)graphics, (int)n, (int)n5, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (Font)this.getFont(), (Color)this.getForeground(), (int)0, (boolean)false);
            n = this.getWidth() - insets.right - n2;
            n2 = (int)HtmlRenderer.renderString((String)string, (Graphics)graphics, (int)n, (int)n5, (int)n2, (int)n3, (Font)this.getFont(), (Color)this.getForeground(), (int)0, (boolean)true);
            if (null != graphics2D) {
                graphics2D.setClip(shape);
            }
        } else {
            String string = this.isClipRight() ? this.getText() + "..." : this.getText();
            n2 = (int)HtmlRenderer.renderString((String)string, (Graphics)graphics, (int)n, (int)n5, (int)n2, (int)n3, (Font)this.getFont(), (Color)this.getForeground(), (int)1, (boolean)true);
        }
    }

    static String preTruncateString(String string, Graphics graphics, int n) {
        String string2;
        if (string.length() < 3) {
            return string;
        }
        if ((string = AbstractTabCellRenderer.stripHTML(string)).length() < 2) {
            return "..." + string;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.stringWidth("...");
        int n3 = string.length() - 2;
        String string3 = string2 = string.substring(n3);
        while (fontMetrics.stringWidth(string2) + n2 < n && --n3 > 0) {
            string3 = string2;
            string2 = string.substring(n3);
        }
        return "..." + string3;
    }

    static boolean isHTML(String string) {
        boolean bl = string.startsWith("<html>") || string.startsWith("<HTML>");
        return bl;
    }

    static String stripHTML(String string) {
        if (AbstractTabCellRenderer.isHTML(string)) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            char[] cArray = string.toCharArray();
            boolean bl = false;
            for (int i = 0; i < cArray.length; ++i) {
                boolean bl2 = bl;
                if (!bl) {
                    if (cArray[i] == '<') {
                        bl = true;
                    }
                } else if (cArray[i] == '>') {
                    bl = false;
                }
                if (bl || bl2 != bl) continue;
                stringBuffer.append(cArray[i]);
            }
            return stringBuffer.toString();
        }
        return string;
    }

    @Override
    public Polygon getTabShape(int n, Rectangle rectangle) {
        this.setBounds(rectangle);
        this.setState(n);
        if (this.getBorder() instanceof TabPainter) {
            TabPainter tabPainter = (TabPainter)this.getBorder();
            Polygon polygon = tabPainter.getInteriorPolygon(this);
            polygon.translate(rectangle.x, rectangle.y);
            return polygon;
        }
        return new Polygon(new int[]{rectangle.x, rectangle.x + rectangle.width - 1, rectangle.x + rectangle.width - 1, rectangle.x}, new int[]{rectangle.y, rectangle.y, rectangle.y + rectangle.height - 1, rectangle.y + rectangle.height - 1}, 4);
    }

    @Override
    public Color getSelectedBackground() {
        Color color = UIManager.getColor("control");
        Color color2 = UIManager.getColor("controlHighlight");
        if (color == null) {
            color = Color.GRAY;
        }
        if (color2 == null) {
            color2 = Color.WHITE;
        }
        Color color3 = ColorUtil.adjustTowards(color, 30, color2);
        return color3;
    }

    @Override
    public Color getSelectedActivatedBackground() {
        return UIManager.getColor("TabRenderer.selectedActivatedBackground");
    }

    public Color getSelectedActivatedForeground() {
        return UIManager.getColor("TabRenderer.selectedActivatedForeground");
    }

    public Color getSelectedForeground() {
        return UIManager.getColor("TabRenderer.selectedForeground");
    }

    protected boolean inCloseButton() {
        return (this.state & 0x200) != 0;
    }

    @Override
    public int getPixelsToAddToSelection() {
        return 0;
    }

    private boolean supportsCloseButton(Border border) {
        if (border instanceof TabPainter) {
            return ((TabPainter)border).supportsCloseButton(this);
        }
        return false;
    }
}

