/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import org.netbeans.swing.popupswitcher.SwitcherTableItem;
import org.netbeans.swing.tabcontrol.ButtonPopupSwitcher;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.event.ComplexListDataEvent;
import org.netbeans.swing.tabcontrol.event.ComplexListDataListener;
import org.openide.windows.TopComponent;

public class TabListPopupAction
extends AbstractAction {
    private TabDisplayer displayer;
    private final ComplexListDataListener listListener = new ComplexListDataListener(){

        private void changed() {
            TabListPopupAction.this.displayer.getModel().removeComplexListDataListener(this);
            ButtonPopupSwitcher.hidePopup();
        }

        @Override
        public void indicesAdded(ComplexListDataEvent complexListDataEvent) {
            this.changed();
        }

        @Override
        public void indicesRemoved(ComplexListDataEvent complexListDataEvent) {
            this.changed();
        }

        @Override
        public void indicesChanged(ComplexListDataEvent complexListDataEvent) {
            this.changed();
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            this.changed();
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.changed();
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            this.changed();
        }
    };

    public TabListPopupAction(TabDisplayer tabDisplayer) {
        this.displayer = tabDisplayer;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("pressed".equals(actionEvent.getActionCommand())) {
            Object object;
            JComponent jComponent = (JComponent)actionEvent.getSource();
            Point point = new Point(jComponent.getWidth(), jComponent.getHeight());
            SwingUtilities.convertPointToScreen(point, jComponent);
            if (!ButtonPopupSwitcher.isShown()) {
                object = this.createSwitcherItems(this.displayer);
                Arrays.sort((Object[])object);
                ButtonPopupSwitcher.selectItem(jComponent, (SwitcherTableItem[])object, point.x, point.y);
            } else {
                ButtonPopupSwitcher.hidePopup();
            }
            if (jComponent instanceof AbstractButton) {
                object = (AbstractButton)jComponent;
                ((AbstractButton)object).getModel().setPressed(false);
                ((AbstractButton)object).getModel().setRollover(false);
                ((AbstractButton)object).getModel().setArmed(false);
                ((Component)object).repaint();
            }
        }
    }

    private SwitcherTableItem[] createSwitcherItems(TabDisplayer tabDisplayer) {
        tabDisplayer.getModel().removeComplexListDataListener(this.listListener);
        tabDisplayer.getModel().addComplexListDataListener(this.listListener);
        List<TabData> list = tabDisplayer.getModel().getTabs();
        SwitcherTableItem[] switcherTableItemArray = new SwitcherTableItem[list.size()];
        int n = 0;
        int n2 = tabDisplayer.getSelectionModel().getSelectedIndex();
        TabData tabData = n2 >= 0 ? tabDisplayer.getModel().getTab(n2) : null;
        for (TabData tabData2 : list) {
            String string;
            String string2;
            if (tabData2.getComponent() instanceof TopComponent) {
                TopComponent topComponent = (TopComponent)tabData2.getComponent();
                string2 = topComponent.getDisplayName();
                if (string2 == null) {
                    string2 = topComponent.getName();
                }
                if ((string = topComponent.getHtmlDisplayName()) == null) {
                    string = string2;
                }
            } else {
                string2 = string = tabData2.getText();
            }
            switcherTableItemArray[n++] = new SwitcherTableItem(new ActivatableTab(tabData2), string2, string, tabData2.getIcon(), tabData2 == tabData);
        }
        return switcherTableItemArray;
    }

    private class ActivatableTab
    implements SwitcherTableItem.Activatable {
        private TabData tab;

        private ActivatableTab(TabData tabData) {
            this.tab = tabData;
        }

        @Override
        public void activate() {
            if (this.tab != null) {
                this.selectTab(this.tab);
            }
        }

        private void selectTab(TabData tabData) {
            int n;
            List<TabData> list = TabListPopupAction.this.displayer.getModel().getTabs();
            int n2 = -1;
            for (n = 0; n < list.size(); ++n) {
                if (!tabData.equals(list.get(n))) continue;
                n2 = n;
                break;
            }
            if (n2 != -1) {
                n = TabListPopupAction.this.displayer.getSelectionModel().getSelectedIndex();
                TabListPopupAction.this.displayer.getSelectionModel().setSelectedIndex(n2);
                if (TabListPopupAction.this.displayer.getType() == 1 && n2 >= 0 && n2 == n) {
                    TabListPopupAction.this.displayer.getUI().makeTabVisible(n2);
                }
            }
        }
    }
}

