/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html.markup;

import com.javafx.tools.doclets.formats.html.markup.Comment;
import com.javafx.tools.doclets.formats.html.markup.DocType;
import com.javafx.tools.doclets.formats.html.markup.HtmlAttr;
import com.javafx.tools.doclets.formats.html.markup.HtmlDocument;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.formats.html.markup.HtmlWriter;
import com.javafx.tools.doclets.formats.html.markup.StringContent;
import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.sun.javadoc.ClassDoc;
import java.io.File;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public abstract class HtmlDocWriter
extends HtmlWriter {
    public HtmlDocWriter(Configuration configuration, String filename) throws IOException {
        super(configuration, null, configuration.destDirName + filename, configuration.docencoding);
        configuration.message.notice("doclet.Generating_0", new File(configuration.destDirName, filename));
    }

    public HtmlDocWriter(Configuration configuration, String path, String filename) throws IOException {
        super(configuration, configuration.destDirName + path, filename, configuration.docencoding);
        configuration.message.notice("doclet.Generating_0", new File(configuration.destDirName, (path.length() > 0 ? path + File.separator : "") + filename));
    }

    public abstract Configuration configuration();

    public void printHyperLink(String link, String where, String label, boolean strong) {
        this.print(this.getHyperLinkString(link, where, label, strong, "", "", ""));
    }

    public void printHyperLink(String link, String where, String label) {
        this.printHyperLink(link, where, label, false);
    }

    public void printHyperLink(String link, String where, String label, boolean strong, String stylename) {
        this.print(this.getHyperLinkString(link, where, label, strong, stylename, "", ""));
    }

    public String getHyperLinkString(String link, String where, String label, boolean strong) {
        return this.getHyperLinkString(link, where, label, strong, "", "", "");
    }

    public String getHyperLinkString(String link, String where, String label, boolean strong, String stylename) {
        return this.getHyperLinkString(link, where, label, strong, stylename, "", "");
    }

    public Content getHyperLink(String link, String where, Content label) {
        return this.getHyperLink(link, where, label, "", "");
    }

    public String getHyperLinkString(String link, String where, String label, boolean strong, String stylename, String title, String target) {
        StringBuffer retlink = new StringBuffer();
        retlink.append("<a href=\"");
        retlink.append(link);
        if (where != null && where.length() != 0) {
            retlink.append("#");
            retlink.append(where);
        }
        retlink.append("\"");
        if (title != null && title.length() != 0) {
            retlink.append(" title=\"" + title + "\"");
        }
        if (target != null && target.length() != 0) {
            retlink.append(" target=\"" + target + "\"");
        }
        retlink.append(">");
        if (stylename != null && stylename.length() != 0) {
            retlink.append("<FONT CLASS=\"");
            retlink.append(stylename);
            retlink.append("\">");
        }
        if (strong) {
            retlink.append("<span class=\"strong\">");
        }
        retlink.append(label);
        if (strong) {
            retlink.append("</span>");
        }
        if (stylename != null && stylename.length() != 0) {
            retlink.append("</FONT>");
        }
        retlink.append("</a>");
        return retlink.toString();
    }

    public Content getHyperLink(String link, String where, Content label, String title, String target) {
        if (where != null && where.length() != 0) {
            link = link + "#" + where;
        }
        HtmlTree anchor = HtmlTree.A(link, label);
        if (title != null && title.length() != 0) {
            anchor.addAttr(HtmlAttr.TITLE, title);
        }
        if (target != null && target.length() != 0) {
            anchor.addAttr(HtmlAttr.TARGET, target);
        }
        return anchor;
    }

    public Content getHyperLink(String link, Content label) {
        return this.getHyperLink(link, "", label);
    }

    public String getHyperLinkString(String link, String label) {
        return this.getHyperLinkString(link, "", label, false);
    }

    public void printPkgName(ClassDoc cd) {
        this.print(this.getPkgName(cd));
    }

    public String getPkgName(ClassDoc cd) {
        String pkgName = cd.containingPackage().name();
        if (pkgName.length() > 0) {
            pkgName = pkgName + ".";
            return pkgName;
        }
        return "";
    }

    public void printMemberDetailsListStartTag() {
        if (!this.getMemberDetailsListPrinted()) {
            this.dl();
            this.memberDetailsListPrinted = true;
        }
    }

    public void printMemberDetailsListEndTag() {
        if (this.getMemberDetailsListPrinted()) {
            this.dlEnd();
            this.memberDetailsListPrinted = false;
        }
    }

    public boolean getMemberDetailsListPrinted() {
        return this.memberDetailsListPrinted;
    }

    public void printFramesetDocument(String title, boolean noTimeStamp, Content frameset) {
        DocType htmlDocType = DocType.Frameset();
        Comment htmlComment = new Comment(this.configuration.getText("doclet.New_Page"));
        HtmlTree head = new HtmlTree(HtmlTag.HEAD);
        if (!noTimeStamp) {
            Comment headComment = new Comment("Generated by javadoc on " + this.today());
            ((Content)head).addContent(headComment);
        }
        if (this.configuration.charset.length() > 0) {
            HtmlTree meta = HtmlTree.META("Content-Type", "text/html", this.configuration.charset);
            ((Content)head).addContent(meta);
        }
        HtmlTree windowTitle = HtmlTree.TITLE(new StringContent(title));
        ((Content)head).addContent(windowTitle);
        ((Content)head).addContent(this.getFramesetJavaScript());
        HtmlTree htmlTree = HtmlTree.HTML(this.configuration.getLocale().getLanguage(), head, frameset);
        HtmlDocument htmlDocument = new HtmlDocument(htmlDocType, htmlComment, htmlTree);
        this.print(htmlDocument.toString());
    }

    public String spaces(int len) {
        String space = "";
        for (int i = 0; i < len; ++i) {
            space = space + " ";
        }
        return space;
    }

    public void printBodyHtmlEnd() {
        this.println();
        this.bodyEnd();
        this.htmlEnd();
    }

    public void printFooter() {
        this.printBodyHtmlEnd();
    }

    public void printFrameFooter() {
        this.htmlEnd();
    }

    public void printNbsps() {
        this.print("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
    }

    public String today() {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault());
        return calendar.getTime().toString();
    }
}

