/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.packager.bundlers;

import com.sun.javafx.tools.packager.Log;
import com.sun.javafx.tools.packager.bundlers.BundleParams;
import com.sun.javafx.tools.packager.bundlers.Bundler;
import com.sun.javafx.tools.packager.bundlers.IOUtils;
import com.sun.javafx.tools.resource.mac.MacResources;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class MacAppBundler
extends Bundler {
    private BundleParams params = null;
    private File configRoot = null;
    public static final String MAC_BUNDLER_PREFIX = "package/macosx" + File.separator;
    private static final String EXECUTABLE_NAME = "JavaAppLauncher";
    static final String TEMPLATE_BUNDLE_ICON = "GenericApp.icns";
    private static final String OS_TYPE_CODE = "APPL";
    private static final String LAUNCHER_CLASS = "com.javafx.main.Main";
    private static final String TEMPLATE_INFO_PLIST = "Info.plist.template";

    public MacAppBundler() {
        this.baseResourceLoader = MacResources.class;
    }

    protected void setBuildRoot(File dir) {
        super.setBuildRoot(dir);
        this.configRoot = new File(dir, "macosx");
        this.configRoot.mkdirs();
    }

    boolean validate(BundleParams p) throws Bundler.UnsupportedPlatformException, Bundler.ConfigException {
        if (p.type != Bundler.BundleType.ALL && p.type != Bundler.BundleType.IMAGE) {
            return false;
        }
        return this.doValidate(p);
    }

    boolean doValidate(BundleParams p) throws Bundler.UnsupportedPlatformException, Bundler.ConfigException {
        if (!System.getProperty("os.name").toLowerCase().startsWith("mac")) {
            throw new Bundler.UnsupportedPlatformException();
        }
        if (p.getMainApplicationJar() == null) {
            throw new Bundler.ConfigException("Main application jar is missing.", "Make sure to use fx:jar task to create main application jar.");
        }
        this.testRuntime(p, "Contents/Home/jre/lib/jfxrt.jar");
        this.testRuntime(p, "Contents/Info.plist");
        return true;
    }

    private File getConfig_InfoPlist() {
        return new File(this.configRoot, "Info.plist");
    }

    private File getConfig_Icon() {
        return new File(this.configRoot, this.params.name + ".icns");
    }

    private void prepareConfigFiles() throws IOException {
        File infoPlistFile = this.getConfig_InfoPlist();
        infoPlistFile.createNewFile();
        this.writeInfoPlist(infoPlistFile);
        this.prepareIcon();
    }

    public boolean bundle(BundleParams p, File outputDirectory) {
        return this.doBundle(p, outputDirectory, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doBundle(BundleParams p, File outputDirectory, boolean dependentTask) {
        try {
            this.params = p;
            this.prepareConfigFiles();
            File rootDirectory = new File(outputDirectory, p.name + ".app");
            IOUtils.deleteRecursive(rootDirectory);
            rootDirectory.mkdirs();
            if (!dependentTask) {
                Log.info("Creating app bundle: " + rootDirectory.getAbsolutePath());
            }
            File contentsDirectory = new File(rootDirectory, "Contents");
            contentsDirectory.mkdirs();
            File macOSDirectory = new File(contentsDirectory, "MacOS");
            macOSDirectory.mkdirs();
            File javaDirectory = new File(contentsDirectory, "Java");
            javaDirectory.mkdirs();
            File plugInsDirectory = new File(contentsDirectory, "PlugIns");
            plugInsDirectory.mkdirs();
            File resourcesDirectory = new File(contentsDirectory, "Resources");
            resourcesDirectory.mkdirs();
            File pkgInfoFile = new File(contentsDirectory, "PkgInfo");
            pkgInfoFile.createNewFile();
            this.writePkgInfo(pkgInfoFile);
            File executableFile = new File(macOSDirectory, EXECUTABLE_NAME);
            IOUtils.copyFromURL(MacResources.class.getResource(executableFile.getName()), executableFile);
            executableFile.setExecutable(true, false);
            this.copyRuntime(plugInsDirectory);
            this.copyClassPathEntries(javaDirectory);
            IOUtils.copyFile(this.getConfig_Icon(), new File(resourcesDirectory, TEMPLATE_BUNDLE_ICON));
            IOUtils.copyFile(this.getConfig_InfoPlist(), new File(contentsDirectory, "Info.plist"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (!this.verbose) {
                this.cleanupConfigFiles();
            } else {
                Log.info("Config files are saved to " + this.configRoot.getAbsolutePath() + ". Use them to customize package.");
            }
        }
        return true;
    }

    protected void cleanupConfigFiles() {
        if (this.getConfig_Icon() != null) {
            this.getConfig_Icon().delete();
        }
        if (this.getConfig_InfoPlist() != null) {
            this.getConfig_InfoPlist().delete();
        }
    }

    public String toString() {
        return "Mac Application Bundler";
    }

    private void copyClassPathEntries(File javaDirectory) throws IOException {
        if (this.params.appResources == null) {
            throw new RuntimeException("Null app resources?");
        }
        File srcdir = this.params.appResources.getBaseDirectory();
        for (String fname : this.params.appResources.getIncludedFiles()) {
            IOUtils.copyFile(new File(srcdir, fname), new File(javaDirectory, fname));
        }
    }

    private void copyRuntime(File plugInsDirectory) throws IOException {
        String jliSymlink = "Contents/MacOS/libjli.dylib";
        String jliFileRelative = "../Home/jre/lib/jli/libjli.dylib";
        File srcdir = this.params.runtime.getBaseDirectory();
        File destDir = new File(plugInsDirectory, srcdir.getName());
        Set<String> filesToCopy = this.params.runtime.getIncludedFiles();
        filesToCopy.remove(jliSymlink);
        for (String fname : filesToCopy) {
            IOUtils.copyFile(new File(srcdir, fname), new File(destDir, fname));
        }
        File jli = new File(destDir, jliSymlink);
        if (jli.exists()) {
            ProcessBuilder pb = new ProcessBuilder("rm", "-f", jli.getAbsolutePath());
            IOUtils.exec(pb, this.verbose);
        }
        File macFolder = new File(destDir, "Contents/MacOS");
        macFolder.mkdirs();
        ProcessBuilder pb = new ProcessBuilder("ln", "-s", jliFileRelative, ".");
        pb.directory(jli.getParentFile());
        IOUtils.exec(pb, this.verbose);
    }

    private void prepareIcon() throws IOException {
        File icon = this.params.icon;
        if (icon == null) {
            this.fetchResource(MAC_BUNDLER_PREFIX + this.params.name + ".icns", "icon", TEMPLATE_BUNDLE_ICON, this.getConfig_Icon());
        } else {
            this.fetchResource(MAC_BUNDLER_PREFIX + this.params.name + ".icns", "icon", icon, this.getConfig_Icon());
        }
    }

    private String getBundleName() {
        if (this.params.identifier != null) {
            return this.params.identifier;
        }
        String nm = this.params.getMainClassName();
        if (nm.length() > 16) {
            nm = nm.substring(0, 16);
        }
        return nm;
    }

    private String getBundleIdentifier() {
        if (this.params.identifier != null) {
            return this.params.identifier;
        }
        return "unknown." + this.params.applicationClass;
    }

    private void writeInfoPlist(File file) throws IOException {
        Log.verbose("Preparing Info.plist: " + file.getAbsolutePath());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("DEPLOY_ICON_FILE", this.params.icon == null ? TEMPLATE_BUNDLE_ICON : this.params.icon.getName());
        data.put("DEPLOY_BUNDLE_IDENTIFIER", this.getBundleIdentifier());
        data.put("DEPLOY_BUNDLE_NAME", this.getBundleName());
        data.put("DEPLOY_BUNLDE_COPYRIGHT", this.params.copyright != null ? this.params.copyright : "Unknown");
        data.put("DEPLOY_JAVA_RUNTIME_NAME", this.params.runtime.getBaseDirectory().getName());
        data.put("DEPLOY_BUNDLE_SHORT_VERSION", this.params.appVersion != null ? this.params.appVersion : "1.0");
        data.put("DEPLOY_BUNDLE_CATEGORY", this.params.applicationCategory != null ? this.params.applicationCategory : "unknown");
        StringBuilder sb = new StringBuilder();
        List<String> jvmOptions = this.params.getAllJvmOptions();
        for (String o : jvmOptions) {
            sb.append("    <string>" + o + "</string>\n");
        }
        data.put("DEPLOY_JVM_OPTIONS", sb.toString());
        BufferedWriter w = new BufferedWriter(new FileWriter(file));
        w.write(this.preprocessTextResource(MAC_BUNDLER_PREFIX + this.getConfig_InfoPlist().getName(), "Bundle config file", TEMPLATE_INFO_PLIST, data));
        ((Writer)w).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePkgInfo(File file) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        String signature = "????";
        try {
            out.write(OS_TYPE_CODE + signature);
            ((Writer)out).flush();
        }
        finally {
            ((Writer)out).close();
        }
    }
}

