/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import org.netbeans.lib.profiler.server.ProfilerRuntime;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Timers;

public class ProfilerRuntimeCPUCodeRegion
extends ProfilerRuntime {
    protected static long[] codeRegionResults = new long[0];
    protected static int newBufSize;
    protected static int bufSize;
    protected static int curIdx;
    protected static long invCount;
    protected static boolean codeRegionInstrumentationDisabled;

    public static void setCPUResBufSize(int n) {
        newBufSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] getProfilingResults() {
        long[] lArray = codeRegionResults;
        synchronized (codeRegionResults) {
            int n = invCount < (long)bufSize ? (int)invCount : bufSize;
            long[] lArray2 = new long[++n];
            lArray2[0] = (int)invCount;
            if (invCount < (long)bufSize) {
                System.arraycopy(codeRegionResults, 0, lArray2, 1, (int)invCount);
            } else {
                System.arraycopy(codeRegionResults, curIdx, lArray2, 1, bufSize - curIdx);
                System.arraycopy(codeRegionResults, 0, lArray2, bufSize - curIdx + 1, curIdx);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return lArray2;
        }
    }

    public static void codeRegionEntry() {
        if (codeRegionInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (!threadInfo.isInitialized()) {
            threadInfo.initialize();
        }
        threadInfo.inCallGraph = true;
        threadInfo.absEntryTime = Timers.getCurrentTimeInCounts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void codeRegionExit() {
        if (codeRegionInstrumentationDisabled) {
            return;
        }
        long l = Timers.getCurrentTimeInCounts();
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (!threadInfo.isInitialized() || !threadInfo.inCallGraph) {
            return;
        }
        l -= threadInfo.absEntryTime;
        long[] lArray = codeRegionResults;
        synchronized (codeRegionResults) {
            ProfilerRuntimeCPUCodeRegion.codeRegionResults[ProfilerRuntimeCPUCodeRegion.curIdx++] = l;
            ++invCount;
            if (curIdx == bufSize) {
                curIdx = 0;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            threadInfo.inCallGraph = false;
            return;
        }
    }

    public static void enableProfiling(boolean bl) {
        if (bl) {
            ProfilerRuntimeCPUCodeRegion.createNewDataStructures();
            codeRegionInstrumentationDisabled = false;
        } else {
            codeRegionInstrumentationDisabled = true;
            ProfilerRuntimeCPUCodeRegion.clearDataStructures();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetProfilerCollectors() {
        long[] lArray = codeRegionResults;
        synchronized (codeRegionResults) {
            bufSize = newBufSize;
            codeRegionResults = new long[bufSize];
            invCount = 0L;
            curIdx = 0;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void clearDataStructures() {
        ProfilerRuntime.clearDataStructures();
        long[] lArray = codeRegionResults;
        synchronized (codeRegionResults) {
            codeRegionResults = new long[0];
            invCount = 0L;
            curIdx = 0;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    protected static void monitorEntryRegion(Thread thread, Object object) {
        if (codeRegionInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (!threadInfo.isInitialized() || !threadInfo.inCallGraph) {
            return;
        }
        threadInfo.lastWaitStartTime = Timers.getCurrentTimeInCounts();
    }

    protected static void monitorExitRegion(Thread thread, Object object) {
        if (codeRegionInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo == null || !threadInfo.inCallGraph) {
            return;
        }
        threadInfo.absEntryTime += Timers.getCurrentTimeInCounts() - threadInfo.lastWaitStartTime;
    }

    protected static void sleepEntryRegion() {
        if (codeRegionInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (!threadInfo.isInitialized() || !threadInfo.inCallGraph) {
            return;
        }
        threadInfo.lastWaitStartTime = Timers.getCurrentTimeInCounts();
    }

    protected static void sleepExitRegion() {
        if (codeRegionInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (!threadInfo.isInitialized() || !threadInfo.inCallGraph) {
            return;
        }
        threadInfo.absEntryTime += Timers.getCurrentTimeInCounts() - threadInfo.lastWaitStartTime;
    }

    protected static void waitEntryRegion() {
        if (codeRegionInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (!threadInfo.isInitialized() || !threadInfo.inCallGraph) {
            return;
        }
        threadInfo.lastWaitStartTime = Timers.getCurrentTimeInCounts();
    }

    protected static void waitExitRegion() {
        if (codeRegionInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (!threadInfo.isInitialized() || !threadInfo.inCallGraph) {
            return;
        }
        threadInfo.absEntryTime += Timers.getCurrentTimeInCounts() - threadInfo.lastWaitStartTime;
    }
}

