/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.ProfilingEventListener;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.client.ProfilingPointsProcessor;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.common.GlobalProfilingSettings;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.common.filters.DefinedFilterSets;
import org.netbeans.lib.profiler.common.filters.GlobalFilters;
import org.netbeans.lib.profiler.global.CalibrationDataFileIO;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.instrumentation.BadLocationException;
import org.netbeans.lib.profiler.instrumentation.InstrumentationException;
import org.netbeans.lib.profiler.results.CCTProvider;
import org.netbeans.lib.profiler.results.ProfilingResultsDispatcher;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUProfilingResultListener;
import org.netbeans.lib.profiler.results.cpu.FlatProfileBuilder;
import org.netbeans.lib.profiler.results.cpu.cct.CCTResultsFilter;
import org.netbeans.lib.profiler.results.cpu.cct.TimeCollector;
import org.netbeans.lib.profiler.results.cpu.marking.MarkingEngine;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.MemoryProfilingResultsListener;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.results.threads.ThreadsDataManager;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryModels;
import org.netbeans.lib.profiler.wireprotocol.Response;
import org.netbeans.lib.profiler.wireprotocol.WireIO;
import org.netbeans.modules.profiler.GestureSubmitter;
import org.netbeans.modules.profiler.LiveResultsWindow;
import org.netbeans.modules.profiler.ProfilerControlPanel2;
import org.netbeans.modules.profiler.ProfilerModule;
import org.netbeans.modules.profiler.ProfilingMonitor;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.TelemetryOverviewPanel;
import org.netbeans.modules.profiler.ThreadsWindow;
import org.netbeans.modules.profiler.api.GlobalStorage;
import org.netbeans.modules.profiler.api.JavaPlatform;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.spi.SessionListener;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public abstract class NetBeansProfiler
extends Profiler {
    private static final Logger LOGGER = Logger.getLogger(NetBeansProfiler.class.getName());
    private static final String CALIBRATION_FAILED_MESSAGE = NbBundle.getMessage(ProfilerModule.class, (String)"ProfilerModule_CalibrationFailedMessage");
    private static final String CALIBRATION_MISSING_MESSAGE = NbBundle.getMessage(ProfilerModule.class, (String)"NetBeansProfiler_MustCalibrateFirstMsg");
    private static final String CALIBRATION_MISSING_SHORT_MESSAGE = NbBundle.getMessage(ProfilerModule.class, (String)"NetBeansProfiler_MustCalibrateFirstShortMsg");
    private static final String PROGRESS_DIALOG_CAPTION = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_ProgressDialogCaption");
    private static final String ENTIRE_APPLICATION_PROFILING_WARNING = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_EntireApplicationProfilingWarning");
    private static final String DIRECTORY_DOES_NOT_EXIST_MESSAGE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_DirectoryDoesNotExistMessage");
    private static final String DIRECTORY_IS_WRITE_PROTECTED_MESSAGE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_DirectoryIsWriteProtectedMessage");
    private static final String ERROR_LOADING_PROFILING_SETTINGS_MESSAGE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_ErrorLoadingProfilingSettingsMessage");
    private static final String ERROR_SAVING_PROFILING_SETTINGS_MESSAGE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_ErrorSavingProfilingSettingsMessage");
    private static final String ERROR_SAVING_FILTER_SETS_MESSAGE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_ErrorSavingFilterSetsMessage");
    private static final String CANNOT_FIND_LIBS_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_CannotFindLibsMsg");
    private static final String ENGINE_INIT_FAILED_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_EngineInitFailedMsg");
    private static final String INITIAL_CALIBRATION_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_InitialCalibrationMsg");
    private static final String TERMINATE_VM_ON_EXIT_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_TerminateVMOnExitMsg");
    private static final String TAKE_SNAPSHOT_ON_EXIT_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_TakeSnapshotOnExitMsg");
    private static final String TAKE_SNAPSHOT_ON_EXIT_DIALOG_TITLE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_TakeSnapshotOnExitDialogTitle");
    private static final String TARGET_APP_NOT_RESPONDING_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_TargetAppNotRespondingMsg");
    private static final String TARGET_APP_NOT_RESPONDING_DIALOG_TITLE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_TargetAppNotRespondingDialogTitle");
    private static final String MODIFYING_INSTRUMENTATION_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_ModifyingInstrumentationMsg");
    private static final String CANCEL_BTN = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_CancelBtn");
    private static final String GLOBAL_FILTERS_FILENAME = "filters";
    private static final String DEFINED_FILTERSETS_FILENAME = "filtersets";
    private static final String DEFAULT_FILE_SUFFIX = "-default";
    private static boolean initialized = false;
    boolean shouldDisplayDialog = true;
    private final ProfilerIDESettings ideSettings = ProfilerIDESettings.getInstance();
    private ProfilingMonitor monitor = null;
    private TargetAppRunner targetAppRunner;
    private DefinedFilterSets definedFilterSets;
    private FileObject profiledSingleFile;
    private final ProfilerEngineSettings sharedSettings;
    private GlobalFilters globalFilters;
    private final Object setupLock = new Object();
    private ProfilingSettings lastProfilingSettings;
    private Lookup.Provider profiledProject = null;
    private SessionSettings lastSessionSettings;
    private StringBuilder logMsgs = new StringBuilder();
    private ThreadsDataManager threadsManager;
    private VMTelemetryDataManager vmTelemetryManager;
    private VMTelemetryModels vmTelemetryModels;
    private boolean calibrating = false;
    private boolean threadsMonitoringEnabled = false;
    private boolean waitDialogOpen = false;
    private int lastMode = 1;
    private int profilingMode = 1;
    private int profilingState = 1;

    public NetBeansProfiler() {
        boolean bl = false;
        this.sharedSettings = new ProfilerEngineSettings();
        try {
            String string = this.getLibsDir();
            if (string == null) {
                throw new IOException(CANNOT_FIND_LIBS_MSG);
            }
            this.sharedSettings.initialize(string);
            this.sharedSettings.setSeparateConsole(System.getProperty("org.netbeans.profiler.separateConsole") != null);
            this.sharedSettings.setTargetWindowRemains(System.getProperty("org.netbeans.profiler.targetWindowRemains") != null);
        }
        catch (RuntimeException runtimeException) {
            ProfilerLogger.log((Exception)runtimeException);
            ProfilerDialogs.displayError((String)runtimeException.getMessage());
            bl = true;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, MessageFormat.format(ENGINE_INIT_FAILED_MSG, iOException.getLocalizedMessage()), iOException);
            bl = true;
        }
        if (!bl) {
            initialized = true;
        }
    }

    public static NetBeansProfiler getDefaultNB() {
        return (NetBeansProfiler)NetBeansProfiler.getDefault();
    }

    public static boolean isInitialized() {
        NetBeansProfiler.getDefaultNB();
        return initialized;
    }

    public int getAgentState(String string, int n, int n2) {
        if (this.profilingState == 4 && n == this.getTargetAppRunner().getProfilerEngineSettings().getPortNo()) {
            if (this.getTargetAppRunner().getProfilerClient().getCurrentAgentId() == n2) {
                return 3;
            }
            return 4;
        }
        Properties properties = this.getAgentProperties(n);
        if (properties == null) {
            return 0;
        }
        try {
            int n3 = Integer.parseInt(properties.getProperty("agent.id"));
            if (n3 == n2) {
                String string2 = properties.getProperty("dynamic");
                if (string2 == null || "false".equals(string2)) {
                    return 2;
                }
                return 1;
            }
            return 4;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public SessionSettings getCurrentSessionSettings() {
        return this.lastSessionSettings;
    }

    public synchronized DefinedFilterSets getDefinedFilterSets() {
        if (this.definedFilterSets == null) {
            this.loadGlobalFilters();
        }
        return this.definedFilterSets;
    }

    public synchronized GlobalFilters getGlobalFilters() {
        if (this.globalFilters == null) {
            this.loadGlobalFilters();
        }
        return this.globalFilters;
    }

    public GlobalProfilingSettings getGlobalProfilingSettings() {
        return this.ideSettings;
    }

    public ProfilingSettings getLastProfilingSettings() {
        return this.lastProfilingSettings;
    }

    public abstract String getLibsDir();

    public int getPlatformArchitecture(String string) {
        JavaPlatform javaPlatform = JavaPlatform.getJavaPlatformById((String)string);
        return javaPlatform.getPlatformArchitecture();
    }

    public String getPlatformJDKVersion(String string) {
        JavaPlatform javaPlatform = JavaPlatform.getJavaPlatformById((String)string);
        return javaPlatform.getPlatformJDKVersion();
    }

    public String getPlatformJavaFile(String string) {
        JavaPlatform javaPlatform = JavaPlatform.getJavaPlatformById((String)string);
        return javaPlatform.getPlatformJavaFile();
    }

    public int getProfilingMode() {
        return this.profilingMode;
    }

    public int getProfilingState() {
        return this.profilingState;
    }

    public synchronized TargetAppRunner getTargetAppRunner() {
        if (initialized) {
            if (this.targetAppRunner == null) {
                this.targetAppRunner = new TargetAppRunner(this.sharedSettings, (AppStatusHandler)new IDEAppStatusHandler(), this.getProfilingPointsManager());
                this.targetAppRunner.addProfilingEventListener(new ProfilingEventListener(){

                    public void targetAppStarted() {
                        if (NetBeansProfiler.this.calibrating) {
                            return;
                        }
                        NetBeansProfiler.this.changeStateTo(4);
                    }

                    public void targetAppStopped() {
                        if (NetBeansProfiler.this.calibrating) {
                            return;
                        }
                        NetBeansProfiler.this.changeStateTo(16);
                    }

                    public void targetAppSuspended() {
                        if (NetBeansProfiler.this.calibrating) {
                            return;
                        }
                        NetBeansProfiler.this.changeStateTo(8);
                    }

                    public void targetAppResumed() {
                        if (NetBeansProfiler.this.calibrating) {
                            return;
                        }
                        NetBeansProfiler.this.changeStateTo(4);
                    }

                    public void attachedToTarget() {
                        if (NetBeansProfiler.this.calibrating) {
                            return;
                        }
                        NetBeansProfiler.this.changeStateTo(4);
                    }

                    public void detachedFromTarget() {
                        if (NetBeansProfiler.this.calibrating) {
                            return;
                        }
                        NetBeansProfiler.this.getMonitor().stopDisplayingVM();
                        NetBeansProfiler.this.changeStateTo(1);
                    }

                    public void targetVMTerminated() {
                        if (NetBeansProfiler.this.calibrating) {
                            return;
                        }
                        NetBeansProfiler.this.getMonitor().stopDisplayingVM();
                        NetBeansProfiler.this.changeStateTo(1);
                    }
                });
            }
            return this.targetAppRunner;
        }
        return null;
    }

    public synchronized ThreadsDataManager getThreadsManager() {
        if (this.threadsManager == null) {
            this.threadsManager = new ThreadsDataManager();
        }
        return this.threadsManager;
    }

    public void setThreadsMonitoringEnabled(boolean bl) {
        this.getThreadsManager().setThreadsMonitoringEnabled(bl);
        if (this.threadsMonitoringEnabled == bl) {
            return;
        }
        this.threadsMonitoringEnabled = bl;
        this.fireThreadsMonitoringChange();
    }

    public boolean getThreadsMonitoringEnabled() {
        return this.threadsMonitoringEnabled;
    }

    public synchronized VMTelemetryModels getVMTelemetryModels() {
        if (this.vmTelemetryModels == null) {
            this.vmTelemetryModels = new VMTelemetryModels(this.getVMTelemetryManager());
        }
        return this.vmTelemetryModels;
    }

    public synchronized VMTelemetryDataManager getVMTelemetryManager() {
        if (this.vmTelemetryManager == null) {
            this.vmTelemetryManager = new VMTelemetryDataManager();
        }
        return this.vmTelemetryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attachToApp(ProfilingSettings profilingSettings, AttachSettings attachSettings) {
        this.profilingMode = 0;
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_StartingSession"));
        progressHandle.setInitialDelay(500);
        progressHandle.start();
        try {
            boolean bl;
            if (this.getProfilingState() != 1) {
                if (this.lastMode == 0) {
                    this.detachFromApp();
                } else if (this.getTargetAppRunner().targetJVMIsAlive()) {
                    this.getTargetAppRunner().terminateTargetJVM();
                }
            }
            this.lastProfilingSettings = profilingSettings;
            this.lastSessionSettings = null;
            this.lastMode = 0;
            ProfilerEngineSettings profilerEngineSettings = this.getTargetAppRunner().getProfilerEngineSettings();
            profilingSettings.applySettings(profilerEngineSettings);
            attachSettings.applySettings(profilerEngineSettings);
            NetBeansProfiler.logActionConfig("attachToApp", profilingSettings, null, attachSettings, profilerEngineSettings.getInstrumentationFilter());
            GestureSubmitter.logAttach(this.getProfiledProject(), attachSettings);
            GestureSubmitter.logConfig(profilingSettings, profilerEngineSettings.getInstrumentationFilter());
            this.changeStateTo(2);
            this.cleanupBeforeProfiling(profilerEngineSettings);
            this.setThreadsMonitoringEnabled(profilingSettings.getThreadsMonitoringEnabled());
            if (this.shouldOpenWindowsOnProfilingStart()) {
                CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        NetBeansProfiler.this.openWindowsOnProfilingStart();
                    }
                });
            }
            if (attachSettings.isDirect()) {
                bl = false;
                if (this.prepareInstrumentation(profilingSettings)) {
                    boolean bl2 = bl = this.getTargetAppRunner().initiateSession(1, false) && this.getTargetAppRunner().attachToTargetVMOnStartup();
                }
                if (!bl) {
                    this.changeStateTo(1);
                    boolean bl3 = false;
                    return bl3;
                }
            } else if (attachSettings.isDynamic16()) {
                String string = this.getLibsDir() + "/jfluid-server-15.jar";
                String string2 = String.valueOf(attachSettings.getPid());
                String string3 = String.valueOf(attachSettings.getPort());
                boolean bl4 = false;
                try {
                    NetBeansProfiler.loadAgentIntoTargetJVM(string, string3, string2);
                    if (this.prepareInstrumentation(profilingSettings)) {
                        bl4 = this.getTargetAppRunner().initiateSession(2, false) && this.getTargetAppRunner().attachToTargetVM();
                    }
                }
                catch (Exception exception) {
                    ProfilerDialogs.displayError((String)exception.getMessage());
                    ProfilerLogger.log((Exception)exception);
                }
                if (!bl4) {
                    this.changeStateTo(1);
                    boolean bl5 = false;
                    return bl5;
                }
            } else {
                throw new IllegalArgumentException("Invalid settings " + attachSettings);
            }
            bl = this.connectToApp();
            return bl;
        }
        finally {
            progressHandle.finish();
        }
    }

    private static void loadAgentIntoTargetJVM(String string, String string2, String string3) throws AttachNotSupportedException, IOException, AgentLoadException, AgentInitializationException {
        VirtualMachine virtualMachine = VirtualMachine.attach(string3);
        virtualMachine.loadAgent(string, string2);
    }

    public void checkAndUpdateState() {
        boolean bl = this.getTargetAppRunner().targetJVMIsAlive();
        if (!bl) {
            this.changeStateTo(1);
            return;
        }
        boolean bl2 = this.getTargetAppRunner().targetAppIsRunning();
        if (!bl2) {
            this.changeStateTo(16);
            return;
        }
        boolean bl3 = this.getTargetAppRunner().targetAppSuspended();
        if (bl3) {
            this.changeStateTo(8);
        }
    }

    public boolean cleanForProfilingOnPort(int n) {
        if (this.isProfilingRunningOnPort(n)) {
            ProfilerLogger.severe((String)(">>> Profiling session already running on port " + n + ", will cause collision when starting another agent on the same port."));
            return false;
        }
        if (!this.shutdownAgent("localhost", n)) {
            ProfilerLogger.severe((String)(">>> Profiler agent already profiling on port " + n + " (communicating with another IDE?), will cause collision when starting another agent on the same port."));
            return false;
        }
        File file = NetBeansProfiler.getInfoFile(n);
        if (file.exists()) {
            boolean bl = this.waitForDeleteAgentFile(file);
            if (!bl) {
                ProfilerLogger.severe((String)(">>> Profiler agent identification file cannot be deleted for port " + n + ", will cause failure starting a server for profiling on the same port."));
            }
            return bl;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connectToStartedApp(ProfilingSettings profilingSettings, SessionSettings sessionSettings) {
        this.profilingMode = 1;
        this.lastProfilingSettings = profilingSettings;
        this.lastSessionSettings = sessionSettings;
        this.lastMode = 1;
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_StartingSession"));
        try {
            progressHandle.setInitialDelay(500);
            progressHandle.start();
            if (this.getTargetAppRunner().targetJVMIsAlive()) {
                this.getTargetAppRunner().terminateTargetJVM();
            }
            ProfilerEngineSettings profilerEngineSettings = this.getTargetAppRunner().getProfilerEngineSettings();
            sessionSettings.applySettings(profilerEngineSettings);
            profilingSettings.applySettings(profilerEngineSettings);
            profilerEngineSettings.setRemoteHost("");
            NetBeansProfiler.logActionConfig("connectToStartedApp", profilingSettings, sessionSettings, null, profilerEngineSettings.getInstrumentationFilter());
            GestureSubmitter.logProfileApp(this.getProfiledProject(), sessionSettings);
            GestureSubmitter.logConfig(profilingSettings, profilerEngineSettings.getInstrumentationFilter());
            if (this.prepareProfilingSession(profilingSettings, sessionSettings)) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        if (NetBeansProfiler.this.tryInitiateSession()) {
                            NetBeansProfiler.this.connectToApp();
                        }
                    }
                });
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            progressHandle.finish();
        }
    }

    private boolean prepareProfilingSession(ProfilingSettings profilingSettings, SessionSettings sessionSettings) {
        this.changeStateTo(2);
        this.cleanupBeforeProfiling(this.getTargetAppRunner().getProfilerEngineSettings());
        this.setThreadsMonitoringEnabled(profilingSettings.getThreadsMonitoringEnabled());
        if (this.shouldOpenWindowsOnProfilingStart()) {
            CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    NetBeansProfiler.this.openWindowsOnProfilingStart();
                }
            });
        }
        if (!CalibrationDataFileIO.validateCalibrationInput((String)sessionSettings.getJavaVersionString(), (String)sessionSettings.getJavaExecutable())) {
            ProfilerDialogs.displayError((String)CALIBRATION_MISSING_SHORT_MESSAGE, null, (String)CALIBRATION_MISSING_MESSAGE);
            this.changeStateTo(1);
            return false;
        }
        return this.prepareInstrumentation(profilingSettings);
    }

    private boolean tryInitiateSession() {
        if (!this.targetAppRunner.initiateSession(0, false) || !this.targetAppRunner.connectToStartedVMAndStartTA()) {
            this.changeStateTo(1);
            return false;
        }
        return true;
    }

    private boolean connectToApp() {
        if (this.getTargetAppRunner().targetAppIsRunning()) {
            this.getThreadsManager().setSupportsSleepingStateMonitoring(Platform.supportsThreadSleepingStateMonitoring((String)this.getTargetAppRunner().getProfilerEngineSettings().getTargetJDKVersionString()));
            CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    NetBeansProfiler.this.getMonitor().monitorVM(NetBeansProfiler.this.getTargetAppRunner());
                }
            });
            return true;
        }
        this.changeStateTo(1);
        return false;
    }

    public void detachFromApp() {
        this.setTransitionState();
        if (this.getTargetAppRunner().getProfilingSessionStatus().currentInstrType != 0) {
            try {
                this.getTargetAppRunner().getProfilerClient().removeAllInstrumentation(false);
            }
            catch (InstrumentationException instrumentationException) {
                ProfilerDialogs.displayError((String)instrumentationException.getMessage());
            }
        }
        this.getTargetAppRunner().detachFromTargetJVM();
    }

    public void instrumentSelectedRoots(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) throws ClassNotFoundException, InstrumentationException, BadLocationException, IOException, ClassFormatError, ClientUtils.TargetAppOrVMTerminated {
        ProfilerClient profilerClient = this.getTargetAppRunner().getProfilerClient();
        if (sourceCodeSelectionArray.length == 0) {
            ClientUtils.SourceCodeSelection sourceCodeSelection = new ClientUtils.SourceCodeSelection(1);
            sourceCodeSelectionArray = new ClientUtils.SourceCodeSelection[]{sourceCodeSelection};
        }
        profilerClient.initiateRecursiveCPUProfInstrumentation(sourceCodeSelectionArray);
    }

    public void log(int n, String string) {
        switch (n) {
            case 1: {
                LOGGER.log(Level.INFO, string);
                break;
            }
            case 2: {
                LOGGER.log(Level.WARNING, string);
                break;
            }
            case 8: 
            case 16: {
                LOGGER.log(Level.SEVERE, string);
                break;
            }
            default: {
                LOGGER.log(Level.FINEST, string);
            }
        }
    }

    public void modifyCurrentProfiling(final ProfilingSettings profilingSettings) {
        this.lastProfilingSettings = profilingSettings;
        if (!this.targetAppRunner.targetJVMIsAlive()) {
            return;
        }
        ProfilerEngineSettings profilerEngineSettings = this.getTargetAppRunner().getProfilerEngineSettings();
        profilingSettings.applySettings(profilerEngineSettings);
        NetBeansProfiler.logActionConfig("modifyCurrentProfiling", profilingSettings, null, null, profilerEngineSettings.getInstrumentationFilter());
        GestureSubmitter.logConfig(profilingSettings, profilerEngineSettings.getInstrumentationFilter());
        this.setThreadsMonitoringEnabled(profilingSettings.getThreadsMonitoringEnabled());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LiveResultsWindow.hasDefault()) {
                    LiveResultsWindow.getDefault().handleCleanupBeforeProfiling();
                }
            }
        });
        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NetBeansProfiler.this.changeStateTo(128);
                NetBeansProfiler.this.getTargetAppRunner().getAppStatusHandler().pauseLiveUpdates();
                ResultsManager.getDefault().reset();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                AppStatusHandler.AsyncDialog asyncDialog = NetBeansProfiler.this.getTargetAppRunner().getAppStatusHandler().getAsyncDialogInstance(MODIFYING_INSTRUMENTATION_MSG, true, null);
                asyncDialog.display();
                try {
                    NetBeansProfiler.this.prepareInstrumentation(profilingSettings);
                    NetBeansProfiler.this.changeStateTo(4);
                }
                finally {
                    asyncDialog.close();
                    NetBeansProfiler.this.getTargetAppRunner().getAppStatusHandler().resumeLiveUpdates();
                }
            }
        });
    }

    public void notifyException(int n, Exception exception) {
        switch (n) {
            case 1: {
                LOGGER.log(Level.INFO, null, exception);
                break;
            }
            case 2: {
                LOGGER.log(Level.WARNING, null, exception);
                break;
            }
            default: {
                LOGGER.log(Level.SEVERE, null, exception);
            }
        }
    }

    public void openJavaSource(String string, String string2, String string3) {
    }

    public boolean processesProfilingPoints() {
        ProfilingPointsProcessor profilingPointsProcessor = this.getProfilingPointsManager();
        if (profilingPointsProcessor != null) {
            return profilingPointsProcessor.getSupportedProfilingPoints().length > 0;
        }
        return false;
    }

    public boolean profileClass(final ProfilingSettings profilingSettings, final SessionSettings sessionSettings) {
        this.profilingMode = 1;
        this.lastProfilingSettings = profilingSettings;
        this.lastSessionSettings = sessionSettings;
        this.lastMode = 1;
        if (this.getTargetAppRunner().targetJVMIsAlive()) {
            this.getTargetAppRunner().terminateTargetJVM();
        }
        final ProfilerEngineSettings profilerEngineSettings = this.getTargetAppRunner().getProfilerEngineSettings();
        sessionSettings.applySettings(profilerEngineSettings);
        profilingSettings.applySettings(profilerEngineSettings);
        profilerEngineSettings.setRemoteHost("");
        NetBeansProfiler.logActionConfig("profileClass", profilingSettings, sessionSettings, null, profilerEngineSettings.getInstrumentationFilter());
        GestureSubmitter.logProfileClass(this.getProfiledProject(), sessionSettings);
        GestureSubmitter.logConfig(profilingSettings, profilerEngineSettings.getInstrumentationFilter());
        this.changeStateTo(2);
        this.cleanupBeforeProfiling(profilerEngineSettings);
        this.setThreadsMonitoringEnabled(profilingSettings.getThreadsMonitoringEnabled());
        if (this.shouldOpenWindowsOnProfilingStart()) {
            this.openWindowsOnProfilingStart();
        }
        final Frame frame = WindowManager.getDefault().getMainWindow();
        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Cursor cursor = frame.getCursor();
                frame.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    if (!NetBeansProfiler.this.runCalibration(true, sessionSettings.getJavaExecutable(), sessionSettings.getJavaVersionString(), sessionSettings.getSystemArchitecture())) {
                        ProfilerDialogs.displayError((String)CALIBRATION_FAILED_MESSAGE);
                        NetBeansProfiler.this.changeStateTo(1);
                        return;
                    }
                    boolean bl = NetBeansProfiler.this.prepareInstrumentation(profilingSettings);
                    boolean bl2 = bl = bl && NetBeansProfiler.this.getTargetAppRunner().startTargetVM() && NetBeansProfiler.this.getTargetAppRunner().initiateSession(0, false) && NetBeansProfiler.this.getTargetAppRunner().connectToStartedVMAndStartTA();
                    if (!bl) {
                        NetBeansProfiler.this.changeStateTo(1);
                        return;
                    }
                    if (NetBeansProfiler.this.getTargetAppRunner().targetAppIsRunning()) {
                        NetBeansProfiler.this.getThreadsManager().setSupportsSleepingStateMonitoring(Platform.supportsThreadSleepingStateMonitoring((String)profilerEngineSettings.getTargetJDKVersionString()));
                        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                NetBeansProfiler.this.getMonitor().monitorVM(NetBeansProfiler.this.getTargetAppRunner());
                            }
                        });
                    } else {
                        NetBeansProfiler.this.changeStateTo(1);
                    }
                }
                finally {
                    frame.setCursor(cursor);
                }
            }
        });
        return true;
    }

    protected boolean shouldOpenWindowsOnProfilingStart() {
        return true;
    }

    public boolean runConfiguredCalibration() {
        this.calibrating = true;
        boolean bl = this.targetAppRunner.calibrateInstrumentationCode();
        this.calibrating = false;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runCalibration(boolean bl, String string, String string2, int n) {
        this.calibrating = true;
        ProfilerEngineSettings profilerEngineSettings = this.getTargetAppRunner().getProfilerEngineSettings();
        int n2 = profilerEngineSettings.getPortNo();
        InstrumentationFilter instrumentationFilter = profilerEngineSettings.getInstrumentationFilter();
        String string3 = profilerEngineSettings.getTargetJVMExeFile();
        String string4 = profilerEngineSettings.getTargetJDKVersionString();
        int n3 = profilerEngineSettings.getSystemArchitecture();
        String string5 = profilerEngineSettings.getMainClassPath();
        if (string != null) {
            profilerEngineSettings.setTargetJVMExeFile(string);
            profilerEngineSettings.setTargetJDKVersionString(string2);
            profilerEngineSettings.setSystemArchitecture(n);
        }
        profilerEngineSettings.setPortNo(this.ideSettings.getCalibrationPortNo());
        profilerEngineSettings.setInstrumentationFilter(new InstrumentationFilter());
        profilerEngineSettings.setMainClassPath("");
        boolean bl2 = false;
        if (bl) {
            bl2 = this.getTargetAppRunner().readSavedCalibrationData();
            if (!bl2) {
                ProfilerDialogs.displayInfo((String)INITIAL_CALIBRATION_MSG);
                bl2 = this.getTargetAppRunner().calibrateInstrumentationCode();
            }
            boolean bl3 = false;
            this.getTargetAppRunner().getProfilingSessionStatus().beginTrans(false);
            try {
                bl3 = Platform.isLinux() && "jdk16".equals(profilerEngineSettings.getTargetJDKVersionString()) && this.getTargetAppRunner().getProfilingSessionStatus().methodEntryExitCallTime[1] > 20000.0;
            }
            finally {
                this.getTargetAppRunner().getProfilingSessionStatus().endTrans();
            }
            if (bl3) {
                bl2 = this.getTargetAppRunner().calibrateInstrumentationCode();
            }
        } else {
            bl2 = this.getTargetAppRunner().calibrateInstrumentationCode();
        }
        this.calibrating = false;
        profilerEngineSettings.setPortNo(n2);
        profilerEngineSettings.setInstrumentationFilter(instrumentationFilter);
        profilerEngineSettings.setTargetJDKVersionString(string4);
        profilerEngineSettings.setSystemArchitecture(n3);
        profilerEngineSettings.setTargetJVMExeFile(string3);
        profilerEngineSettings.setMainClassPath(string5);
        return bl2;
    }

    public void setProfiledProject(Lookup.Provider provider, FileObject fileObject) {
        this.profiledProject = provider;
        this.profiledSingleFile = fileObject;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProfilerControlPanel2.getDefault().setProfiledProject(NetBeansProfiler.this.profiledProject);
            }
        });
    }

    public Lookup.Provider getProfiledProject() {
        return this.profiledProject;
    }

    public FileObject getProfiledSingleFile() {
        return this.profiledSingleFile;
    }

    public boolean prepareInstrumentation(ProfilingSettings profilingSettings) {
        this.teardownDispatcher();
        this.setupDispatcher(profilingSettings);
        ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = MarkingEngine.getDefault().getMarkerMethods();
        profilingSettings.setInstrumentationMarkerMethods(sourceCodeSelectionArray);
        return this.prepareInstrumentationImpl(profilingSettings);
    }

    private synchronized ProfilingMonitor getMonitor() {
        if (this.monitor == null) {
            this.monitor = new ProfilingMonitor();
        }
        return this.monitor;
    }

    private boolean prepareInstrumentationImpl(ProfilingSettings profilingSettings) {
        try {
            return super.prepareInstrumentation(profilingSettings);
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            ProfilerDialogs.displayError((String)targetAppOrVMTerminated.getMessage());
            targetAppOrVMTerminated.printStackTrace(System.err);
        }
        catch (InstrumentationException instrumentationException) {
            ProfilerDialogs.displayError((String)instrumentationException.getMessage());
            instrumentationException.printStackTrace(System.err);
        }
        catch (BadLocationException badLocationException) {
            ProfilerDialogs.displayError((String)badLocationException.getMessage());
            badLocationException.printStackTrace(System.err);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ProfilerDialogs.displayError((String)classNotFoundException.getMessage());
            classNotFoundException.printStackTrace(System.err);
        }
        catch (IOException iOException) {
            ProfilerDialogs.displayError((String)iOException.getMessage());
        }
        catch (ClassFormatError classFormatError) {
            ProfilerDialogs.displayError((String)classFormatError.getMessage());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFilters() {
        Properties properties;
        BufferedOutputStream bufferedOutputStream;
        OutputStream outputStream;
        FileObject fileObject;
        FileObject fileObject2;
        FileLock fileLock = null;
        try {
            fileObject2 = GlobalStorage.getSettingsFolder((boolean)true);
            fileObject = fileObject2.getFileObject(GLOBAL_FILTERS_FILENAME, "xml");
            if (fileObject == null) {
                fileObject = fileObject2.createData(GLOBAL_FILTERS_FILENAME, "xml");
            }
            fileLock = fileObject.lock();
            outputStream = fileObject.getOutputStream(fileLock);
            bufferedOutputStream = new BufferedOutputStream(outputStream);
            properties = new Properties();
            this.globalFilters.store((Map)properties);
            properties.storeToXML(bufferedOutputStream, "");
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            ProfilerLogger.log((Exception)exception);
            ProfilerDialogs.displayError((String)MessageFormat.format(ERROR_SAVING_PROFILING_SETTINGS_MESSAGE, exception.getMessage()));
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        fileLock = null;
        try {
            fileObject2 = GlobalStorage.getSettingsFolder((boolean)true);
            fileObject = fileObject2.getFileObject(DEFINED_FILTERSETS_FILENAME, "xml");
            if (fileObject == null) {
                fileObject = fileObject2.createData(DEFINED_FILTERSETS_FILENAME, "xml");
            }
            fileLock = fileObject.lock();
            outputStream = fileObject.getOutputStream(fileLock);
            bufferedOutputStream = new BufferedOutputStream(outputStream);
            properties = new Properties();
            this.definedFilterSets.store((Map)properties);
            properties.storeToXML(bufferedOutputStream, "");
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            ProfilerLogger.log((Exception)exception);
            ProfilerDialogs.displayError((String)MessageFormat.format(ERROR_SAVING_FILTER_SETS_MESSAGE, exception.getMessage()));
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }

    public void shutdown() {
        this.getMonitor().stopUpdateThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdownBlockedAgent(String string, int n, int n2) {
        int n3 = this.getAgentState(string, n, n2);
        if (n3 == 2) {
            Socket socket = null;
            ObjectOutputStream objectOutputStream = null;
            ObjectInputStream objectInputStream = null;
            try {
                socket = new Socket(string, n);
                socket.setSoTimeout(100);
                socket.setTcpNoDelay(true);
                objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
                objectInputStream = new ObjectInputStream(socket.getInputStream());
                WireIO wireIO = new WireIO(objectOutputStream, objectInputStream);
                wireIO.sendSimpleCommand(12);
                Object object = wireIO.receiveCommandOrResponse();
                if (object instanceof Response && ((Response)object).isOK()) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (IOException iOException) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                    if (objectOutputStream != null) {
                        objectOutputStream.close();
                    }
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException iOException) {
                    ProfilerLogger.log((Exception)iOException);
                }
            }
        }
        return false;
    }

    public void stopApp() {
        this.setTransitionState();
        this.getTargetAppRunner().terminateTargetJVM();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getAgentProperties(int n) {
        File file = NetBeansProfiler.getInfoFile(n);
        if (!file.exists()) {
            return null;
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            properties.load(bufferedInputStream);
            bufferedInputStream.close();
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException iOException) {
            Properties properties = null;
            return properties;
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private static File getInfoFile(int n) {
        String string = System.getProperty("user.home");
        return new File(string + File.separator + ".nbprofiler" + File.separator + n);
    }

    private boolean isProfilingRunningOnPort(int n) {
        return this.profilingState == 4 && n == this.getTargetAppRunner().getProfilerEngineSettings().getPortNo();
    }

    private void setTransitionState() {
        this.changeStateTo(128);
    }

    private void changeStateTo(int n) {
        if (this.profilingState == n) {
            return;
        }
        int n2 = this.profilingState;
        this.profilingState = n;
        this.fireProfilingStateChange(n2, this.profilingState);
        if (n == 1 || n == 16) {
            this.cleanupAfterProfiling();
        }
    }

    protected void cleanupAfterProfiling() {
        this.teardownDispatcher();
        MarkingEngine.getDefault().deconfigure();
        ClassRepository.cleanup();
    }

    private void cleanupBeforeProfiling(ProfilerEngineSettings profilerEngineSettings) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NetBeansProfiler.this.getThreadsManager().reset();
                NetBeansProfiler.this.getVMTelemetryManager().reset();
                if (LiveResultsWindow.hasDefault()) {
                    LiveResultsWindow.getDefault().handleCleanupBeforeProfiling();
                }
            }
        });
        ResultsManager.getDefault().reset();
        ClassRepository.clearCache();
        ClassRepository.initClassPaths((String)profilerEngineSettings.getWorkingDir(), (String[])profilerEngineSettings.getVMClassPaths());
    }

    private void displayWarningAboutEntireAppProfiling() {
        ProfilerDialogs.displayWarning((String)ENTIRE_APPLICATION_PROFILING_WARNING);
    }

    private void loadGlobalFilters() {
        try {
            Object object;
            InputStream inputStream;
            InputStream inputStream2;
            FileObject fileObject = GlobalStorage.getSettingsFolder((boolean)false);
            FileObject fileObject2 = FileUtil.getConfigFile((String)"NBProfiler/Config");
            FileObject fileObject3 = null;
            if (fileObject != null && fileObject.isValid()) {
                fileObject3 = fileObject.getFileObject(GLOBAL_FILTERS_FILENAME, "xml");
            }
            if (fileObject3 == null && fileObject2 != null && fileObject2.isValid()) {
                fileObject3 = fileObject2.getFileObject("filters-default", "xml");
            }
            if (fileObject3 != null) {
                inputStream2 = fileObject3.getInputStream();
                inputStream = new BufferedInputStream(inputStream2);
                object = new Properties();
                ((Properties)object).loadFromXML(inputStream);
                this.globalFilters = new GlobalFilters();
                this.globalFilters.load((Map)object);
                ((BufferedInputStream)inputStream).close();
            }
            inputStream2 = null;
            if (fileObject != null && fileObject.isValid()) {
                inputStream2 = fileObject.getFileObject(DEFINED_FILTERSETS_FILENAME, "xml");
            }
            if (inputStream2 == null && fileObject2 != null && fileObject2.isValid()) {
                inputStream2 = fileObject2.getFileObject("filtersets-default", "xml");
            }
            if (inputStream2 != null) {
                inputStream = inputStream2.getInputStream();
                object = new BufferedInputStream(inputStream);
                Properties properties = new Properties();
                properties.loadFromXML((InputStream)object);
                this.definedFilterSets = new DefinedFilterSets();
                this.definedFilterSets.load((Map)properties);
                ((BufferedInputStream)object).close();
            }
        }
        catch (Exception exception) {
            ProfilerLogger.log((Exception)exception);
            ProfilerDialogs.displayError((String)MessageFormat.format(ERROR_LOADING_PROFILING_SETTINGS_MESSAGE, exception.getMessage()));
        }
    }

    private void openWindowsOnProfilingStart() {
        int n = this.ideSettings.getTelemetryOverviewBehavior();
        int n2 = this.ideSettings.getThreadsViewBehavior();
        boolean bl = this.lastProfilingSettings.getThreadsMonitoringEnabled();
        int n3 = this.lastProfilingSettings.getProfilingType();
        if (n == 1 || n == 2 && n3 == 1) {
            TelemetryOverviewPanel.getDefault().open();
            TelemetryOverviewPanel.getDefault().requestVisible();
        }
        if (bl && (n2 == 1 || n2 == 2 && n3 == 1)) {
            ThreadsWindow.getDefault().open();
            ThreadsWindow.getDefault().requestVisible();
        }
        if (this.ideSettings.getDisplayLiveResultsCPU() && (n3 == 8 || n3 == 16) || this.ideSettings.getDisplayLiveResultsFragment() && n3 == 32 || this.ideSettings.getDisplayLiveResultsMemory() && (n3 == 2 || n3 == 4)) {
            LiveResultsWindow.getDefault().open();
            LiveResultsWindow.getDefault().requestVisible();
        }
        ProfilerControlPanel2 profilerControlPanel2 = ProfilerControlPanel2.getDefault();
        profilerControlPanel2.open();
        profilerControlPanel2.requestActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupDispatcher(ProfilingSettings profilingSettings) {
        Object object = this.setupLock;
        synchronized (object) {
            CCTProvider.Listener listener2;
            Lookup.Provider provider = this.getProfiledProject();
            CCTProvider cCTProvider = null;
            Collection collection = null;
            switch (profilingSettings.getProfilingType()) {
                case 8: 
                case 16: 
                case 32: 
                case 64: {
                    cCTProvider = (CCTProvider)Lookup.getDefault().lookup(CPUCCTProvider.class);
                    collection = Lookup.getDefault().lookupAll(CPUCCTProvider.Listener.class);
                    break;
                }
                case 2: 
                case 4: {
                    cCTProvider = (CCTProvider)Lookup.getDefault().lookup(MemoryCCTProvider.class);
                    collection = Lookup.getDefault().lookupAll(MemoryCCTProvider.Listener.class);
                }
            }
            if (cCTProvider != null && collection != null && collection.size() > 0) {
                for (CCTProvider.Listener listener2 : collection) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Adding listener " + listener2.getClass().getName() + " to the provider " + cCTProvider.getClass().getName());
                    }
                    cCTProvider.addListener(listener2);
                }
            } else if (LOGGER.isLoggable(Level.WARNING)) {
                if (cCTProvider == null) {
                    LOGGER.warning("Could not find a CCT provider in lookup!");
                } else if (collection == null || collection.size() == 0) {
                    LOGGER.warning("Could not find listeners in lookup!");
                }
            }
            for (CCTProvider.Listener listener2 : Lookup.getDefault().lookupAll(SessionListener.class)) {
                listener2.onStartup(profilingSettings, provider);
            }
            ProfilerClient profilerClient = this.getTargetAppRunner().getProfilerClient();
            listener2 = (CCTResultsFilter)Lookup.getDefault().lookup(CCTResultsFilter.class);
            if (listener2 != null) {
                listener2.reset();
                listener2.setEvaluators(Lookup.getDefault().lookupAll(CCTResultsFilter.EvaluatorProvider.class));
            }
            FlatProfileBuilder flatProfileBuilder = (FlatProfileBuilder)Lookup.getDefault().lookup(FlatProfileBuilder.class);
            TimeCollector timeCollector = (TimeCollector)Lookup.getDefault().lookup(TimeCollector.class);
            flatProfileBuilder.setContext(profilerClient, timeCollector, (CCTResultsFilter)listener2);
            Collection collection2 = null;
            switch (profilingSettings.getProfilingType()) {
                case 8: 
                case 16: 
                case 64: {
                    collection2 = Lookup.getDefault().lookupAll(CPUProfilingResultListener.class);
                    for (CPUProfilingResultListener cPUProfilingResultListener : collection2) {
                        ProfilingResultsDispatcher.getDefault().addListener(cPUProfilingResultListener);
                        cPUProfilingResultListener.startup(this.getTargetAppRunner().getProfilerClient());
                    }
                    break;
                }
                case 2: 
                case 4: {
                    collection2 = Lookup.getDefault().lookupAll(MemoryProfilingResultsListener.class);
                    for (MemoryProfilingResultsListener memoryProfilingResultsListener : collection2) {
                        ProfilingResultsDispatcher.getDefault().addListener(memoryProfilingResultsListener);
                        memoryProfilingResultsListener.startup(this.getTargetAppRunner().getProfilerClient());
                    }
                    break;
                }
            }
            ProfilingPointsProcessor profilingPointsProcessor = this.getProfilingPointsManager();
            if (profilingPointsProcessor != null) {
                profilingPointsProcessor.init((Object)this.getProfiledProject());
            }
            ProfilingResultsDispatcher.getDefault().startup(profilerClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shutdownAgent(String string, int n) {
        Socket socket = null;
        ObjectOutputStream objectOutputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            socket = new Socket(string, n);
            socket.setSoTimeout(100);
            socket.setTcpNoDelay(true);
            objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
            objectInputStream = new ObjectInputStream(socket.getInputStream());
            WireIO wireIO = new WireIO(objectOutputStream, objectInputStream);
            wireIO.sendSimpleCommand(12);
            try {
                Object object = wireIO.receiveCommandOrResponse();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ProfilerLogger.warning((String)(">>> An existing Profiler agent listening on port " + n + " was terminated to allow starting new profiling session on the same port."));
            boolean bl = true;
            return bl;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void teardownDispatcher() {
        Object object = this.setupLock;
        synchronized (object) {
            ProfilingResultsDispatcher.getDefault().shutdown();
            ProfilerClient profilerClient = this.getTargetAppRunner().getProfilerClient();
            profilerClient.registerFlatProfileProvider(null);
        }
    }

    private ProfilingPointsProcessor getProfilingPointsManager() {
        return (ProfilingPointsProcessor)Lookup.getDefault().lookup(ProfilingPointsProcessor.class);
    }

    private boolean waitForDeleteAgentFile(File file) {
        if (file.delete()) {
            return true;
        }
        for (int i = 0; i < 5; ++i) {
            if (file.delete()) {
                return true;
            }
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    private static void logActionConfig(String string, ProfilingSettings profilingSettings, SessionSettings sessionSettings, AttachSettings attachSettings, InstrumentationFilter instrumentationFilter) {
        assert (string != null);
        assert (profilingSettings != null);
        assert (instrumentationFilter != null);
        Object[] objectArray = new Object[5];
        objectArray[0] = string;
        objectArray[1] = profilingSettings.debug();
        Object object = sessionSettings != null ? "Session" : (objectArray[2] = attachSettings != null ? "Attach" : null);
        objectArray[3] = sessionSettings != null ? sessionSettings.debug() : (attachSettings != null ? attachSettings.debug() : null);
        objectArray[4] = instrumentationFilter.debug();
        LOGGER.log(Level.CONFIG, "*** Profiler Action = {0}\n>>> Profiling Settings = \n{1}\n>>> {2} Settings = \n{3}\n>>> Instrumentation Filter = \n{4}", objectArray);
    }

    private final class IDEAppStatusHandler
    implements AppStatusHandler {
        private IDEAppStatusHandler() {
        }

        public AppStatusHandler.AsyncDialog getAsyncDialogInstance(String string, boolean bl, Runnable runnable) {
            return new ProgressPanel(string, bl, runnable);
        }

        public boolean confirmWaitForConnectionReply() {
            return !ProfilerDialogs.displayConfirmation((String)TARGET_APP_NOT_RESPONDING_MSG, (String)TARGET_APP_NOT_RESPONDING_DIALOG_TITLE);
        }

        public void displayError(String string) {
            LOGGER.log(Level.WARNING, "IDEAppStatusHandler - error: {)}", string);
            ProfilerDialogs.displayError((String)string);
        }

        public void displayErrorAndWaitForConfirm(String string) {
            LOGGER.log(Level.WARNING, "IDEAppStatusHandler - errorAndWaitForConfirm: {0}", string);
            ProfilerDialogs.displayError((String)string);
        }

        public void displayErrorWithDetailsAndWaitForConfirm(String string, String string2) {
            ProfilerDialogs.displayError((String)string, null, (String)string2);
        }

        public void displayNotification(String string) {
            StatusDisplayer.getDefault().setStatusText(string);
        }

        public void displayNotificationAndWaitForConfirm(String string) {
            ProfilerDialogs.displayInfo((String)string);
        }

        public void displayNotificationWithDetailsAndWaitForConfirm(String string, String string2) {
            ProfilerDialogs.displayInfo((String)string, null, (String)string2);
        }

        public void displayWarning(String string) {
            LOGGER.log(Level.WARNING, "IDEAppStatusHandler - warning: {0}", string);
            ProfilerDialogs.displayWarning((String)string);
        }

        public void displayWarningAndWaitForConfirm(String string) {
            LOGGER.log(Level.WARNING, "IDEAppStatusHandler - warningAndWaitForConfirm: {0}", string);
            ProfilerDialogs.displayWarning((String)string);
        }

        public void handleShutdown() {
            if (LiveResultsWindow.hasDefault()) {
                LiveResultsWindow.getDefault().handleShutdown();
            }
            if (NetBeansProfiler.this.getTargetAppRunner().getProfilerClient().getCurrentInstrType() == 0 || !ResultsManager.getDefault().resultsAvailable()) {
                ProfilerDialogs.displayInfoDNSA((String)TERMINATE_VM_ON_EXIT_MSG, null, null, (String)"NetBeansProfiler.handleShutdown.noResults", (boolean)false);
            } else if (ProfilerDialogs.displayConfirmationDNSA((String)TAKE_SNAPSHOT_ON_EXIT_MSG, (String)TAKE_SNAPSHOT_ON_EXIT_DIALOG_TITLE, null, (String)"NetBeansProfiler.handleShutdown", (boolean)false)) {
                ResultsManager.getDefault().takeSnapshot();
            }
        }

        public void pauseLiveUpdates() {
            LiveResultsWindow.setPaused(true);
        }

        public void resultsAvailable() {
            ResultsManager.getDefault().resultsBecameAvailable();
        }

        public void resumeLiveUpdates() {
            LiveResultsWindow.setPaused(false);
        }

        public void takeSnapshot() {
            ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                @Override
                public void run() {
                    ResultsManager.getDefault().takeSnapshot();
                }
            });
        }
    }

    public static final class ProgressPanel
    implements AppStatusHandler.AsyncDialog {
        private static final int MINIMUM_WIDTH = 350;
        private volatile boolean opened;
        private volatile boolean closed;
        private JDialog dialog;
        private final String message;
        private final boolean showProgress;
        private final Runnable cancelHandler;

        private ProgressPanel(String string, boolean bl, Runnable runnable) {
            this.message = string;
            this.showProgress = bl;
            this.cancelHandler = runnable;
        }

        public void close() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!ProgressPanel.this.opened) {
                        ProgressPanel.this.closed = true;
                    } else {
                        ProgressPanel.this.closeImpl();
                    }
                }
            });
        }

        public void display() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressPanel.this.initUI();
                    if (!ProgressPanel.this.closed) {
                        ProgressPanel.this.dialog.setVisible(true);
                    }
                }
            });
        }

        private void initUI() {
            Serializable serializable;
            Frame frame = WindowManager.getDefault().getMainWindow();
            this.dialog = new JDialog(frame, PROGRESS_DIALOG_CAPTION, true);
            JPanel jPanel = new JPanel(new BorderLayout(5, 5));
            jPanel.setBorder(new EmptyBorder(15, 15, 15, 10));
            jPanel.add((Component)new JLabel(this.message), "North");
            if (this.showProgress) {
                serializable = new JProgressBar();
                serializable.setIndeterminate(true);
                jPanel.add((Component)serializable, "South");
            }
            if (this.cancelHandler != null) {
                serializable = new JButton(){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        ProgressPanel.this.close();
                        ProgressPanel.this.cancelHandler.run();
                    }
                };
                Mnemonics.setLocalizedText((AbstractButton)serializable, (String)CANCEL_BTN);
                JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
                jPanel2.setBorder(new EmptyBorder(5, 15, 10, 10));
                jPanel2.add((Component)serializable, "East");
                this.dialog.add((Component)jPanel, "North");
                this.dialog.add((Component)jPanel2, "South");
            } else {
                this.dialog.add((Component)jPanel, "North");
            }
            serializable = jPanel.getPreferredSize();
            jPanel.setPreferredSize(new Dimension(Math.max(((Dimension)serializable).width, 350), ((Dimension)serializable).height));
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(frame);
            this.dialog.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && ProgressPanel.this.dialog.isShowing()) {
                        ProgressPanel.this.dialog.removeHierarchyListener(this);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ProgressPanel.this.opened = true;
                                if (ProgressPanel.this.closed) {
                                    ProgressPanel.this.closeImpl();
                                }
                            }
                        });
                    }
                }
            });
            this.dialog.setDefaultCloseOperation(0);
        }

        private void closeImpl() {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }
}

