/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.NavigatorView;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.javahelp.HelpConstants;
import org.netbeans.modules.javahelp.Installer;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public abstract class AbstractHelp
extends Help
implements HelpConstants {
    private Lookup.Result<HelpSet> helpsets = null;
    private final ChangeSupport cs = new ChangeSupport((Object)this);

    protected AbstractHelp() {
    }

    protected final Collection<? extends HelpSet> getHelpSets() {
        if (this.helpsets == null) {
            Installer.log.fine("searching for instances of HelpSet...");
            this.helpsets = Lookup.getDefault().lookupResult(HelpSet.class);
            this.helpsets.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    AbstractHelp.this.helpSetsChanged();
                }
            });
            this.fireChangeEvent();
        }
        Collection<? extends HelpSet> collection = this.helpsets.allInstances();
        if (Installer.log.isLoggable(Level.FINE)) {
            ArrayList<String> arrayList = new ArrayList<String>(Math.min(1, collection.size()));
            for (HelpSet helpSet : collection) {
                arrayList.add(helpSet.getTitle());
            }
            Installer.log.fine("listing helpsets: " + arrayList);
        }
        assert ((collection = AbstractHelp.selectSafeHelpSets(collection)) != null);
        return collection;
    }

    private static Collection<? extends HelpSet> selectSafeHelpSets(Collection<? extends HelpSet> collection) {
        ArrayList<HelpSet> arrayList = new ArrayList<HelpSet>(collection.size());
        for (HelpSet helpSet : collection) {
            if (!AbstractHelp.isSafe(helpSet)) continue;
            arrayList.add(helpSet);
        }
        return arrayList;
    }

    private static boolean isSafe(HelpSet helpSet) {
        for (NavigatorView navigatorView : helpSet.getNavigatorViews()) {
            if (!"Search".equals(navigatorView.getName())) continue;
            String string = (String)navigatorView.getParameters().get("engine");
            if (string == null) {
                string = HelpUtilities.getDefaultQueryEngine();
            }
            assert (string != null);
            try {
                AbstractHelp.checkSearchEngineCanBeCreated(string, helpSet, navigatorView);
            }
            catch (Exception exception) {
                Installer.log.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                return false;
            }
        }
        return true;
    }

    private static void checkSearchEngineCanBeCreated(String string, HelpSet helpSet, NavigatorView navigatorView) throws Exception {
        Object[] objectArray;
        Class<?> clazz;
        URL uRL = helpSet.getHelpSetURL();
        ClassLoader classLoader = helpSet.getLoader();
        try {
            clazz = classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
        }
        catch (Throwable throwable) {
            String string2 = "Could not load engine named {0} for Help Set {1} with url {2}";
            String string3 = MessageFormat.format(string2, string, helpSet.getTitle(), uRL);
            throw new Exception(string3, throwable);
        }
        Constructor<?> constructor = null;
        try {
            objectArray = new Class[]{URL.class, Hashtable.class};
            constructor = clazz.getConstructor((Class<?>[])objectArray);
        }
        catch (Throwable throwable) {
            String string4 = "Could not find constructor for {0} for Help Set {1} with url {2}";
            String string5 = MessageFormat.format(string4, string, helpSet.getTitle(), uRL);
            throw new Exception(string5, throwable);
        }
        try {
            objectArray = new Object[]{uRL, navigatorView.getParameters()};
            constructor.newInstance(objectArray);
        }
        catch (Throwable throwable) {
            String string6 = "Exception while creating engine {0} for Help Set {1} with url {2}";
            String string7 = MessageFormat.format(string6, string, helpSet.getTitle(), uRL);
            throw new Exception(string7, throwable);
        }
    }

    protected final boolean helpSetsReady() {
        return this.helpsets != null;
    }

    protected final boolean shouldMerge(HelpSet helpSet) {
        Boolean bl = (Boolean)helpSet.getKeyData("OpenIDE", "mergeIntoMaster");
        return bl == null || bl != false;
    }

    protected void helpSetsChanged() {
        Installer.log.fine("helpSetsChanged");
        this.fireChangeEvent();
    }

    @Override
    public final void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    @Override
    public final void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    private final void fireChangeEvent() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractHelp.this.fireChangeEvent();
                }
            });
            return;
        }
        Installer.log.fine("Help.stateChanged");
        this.cs.fireChange();
    }
}

