/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.ChildrenComputer;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;
import org.netbeans.modules.profiler.heapwalk.model.InstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.InstancesContainerNode;
import org.netbeans.modules.profiler.heapwalk.model.RootNode;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class BrowserUtils {
    private static final String OUT_OF_MEMORY_MSG = NbBundle.getMessage(BrowserUtils.class, (String)"BrowserUtils_OutOfMemoryMsg");
    private static final String TRUNCATED_STRING = NbBundle.getMessage(BrowserUtils.class, (String)"BrowserUtils_TruncatedMsg");
    public static final ImageIcon ICON_INSTANCE = Icons.getImageIcon((String)"LanguageIcons.Instance");
    public static final ImageIcon ICON_PRIMITIVE = Icons.getImageIcon((String)"LanguageIcons.Primitive");
    public static final ImageIcon ICON_ARRAY = Icons.getImageIcon((String)"LanguageIcons.Array");
    public static final ImageIcon ICON_PROGRESS = Icons.getImageIcon((String)"HeapWalkerIcons.Progress");
    public static final ImageIcon ICON_STATIC = Icons.getImageIcon((String)"HeapWalkerIcons.Static");
    public static final ImageIcon ICON_LOOP = Icons.getImageIcon((String)"HeapWalkerIcons.Loop");
    public static final ImageIcon ICON_GCROOT = Icons.getImageIcon((String)"HeapWalkerIcons.GcRoot");
    private static final RequestProcessor requestProcessor = new RequestProcessor("HeapWalker Processor", 3);
    private static final int MAX_FULLNAME_LENGTH = 100;

    public static String getArrayItemType(String string) {
        int n = string.lastIndexOf("[");
        return n == -1 ? string : string.substring(0, n);
    }

    public static String getFullNodeName(HeapWalkerNode heapWalkerNode) {
        StringBuilder stringBuilder = new StringBuilder();
        while (!heapWalkerNode.isRoot()) {
            int n = stringBuilder.length();
            if (n < 100) {
                String string = BrowserUtils.getNodeName(heapWalkerNode);
                stringBuilder.insert(0, "." + string);
                heapWalkerNode = heapWalkerNode.getParent();
                continue;
            }
            stringBuilder.delete(0, TRUNCATED_STRING.length());
            stringBuilder.insert(0, TRUNCATED_STRING);
            break;
        }
        stringBuilder.insert(0, BrowserUtils.getNodeName(heapWalkerNode));
        return stringBuilder.toString();
    }

    public static GroupingInfo getGroupingInfo(int n) {
        int n2 = n;
        int n3 = 500;
        int n4 = (int)Math.ceil((float)n2 / (float)n3);
        while (n4 > 5000 && n3 < 5000) {
            n4 = (int)Math.ceil((float)n2 / (float)(n3 += 500));
        }
        return new GroupingInfo(n4, n3);
    }

    public static HeapWalkerNode getRoot(HeapWalkerNode heapWalkerNode) {
        while (heapWalkerNode != null && !heapWalkerNode.isRoot()) {
            heapWalkerNode = heapWalkerNode.getParent();
        }
        return heapWalkerNode == null ? null : heapWalkerNode;
    }

    public static String getSimpleType(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        if (string.startsWith("<")) {
            return "<" + string.substring(n + 1);
        }
        return string.substring(n + 1);
    }

    public static boolean isStaticField(FieldValue fieldValue) {
        return fieldValue.getField().isStatic();
    }

    public static HeapWalkerNode computeChildrenToNearestGCRoot(InstanceNode instanceNode) {
        HeapWalkerNode heapWalkerNode = instanceNode;
        Instance instance = instanceNode.getInstance();
        Instance instance2 = instance.getNearestGCRootPointer();
        HeapWalkerNode[] heapWalkerNodeArray = null;
        while (!instance.equals(instance2)) {
            if (instance2 == null || heapWalkerNode == null) {
                heapWalkerNode = null;
                break;
            }
            if (heapWalkerNodeArray == null) {
                if (heapWalkerNode instanceof InstanceNode && !heapWalkerNode.currentlyHasChildren()) {
                    InstanceNode instanceNode2 = heapWalkerNode;
                    heapWalkerNodeArray = instanceNode2.getChildrenComputer().computeChildren();
                    instanceNode2.setChildren(heapWalkerNodeArray);
                } else {
                    heapWalkerNodeArray = heapWalkerNode.getChildren();
                }
            }
            for (int i = 0; i < heapWalkerNodeArray.length; ++i) {
                HeapWalkerNode heapWalkerNode2 = heapWalkerNodeArray[i];
                if (heapWalkerNode2 instanceof InstanceNode) {
                    if (!((InstanceNode)heapWalkerNode2).getInstance().equals(instance2)) continue;
                    heapWalkerNode = heapWalkerNode2;
                    heapWalkerNodeArray = null;
                    break;
                }
                if (!(heapWalkerNode2 instanceof InstancesContainerNode) || !((InstancesContainerNode)heapWalkerNode2).getInstances().contains(instance2)) continue;
                heapWalkerNode = heapWalkerNode2;
                heapWalkerNodeArray = null;
                break;
            }
            instance = instance2;
            instance2 = instance2.getNearestGCRootPointer();
        }
        return heapWalkerNode;
    }

    public static ImageIcon createGCRootIcon(ImageIcon imageIcon) {
        return new ImageIcon(ImageUtilities.mergeImages((Image)imageIcon.getImage(), (Image)ICON_GCROOT.getImage(), (int)0, (int)0));
    }

    public static ImageIcon createLoopIcon(ImageIcon imageIcon) {
        return new ImageIcon(ImageUtilities.mergeImages((Image)imageIcon.getImage(), (Image)ICON_LOOP.getImage(), (int)0, (int)0));
    }

    public static ImageIcon createStaticIcon(ImageIcon imageIcon) {
        return new ImageIcon(ImageUtilities.mergeImages((Image)imageIcon.getImage(), (Image)ICON_STATIC.getImage(), (int)0, (int)0));
    }

    public static HeapWalkerNode[] lazilyCreateChildren(final HeapWalkerNode heapWalkerNode, final ChildrenComputer childrenComputer) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BrowserUtils.performTask(new Runnable(){

                    @Override
                    public void run() {
                        if (heapWalkerNode instanceof AbstractHeapWalkerNode) {
                            HeapWalkerNode[] heapWalkerNodeArray;
                            boolean bl = false;
                            try {
                                heapWalkerNodeArray = childrenComputer.computeChildren();
                            }
                            catch (OutOfMemoryError outOfMemoryError) {
                                bl = true;
                                heapWalkerNodeArray = new HeapWalkerNode[]{HeapWalkerNodeFactory.createOOMNode(heapWalkerNode)};
                            }
                            final HeapWalkerNode[] heapWalkerNodeArray2 = heapWalkerNodeArray;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ((AbstractHeapWalkerNode)heapWalkerNode).changeChildren(heapWalkerNodeArray2);
                                    HeapWalkerNode heapWalkerNode = BrowserUtils.getRoot(heapWalkerNode);
                                    if (heapWalkerNode instanceof RootNode) {
                                        ((RootNode)((Object)heapWalkerNode)).refreshView();
                                    }
                                }
                            });
                            if (bl) {
                                ProfilerDialogs.displayError((String)OUT_OF_MEMORY_MSG);
                            }
                        }
                    }
                });
            }
        });
        return new HeapWalkerNode[]{HeapWalkerNodeFactory.createProgressNode(heapWalkerNode)};
    }

    public static void performTask(Runnable runnable) {
        requestProcessor.post(runnable);
    }

    private static String getNodeName(HeapWalkerNode heapWalkerNode) {
        String string = heapWalkerNode.getName();
        if (string.endsWith(")")) {
            string = string.substring(0, string.indexOf("(")).trim();
        }
        return string;
    }

    public static class GroupingInfo {
        public int collapseUnitSize;
        public int containersCount;

        GroupingInfo(int n, int n2) {
            this.containersCount = n;
            this.collapseUnitSize = n2;
        }
    }
}

