/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ProfilingPointsProcessor;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.results.BaseCallGraphBuilder;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.RuntimeCCTNodeProcessor;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUProfilingResultListener;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.MethodInfoMapper;
import org.netbeans.lib.profiler.results.cpu.ThreadInfo;
import org.netbeans.lib.profiler.results.cpu.ThreadInfos;
import org.netbeans.lib.profiler.results.cpu.TimingAdjusterOld;
import org.netbeans.lib.profiler.results.cpu.cct.CPUCCTNodeFactory;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.BaseCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MarkedCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.RuntimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.ServletRequestCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.SimpleCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.ThreadCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.TimedCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.marking.MarkingEngine;

public class CPUCallGraphBuilder
extends BaseCallGraphBuilder
implements CPUProfilingResultListener,
CPUCCTProvider {
    private CPUCCTNodeFactory factory;
    private DebugInfoCollector debugCollector = null;
    private InstrumentationFilter instrFilter;
    private boolean stackIntegrityViolationReported;
    private long delta;
    private MethodInfoMapper methodInfoMapper = MethodInfoMapper.DEFAULT;
    private TimingAdjusterOld timingAdjuster = TimingAdjusterOld.getDefault();
    private final ThreadInfos threadInfos = new ThreadInfos();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CPUCCTContainer[] createPresentationCCTs(CPUResultsSnapshot cPUResultsSnapshot) {
        this.threadInfos.beginTrans(false);
        try {
            String[] stringArray = this.threadInfos.getThreadNames();
            if (stringArray == null) {
                CPUCCTContainer[] cPUCCTContainerArray = null;
                return cPUCCTContainerArray;
            }
            int n = stringArray.length;
            if (n == 0) {
                CPUCCTContainer[] cPUCCTContainerArray = null;
                return cPUCCTContainerArray;
            }
            ArrayList<CPUCCTContainer> arrayList = new ArrayList<CPUCCTContainer>(n);
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                ThreadInfo threadInfo = this.threadInfos.threadInfos[i];
                if (threadInfo == null || threadInfo.stack[0] == null) continue;
                double[] dArray = this.calculateThreadActiveTimes(threadInfo);
                TimedCPUCCTNode timedCPUCCTNode = threadInfo.stack[0];
                CPUCCTContainer cPUCCTContainer = new CPUCCTContainer(timedCPUCCTNode, cPUResultsSnapshot, this.methodInfoMapper, this.timingAdjuster, this.instrFilter, threadInfo.totalNNodes, dArray, n2++, stringArray[i]);
                if (cPUCCTContainer.rootNode == null || cPUCCTContainer.rootNode.getNChildren() <= 0) continue;
                arrayList.add(cPUCCTContainer);
            }
            CPUCCTContainer[] cPUCCTContainerArray = arrayList.toArray(new CPUCCTContainer[arrayList.size()]);
            return cPUCCTContainerArray;
        }
        finally {
            this.threadInfos.endTrans();
        }
    }

    public void setMethodInfoMapper(MethodInfoMapper methodInfoMapper) {
        this.methodInfoMapper = methodInfoMapper != null ? methodInfoMapper : MethodInfoMapper.DEFAULT;
    }

    protected boolean isCollectingTwoTimeStamps() {
        return this.status.collectingTwoTimeStamps();
    }

    protected long getDumpAbsTimeStamp() {
        return this.status.dumpAbsTimeStamp;
    }

    @Override
    public void methodEntry(int n, int n2, int n3, long l, long l2) {
        if (!this.isReady() || this.threadInfos.threadInfos == null) {
            return;
        }
        ThreadInfo threadInfo = this.threadInfos.threadInfos[n2];
        if (threadInfo == null) {
            return;
        }
        switch (n3) {
            case 1: {
                this.plainMethodEntry(n, threadInfo, l, l2);
                break;
            }
            case 2: {
                this.rootMethodEntry(n, threadInfo, l, l2);
                break;
            }
            case 3: {
                this.markerMethodEntry(n, threadInfo, l, l2);
            }
        }
        this.batchNotEmpty = true;
    }

    @Override
    public void methodEntryUnstamped(int n, int n2, int n3) {
        if (!this.isReady() || this.threadInfos.threadInfos == null) {
            return;
        }
        ThreadInfo threadInfo = this.threadInfos.threadInfos[n2];
        if (threadInfo == null) {
            return;
        }
        switch (n3) {
            case 1: {
                this.plainMethodEntry(n, threadInfo);
                break;
            }
            case 3: {
                this.markerMethodEntry(n, threadInfo);
            }
        }
        this.batchNotEmpty = true;
    }

    @Override
    public void methodExit(int n, int n2, int n3, long l, long l2) {
        if (!this.isReady() || this.threadInfos.threadInfos == null) {
            return;
        }
        ThreadInfo threadInfo = this.threadInfos.threadInfos[n2];
        if (threadInfo == null) {
            return;
        }
        TimedCPUCCTNode timedCPUCCTNode = null;
        switch (n3) {
            case 1: 
            case 3: {
                timedCPUCCTNode = this.plainMethodExit(n, threadInfo, l, l2);
                break;
            }
            case 2: {
                timedCPUCCTNode = this.rootMethodExit(n, threadInfo, l, l2);
            }
        }
        if (timedCPUCCTNode != null) {
            TimedCPUCCTNode timedCPUCCTNode2 = threadInfo.peek();
            if (timedCPUCCTNode2 instanceof MarkedCPUCCTNode) {
                threadInfo.pop();
                timedCPUCCTNode2 = threadInfo.peek();
            }
            if (timedCPUCCTNode2 instanceof ServletRequestCPUCCTNode) {
                threadInfo.pop();
            }
        }
        this.batchNotEmpty = true;
    }

    @Override
    public void methodExitUnstamped(int n, int n2, int n3) {
        if (!this.isReady() || this.threadInfos.threadInfos == null) {
            return;
        }
        ThreadInfo threadInfo = this.threadInfos.threadInfos[n2];
        if (threadInfo == null) {
            return;
        }
        TimedCPUCCTNode timedCPUCCTNode = null;
        switch (n3) {
            case 1: 
            case 3: {
                timedCPUCCTNode = this.plainMethodExit(n, threadInfo);
            }
        }
        if (timedCPUCCTNode != null) {
            TimedCPUCCTNode timedCPUCCTNode2 = threadInfo.peek();
            if (timedCPUCCTNode2 instanceof MarkedCPUCCTNode) {
                threadInfo.pop();
                timedCPUCCTNode2 = threadInfo.peek();
            }
            if (timedCPUCCTNode2 instanceof ServletRequestCPUCCTNode) {
                threadInfo.pop();
            }
        }
        this.batchNotEmpty = true;
    }

    @Override
    public void monitorEntry(int n, long l, long l2) {
        this.waitEntry(n, l, l2);
        this.batchNotEmpty = true;
    }

    @Override
    public void monitorExit(int n, long l, long l2) {
        this.waitExit(n, l, l2);
        this.batchNotEmpty = true;
    }

    @Override
    public void newThread(int n, String string, String string2) {
        if (!this.isReady()) {
            return;
        }
        LOGGER.log(Level.FINEST, "New thread creation for thread id = {0}, name = {1}", new Object[]{n, string});
        this.threadInfos.newThreadInfo(n, string, string2);
        this.batchNotEmpty = true;
    }

    @Override
    public void servletRequest(int n, int n2, String string, int n3) {
        ServletRequestCPUCCTNode servletRequestCPUCCTNode;
        if (!this.isReady() || this.threadInfos.threadInfos == null) {
            return;
        }
        ThreadInfo threadInfo = this.threadInfos.threadInfos[n];
        if (threadInfo == null) {
            return;
        }
        TimedCPUCCTNode timedCPUCCTNode = threadInfo.peek();
        if (timedCPUCCTNode == null) {
            timedCPUCCTNode = this.factory.createThreadNode(n);
            ++threadInfo.totalNNodes;
            threadInfo.push(timedCPUCCTNode);
            --threadInfo.totalNInv;
        }
        if ((servletRequestCPUCCTNode = ServletRequestCPUCCTNode.Locator.locate(n2, string, timedCPUCCTNode.getChildren())) == null) {
            servletRequestCPUCCTNode = this.factory.createServletRequestNode(n2, string);
            timedCPUCCTNode.attachNodeAsChild(servletRequestCPUCCTNode);
        }
        threadInfo.push(servletRequestCPUCCTNode);
    }

    @Override
    public void sleepEntry(int n, long l, long l2) {
        long l3;
        if (!this.isReady() || this.threadInfos.threadInfos == null) {
            return;
        }
        ThreadInfo threadInfo = this.threadInfos.threadInfos[n];
        TimedCPUCCTNode timedCPUCCTNode = threadInfo.stack[threadInfo.stackTopIdx];
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("ENTRY SLEEP: " + this.debugNode(timedCPUCCTNode) + ", time: " + l + ", delta: " + (l - this.delta) + ", ti: " + threadInfo);
            this.delta = l;
        }
        if ((l3 = l - threadInfo.topMethodEntryTime0) > 0L) {
            timedCPUCCTNode.addNetTime0(l3);
        } else {
            l = threadInfo.topMethodEntryTime0;
        }
        threadInfo.topMethodEntryTime0 = l;
        timedCPUCCTNode.setLastWaitOrSleepStamp(l);
        this.batchNotEmpty = true;
    }

    @Override
    public void sleepExit(int n, long l, long l2) {
        if (!this.isReady() || this.threadInfos.threadInfos == null) {
            return;
        }
        ThreadInfo threadInfo = this.threadInfos.threadInfos[n];
        TimedCPUCCTNode timedCPUCCTNode = threadInfo.stack[threadInfo.stackTopIdx];
        long l3 = l - timedCPUCCTNode.getLastWaitOrSleepStamp();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("EXIT SLEEP: " + this.debugNode(timedCPUCCTNode) + ", time: " + l + ", delta: " + (l - this.delta) + ", slept: " + l3 + ", ti: " + threadInfo);
            this.delta = l;
            l3 = 0L;
        }
        timedCPUCCTNode.setLastWaitOrSleepStamp(0L);
        timedCPUCCTNode.addSleepTime0(l3);
        if (l - threadInfo.topMethodEntryTime0 > 0L) {
            threadInfo.topMethodEntryTime0 = l;
        }
        this.batchNotEmpty = true;
    }

    @Override
    public void threadsResume(long l, long l2) {
        if (!this.isReady() || this.threadInfos.threadInfos == null) {
            return;
        }
        ThreadInfo[] threadInfoArray = this.threadInfos.threadInfos;
        for (int i = 0; i < threadInfoArray.length; ++i) {
            ThreadInfo threadInfo = threadInfoArray[i];
            if (threadInfo == null || threadInfo.stackTopIdx < 0) continue;
            threadInfo.topMethodEntryTime0 = l;
            if (this.isCollectingTwoTimeStamps()) {
                threadInfo.topMethodEntryTime1 = l2;
            }
            if (this.isCollectingTwoTimeStamps()) {
                threadInfo.rootMethodEntryTimeAbs = l;
                threadInfo.rootMethodEntryTimeThreadCPU = l2;
                continue;
            }
            threadInfo.rootMethodEntryTimeAbs = l;
        }
        this.batchNotEmpty = true;
    }

    @Override
    public void threadsSuspend(long l, long l2) {
        if (!this.isReady() || this.threadInfos.threadInfos == null) {
            return;
        }
        ThreadInfo[] threadInfoArray = this.threadInfos.threadInfos;
        for (int i = 0; i < threadInfoArray.length; ++i) {
            ThreadInfo threadInfo = threadInfoArray[i];
            if (threadInfo == null || threadInfo.stackTopIdx < 0) continue;
            TimedCPUCCTNode timedCPUCCTNode = threadInfo.stack[threadInfo.stackTopIdx];
            long l3 = l - threadInfo.topMethodEntryTime0;
            if (l3 > 0L) {
                timedCPUCCTNode.addNetTime0(l3);
            }
            if (this.isCollectingTwoTimeStamps()) {
                threadInfo.rootGrossTimeAbs += l - threadInfo.rootMethodEntryTimeAbs;
                l3 = l2 - threadInfo.topMethodEntryTime1;
                if (l3 > 0L) {
                    timedCPUCCTNode.addNetTime1(l3);
                }
                threadInfo.rootGrossTimeThreadCPU += l2 - threadInfo.rootMethodEntryTimeThreadCPU;
                continue;
            }
            threadInfo.rootGrossTimeAbs += l - threadInfo.rootMethodEntryTimeAbs;
        }
        this.batchNotEmpty = true;
    }

    @Override
    public void timeAdjust(final int n, final long l, final long l2) {
        if (!this.isReady() || this.threadInfos.threadInfos == null) {
            return;
        }
        final ProfilingPointsProcessor profilingPointsProcessor = TargetAppRunner.getDefault().getProfilingPointsProcessor();
        ThreadInfo threadInfo = this.threadInfos.threadInfos[n];
        threadInfo.rootMethodEntryTimeAbs += l;
        threadInfo.rootMethodEntryTimeThreadCPU += l2;
        threadInfo.topMethodEntryTime0 += l;
        if (this.isCollectingTwoTimeStamps()) {
            threadInfo.topMethodEntryTime1 += l2;
        }
        this.afterBatchCommands.add(new Runnable(){

            @Override
            public void run() {
                profilingPointsProcessor.timeAdjust(n, l, l2);
            }
        });
        this.batchNotEmpty = true;
    }

    @Override
    public void waitEntry(int n, long l, long l2) {
        long l3;
        if (!this.isReady() || this.threadInfos.threadInfos == null) {
            return;
        }
        ThreadInfo threadInfo = this.threadInfos.threadInfos[n];
        TimedCPUCCTNode timedCPUCCTNode = threadInfo.stack[threadInfo.stackTopIdx];
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("ENTRY WAIT: " + this.debugNode(timedCPUCCTNode) + ", time: " + l + ", delta: " + (l - this.delta) + ", ti: " + threadInfo);
            this.delta = l;
            LOGGER.finest(this.dumpStack(threadInfo));
        }
        if ((l3 = l - threadInfo.topMethodEntryTime0) > 0L) {
            timedCPUCCTNode.addNetTime0(l3);
        } else {
            l = threadInfo.topMethodEntryTime0;
        }
        threadInfo.topMethodEntryTime0 = l;
        timedCPUCCTNode.setLastWaitOrSleepStamp(l);
        this.batchNotEmpty = true;
    }

    @Override
    public void waitExit(int n, long l, long l2) {
        if (!this.isReady() || this.threadInfos.threadInfos == null) {
            return;
        }
        ThreadInfo threadInfo = this.threadInfos.threadInfos[n];
        TimedCPUCCTNode timedCPUCCTNode = threadInfo.stack[threadInfo.stackTopIdx];
        long l3 = l - timedCPUCCTNode.getLastWaitOrSleepStamp();
        timedCPUCCTNode.setLastWaitOrSleepStamp(0L);
        timedCPUCCTNode.addWaitTime0(l3);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("EXIT WAIT: " + this.debugNode(timedCPUCCTNode) + ", time: " + l + ", delta: " + (l - this.delta) + ", waited: " + l3 + ", ti: " + threadInfo);
            this.delta = l;
            LOGGER.finest(this.dumpStack(threadInfo));
        }
        if (l - threadInfo.topMethodEntryTime0 > 0L) {
            threadInfo.topMethodEntryTime0 = l;
        }
        this.batchNotEmpty = true;
    }

    protected long[][] getAllThreadsActiveTimes() {
        int n = this.threadInfos.getThreadNames().length;
        long[][] lArray = new long[2][n];
        for (int i = 0; i < n; ++i) {
            ThreadInfo threadInfo = this.threadInfos.threadInfos[i];
            double[] dArray = this.calculateThreadActiveTimes(threadInfo);
            lArray[0][i] = (long)((dArray[0] - dArray[2]) * 1000.0 / (double)this.timingAdjuster.getInstrTimingData().timerCountsInSecond0);
            lArray[1][i] = dArray[1] != -1.0 ? (long)((dArray[1] - dArray[3]) * 1000.0 / (double)this.timingAdjuster.getInstrTimingData().timerCountsInSecond1) : -1L;
        }
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RuntimeCCTNode getAppRootNode() {
        if (this.threadInfos.isEmpty()) {
            return null;
        }
        SimpleCPUCCTNode simpleCPUCCTNode = null;
        this.threadInfos.beginTrans(false);
        try {
            simpleCPUCCTNode = new SimpleCPUCCTNode(true);
            int n = this.threadInfos.getThreadNames() != null ? this.threadInfos.getThreadNames().length : 0;
            for (int i = 0; i < n; ++i) {
                ThreadInfo threadInfo = this.threadInfos.threadInfos[i];
                if (threadInfo == null || threadInfo.stack[0] == null) continue;
                simpleCPUCCTNode.attachNodeAsChild(threadInfo.stack[0]);
            }
        }
        finally {
            this.threadInfos.endTrans();
        }
        return simpleCPUCCTNode;
    }

    double[] calculateThreadActiveTimes(ThreadInfo threadInfo) {
        long l;
        TimedCPUCCTNode timedCPUCCTNode = threadInfo.stack[0];
        if (timedCPUCCTNode == null) {
            return new double[]{0.0, 0.0, 0.0, 0.0};
        }
        long l2 = threadInfo.rootGrossTimeAbs;
        if (threadInfo.stackTopIdx != -1) {
            l = this.getDumpAbsTimeStamp();
            if (threadInfo.topMethodEntryTime0 > l) {
                l = threadInfo.topMethodEntryTime0;
            }
            l2 += l - threadInfo.rootMethodEntryTimeAbs;
        }
        l = threadInfo.rootGrossTimeThreadCPU;
        if (threadInfo.stackTopIdx != -1) {
            l = this.isCollectingTwoTimeStamps() ? (l += threadInfo.topMethodEntryTime1 - threadInfo.rootMethodEntryTimeThreadCPU) : -1L;
        }
        int n = timedCPUCCTNode.getNCalls();
        double d = 0.0;
        double d2 = this.timingAdjuster.delta(n, (int)(threadInfo.totalNInv - (long)n), false);
        d = this.isCollectingTwoTimeStamps() ? this.timingAdjuster.delta(n, (int)(threadInfo.totalNInv - (long)n), true) : d2 * (double)this.timingAdjuster.getInstrTimingData().timerCountsInSecond1 / (double)this.timingAdjuster.getInstrTimingData().timerCountsInSecond0;
        return new double[]{l2, l, d2, d};
    }

    @Override
    protected void doBatchStart() {
        ProfilerClient profilerClient = this.getClient();
        if (profilerClient != null) {
            this.timingAdjuster = TimingAdjusterOld.getInstance(profilerClient.getStatus());
        }
        if (this.factory == null) {
            this.factory = new CPUCCTNodeFactory(this.isCollectingTwoTimeStamps());
        }
        this.threadInfos.beginTrans(true);
    }

    @Override
    protected void doBatchStop() {
        this.threadInfos.endTrans();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doReset() {
        boolean bl = this.threadInfos.beginTrans(true, true);
        if (bl) {
            try {
                this.threadInfos.reset();
            }
            finally {
                this.threadInfos.endTrans();
            }
        }
    }

    @Override
    protected void doShutdown() {
        this.threadInfos.reset();
        this.factory = null;
        this.instrFilter = null;
    }

    @Override
    protected void doStartup(final ProfilerClient profilerClient) {
        this.instrFilter = profilerClient.getSettings().getInstrumentationFilter();
        this.setMethodInfoMapper(new MethodInfoMapper(){
            private final String INVALID_MID = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.cpu.Bundle").getString("MSG_INVALID_METHODID");

            @Override
            public String getInstrMethodClass(int n) {
                String[] stringArray = profilerClient.getStatus().getInstrMethodClasses();
                if (n < stringArray.length) {
                    return stringArray[n];
                }
                LOGGER.log(Level.WARNING, this.INVALID_MID, new Object[]{n, stringArray.length - 1});
                return null;
            }

            @Override
            public String getInstrMethodName(int n) {
                String[] stringArray = profilerClient.getStatus().getInstrMethodNames();
                if (n < stringArray.length) {
                    return stringArray[n];
                }
                LOGGER.log(Level.WARNING, this.INVALID_MID, new Object[]{n, stringArray.length - 1});
                return null;
            }

            @Override
            public String getInstrMethodSignature(int n) {
                String[] stringArray = profilerClient.getStatus().getInstrMethodSignatures();
                if (n < stringArray.length) {
                    return stringArray[n];
                }
                LOGGER.log(Level.WARNING, this.INVALID_MID, new Object[]{n, stringArray.length - 1});
                return null;
            }

            @Override
            public int getMinMethodId() {
                return profilerClient.getStatus().getStartingMethodId();
            }

            @Override
            public int getMaxMethodId() {
                return profilerClient.getStatus().getNInstrMethods() + profilerClient.getStatus().getStartingMethodId() - 1;
            }

            @Override
            public void lock(boolean bl) {
                profilerClient.getStatus().beginTrans(bl);
            }

            @Override
            public void unlock() {
                profilerClient.getStatus().endTrans();
            }
        });
        profilerClient.registerCPUCCTProvider(this);
    }

    protected void setFactory(CPUCCTNodeFactory cPUCCTNodeFactory) {
        this.factory = cPUCCTNodeFactory;
    }

    protected void setFilter(InstrumentationFilter instrumentationFilter) {
        this.instrFilter = instrumentationFilter;
    }

    private synchronized DebugInfoCollector getDebugCollector() {
        if (this.debugCollector == null) {
            this.debugCollector = new DebugInfoCollector();
        }
        return this.debugCollector;
    }

    protected boolean isReady() {
        return this.status != null && this.factory != null && this.instrFilter != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String debugMethod(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            this.methodInfoMapper.lock(false);
            stringBuilder.append(this.methodInfoMapper.getInstrMethodClass(n)).append('.').append(this.methodInfoMapper.getInstrMethodName(n));
            stringBuilder.append(this.methodInfoMapper.getInstrMethodSignature(n)).append(" (methodId = ").append(n).append(')');
        }
        finally {
            this.methodInfoMapper.unlock();
        }
        return stringBuilder.toString();
    }

    private String debugNode(RuntimeCPUCCTNode runtimeCPUCCTNode) {
        return this.getDebugCollector().getInfo(runtimeCPUCCTNode);
    }

    private String dumpStack(ThreadInfo threadInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("*** Thread stack dump:\n");
        for (int i = threadInfo.stackTopIdx; i >= 0; --i) {
            DebugInfoCollector debugInfoCollector = new DebugInfoCollector();
            TimedCPUCCTNode timedCPUCCTNode = threadInfo.stack[i];
            RuntimeCCTNodeProcessor.process(timedCPUCCTNode, debugInfoCollector);
            stringBuilder.append(debugInfoCollector.getInfo(timedCPUCCTNode)).append('\n');
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimedCPUCCTNode markerMethodEntry(int n, ThreadInfo threadInfo, long l, long l2, boolean bl) {
        Object object;
        TimedCPUCCTNode timedCPUCCTNode;
        Mark mark = MarkingEngine.getDefault().markMethod(n, this.status);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "MarkerMEntry{0} for tId = {1}, time: {2}, method:  {3}, inRoot: {4}, rootEntryTimeThread: {5}", new Object[]{!bl ? "(unstamped)" : "", threadInfo.threadId, l, this.debugMethod(n), threadInfo.rootMethodEntryTimeAbs, threadInfo.rootMethodEntryTimeThreadCPU});
        }
        if ((timedCPUCCTNode = threadInfo.peek()) == null) {
            object = this.factory.createThreadNode(threadInfo.threadId);
            ++threadInfo.totalNNodes;
            threadInfo.push((TimedCPUCCTNode)object);
            --threadInfo.totalNInv;
            if (!mark.isDefault()) {
                timedCPUCCTNode = this.factory.createCategory(mark);
                ((BaseCPUCCTNode)object).attachNodeAsChild(timedCPUCCTNode);
                ++threadInfo.totalNNodes;
                threadInfo.push(timedCPUCCTNode);
                object = timedCPUCCTNode;
            }
            timedCPUCCTNode = this.factory.createMethodNode(n);
            ((BaseCPUCCTNode)object).attachNodeAsChild(timedCPUCCTNode);
            ++threadInfo.totalNNodes;
            threadInfo.push(timedCPUCCTNode);
            threadInfo.topMethodEntryTime0 = l;
            if (this.isCollectingTwoTimeStamps()) {
                threadInfo.topMethodEntryTime1 = l2;
            }
        } else {
            if (bl) {
                long l3 = l - threadInfo.topMethodEntryTime0;
                if (l3 > 0L) {
                    timedCPUCCTNode.addNetTime0(l3);
                } else {
                    l = threadInfo.topMethodEntryTime0;
                }
                threadInfo.topMethodEntryTime0 = l;
                if (this.isCollectingTwoTimeStamps()) {
                    l3 = l2 - threadInfo.topMethodEntryTime1;
                    if (l3 > 0L) {
                        timedCPUCCTNode.addNetTime1(l3);
                    } else {
                        l2 = threadInfo.topMethodEntryTime1;
                    }
                    threadInfo.topMethodEntryTime1 = l2;
                }
            }
            if (!mark.isDefault()) {
                MarkedCPUCCTNode markedCPUCCTNode = MarkedCPUCCTNode.Locator.locate(mark, timedCPUCCTNode.getChildren());
                if (markedCPUCCTNode == null) {
                    markedCPUCCTNode = this.factory.createCategory(mark);
                    timedCPUCCTNode.attachNodeAsChild(markedCPUCCTNode);
                    ++threadInfo.totalNNodes;
                }
                threadInfo.push(markedCPUCCTNode);
                timedCPUCCTNode = markedCPUCCTNode;
            }
            if ((object = MethodCPUCCTNode.Locator.locate(n, timedCPUCCTNode.getChildren())) == null) {
                object = this.factory.createMethodNode(n);
                timedCPUCCTNode.attachNodeAsChild((RuntimeCPUCCTNode)object);
                ++threadInfo.totalNNodes;
            }
            threadInfo.push((TimedCPUCCTNode)object);
            timedCPUCCTNode = object;
        }
        if (!threadInfo.isInRoot()) {
            timedCPUCCTNode.setFilteredStatus(2);
            if (bl) {
                threadInfo.rootMethodEntryTimeAbs = l;
                threadInfo.rootMethodEntryTimeThreadCPU = l2;
                threadInfo.topMethodEntryTime0 = l;
                if (this.isCollectingTwoTimeStamps()) {
                    threadInfo.topMethodEntryTime1 = l2;
                }
            }
        } else {
            try {
                this.methodInfoMapper.lock(false);
                object = this.methodInfoMapper.getInstrMethodClass(((MethodCPUCCTNode)timedCPUCCTNode).getMethodId()).replace('.', '/');
                ProfilerClient profilerClient = this.getClient();
                if (profilerClient != null) {
                    if (!profilerClient.getSettings().getInstrumentationFilter().passesFilter((String)object)) {
                        timedCPUCCTNode.setFilteredStatus(2);
                    }
                } else {
                    timedCPUCCTNode.setFilteredStatus(2);
                }
            }
            finally {
                this.methodInfoMapper.unlock();
            }
        }
        return timedCPUCCTNode;
    }

    private TimedCPUCCTNode markerMethodEntry(int n, ThreadInfo threadInfo, long l, long l2) {
        return this.markerMethodEntry(n, threadInfo, l, l2, true);
    }

    private TimedCPUCCTNode markerMethodEntry(int n, ThreadInfo threadInfo) {
        return this.markerMethodEntry(n, threadInfo, 0L, 0L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimedCPUCCTNode plainMethodEntry(int n, ThreadInfo threadInfo, long l, long l2, boolean bl) {
        MethodCPUCCTNode methodCPUCCTNode;
        if (LOGGER.isLoggable(Level.FINEST) && LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "MethodEntry {0} for tId = {1}, time: {2}, delta: {3}, method:  {4}", new Object[]{!bl ? "(unstamped)" : "", threadInfo.threadId, l, l - this.delta, this.debugMethod(n)});
        }
        TimedCPUCCTNode timedCPUCCTNode = threadInfo.peek();
        if (bl) {
            long l3 = l - threadInfo.topMethodEntryTime0;
            if (l3 > 0L) {
                timedCPUCCTNode.addNetTime0(l3);
            } else {
                l = threadInfo.topMethodEntryTime0;
            }
            threadInfo.topMethodEntryTime0 = l;
            if (this.isCollectingTwoTimeStamps()) {
                l3 = l2 - threadInfo.topMethodEntryTime1;
                if (l3 > 0L) {
                    timedCPUCCTNode.addNetTime1(l3);
                } else {
                    l2 = threadInfo.topMethodEntryTime1;
                }
                threadInfo.topMethodEntryTime1 = l2;
            }
        }
        if ((methodCPUCCTNode = MethodCPUCCTNode.Locator.locate(n, timedCPUCCTNode.getChildren())) != null) {
            threadInfo.push(methodCPUCCTNode);
            return methodCPUCCTNode;
        }
        methodCPUCCTNode = this.factory.createMethodNode(n);
        timedCPUCCTNode.attachNodeAsChild(methodCPUCCTNode);
        timedCPUCCTNode = methodCPUCCTNode;
        ++threadInfo.totalNNodes;
        threadInfo.push(timedCPUCCTNode);
        if (!threadInfo.isInRoot()) {
            try {
                this.methodInfoMapper.lock(false);
                String string = this.methodInfoMapper.getInstrMethodClass(((MethodCPUCCTNode)timedCPUCCTNode).getMethodId()).replace('.', '/');
                ProfilerClient profilerClient = this.getClient();
                if (profilerClient != null) {
                    if (!profilerClient.getSettings().getInstrumentationFilter().passesFilter(string)) {
                        timedCPUCCTNode.setFilteredStatus(2);
                    }
                } else {
                    timedCPUCCTNode.setFilteredStatus(2);
                }
            }
            finally {
                this.methodInfoMapper.unlock();
            }
        }
        return timedCPUCCTNode;
    }

    private TimedCPUCCTNode plainMethodEntry(int n, ThreadInfo threadInfo, long l, long l2) {
        return this.plainMethodEntry(n, threadInfo, l, l2, true);
    }

    private TimedCPUCCTNode plainMethodEntry(int n, ThreadInfo threadInfo) {
        return this.plainMethodEntry(n, threadInfo, 0L, 0L, false);
    }

    private TimedCPUCCTNode plainMethodExit(int n, ThreadInfo threadInfo, long l, long l2, boolean bl) {
        TimedCPUCCTNode timedCPUCCTNode;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "MethodExit{0}: {1}, time: {2}, delta: {3}, ti: {4}", new Object[]{!bl ? "(unstamped)" : "", this.debugMethod(n), l, l - this.delta, threadInfo});
            this.delta = l;
        }
        if ((timedCPUCCTNode = threadInfo.peek()) == null) {
            LOGGER.severe("*** Profiler engine warning: critical: stack integrity violation on method exit.\n*** methodId on simulated stack top is unidentifiable\n");
            return null;
        }
        if (!(timedCPUCCTNode instanceof MethodCPUCCTNode)) {
            LOGGER.severe("*** Profiler engine warning: critical: stack integrity violation on method exit.\n*** methodId on simulated stack top is unidentifiable\n");
            return null;
        }
        MethodCPUCCTNode methodCPUCCTNode = (MethodCPUCCTNode)timedCPUCCTNode;
        if (n != methodCPUCCTNode.getMethodId()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("*** Profiler engine warning: ").append("critical: stack integrity violation on method exit.\n");
            stringBuilder.append("*** methodId on simulated stack top: ").append(methodCPUCCTNode.getMethodId());
            stringBuilder.append(", received methodId (should match) = ").append(n).append('\n');
            stringBuilder.append("received method debug: ").append(this.debugMethod(n)).append('\n');
            stringBuilder.append("*** Please report this problem to feedback@profiler.netbeans.org");
            if (!this.stackIntegrityViolationReported) {
                stringBuilder.append(this.dumpStack(threadInfo));
                this.stackIntegrityViolationReported = true;
            }
            stringBuilder.append('\n');
            LOGGER.severe(stringBuilder.toString());
            return null;
        }
        if (bl) {
            long l3 = l - threadInfo.topMethodEntryTime0;
            if (l3 > 0L) {
                timedCPUCCTNode.addNetTime0(l3);
            } else {
                l = threadInfo.topMethodEntryTime0;
            }
            if (this.isCollectingTwoTimeStamps()) {
                l3 = l2 - threadInfo.topMethodEntryTime1;
                if (l3 > 0L) {
                    timedCPUCCTNode.addNetTime1(l3);
                } else {
                    l2 = threadInfo.topMethodEntryTime1;
                }
            }
        }
        TimedCPUCCTNode timedCPUCCTNode2 = threadInfo.pop();
        if (bl) {
            threadInfo.topMethodEntryTime0 = l;
            if (this.isCollectingTwoTimeStamps()) {
                threadInfo.topMethodEntryTime1 = l2;
            }
        }
        return timedCPUCCTNode2;
    }

    private TimedCPUCCTNode plainMethodExit(int n, ThreadInfo threadInfo, long l, long l2) {
        return this.plainMethodExit(n, threadInfo, l, l2, true);
    }

    private TimedCPUCCTNode plainMethodExit(int n, ThreadInfo threadInfo) {
        return this.plainMethodExit(n, threadInfo, 0L, 0L, false);
    }

    private TimedCPUCCTNode rootMethodEntry(int n, ThreadInfo threadInfo, long l, long l2) {
        Object object;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "RootMEntry for tId = {0}, time: {1}, method:  {2}", new Object[]{threadInfo.threadId, l, this.debugMethod(n)});
        }
        Mark mark = MarkingEngine.getDefault().markMethod(n, this.status);
        Object object2 = threadInfo.peek();
        if (threadInfo.isInRoot()) {
            object = new StringBuilder();
            ((StringBuilder)object).append("*** Profiler engine warning: ").append("critical: at root method entry thread stack is not at 0 - should not happen!\n");
            ((StringBuilder)object).append("*** thread = ").append(this.threadInfos.threadNames[threadInfo.threadId]);
            ((StringBuilder)object).append(", ti.stackTopIdx = ").append(threadInfo.stackTopIdx);
            if (object2 != null) {
                ((StringBuilder)object).append(", curNode = ").append(object2).append('\n');
            }
            ((StringBuilder)object).append("*** Please report this problem to feedback@profiler.netbeans.org");
            LOGGER.severe(((StringBuilder)object).toString());
        }
        if (object2 == null) {
            object = this.factory.createThreadNode(threadInfo.threadId);
            ++threadInfo.totalNNodes;
            threadInfo.push((TimedCPUCCTNode)object);
            --threadInfo.totalNInv;
            if (!mark.isDefault()) {
                object2 = this.factory.createCategory(mark);
                ((BaseCPUCCTNode)object).attachNodeAsChild((RuntimeCPUCCTNode)object2);
                ++threadInfo.totalNNodes;
                threadInfo.push((TimedCPUCCTNode)object2);
                object = object2;
            }
            object2 = this.factory.createMethodNode(n);
            ((BaseCPUCCTNode)object).attachNodeAsChild((RuntimeCPUCCTNode)object2);
            ++threadInfo.totalNNodes;
        } else {
            if (!mark.isDefault()) {
                object = MarkedCPUCCTNode.Locator.locate(mark, ((BaseCPUCCTNode)object2).getChildren());
                if (object == null) {
                    object = this.factory.createCategory(mark);
                    ((BaseCPUCCTNode)object2).attachNodeAsChild((RuntimeCPUCCTNode)object);
                    ++threadInfo.totalNNodes;
                }
                threadInfo.push((TimedCPUCCTNode)object);
                object2 = object;
            }
            if ((object = MethodCPUCCTNode.Locator.locate(n, ((BaseCPUCCTNode)object2).getChildren())) == null) {
                object = this.factory.createMethodNode(n);
                ((BaseCPUCCTNode)object2).attachNodeAsChild((RuntimeCPUCCTNode)object);
                ++threadInfo.totalNNodes;
            }
            object2 = object;
        }
        threadInfo.push((TimedCPUCCTNode)object2);
        threadInfo.rootMethodEntryTimeAbs = l;
        threadInfo.rootMethodEntryTimeThreadCPU = l2;
        threadInfo.topMethodEntryTime0 = l;
        if (this.isCollectingTwoTimeStamps()) {
            threadInfo.topMethodEntryTime1 = l2;
        }
        ++threadInfo.inRoot;
        return object2;
    }

    private TimedCPUCCTNode rootMethodExit(int n, ThreadInfo threadInfo, long l, long l2) {
        TimedCPUCCTNode timedCPUCCTNode;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "RootMExit for tId = {0}, time: {1}, delta: {2}, method: {3}", new Object[]{threadInfo.threadId, l, l - this.delta, this.debugMethod(n)});
            this.delta = l;
        }
        if ((timedCPUCCTNode = threadInfo.peek()) == null) {
            LOGGER.severe("*** Profiler engine warning: critical: stack integrity violation on root method exit.\n*** methodId on simulated stack top is unidentifiable\n");
            return null;
        }
        if (!(timedCPUCCTNode instanceof MethodCPUCCTNode)) {
            LOGGER.severe("*** Profiler engine warning: critical: stack integrity violation on root method exit.\n*** methodId on simulated stack top is unidentifiable\n");
            return null;
        }
        MethodCPUCCTNode methodCPUCCTNode = (MethodCPUCCTNode)timedCPUCCTNode;
        if (n != methodCPUCCTNode.getMethodId()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("*** Profiler engine warning: ").append("critical: stack integrity violation on root thod exit.\n");
            stringBuilder.append("*** methodId on simulated stack top: ").append(methodCPUCCTNode.getMethodId()).append('\n');
            stringBuilder.append(", received methodId (should match) = ").append(n).append('\n');
            stringBuilder.append("received method debug: ").append(this.debugMethod(n)).append('\n');
            stringBuilder.append("*** Please report this problem to feedback@profiler.netbeans.org");
            if (this.status != null && this.status.getInstrMethodClasses() != null && !this.stackIntegrityViolationReported) {
                stringBuilder.append(this.dumpStack(threadInfo));
                this.stackIntegrityViolationReported = true;
            }
            stringBuilder.append('\n');
            LOGGER.severe(stringBuilder.toString());
            return null;
        }
        long l3 = l - threadInfo.topMethodEntryTime0;
        if (l3 > 0L) {
            timedCPUCCTNode.addNetTime0(l3);
        } else {
            l = threadInfo.topMethodEntryTime0;
        }
        if (this.isCollectingTwoTimeStamps()) {
            l3 = l2 - threadInfo.topMethodEntryTime1;
            if (l3 > 0L) {
                timedCPUCCTNode.addNetTime1(l3);
            } else {
                l2 = threadInfo.topMethodEntryTime1;
            }
        }
        --threadInfo.inRoot;
        TimedCPUCCTNode timedCPUCCTNode2 = threadInfo.pop();
        if (threadInfo.isInRoot()) {
            threadInfo.topMethodEntryTime0 = l;
            if (this.isCollectingTwoTimeStamps()) {
                threadInfo.topMethodEntryTime1 = l2;
            }
        } else {
            threadInfo.rootGrossTimeAbs += l - threadInfo.rootMethodEntryTimeAbs;
            threadInfo.rootGrossTimeThreadCPU += l2 - threadInfo.rootMethodEntryTimeThreadCPU;
            threadInfo.rootMethodEntryTimeAbs = 0L;
            threadInfo.rootMethodEntryTimeThreadCPU = 0L;
        }
        return timedCPUCCTNode2;
    }

    private class DebugInfoCollector
    extends RuntimeCCTNodeProcessor.PluginAdapter {
        private StringBuffer buffer = new StringBuffer();

        public StringBuffer getBuffer() {
            return this.buffer;
        }

        public synchronized String getInfo(RuntimeCPUCCTNode runtimeCPUCCTNode) {
            this.buffer = new StringBuffer();
            RuntimeCCTNodeProcessor.process(runtimeCPUCCTNode, this);
            return this.buffer.toString();
        }

        @Override
        public void onNode(MethodCPUCCTNode methodCPUCCTNode) {
            this.buffer.append(CPUCallGraphBuilder.this.debugMethod(methodCPUCCTNode.getMethodId()));
        }

        @Override
        public void onNode(ServletRequestCPUCCTNode servletRequestCPUCCTNode) {
            this.buffer.append("Boundary");
        }

        @Override
        public void onNode(ThreadCPUCCTNode threadCPUCCTNode) {
            this.buffer.append("threadId = ").append(threadCPUCCTNode.getThreadId());
        }

        @Override
        public void onNode(MarkedCPUCCTNode markedCPUCCTNode) {
            this.buffer.append("Category ").append(markedCPUCCTNode.getMark());
        }
    }
}

