/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.bugspot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import sun.jvm.hotspot.bugspot.tree.AddressTreeNodeAdapter;
import sun.jvm.hotspot.bugspot.tree.DoubleTreeNodeAdapter;
import sun.jvm.hotspot.bugspot.tree.EnumTreeNodeAdapter;
import sun.jvm.hotspot.bugspot.tree.FloatTreeNodeAdapter;
import sun.jvm.hotspot.bugspot.tree.LongTreeNodeAdapter;
import sun.jvm.hotspot.bugspot.tree.ObjectTreeNodeAdapter;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.AddressException;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.DefaultObjectVisitor;
import sun.jvm.hotspot.debugger.cdbg.FieldIdentifier;
import sun.jvm.hotspot.debugger.cdbg.Type;
import sun.jvm.hotspot.oops.LocalVariableTableElement;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.NamedFieldIdentifier;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.JavaVFrame;
import sun.jvm.hotspot.runtime.StackValueCollection;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.ui.tree.BooleanTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.CharTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.FieldTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.OopTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.SimpleTreeGroupNode;
import sun.jvm.hotspot.ui.tree.SimpleTreeNode;
import sun.jvm.hotspot.ui.treetable.JTreeTable;
import sun.jvm.hotspot.ui.treetable.SimpleTreeTableModel;

public class VariablePanel
extends JPanel {
    private JTreeTable treeTable;
    private SimpleTreeTableModel model = new SimpleTreeTableModel();
    private SimpleTreeGroupNode root;

    public VariablePanel() {
        this.model.setValuesEditable(false);
        this.root = new SimpleTreeGroupNode();
        this.model.setRoot(this.root);
        this.treeTable = new JTreeTable(this.model);
        this.treeTable.setRootVisible(false);
        this.treeTable.setShowsRootHandles(true);
        this.treeTable.setShowsIcons(false);
        this.treeTable.setTreeEditable(false);
        this.treeTable.getTableHeader().setReorderingAllowed(false);
        this.treeTable.setCellSelectionEnabled(true);
        this.treeTable.setSelectionMode(1);
        this.treeTable.setDragEnabled(true);
        JScrollPane sp = new JScrollPane(this.treeTable);
        sp.getViewport().setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.add((Component)sp, "Center");
    }

    public void clear() {
        this.root.removeAllChildren();
        this.model.fireTreeStructureChanged();
    }

    public void update(CFrame fr) {
        CCollector coll = new CCollector();
        fr.iterateLocals(coll);
        this.update(coll);
    }

    public void update(JavaVFrame jfr) {
        Method m = jfr.getMethod();
        if (!m.hasLocalVariableTable()) {
            return;
        }
        int bci = jfr.getBCI();
        LocalVariableTableElement[] locals = m.getLocalVariableTable();
        StackValueCollection coll = jfr.getLocals();
        this.root.removeAllChildren();
        for (int i = 0; i < locals.length; ++i) {
            Symbol name;
            FieldTreeNodeAdapter node;
            LocalVariableTableElement local;
            block17: {
                local = locals[i];
                if (local.getStartBCI() > bci || bci >= local.getStartBCI() + local.getLength()) continue;
                node = null;
                name = null;
                try {
                    name = m.getConstants().getSymbolAt(local.getNameCPIndex());
                    if (name == null) {
                        System.err.println("Null name at slot " + local.getNameCPIndex() + " for local variable at slot " + local.getSlot());
                    }
                    break block17;
                }
                catch (Exception e) {
                    System.err.println("Unable to fetch name at slot " + local.getNameCPIndex() + " for local variable at slot " + local.getSlot());
                    e.printStackTrace();
                }
                continue;
            }
            NamedFieldIdentifier f = new NamedFieldIdentifier(name.asString());
            Symbol descriptor = null;
            try {
                descriptor = m.getConstants().getSymbolAt(local.getDescriptorCPIndex());
            }
            catch (Exception e) {
                System.err.println("Unable to fetch descriptor at slot " + local.getDescriptorCPIndex() + " for local variable " + f.getName() + " at slot " + local.getSlot());
                e.printStackTrace();
                continue;
            }
            if (descriptor == null) continue;
            switch (descriptor.getByteAt(0L)) {
                case 70: {
                    node = new sun.jvm.hotspot.ui.tree.FloatTreeNodeAdapter(coll.floatAt(local.getSlot()), f, true);
                    break;
                }
                case 68: {
                    node = new sun.jvm.hotspot.ui.tree.DoubleTreeNodeAdapter(coll.doubleAt(local.getSlot()), f, true);
                    break;
                }
                case 67: {
                    node = new CharTreeNodeAdapter((char)coll.intAt(local.getSlot()), f, true);
                    break;
                }
                case 66: 
                case 73: 
                case 83: {
                    node = new sun.jvm.hotspot.ui.tree.LongTreeNodeAdapter(coll.intAt(local.getSlot()), f, true);
                    break;
                }
                case 90: {
                    node = new BooleanTreeNodeAdapter(coll.intAt(local.getSlot()) != 0, f, true);
                    break;
                }
                case 74: {
                    node = new sun.jvm.hotspot.ui.tree.LongTreeNodeAdapter(coll.longAt(local.getSlot()), f, true);
                    break;
                }
                default: {
                    try {
                        node = new OopTreeNodeAdapter(VM.getVM().getObjectHeap().newOop(coll.oopHandleAt(local.getSlot())), f, true);
                        break;
                    }
                    catch (AddressException e) {
                        node = new FieldTreeNodeAdapter(f, true){

                            @Override
                            public int getChildCount() {
                                return 0;
                            }

                            @Override
                            public SimpleTreeNode getChild(int i) {
                                return null;
                            }

                            @Override
                            public boolean isLeaf() {
                                return false;
                            }

                            @Override
                            public int getIndexOfChild(SimpleTreeNode child) {
                                return 0;
                            }

                            @Override
                            public String getValue() {
                                return "<Bad oop>";
                            }
                        };
                    }
                }
            }
            if (node == null) continue;
            this.root.addChild(node);
        }
        this.model.fireTreeStructureChanged();
    }

    public void update(Address thisAddr, Type type) {
        CCollector coll = new CCollector();
        type.iterateObject(thisAddr, coll);
        this.update(coll);
    }

    private void update(CCollector coll) {
        this.root.removeAllChildren();
        for (int i = 0; i < coll.getNumChildren(); ++i) {
            this.root.addChild(coll.getChild(i));
        }
        this.model.fireTreeStructureChanged();
    }

    static class CCollector
    extends DefaultObjectVisitor {
        private List children = new ArrayList();

        public int getNumChildren() {
            return this.children.size();
        }

        public SimpleTreeNode getChild(int i) {
            return (SimpleTreeNode)this.children.get(i);
        }

        @Override
        public void doBit(FieldIdentifier f, long val) {
            this.children.add(new LongTreeNodeAdapter(val, f, true));
        }

        @Override
        public void doInt(FieldIdentifier f, long val) {
            this.children.add(new LongTreeNodeAdapter(val, f, true));
        }

        @Override
        public void doEnum(FieldIdentifier f, long val, String enumName) {
            this.children.add(new EnumTreeNodeAdapter(enumName, val, f, true));
        }

        @Override
        public void doFloat(FieldIdentifier f, float val) {
            this.children.add(new FloatTreeNodeAdapter(val, f, true));
        }

        @Override
        public void doDouble(FieldIdentifier f, double val) {
            this.children.add(new DoubleTreeNodeAdapter(val, f, true));
        }

        @Override
        public void doPointer(FieldIdentifier f, Address val) {
            this.children.add(new AddressTreeNodeAdapter(val, f, true));
        }

        @Override
        public void doArray(FieldIdentifier f, Address val) {
            this.children.add(new AddressTreeNodeAdapter(val, f, true));
        }

        @Override
        public void doRef(FieldIdentifier f, Address val) {
            this.children.add(new AddressTreeNodeAdapter(val, f, true));
        }

        @Override
        public void doCompound(FieldIdentifier f, Address val) {
            this.children.add(new ObjectTreeNodeAdapter(val, f, true));
        }
    }
}

