/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.jvm;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.application.jvm.MonitoredData;
import com.sun.tools.visualvm.application.jvm.MonitoredDataListener;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.heapdump.HeapDumpSupport;
import com.sun.tools.visualvm.host.Host;
import com.sun.tools.visualvm.jvm.JmxSupport;
import com.sun.tools.visualvm.jvm.MonitoredDataImpl;
import com.sun.tools.visualvm.threaddump.ThreadDumpSupport;
import com.sun.tools.visualvm.tools.attach.AttachModel;
import com.sun.tools.visualvm.tools.attach.AttachModelFactory;
import com.sun.tools.visualvm.tools.jmx.JmxModel;
import com.sun.tools.visualvm.tools.jmx.JmxModelFactory;
import com.sun.tools.visualvm.tools.jmx.JvmMXBeans;
import com.sun.tools.visualvm.tools.jvmstat.JvmJvmstatModel;
import com.sun.tools.visualvm.tools.jvmstat.JvmJvmstatModelFactory;
import com.sun.tools.visualvm.tools.jvmstat.JvmstatListener;
import com.sun.tools.visualvm.tools.jvmstat.JvmstatModel;
import com.sun.tools.visualvm.tools.sa.SaModel;
import com.sun.tools.visualvm.tools.sa.SaModelFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.GarbageCollectorMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.openide.util.NbBundle;

public class JVMImpl
extends Jvm
implements JvmstatListener {
    private static final String HEAP_DUMP_ON_OOME = "HeapDumpOnOutOfMemoryError";
    private static final String HEAP_DUMP_PATH = "HeapDumpPath";
    Application application;
    Boolean isDumpOnOOMEnabled;
    JvmstatModel monitoredVm;
    JvmJvmstatModel jvmstatModel;
    Set<MonitoredDataListener> listeners;
    JmxSupport jmxSupport;
    private boolean staticDataInitialized;
    private Object staticDataLock = new Object();
    private String commandLine;
    private String jvmArgs;
    private String jvmFlags;
    private String mainArgs;
    private String mainClass;
    private String vmVersion;
    private String javaVersion;
    private String javaHome;
    private String vmInfo;
    private String vmName;
    private String vmVendor;

    JVMImpl(Application app, JvmstatModel jvms) {
        this.application = app;
        this.monitoredVm = jvms;
        this.jvmstatModel = JvmJvmstatModelFactory.getJvmstatModelFor((Application)app);
        this.jmxSupport = new JmxSupport(app, this);
        this.listeners = new HashSet<MonitoredDataListener>();
    }

    JVMImpl(Application app) {
        this.application = app;
        this.jmxSupport = new JmxSupport(app, this);
        this.listeners = new HashSet<MonitoredDataListener>();
    }

    public boolean isAttachable() {
        if (this.jvmstatModel != null) {
            if (!this.jvmstatModel.isAttachable()) {
                return false;
            }
            return this.getAttach() != null;
        }
        return false;
    }

    public boolean isBasicInfoSupported() {
        return true;
    }

    public String getCommandLine() {
        this.initStaticData();
        return this.commandLine;
    }

    public String getJvmArgs() {
        this.initStaticData();
        return this.jvmArgs;
    }

    public String getJvmFlags() {
        this.initStaticData();
        return this.jvmFlags;
    }

    public String getMainArgs() {
        this.initStaticData();
        return this.mainArgs;
    }

    public String getMainClass() {
        this.initStaticData();
        return this.mainClass;
    }

    public String getVmVersion() {
        this.initStaticData();
        return this.vmVersion;
    }

    public String getJavaVersion() {
        this.initStaticData();
        if (this.javaVersion != null) {
            return this.javaVersion;
        }
        return this.vmVersion;
    }

    public String getJavaHome() {
        this.initStaticData();
        return this.javaHome;
    }

    public String getVmInfo() {
        this.initStaticData();
        return this.vmInfo;
    }

    public String getVmName() {
        this.initStaticData();
        return this.vmName;
    }

    public String getVmVendor() {
        this.initStaticData();
        return this.vmVendor;
    }

    public boolean is14() {
        String ver = this.getVmVersion();
        return ver != null && ver.startsWith("1.4.");
    }

    public boolean is15() {
        String ver = this.getJavaVersion();
        return ver != null && ver.startsWith("1.5.");
    }

    public boolean is16() {
        String ver = this.getJavaVersion();
        return ver != null && (ver.startsWith("1.6.") || ver.startsWith("10.") || ver.startsWith("11."));
    }

    public boolean is17() {
        String ver = this.getJavaVersion();
        return ver != null && (ver.startsWith("1.7.") || ver.startsWith("12.") || ver.startsWith("13.") || ver.startsWith("14."));
    }

    public boolean is18() {
        String ver = this.getJavaVersion();
        return ver != null && ver.startsWith("1.8.");
    }

    public boolean isDumpOnOOMEnabled() {
        if (this.isDumpOnOOMEnabled == null) {
            JmxModel jmx;
            AttachModel attach = this.getAttach();
            String args = null;
            if (attach != null) {
                args = attach.printFlag(HEAP_DUMP_ON_OOME);
            }
            if (args == null && (jmx = this.getJmxModel()) != null && jmx.isTakeHeapDumpSupported() && !this.jmxSupport.isReadOnlyConnection()) {
                String value = jmx.getFlagValue(HEAP_DUMP_ON_OOME);
                this.isDumpOnOOMEnabled = Boolean.valueOf(value);
                return this.isDumpOnOOMEnabled;
            }
            if (args == null && this.monitoredVm != null) {
                args = this.getJvmFlags().concat(this.getJvmArgs());
            }
            this.isDumpOnOOMEnabled = args != null && args.contains("-XX:+HeapDumpOnOutOfMemoryError") ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.isDumpOnOOMEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitoredDataListener(MonitoredDataListener l) {
        Set<MonitoredDataListener> set = this.listeners;
        synchronized (set) {
            if (this.listeners.add(l)) {
                if (this.monitoredVm != null) {
                    if (this.jmxSupport != null) {
                        this.jmxSupport.disableTimer();
                    }
                    this.monitoredVm.addJvmstatListener((JvmstatListener)this);
                } else if (this.jmxSupport != null) {
                    this.jmxSupport.initTimer();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMonitoredDataListener(MonitoredDataListener l) {
        Set<MonitoredDataListener> set = this.listeners;
        synchronized (set) {
            if (this.listeners.remove(l) && this.listeners.isEmpty()) {
                if (this.monitoredVm != null) {
                    this.monitoredVm.removeJvmstatListener((JvmstatListener)this);
                } else if (this.jmxSupport != null) {
                    this.jmxSupport.disableTimer();
                }
            }
        }
    }

    public boolean isMonitoringSupported() {
        return this.isClassMonitoringSupported() || this.isThreadMonitoringSupported() || this.isMemoryMonitoringSupported();
    }

    public boolean isClassMonitoringSupported() {
        return this.monitoredVm != null || this.jmxSupport.getRuntime() != null;
    }

    public boolean isThreadMonitoringSupported() {
        return !this.is14() && this.monitoredVm != null || this.jmxSupport.getRuntime() != null;
    }

    public boolean isMemoryMonitoringSupported() {
        return this.monitoredVm != null || this.jmxSupport.getRuntime() != null;
    }

    public boolean isGetSystemPropertiesSupported() {
        return this.getAttach() != null || this.jmxSupport.getRuntime() != null || this.getSAAgent() != null;
    }

    public Properties getSystemProperties() {
        AttachModel attach = this.getAttach();
        Properties prop = null;
        if (attach != null) {
            prop = attach.getSystemProperties();
        }
        if (prop != null) {
            return prop;
        }
        JmxModel jmx = this.getJmxModel();
        if (jmx != null) {
            prop = jmx.getSystemProperties();
        }
        if (prop != null) {
            return prop;
        }
        SaModel saAgent = this.getSAAgent();
        if (saAgent != null) {
            return saAgent.getSystemProperties();
        }
        if (!this.isGetSystemPropertiesSupported()) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public boolean isDumpOnOOMEnabledSupported() {
        if (this.getAttach() != null) {
            return true;
        }
        JmxModel jmx = this.getJmxModel();
        return Host.LOCALHOST.equals((Object)this.application.getHost()) && jmx != null && jmx.isTakeHeapDumpSupported();
    }

    public synchronized void setDumpOnOOMEnabled(boolean enabled) {
        if (!this.isDumpOnOOMEnabledSupported()) {
            throw new UnsupportedOperationException();
        }
        AttachModel attach = this.getAttach();
        if (attach != null) {
            attach.setFlag(HEAP_DUMP_ON_OOME, enabled ? "1" : "0");
            if (enabled) {
                attach.setFlag(HEAP_DUMP_PATH, this.application.getStorage().getDirectory().getAbsolutePath());
            }
        } else {
            JmxModel jmx = this.getJmxModel();
            jmx.setFlagValue(HEAP_DUMP_ON_OOME, Boolean.toString(enabled));
            if (enabled) {
                jmx.setFlagValue(HEAP_DUMP_PATH, this.application.getStorage().getDirectory().getAbsolutePath());
            }
        }
        Boolean oldVlue = this.isDumpOnOOMEnabled;
        this.isDumpOnOOMEnabled = enabled;
        this.firePropertyChange("prop_oome", oldVlue, this.isDumpOnOOMEnabled);
    }

    public boolean isTakeHeapDumpSupported() {
        if (this.getAttach() != null) {
            return true;
        }
        JmxModel jmx = this.getJmxModel();
        return Host.LOCALHOST.equals((Object)this.application.getHost()) && jmx != null && jmx.isTakeHeapDumpSupported();
    }

    public File takeHeapDump() throws IOException {
        if (!this.isTakeHeapDumpSupported()) {
            throw new UnsupportedOperationException();
        }
        File snapshotDir = this.application.getStorage().getDirectory();
        String name = HeapDumpSupport.getInstance().getCategory().createFileName();
        File dumpFile = new File(snapshotDir, name);
        AttachModel attach = this.getAttach();
        if (attach != null) {
            if (attach.takeHeapDump(dumpFile.getAbsolutePath())) {
                return dumpFile;
            }
            return null;
        }
        if (this.getJmxModel().takeHeapDump(dumpFile.getAbsolutePath())) {
            return dumpFile;
        }
        return null;
    }

    public boolean isTakeThreadDumpSupported() {
        if (this.getAttach() != null) {
            return true;
        }
        JmxModel jmx = this.getJmxModel();
        if (jmx != null && jmx.isTakeThreadDumpSupported()) {
            return true;
        }
        return this.getSAAgent() != null;
    }

    public File takeThreadDump() throws IOException {
        SaModel sa;
        JmxModel jmx;
        AttachModel attach = this.getAttach();
        String threadDump = null;
        if (attach != null) {
            threadDump = attach.takeThreadDump();
        }
        if (threadDump == null && (jmx = this.getJmxModel()) != null) {
            threadDump = jmx.takeThreadDump();
        }
        if (threadDump == null && (sa = this.getSAAgent()) != null) {
            threadDump = sa.takeThreadDump();
        }
        if (threadDump == null) {
            if (!this.isTakeThreadDumpSupported()) {
                throw new UnsupportedOperationException();
            }
            threadDump = NbBundle.getMessage(JVMImpl.class, (String)"MSG_ThreadDumpfailed");
        }
        File snapshotDir = this.application.getStorage().getDirectory();
        String name = ThreadDumpSupport.getInstance().getCategory().createFileName();
        File dumpFile = new File(snapshotDir, name);
        FileOutputStream os = new FileOutputStream(dumpFile);
        ((OutputStream)os).write(threadDump.getBytes("UTF-8"));
        ((OutputStream)os).close();
        return dumpFile;
    }

    public boolean isCpuMonitoringSupported() {
        return this.jmxSupport.hasProcessCPUTimeAttribute();
    }

    public boolean isCollectionTimeSupported() {
        Collection<GarbageCollectorMXBean> gcList = this.jmxSupport.getGarbageCollectorMXBeans();
        return gcList != null && !gcList.isEmpty();
    }

    public MonitoredData getMonitoredData() {
        if (this.application.getState() == 1) {
            JvmMXBeans jmx;
            if (this.monitoredVm != null) {
                return new MonitoredDataImpl((Jvm)this, this.jvmstatModel, this.jmxSupport);
            }
            if (this.jmxSupport != null && (jmx = this.jmxSupport.getJvmMXBeans()) != null) {
                return new MonitoredDataImpl((Jvm)this, this.jmxSupport, jmx);
            }
        }
        return null;
    }

    protected AttachModel getAttach() {
        return AttachModelFactory.getAttachFor((Application)this.application);
    }

    protected SaModel getSAAgent() {
        return SaModelFactory.getSAAgentFor((DataSource)this.application);
    }

    protected JmxModel getJmxModel() {
        return JmxModelFactory.getJmxModelFor((Application)this.application);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initStaticData() {
        Object object = this.staticDataLock;
        synchronized (object) {
            if (this.staticDataInitialized) {
                return;
            }
            if (this.jvmstatModel != null) {
                this.commandLine = this.jvmstatModel.getCommandLine();
                this.jvmArgs = this.getJvmArgsJvmstat();
                this.jvmFlags = this.jvmstatModel.getJvmFlags();
                this.mainArgs = this.jvmstatModel.getMainArgs();
                this.mainClass = this.jvmstatModel.getMainClass();
                this.vmVersion = this.jvmstatModel.getVmVersion();
                this.javaVersion = this.monitoredVm.findByName("java.property.java.version");
                this.javaHome = this.jvmstatModel.getJavaHome();
                this.vmInfo = this.jvmstatModel.getVmInfo();
                this.vmName = this.jvmstatModel.getVmName();
                this.vmVendor = this.jvmstatModel.getVmVendor();
            } else {
                this.jvmArgs = this.jmxSupport.getJvmArgs();
                Properties prop = this.getJmxModel().getSystemProperties();
                if (prop != null) {
                    this.vmVersion = prop.getProperty("java.vm.version");
                    this.javaVersion = prop.getProperty("java.version");
                    this.javaHome = prop.getProperty("java.home");
                    this.vmInfo = prop.getProperty("java.vm.info");
                    this.vmName = prop.getProperty("java.vm.name");
                    this.vmVendor = prop.getProperty("java.vm.vendor");
                }
            }
            this.staticDataInitialized = true;
        }
    }

    private String getJvmArgsJvmstat() {
        String args = this.jvmstatModel.getJvmArgs();
        if (args.length() == 1024) {
            SaModel sa;
            args = this.jmxSupport.getJvmArgs();
            if (args == null && (sa = this.getSAAgent()) != null) {
                args = sa.getJvmArgs();
            }
            if (args == null || args.length() == 0) {
                args = this.jvmstatModel.getJvmArgs();
            }
        }
        return args;
    }

    public void dataChanged(JvmstatModel stat) {
        assert (stat == this.monitoredVm);
        MonitoredDataImpl data = new MonitoredDataImpl((Jvm)this, this.jvmstatModel, this.jmxSupport);
        this.notifyListeners(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListeners(MonitoredData data) {
        ArrayList<MonitoredDataListener> listenersCopy;
        Set<MonitoredDataListener> set = this.listeners;
        synchronized (set) {
            listenersCopy = new ArrayList<MonitoredDataListener>(this.listeners);
        }
        for (MonitoredDataListener listener : listenersCopy) {
            listener.monitoredDataEvent(data);
        }
    }
}

