/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.EventObject;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.inspector.ThreadDialog;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XDataViewer;
import sun.tools.jconsole.inspector.XMBean;
import sun.tools.jconsole.inspector.XTable;
import sun.tools.jconsole.inspector.XTextFieldEditor;

public class XMBeanAttributes
extends XTable {
    final Logger LOGGER = Logger.getLogger(XMBeanAttributes.class.getPackage().getName());
    private static final String[] columnNames = new String[]{Resources.getText("Name", new Object[0]), Resources.getText("Value", new Object[0])};
    private XMBean mbean;
    private MBeanInfo mbeanInfo;
    private MBeanAttributeInfo[] attributesInfo;
    private HashMap<String, Object> attributes;
    private HashMap<String, Object> unavailableAttributes;
    private HashMap<String, Object> viewableAttributes;
    private WeakHashMap<XMBean, HashMap<String, ZoomedCell>> viewersCache = new WeakHashMap();
    private final TableModelListener attributesListener;
    private MBeansTab mbeansTab;
    private TableCellEditor valueCellEditor = new ValueCellEditor();
    private int rowMinHeight = -1;
    private AttributesMouseListener mouseListener = new AttributesMouseListener();
    private static TableCellEditor editor = new Utils.ReadOnlyTableCellEditor(new JTextField());

    public XMBeanAttributes(MBeansTab mBeansTab) {
        this.mbeansTab = mBeansTab;
        ((DefaultTableModel)this.getModel()).setColumnIdentifiers(columnNames);
        this.attributesListener = new AttributesListener(this);
        this.getModel().addTableModelListener(this.attributesListener);
        this.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.addMouseListener(this.mouseListener);
        this.getTableHeader().setReorderingAllowed(false);
        this.setColumnEditors();
        this.addKeyListener(new Utils.CopyKeyAdapter());
    }

    @Override
    public synchronized Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        if (n >= this.getRowCount()) {
            return null;
        }
        return super.prepareRenderer(tableCellRenderer, n, n2);
    }

    void updateRowHeight(Object object, int n) {
        ZoomedCell zoomedCell = null;
        if (object instanceof ZoomedCell) {
            zoomedCell = (ZoomedCell)object;
            if (zoomedCell.isInited()) {
                this.setRowHeight(n, zoomedCell.getHeight());
            } else if (this.rowMinHeight != -1) {
                this.setRowHeight(n, this.rowMinHeight);
            }
        } else if (this.rowMinHeight != -1) {
            this.setRowHeight(n, this.rowMinHeight);
        }
    }

    @Override
    public synchronized TableCellRenderer getCellRenderer(int n, int n2) {
        ZoomedCell zoomedCell;
        Object object;
        if (n >= this.getRowCount()) {
            return null;
        }
        if (n2 == 1 && (object = this.getModel().getValueAt(n, n2)) instanceof ZoomedCell && (zoomedCell = (ZoomedCell)object).isInited()) {
            DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)zoomedCell.getRenderer();
            defaultTableCellRenderer.setToolTipText(this.getToolTip(n, n2));
            return defaultTableCellRenderer;
        }
        object = (DefaultTableCellRenderer)super.getCellRenderer(n, n2);
        if (!(this.isCellError(n, n2) || this.isColumnEditable(n2) && this.isWritable(n) && Utils.isEditableType(this.getClassName(n)))) {
            ((DefaultTableCellRenderer)object).setForeground(this.getDefaultColor());
        }
        return object;
    }

    private void setColumnEditors() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i = 0; i < columnNames.length; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (this.isColumnEditable(i)) {
                tableColumn.setCellEditor(this.valueCellEditor);
                continue;
            }
            tableColumn.setCellEditor(editor);
        }
    }

    public void cancelCellEditing() {
        TableCellEditor tableCellEditor;
        if (this.LOGGER.isLoggable(Level.FINER)) {
            this.LOGGER.finer("Cancel Editing Row: " + this.getEditingRow());
        }
        if ((tableCellEditor = this.getCellEditor()) != null) {
            tableCellEditor.cancelCellEditing();
        }
    }

    public void stopCellEditing() {
        TableCellEditor tableCellEditor;
        if (this.LOGGER.isLoggable(Level.FINER)) {
            this.LOGGER.finer("Stop Editing Row: " + this.getEditingRow());
        }
        if ((tableCellEditor = this.getCellEditor()) != null) {
            tableCellEditor.stopCellEditing();
        }
    }

    @Override
    public final boolean editCellAt(int n, int n2, EventObject eventObject) {
        TableCellEditor tableCellEditor;
        boolean bl;
        if (this.LOGGER.isLoggable(Level.FINER)) {
            this.LOGGER.finer("editCellAt(row=" + n + ", col=" + n2 + ", e=" + eventObject + ")");
        }
        if (JConsole.isDebug()) {
            System.err.println("edit: " + this.getValueName(n) + "=" + this.getValue(n));
        }
        if ((bl = super.editCellAt(n, n2, eventObject)) && (tableCellEditor = this.getColumnModel().getColumn(n2).getCellEditor()) == this.valueCellEditor) {
            ((JComponent)((Object)tableCellEditor)).requestFocus();
        }
        return bl;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (!this.isColumnEditable(n2)) {
            return true;
        }
        Object object = this.getModel().getValueAt(n, n2);
        if (object instanceof ZoomedCell) {
            ZoomedCell zoomedCell = (ZoomedCell)object;
            return zoomedCell.isMaximized();
        }
        return true;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (!this.isCellError(n, n2) && this.isColumnEditable(n2) && this.isWritable(n) && Utils.isEditableType(this.getClassName(n))) {
            if (JConsole.isDebug()) {
                System.err.println("validating [row=" + n + ", column=" + n2 + "]: " + this.getValueName(n) + "=" + object);
            }
            super.setValueAt(object, n, n2);
        }
    }

    @Override
    public boolean isTableEditable() {
        return true;
    }

    @Override
    public void setTableValue(Object object, int n) {
    }

    @Override
    public boolean isColumnEditable(int n) {
        if (n < this.getColumnCount()) {
            return this.getColumnName(n).equals(Resources.getText("Value", new Object[0]));
        }
        return false;
    }

    @Override
    public String getClassName(int n) {
        int n2 = this.convertRowToIndex(n);
        if (n2 != -1) {
            return this.attributesInfo[n2].getType();
        }
        return null;
    }

    @Override
    public String getValueName(int n) {
        int n2 = this.convertRowToIndex(n);
        if (n2 != -1) {
            return this.attributesInfo[n2].getName();
        }
        return null;
    }

    @Override
    public Object getValue(int n) {
        Object object = ((DefaultTableModel)this.getModel()).getValueAt(n, 1);
        return object;
    }

    @Override
    public String getToolTip(int n, int n2) {
        int n3;
        if (this.isCellError(n, n2)) {
            return (String)this.unavailableAttributes.get(this.getValueName(n));
        }
        if (this.isColumnEditable(n2)) {
            Object object = this.getValue(n);
            String string = null;
            if (object != null) {
                string = object.toString();
                if (this.isAttributeViewable(n, 1)) {
                    string = Resources.getText("Double click to expand/collapse", new Object[0]) + ". " + string;
                }
            }
            return string;
        }
        if (n2 == 0 && (n3 = this.convertRowToIndex(n)) != -1) {
            return this.attributesInfo[n3].getDescription();
        }
        return null;
    }

    @Override
    public synchronized boolean isWritable(int n) {
        int n2 = this.convertRowToIndex(n);
        if (n2 != -1) {
            return this.attributesInfo[n2].isWritable();
        }
        return false;
    }

    @Override
    public synchronized int getRowCount() {
        return super.getRowCount();
    }

    @Override
    public synchronized boolean isReadable(int n) {
        int n2 = this.convertRowToIndex(n);
        if (n2 != -1) {
            return this.attributesInfo[n2].isReadable();
        }
        return false;
    }

    @Override
    public synchronized boolean isCellError(int n, int n2) {
        return this.isColumnEditable(n2) && this.unavailableAttributes.containsKey(this.getValueName(n));
    }

    @Override
    public synchronized boolean isAttributeViewable(int n, int n2) {
        Object object;
        boolean bl = false;
        if (n2 == 1 && (object = this.getModel().getValueAt(n, n2)) instanceof ZoomedCell) {
            bl = true;
        }
        return bl;
    }

    public void loadAttributes(final XMBean xMBean, final MBeanInfo mBeanInfo) {
        SwingWorker<Runnable, Void> swingWorker = new SwingWorker<Runnable, Void>(){

            @Override
            protected Runnable doInBackground() throws Exception {
                return XMBeanAttributes.this.doLoadAttributes(xMBean, mBeanInfo);
            }

            @Override
            protected void done() {
                block6: {
                    try {
                        Runnable runnable = (Runnable)this.get();
                        if (runnable != null) {
                            runnable.run();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (ExecutionException executionException) {
                        if (JConsole.isDebug()) {
                            System.err.println("Exception raised while loading attributes: " + executionException.getCause());
                            executionException.printStackTrace();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        if (!JConsole.isDebug()) break block6;
                        System.err.println("Interrupted while loading attributes: " + interruptedException);
                        interruptedException.printStackTrace();
                    }
                }
            }
        };
        this.mbeansTab.workerAdd(swingWorker);
    }

    private Runnable doLoadAttributes(final XMBean xMBean, MBeanInfo mBeanInfo) throws JMException, IOException {
        HashMap<String, Object> hashMap;
        HashMap<Object, String> hashMap2;
        HashMap<String, Object> hashMap3;
        MBeanAttributeInfo[] mBeanAttributeInfoArray;
        MBeanInfo mBeanInfo2;
        block15: {
            Object object;
            Object object2;
            int n;
            if (xMBean == null) {
                return null;
            }
            mBeanInfo2 = mBeanInfo == null ? xMBean.getMBeanInfo() : mBeanInfo;
            mBeanAttributeInfoArray = mBeanInfo2.getAttributes();
            hashMap3 = new HashMap<String, Object>(mBeanAttributeInfoArray.length);
            hashMap2 = new HashMap<Object, String>(mBeanAttributeInfoArray.length);
            hashMap = new HashMap<String, Object>(mBeanAttributeInfoArray.length);
            AttributeList attributeList = null;
            try {
                attributeList = xMBean.getAttributes(mBeanAttributeInfoArray);
            }
            catch (Exception exception) {
                if (JConsole.isDebug()) {
                    System.err.println("Error calling getAttributes() on MBean \"" + xMBean.getObjectName() + "\". JConsole will " + "try to get them individually calling " + "getAttribute() instead. Exception:");
                    exception.printStackTrace(System.err);
                }
                attributeList = new AttributeList();
                for (n = 0; n < mBeanAttributeInfoArray.length; ++n) {
                    object2 = null;
                    try {
                        object2 = mBeanAttributeInfoArray[n].getName();
                        object = xMBean.getMBeanServerConnection().getAttribute(xMBean.getObjectName(), (String)object2);
                        attributeList.add(new Attribute((String)object2, object));
                        continue;
                    }
                    catch (Exception exception2) {
                        if (!mBeanAttributeInfoArray[n].isReadable()) continue;
                        hashMap2.put(object2, Utils.getActualException(exception2).toString());
                    }
                }
            }
            try {
                int n2 = attributeList.size();
                for (n = 0; n < n2; ++n) {
                    object2 = (Attribute)attributeList.get(n);
                    if (this.isViewable((Attribute)object2)) {
                        hashMap.put(((Attribute)object2).getName(), ((Attribute)object2).getValue());
                        continue;
                    }
                    hashMap3.put(((Attribute)object2).getName(), ((Attribute)object2).getValue());
                }
                if (n2 >= mBeanAttributeInfoArray.length) break block15;
                for (n = 0; n < mBeanAttributeInfoArray.length; ++n) {
                    object2 = mBeanAttributeInfoArray[n];
                    if (hashMap3.containsKey(((MBeanFeatureInfo)object2).getName()) || hashMap.containsKey(((MBeanFeatureInfo)object2).getName()) || hashMap2.containsKey(((MBeanFeatureInfo)object2).getName()) || !((MBeanAttributeInfo)object2).isReadable()) continue;
                    try {
                        object = xMBean.getMBeanServerConnection().getAttribute(xMBean.getObjectName(), ((MBeanFeatureInfo)object2).getName());
                        hashMap3.put(((MBeanFeatureInfo)object2).getName(), object);
                        continue;
                    }
                    catch (Exception exception) {
                        hashMap2.put(((MBeanFeatureInfo)object2).getName(), Utils.getActualException(exception).toString());
                    }
                }
            }
            catch (Exception exception) {
                for (n = 0; n < mBeanAttributeInfoArray.length; ++n) {
                    object2 = mBeanAttributeInfoArray[n];
                    if (!((MBeanAttributeInfo)object2).isReadable()) continue;
                    hashMap2.put(((MBeanFeatureInfo)object2).getName(), Utils.getActualException(exception).toString());
                }
            }
        }
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                XMBeanAttributes xMBeanAttributes = XMBeanAttributes.this;
                synchronized (xMBeanAttributes) {
                    XMBeanAttributes.this.mbean = xMBean;
                    XMBeanAttributes.this.mbeanInfo = mBeanInfo2;
                    XMBeanAttributes.access$302(XMBeanAttributes.this, mBeanAttributeInfoArray);
                    XMBeanAttributes.this.attributes = hashMap3;
                    XMBeanAttributes.this.unavailableAttributes = hashMap2;
                    XMBeanAttributes.this.viewableAttributes = hashMap;
                    DefaultTableModel defaultTableModel = (DefaultTableModel)XMBeanAttributes.this.getModel();
                    XMBeanAttributes.this.emptyTable(defaultTableModel);
                    XMBeanAttributes.this.addTableData(defaultTableModel, xMBean, mBeanAttributeInfoArray, hashMap3, hashMap2, hashMap);
                    defaultTableModel.newDataAvailable(new TableModelEvent(defaultTableModel));
                    defaultTableModel.addTableModelListener(XMBeanAttributes.this.attributesListener);
                }
            }
        };
    }

    void collapse(String string, Component component) {
        int n = this.getSelectedRow();
        Object object = this.getModel().getValueAt(n, 1);
        if (object instanceof ZoomedCell) {
            this.cancelCellEditing();
            ZoomedCell zoomedCell = (ZoomedCell)object;
            zoomedCell.reset();
            this.setRowHeight(n, zoomedCell.getHeight());
            this.editCellAt(n, 1);
            this.invalidate();
            this.repaint();
        }
    }

    ZoomedCell updateZoomedCell(int n, int n2) {
        Object object = this.getModel().getValueAt(n, 1);
        ZoomedCell zoomedCell = null;
        if (object instanceof ZoomedCell) {
            zoomedCell = (ZoomedCell)object;
            if (!zoomedCell.isInited()) {
                Object object2 = zoomedCell.getValue();
                String string = (String)this.getModel().getValueAt(n, 0);
                Component component = this.mbeansTab.getDataViewer().createAttributeViewer(object2, this.mbean, string, this);
                if (component != null) {
                    if (this.rowMinHeight == -1) {
                        this.rowMinHeight = this.getRowHeight(n);
                    }
                    zoomedCell.init(super.getCellRenderer(n, n2), component, this.rowMinHeight);
                    this.mbeansTab.getDataViewer();
                    XDataViewer.registerForMouseEvent(component, this.mouseListener);
                } else {
                    return zoomedCell;
                }
            }
            zoomedCell.switchState();
            this.setRowHeight(n, zoomedCell.getHeight());
            if (!zoomedCell.isMaximized()) {
                this.cancelCellEditing();
                this.editCellAt(n, 1);
            }
            this.invalidate();
            this.repaint();
        }
        return zoomedCell;
    }

    public void refreshAttributes() {
        this.refreshAttributes(true);
    }

    private void refreshAttributes(final boolean bl) {
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                ProxyClient.SnapshotMBeanServerConnection snapshotMBeanServerConnection = XMBeanAttributes.this.mbeansTab.getSnapshotMBeanServerConnection();
                snapshotMBeanServerConnection.flush();
                return null;
            }

            @Override
            protected void done() {
                block3: {
                    try {
                        this.get();
                        if (bl) {
                            XMBeanAttributes.this.stopCellEditing();
                        }
                        XMBeanAttributes.this.loadAttributes(XMBeanAttributes.this.mbean, XMBeanAttributes.this.mbeanInfo);
                    }
                    catch (Exception exception) {
                        if (!JConsole.isDebug()) break block3;
                        exception.printStackTrace();
                    }
                }
            }
        };
        this.mbeansTab.workerAdd(swingWorker);
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
        if (this.isEditing()) {
            this.stopCellEditing();
        }
        super.columnMarginChanged(changeEvent);
    }

    @Override
    void sortRequested(int n) {
        if (this.isEditing()) {
            this.stopCellEditing();
        }
        super.sortRequested(n);
    }

    @Override
    public synchronized void emptyTable() {
        this.emptyTable((DefaultTableModel)this.getModel());
    }

    private void emptyTable(DefaultTableModel defaultTableModel) {
        defaultTableModel.removeTableModelListener(this.attributesListener);
        super.emptyTable();
    }

    private boolean isViewable(Attribute attribute) {
        Object object = attribute.getValue();
        return XDataViewer.isViewableValue(object);
    }

    synchronized void removeAttributes() {
        if (this.attributes != null) {
            this.attributes.clear();
        }
        if (this.unavailableAttributes != null) {
            this.unavailableAttributes.clear();
        }
        if (this.viewableAttributes != null) {
            this.viewableAttributes.clear();
        }
        this.mbean = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZoomedCell getZoomedCell(XMBean xMBean, String string, Object object) {
        WeakHashMap<XMBean, HashMap<String, ZoomedCell>> weakHashMap = this.viewersCache;
        synchronized (weakHashMap) {
            ZoomedCell zoomedCell;
            HashMap<Object, Object> hashMap = this.viewersCache.containsKey(xMBean) ? this.viewersCache.get(xMBean) : new HashMap();
            if (hashMap.containsKey(string)) {
                zoomedCell = (ZoomedCell)hashMap.get(string);
                zoomedCell.setValue(object);
                if (zoomedCell.isMaximized() && zoomedCell.getType() != 3) {
                    Component component = this.mbeansTab.getDataViewer().createAttributeViewer(object, xMBean, string, this);
                    zoomedCell.init(zoomedCell.getMinRenderer(), component, zoomedCell.getMinHeight());
                    this.mbeansTab.getDataViewer();
                    XDataViewer.registerForMouseEvent(component, this.mouseListener);
                }
            } else {
                zoomedCell = new ZoomedCell(object);
                hashMap.put(string, zoomedCell);
            }
            this.viewersCache.put(xMBean, hashMap);
            return zoomedCell;
        }
    }

    protected void addTableData(DefaultTableModel defaultTableModel, XMBean xMBean, MBeanAttributeInfo[] mBeanAttributeInfoArray, HashMap<String, Object> hashMap, HashMap<String, Object> hashMap2, HashMap<String, Object> hashMap3) {
        Object[] objectArray = new Object[2];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
            objectArray[0] = mBeanAttributeInfoArray[i].getName();
            if (hashMap2.containsKey(objectArray[0])) {
                objectArray[1] = Resources.getText("Unavailable", new Object[0]);
            } else if (hashMap3.containsKey(objectArray[0])) {
                objectArray[1] = hashMap3.get(objectArray[0]);
                if (!mBeanAttributeInfoArray[i].isWritable() || !Utils.isEditableType(mBeanAttributeInfoArray[i].getType())) {
                    objectArray[1] = this.getZoomedCell(xMBean, (String)objectArray[0], objectArray[1]);
                }
            } else {
                objectArray[1] = hashMap.get(objectArray[0]);
            }
            defaultTableModel.addRow(objectArray);
            String string = null;
            if (objectArray[0] != null && (string = objectArray[0].toString()).length() > n) {
                n = string.length();
            }
            if (objectArray[1] == null || (string = objectArray[1].toString()).length() <= n2) continue;
            n2 = string.length();
        }
        this.updateColumnWidth(n, n2);
    }

    private void updateColumnWidth(int n, int n2) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        if ((n *= 7) + (n2 *= 7) < (int)this.getPreferredScrollableViewportSize().getWidth()) {
            n2 = (int)this.getPreferredScrollableViewportSize().getWidth() - n;
        }
        tableColumnModel.getColumn(0).setPreferredWidth(50);
    }

    static /* synthetic */ MBeanAttributeInfo[] access$302(XMBeanAttributes xMBeanAttributes, MBeanAttributeInfo[] mBeanAttributeInfoArray) {
        xMBeanAttributes.attributesInfo = mBeanAttributeInfoArray;
        return mBeanAttributeInfoArray;
    }

    class AttributesListener
    implements TableModelListener {
        private Component component;

        public AttributesListener(Component component) {
            this.component = component;
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (XMBeanAttributes.this.isColumnEditable(tableModelEvent.getColumn())) {
                TableModel tableModel = (TableModel)tableModelEvent.getSource();
                Object object = tableModel.getValueAt(tableModelEvent.getFirstRow(), tableModelEvent.getColumn());
                if (XMBeanAttributes.this.LOGGER.isLoggable(Level.FINER)) {
                    XMBeanAttributes.this.LOGGER.finer("tableChanged: firstRow=" + tableModelEvent.getFirstRow() + ", lastRow=" + tableModelEvent.getLastRow() + ", column=" + tableModelEvent.getColumn() + ", value=" + object);
                }
                if (object instanceof String) {
                    try {
                        object = Utils.createObjectFromString(XMBeanAttributes.this.getClassName(tableModelEvent.getFirstRow()), (String)object);
                    }
                    catch (Throwable throwable) {
                        this.popupAndLog(throwable, "tableChanged", "Problem setting attribute");
                    }
                }
                String string = XMBeanAttributes.this.getValueName(tableModelEvent.getFirstRow());
                Attribute attribute = new Attribute(string, object);
                this.setAttribute(attribute, "tableChanged");
            }
        }

        private void setAttribute(final Attribute attribute, final String string) {
            SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    try {
                        if (JConsole.isDebug()) {
                            System.err.println("setAttribute(" + attribute.getName() + "=" + attribute.getValue() + ")");
                        }
                        XMBeanAttributes.this.mbean.setAttribute(attribute);
                    }
                    catch (Throwable throwable) {
                        AttributesListener.this.popupAndLog(throwable, string, "Problem setting attribute");
                    }
                    return null;
                }

                @Override
                protected void done() {
                    block2: {
                        try {
                            this.get();
                        }
                        catch (Exception exception) {
                            if (!JConsole.isDebug()) break block2;
                            exception.printStackTrace();
                        }
                    }
                    XMBeanAttributes.this.refreshAttributes(false);
                }
            };
            XMBeanAttributes.this.mbeansTab.workerAdd(swingWorker);
        }

        private void popupAndLog(Throwable throwable, String string, String string2) {
            throwable = Utils.getActualException(throwable);
            if (JConsole.isDebug()) {
                throwable.printStackTrace();
            }
            String string3 = throwable.getMessage() != null ? throwable.getMessage() : throwable.toString();
            EventQueue.invokeLater(new ThreadDialog(this.component, string3 + "\n", Resources.getText(string2, new Object[0]), 0));
        }
    }

    class ZoomedCell {
        TableCellRenderer minRenderer;
        MaximizedCellRenderer maxRenderer;
        int minHeight;
        boolean minimized = true;
        boolean init = false;
        int type;
        Object value;

        ZoomedCell(Object object) {
            this.type = XDataViewer.getViewerType(object);
            this.value = object;
        }

        boolean isInited() {
            return this.init;
        }

        Object getValue() {
            return this.value;
        }

        void setValue(Object object) {
            this.value = object;
        }

        void init(TableCellRenderer tableCellRenderer, Component component, int n) {
            this.minRenderer = tableCellRenderer;
            this.maxRenderer = new MaximizedCellRenderer(component);
            this.minHeight = n;
            this.init = true;
        }

        int getType() {
            return this.type;
        }

        void reset() {
            this.init = false;
            this.minimized = true;
        }

        void switchState() {
            this.minimized = !this.minimized;
        }

        boolean isMaximized() {
            return !this.minimized;
        }

        void minimize() {
            this.minimized = true;
        }

        void maximize() {
            this.minimized = false;
        }

        int getHeight() {
            if (this.minimized) {
                return this.minHeight;
            }
            return (int)this.maxRenderer.getComponent().getPreferredSize().getHeight();
        }

        int getMinHeight() {
            return this.minHeight;
        }

        public String toString() {
            if (this.value == null) {
                return null;
            }
            if (this.value.getClass().isArray()) {
                String string = Utils.getArrayClassName(this.value.getClass().getName());
                int n = Array.getLength(this.value);
                return string + "[" + n + "]";
            }
            if (this.value instanceof CompositeData || this.value instanceof TabularData) {
                return this.value.getClass().getName();
            }
            return this.value.toString();
        }

        TableCellRenderer getRenderer() {
            if (this.minimized) {
                return this.minRenderer;
            }
            return this.maxRenderer;
        }

        TableCellRenderer getMinRenderer() {
            return this.minRenderer;
        }
    }

    class MaximizedCellRenderer
    extends DefaultTableCellRenderer {
        Component comp;

        MaximizedCellRenderer(Component component) {
            this.comp = component;
            Dimension dimension = component.getPreferredSize();
            if (dimension.getHeight() > 220.0) {
                component.setPreferredSize(new Dimension((int)dimension.getWidth(), 220));
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return this.comp;
        }

        public Component getComponent() {
            return this.comp;
        }
    }

    class ValueCellEditor
    extends XTextFieldEditor {
        ValueCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Object object2 = object;
            if (n2 == 1) {
                Object object3 = XMBeanAttributes.this.getModel().getValueAt(n, n2);
                if (object3 instanceof ZoomedCell) {
                    ZoomedCell zoomedCell = (ZoomedCell)object3;
                    if (zoomedCell.getRenderer() instanceof MaximizedCellRenderer) {
                        MaximizedCellRenderer maximizedCellRenderer = (MaximizedCellRenderer)zoomedCell.getRenderer();
                        return maximizedCellRenderer.getComponent();
                    }
                } else {
                    Component component = super.getTableCellEditorComponent(jTable, object2, bl, n, n2);
                    if (XMBeanAttributes.this.isCellError(n, n2) || !XMBeanAttributes.this.isWritable(n) || !Utils.isEditableType(XMBeanAttributes.this.getClassName(n))) {
                        this.textField.setEditable(false);
                    }
                    return component;
                }
            }
            return super.getTableCellEditorComponent(jTable, object2, bl, n, n2);
        }

        @Override
        public boolean stopCellEditing() {
            ZoomedCell zoomedCell;
            Object object;
            int n = XMBeanAttributes.this.getEditingRow();
            int n2 = XMBeanAttributes.this.getEditingColumn();
            if (n2 == 1 && (object = XMBeanAttributes.this.getModel().getValueAt(n, n2)) instanceof ZoomedCell && (zoomedCell = (ZoomedCell)object).isMaximized()) {
                this.cancelCellEditing();
                return true;
            }
            return super.stopCellEditing();
        }
    }

    class AttributesMouseListener
    extends MouseAdapter {
        AttributesMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() >= 2) {
                int n = XMBeanAttributes.this.getSelectedRow();
                int n2 = XMBeanAttributes.this.getSelectedColumn();
                if (n2 != 1) {
                    return;
                }
                if (n2 == -1 || n == -1) {
                    return;
                }
                XMBeanAttributes.this.updateZoomedCell(n, n2);
            }
        }
    }
}

