/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.ListenerList;
import org.openide.filesystems.MultiFileObject;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.util.Enumerations;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

abstract class AbstractFolder
extends FileObject {
    private static final AbstractFolder[] EMPTY_ARRAY = new AbstractFolder[0];
    private static final char EXT_SEP = '.';
    private FileSystem system;
    protected String name;
    protected final AbstractFolder parent;
    boolean validFlag;
    private final AbstractFolder validRoot;
    private String[] children;
    private Map<String, Reference<AbstractFolder>> map;
    private ListenerList<FileChangeListener> listeners;

    public AbstractFolder(FileSystem fileSystem, AbstractFolder abstractFolder, String string) {
        this.system = fileSystem;
        this.parent = abstractFolder;
        this.name = string;
        this.validFlag = true;
        this.validRoot = abstractFolder != null ? (AbstractFolder)fileSystem.getRoot() : null;
    }

    @Override
    public final String getName() {
        int n = this.name.lastIndexOf(46);
        return n <= 0 ? this.name : this.name.substring(0, n);
    }

    @Override
    public final String getExt() {
        int n = this.name.lastIndexOf(46) + 1;
        return n <= 1 || n == this.name.length() ? "" : this.name.substring(n);
    }

    @Override
    public final String getNameExt() {
        return this.name;
    }

    @Override
    final boolean isHasExtOverride() {
        return true;
    }

    @Override
    boolean hasExtOverride(String string) {
        if (string == null) {
            return false;
        }
        if (this.name.length() - string.length() <= 1) {
            return false;
        }
        boolean bl = this.name.endsWith(string);
        if (!bl) {
            return false;
        }
        return this.name.charAt(this.name.length() - string.length() - 1) == '.';
    }

    @Override
    public final FileSystem getFileSystem() {
        return this.system;
    }

    @Override
    public final boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public final boolean isValid() {
        if (this.parent == null) {
            return this == this.system.getRoot();
        }
        boolean bl = this.getFileSystem().getRoot() == this.validRoot;
        return this.validFlag && bl;
    }

    @Override
    public String toString() {
        if (!this.isValid()) {
            return super.toString() + " parent: " + this.parent + " validFlag: " + this.validFlag + " validRoot: " + this.validRoot + " isValidRoot: " + (this.getFileSystem().getRoot() == this.validRoot);
        }
        return super.toString();
    }

    @Override
    public final FileObject getParent() {
        return this.parent;
    }

    @Override
    public final synchronized FileObject[] getChildren() {
        this.check();
        if (this.children == null) {
            return new FileObject[0];
        }
        int n = this.children.length;
        ArrayList<AbstractFolder> arrayList = new ArrayList<AbstractFolder>();
        for (int i = 0; i < n; ++i) {
            AbstractFolder abstractFolder = this.getChild(this.children[i]);
            if (abstractFolder == null) continue;
            arrayList.add(abstractFolder);
        }
        return arrayList.toArray(new FileObject[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final FileObject find(Enumeration<String> enumeration) {
        AbstractFolder abstractFolder = this;
        while (abstractFolder != null && enumeration.hasMoreElements()) {
            AbstractFolder abstractFolder2 = abstractFolder;
            synchronized (abstractFolder2) {
                abstractFolder.check();
                String string = enumeration.nextElement();
                abstractFolder = "..".equals(string) ? (AbstractFolder)abstractFolder.getParent() : abstractFolder.getChild(string);
            }
        }
        return abstractFolder;
    }

    final FileObject findIfExists(Enumeration<String> enumeration) {
        Reference<AbstractFolder> reference = this.findRefIfExists(enumeration);
        return reference == null ? null : reference.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Reference<AbstractFolder> findRefIfExists(Enumeration<String> enumeration) {
        String string;
        for (AbstractFolder abstractFolder = this; abstractFolder != null && enumeration.hasMoreElements(); abstractFolder = abstractFolder.getChild(string)) {
            if (abstractFolder.map == null) {
                return null;
            }
            AbstractFolder abstractFolder2 = abstractFolder;
            synchronized (abstractFolder2) {
                string = enumeration.nextElement();
                if (!enumeration.hasMoreElements()) {
                    return abstractFolder.map.get(string);
                }
                continue;
            }
        }
        return null;
    }

    protected final AbstractFolder getChild(String string) {
        return this.getChild(string, true);
    }

    private final AbstractFolder getChild(String string, boolean bl) {
        AbstractFolder abstractFolder;
        Reference<AbstractFolder> reference = this.map.get(string);
        if (reference == null) {
            if (Utilities.getOperatingSystem() == 16384) {
                reference = Character.isLowerCase(string.charAt(0)) ? this.map.get(string.toUpperCase()) : this.map.get(string.toLowerCase());
                if (reference == null) {
                    return null;
                }
            } else {
                return null;
            }
        }
        if ((abstractFolder = reference.get()) == null) {
            abstractFolder = this.createFile(string);
            if (abstractFolder != null && abstractFolder.isValid()) {
                this.map.put(string, abstractFolder != null ? this.createReference(abstractFolder) : null);
            } else if (bl) {
                abstractFolder = null;
            }
        }
        return abstractFolder;
    }

    final String[] getChildrenArray() {
        return this.children;
    }

    protected Reference<AbstractFolder> createReference(AbstractFolder abstractFolder) {
        return new WeakReference<AbstractFolder>(abstractFolder);
    }

    final synchronized AbstractFolder[] subfiles() {
        if (this.map == null) {
            return EMPTY_ARRAY;
        }
        Iterator<Reference<AbstractFolder>> iterator = this.map.values().iterator();
        ArrayList<AbstractFolder> arrayList = new ArrayList<AbstractFolder>(this.map.size() + 2);
        while (iterator.hasNext()) {
            AbstractFolder abstractFolder;
            Reference<AbstractFolder> reference = iterator.next();
            if (reference == null || (abstractFolder = reference.get()) == null) continue;
            arrayList.add(abstractFolder);
        }
        return arrayList.toArray(EMPTY_ARRAY);
    }

    final boolean isInitialized() {
        return this.map != null;
    }

    final Enumeration<AbstractFolder> existingSubFiles(boolean bl) {
        if (!bl) {
            return Enumerations.array((Object[])this.subfiles());
        }
        class P
        implements Enumerations.Processor<AbstractFolder, AbstractFolder> {
            P() {
            }

            public AbstractFolder process(AbstractFolder abstractFolder, Collection<AbstractFolder> collection) {
                collection.addAll(Arrays.asList(abstractFolder.subfiles()));
                return abstractFolder;
            }
        }
        return Enumerations.queue((Enumeration)Enumerations.singleton((Object)this), (Enumerations.Processor)new P());
    }

    abstract void setAttribute(String var1, Object var2, boolean var3) throws IOException;

    @Override
    public final FileObject getFileObject(String string, String string2) {
        this.getFileSystem().waitRefreshed();
        return this.getFileObjectImpl(string, string2);
    }

    private synchronized FileObject getFileObjectImpl(String string, String string2) {
        this.check();
        if (string2 == null || string2.equals("")) {
            return this.getChild(string);
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 1 + (string2 == null ? 0 : string2.length()));
        stringBuffer.append(string).append('.').append(string2);
        return this.getChild(stringBuffer.toString());
    }

    @Override
    public void refresh(boolean bl) {
        if (!this.isInitialized() && this.isFolder()) {
            return;
        }
        this.refresh(null, null, true, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addFileChangeListener(FileChangeListener fileChangeListener) {
        AbstractFolder[] abstractFolderArray = EMPTY_ARRAY;
        synchronized (EMPTY_ARRAY) {
            if (this.listeners == null) {
                this.listeners = new ListenerList();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.listeners.add(fileChangeListener);
            return;
        }
    }

    @Override
    public final void removeFileChangeListener(FileChangeListener fileChangeListener) {
        if (this.listeners != null) {
            this.listeners.remove(fileChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fileDeleted0(FileEvent fileEvent) {
        super.fireFileDeletedEvent(this.listeners(), fileEvent);
        if (fileEvent.getFile().equals(this) && this.parent != null) {
            FileEvent fileEvent2 = new FileEvent((FileObject)this.parent, fileEvent.getFile(), fileEvent.isExpected());
            try {
                fileEvent2.inheritPostNotify(fileEvent);
                this.parent.fileDeleted0(fileEvent2);
            }
            finally {
                fileEvent2.setPostNotify(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fileCreated0(FileEvent fileEvent, boolean bl) {
        this.dispatchEvent(this.listeners(), fileEvent);
        if (fileEvent.getFile().equals(this) && this.parent != null) {
            FileEvent fileEvent2 = new FileEvent((FileObject)this.parent, fileEvent.getFile(), fileEvent.isExpected());
            try {
                fileEvent2.inheritPostNotify(fileEvent);
                this.parent.fileCreated0(fileEvent2, bl);
            }
            finally {
                fileEvent2.setPostNotify(null);
            }
        }
    }

    protected final void fileCreated0(FileObject fileObject, FileObject fileObject2, boolean bl) {
        this.fileCreated0(new FileEvent(fileObject, fileObject2, bl), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fileChanged0(FileEvent fileEvent) {
        super.fireFileChangedEvent(this.listeners(), fileEvent);
        if (fileEvent.getFile().equals(this) && this.parent != null) {
            FileEvent fileEvent2 = new FileEvent(this.parent, fileEvent.getFile(), fileEvent.isExpected(), fileEvent.getTime());
            try {
                fileEvent2.inheritPostNotify(fileEvent);
                this.parent.fileChanged0(fileEvent2);
            }
            finally {
                fileEvent2.setPostNotify(null);
            }
        }
    }

    final void fileChanged1(FileEvent fileEvent) {
        super.fireFileChangedEvent(this.listeners(), fileEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fileRenamed0(FileRenameEvent fileRenameEvent) {
        super.fireFileRenamedEvent(this.listeners(), fileRenameEvent);
        if (fileRenameEvent.getFile().equals(this) && this.parent != null) {
            FileRenameEvent fileRenameEvent2 = new FileRenameEvent(this.parent, fileRenameEvent.getFile(), fileRenameEvent.getName(), fileRenameEvent.getExt(), fileRenameEvent.isExpected());
            try {
                fileRenameEvent2.inheritPostNotify(fileRenameEvent);
                this.parent.fileRenamed0(fileRenameEvent2);
            }
            finally {
                fileRenameEvent2.setPostNotify(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fileAttributeChanged0(FileAttributeEvent fileAttributeEvent) {
        super.fireFileAttributeChangedEvent(this.listeners(), fileAttributeEvent);
        if (fileAttributeEvent.getFile().equals(this) && this.parent != null) {
            FileAttributeEvent fileAttributeEvent2 = new FileAttributeEvent(this.parent, fileAttributeEvent.getFile(), fileAttributeEvent.getName(), fileAttributeEvent.getOldValue(), fileAttributeEvent.getNewValue(), fileAttributeEvent.isExpected());
            try {
                fileAttributeEvent2.inheritPostNotify(fileAttributeEvent);
                this.parent.fileAttributeChanged0(fileAttributeEvent2);
            }
            finally {
                fileAttributeEvent2.setPostNotify(null);
            }
        }
    }

    protected final boolean hasListeners() {
        boolean bl = this.getFileSystem().getFCLSupport().hasListeners();
        boolean bl2 = false;
        Repository repository = this.getFileSystem().getRepository();
        if (repository != null) {
            bl2 = repository.getFCLSupport().hasListeners();
        }
        return this.listeners != null && this.listeners.hasListeners() || bl2 || bl;
    }

    protected final boolean hasAtLeastOneListeners() {
        return this.hasListeners() || this.parent != null && this.parent.hasListeners();
    }

    private final Enumeration<FileChangeListener> listeners() {
        if (this.listeners == null) {
            return Enumerations.empty();
        }
        return Collections.enumeration(this.listeners.getAllListeners());
    }

    private final void check() {
        if (this.map == null) {
            this.refresh(null, null, false, false);
            if (this.map == null) {
                this.map = Collections.emptyMap();
                if (this.children == null) {
                    this.children = new String[0];
                }
            }
        }
    }

    protected final void refresh(String string, String string2) {
        this.refresh(string, string2, false);
    }

    protected final void refresh(String string, String string2, boolean bl) {
        if (bl && string2 != null) {
            String[] stringArray = new String[this.children.length];
            System.arraycopy(this.children, 0, stringArray, 0, this.children.length);
            int n = stringArray.length;
            while (--n >= 0) {
                if (!string2.equals(stringArray[n])) continue;
                stringArray[n] = null;
                break;
            }
            this.refresh(string, string2, true, false, stringArray);
        } else {
            this.refresh(string, string2, true, false, null);
        }
    }

    protected abstract String[] list();

    protected abstract AbstractFolder createFile(String var1);

    protected void refresh(String string, String string2, boolean bl, boolean bl2) {
        this.refresh(string, string2, bl, bl2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerChild(String string) {
        AbstractFolder abstractFolder = this;
        synchronized (abstractFolder) {
            Reference reference;
            if (this.map == null) {
                this.check();
            }
            if ((reference = (Reference)this.map.put(string, new WeakReference<Object>(null))) != null) {
                this.map.put(string, reference);
            } else {
                String[] stringArray = new String[this.children.length + 1];
                System.arraycopy(this.children, 0, stringArray, 0, this.children.length);
                stringArray[this.children.length] = string;
                this.children = stringArray;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void refreshFolder(String string, String string2, boolean bl, boolean bl2, String[] stringArray) {
        try {
            Map<String, AbstractFolder> map;
            HashSet<String> hashSet;
            this.getFileSystem().beginAtomicAction();
            String[] stringArray2 = this.getNewChildren(stringArray);
            Serializable serializable = this;
            synchronized (serializable) {
                block22: {
                    if (this.children != null || stringArray2 != null) break block22;
                    return;
                }
                int n = stringArray2 != null ? stringArray2.length * 4 / 3 + 1 : 0;
                HashMap<String, Reference<AbstractFolder>> hashMap = new HashMap<String, Reference<AbstractFolder>>(n);
                hashSet = new HashSet<String>(n);
                if (stringArray2 != null) {
                    Reference<AbstractFolder> reference = this.map != null ? this.map.get(string2) : null;
                    for (int i = 0; i < stringArray2.length; ++i) {
                        String string3 = stringArray2[i];
                        Reference<AbstractFolder> reference2 = null;
                        if (this.map != null) {
                            reference2 = this.map.remove(string3);
                            if (reference2 != null && string != null && string2 != null && string3.equals(string2)) {
                                reference2 = null;
                            }
                            if (string != null && string2 != null && string3.equals(string)) {
                                reference2 = reference;
                            }
                            if (reference2 != null && string == null && string2 != null && string3.equals(string2)) {
                                reference2 = null;
                            }
                        }
                        if (reference2 == null) {
                            if (!string3.equals(string)) {
                                hashSet.add(string3);
                            }
                            reference2 = new WeakReference<Object>(null);
                        }
                        hashMap.put(string3, reference2);
                    }
                }
                map = this.map != null ? this.dereferenceValues(this.map) : null;
                this.map = hashMap;
                this.children = stringArray2;
            }
            if (bl && hashSet != null && this.hasAtLeastOneListeners()) {
                this.filesCreated(hashSet, bl2);
            }
            if (bl && map != null) {
                if (string2 != null) {
                    map.remove(string2);
                }
                this.filesDeleted(map, bl2);
            }
            if (bl && string == null && string2 == null && !this.getFileSystem().isReadOnly() && !(this instanceof MultiFileObject)) {
                serializable = new HashSet();
                if (hashSet != null) {
                    serializable.addAll(hashSet);
                }
                if (map != null) {
                    serializable.addAll(map.keySet());
                }
                this.refreshChildren(this.existingSubFiles(false), (Collection)((Object)serializable), bl2);
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    private void refreshChildren(Enumeration<? extends AbstractFolder> enumeration, Collection collection, boolean bl) {
        while (enumeration.hasMoreElements()) {
            AbstractFolder abstractFolder = enumeration.nextElement();
            if (!abstractFolder.isData() || collection.contains(abstractFolder.getNameExt())) continue;
            abstractFolder.refresh(bl);
        }
    }

    private void filesDeleted(Map<String, AbstractFolder> map, boolean bl) {
        for (AbstractFolder abstractFolder : map.values()) {
            abstractFolder.validFlag = false;
            if (!this.hasAtLeastOneListeners() && !abstractFolder.hasAtLeastOneListeners()) continue;
            FileEvent fileEvent = new FileEvent((FileObject)abstractFolder, (FileObject)abstractFolder, bl);
            abstractFolder.fileDeleted0(fileEvent);
        }
    }

    private void filesCreated(Set<String> set, boolean bl) {
        for (String string : set) {
            AbstractFolder abstractFolder = this.getChild(string);
            if (abstractFolder == null) continue;
            this.fileCreated0(this, abstractFolder, bl);
        }
    }

    private Map<String, AbstractFolder> dereferenceValues(Map<String, Reference<AbstractFolder>> map) {
        HashMap<String, AbstractFolder> hashMap = new HashMap<String, AbstractFolder>(map.size());
        for (String string : map.keySet()) {
            AbstractFolder abstractFolder = this.getChild(string, false);
            if (abstractFolder == null) continue;
            hashMap.put(string, abstractFolder);
        }
        return hashMap;
    }

    private String[] getNewChildren(String[] stringArray) {
        String[] stringArray2;
        String[] stringArray3 = stringArray2 = stringArray != null ? stringArray : this.list();
        if (this.isRoot() && stringArray2 == null) {
            stringArray2 = new String[]{};
        }
        if (stringArray2 != null) {
            stringArray2 = AbstractFolder.stripNulls(stringArray2);
        }
        return stringArray2;
    }

    private static String[] stripNulls(String[] stringArray) {
        String[] stringArray2 = stringArray;
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray2));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string != null) continue;
            iterator.remove();
        }
        if (arrayList.size() != stringArray2.length) {
            stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        }
        return stringArray2;
    }

    protected void refresh(String string, String string2, boolean bl, boolean bl2, String[] stringArray) {
        if (this.isFolder()) {
            this.refreshFolder(string, string2, bl, bl2, stringArray);
        }
    }

    protected void outputStreamClosed(boolean bl) {
        if (bl) {
            this.fileChanged0(new FileEvent((FileObject)this, (FileObject)this, this.lastModified().getTime()));
        }
    }

    public final Object writeReplace() {
        return new Replace(this);
    }

    @Override
    public final void delete(FileLock fileLock) throws IOException {
        if (this.isFolder()) {
            FileObject[] fileObjectArray = this.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                FileObject fileObject = fileObjectArray[i];
                FileLock fileLock2 = fileObject.lock();
                try {
                    fileObject.delete(fileLock2);
                    continue;
                }
                catch (IOException iOException) {
                    String string = NbBundle.getMessage(AbstractFolder.class, (String)"EXC_CannotDelete", (Object)this.getPath(), (Object)fileObject.getFileSystem().getDisplayName());
                    ExternalUtil.annotate((Throwable)iOException, string);
                    throw iOException;
                }
                finally {
                    fileLock2.releaseLock();
                }
            }
        }
        this.handleDelete(fileLock);
    }

    abstract void handleDelete(FileLock var1) throws IOException;

    @Override
    public boolean canWrite() {
        return !this.isReadOnly();
    }

    private static final class Replace
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient FileObject f;
        private String fsname;
        private String path;
        private URL url;

        public Replace(FileObject fileObject) {
            this.f = fileObject;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            this.fsname = this.f.getFileSystem().getSystemName();
            this.path = this.f.getPath();
            this.url = this.f.getURL();
            assert (this.url != null) : "No URL for " + this.path;
            objectOutputStream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            assert (this.fsname != null) : "Should always have a non-null fsname here";
            FileSystem fileSystem = Repository.getDefault().findFileSystem(this.fsname);
            if (fileSystem != null) {
                assert (this.path != null) : "Should always have a non-null path here";
                this.f = fileSystem.findResource(this.path);
            }
            if (this.f == null) {
                assert (this.url != null) : "Should always have a non-null URL here";
                this.f = URLMapper.findFileObject(this.url);
                if (this.f == null) {
                    throw new FileNotFoundException("Could not restore: " + this.url);
                }
            }
        }

        public Object readResolve() {
            assert (this.f != null) : "Did not read " + this.url;
            return this.f;
        }
    }
}

