/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.panels;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.modules.profiler.attach.panels.AttachSettingsPanelUI;
import org.netbeans.modules.profiler.attach.panels.AttachWizardPanel;
import org.netbeans.modules.profiler.attach.providers.IntegrationCategorizer;
import org.netbeans.modules.profiler.attach.providers.WizardIntegrationProvider;
import org.netbeans.modules.profiler.attach.spi.IntegrationProvider;
import org.netbeans.modules.profiler.attach.wizard.AttachWizardContext;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AttachSettingsPanel
extends AttachWizardPanel {
    private static final String LOCAL_HELP_STRING = NbBundle.getMessage(AttachSettingsPanel.class, (String)"TargetSettingsWizardPanelUI_LocalHelpString");
    private static final String REMOTE_HELP_STRING = NbBundle.getMessage(AttachSettingsPanel.class, (String)"TargetSettingsWizardPanelUI_RemoteHelpString");
    private static final String REMOTE_NOSUPP_HELP_STRING = NbBundle.getMessage(AttachSettingsPanel.class, (String)"TargetSettingsWizardPanelUI_RemoteNosuppHelpString");
    private static final String REMOTE_PACKS_HELP_STRING = NbBundle.getMessage(AttachSettingsPanel.class, (String)"TargetSettingsWizardPanelUI_RemotePacksHelpString");
    private static final String DIRECT_HELP_STRING = NbBundle.getMessage(AttachSettingsPanel.class, (String)"TargetSettingsWizardPanelUI_DirectHelpString");
    private static final String DYNAMIC_HELP_STRING = NbBundle.getMessage(AttachSettingsPanel.class, (String)"TargetSettingsWizardPanelUI_DynamicHelpString");
    private static final String DYNAMIC_NOSUPP_HELP_STRING = NbBundle.getMessage(AttachSettingsPanel.class, (String)"TargetSettingsWizardPanelUI_DynamicNosuppHelpString");
    private static final String DYNAMIC_JVM_HELP_STRING = NbBundle.getMessage(AttachSettingsPanel.class, (String)"TargetSettingsWizardPanelUI_DynamicJvmHelpString");
    private static final String APPLICATION_STRING = NbBundle.getMessage(AttachSettingsPanel.class, (String)"AttachWizard_GroupApplication");
    private static final String APPLET_STRING = NbBundle.getMessage(AttachSettingsPanel.class, (String)"AttachWizard_GroupApplet");
    private static final String J2EE_STRING = NbBundle.getMessage(AttachSettingsPanel.class, (String)"AttachWizard_GroupJ2EE");
    private static final String HELP_CTX_KEY = "AttachSettingsPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("AttachSettingsPanel.HelpCtx");
    private AttachSettingsPanelUI panel = null;
    private PanelModel model = new PanelModel();
    private WizardIntegrationProvider nullProvider = new WizardIntegrationProvider.NullIntegrationProvider();

    public HelpCtx getHelp() {
        return HELP_CTX;
    }

    public boolean isValid() {
        return this.model.getTargetGroup() != null && !this.model.getTargetGroup().isNull() && this.model.getTarget() != null && (this.model.isRemote() || this.model.isLocal() && (this.model.isDirectAttach() || this.model.isDynamicAttach16()));
    }

    @Override
    public boolean canBack(AttachWizardContext attachWizardContext) {
        return true;
    }

    @Override
    public boolean canFinish(AttachWizardContext attachWizardContext) {
        return false;
    }

    @Override
    public boolean canNext(AttachWizardContext attachWizardContext) {
        return this.isValid();
    }

    @Override
    public boolean onCancel(AttachWizardContext attachWizardContext) {
        return true;
    }

    @Override
    public void onEnter(AttachWizardContext attachWizardContext) {
        this.getContext().setHideIntegration(true);
        this.setTrackUpdates(false);
        String string = attachWizardContext.getAttachSettings().getTargetType();
        String string2 = attachWizardContext.getAttachSettings().getServerType();
        TargetGroup targetGroup = null;
        Target target = null;
        TargetGroup[] targetGroupArray = this.model.getTargetGroups();
        block0: for (int i = 0; i < targetGroupArray.length; ++i) {
            if (targetGroupArray[i].getName().equals(string)) {
                targetGroup = targetGroupArray[i];
                string = targetGroup.getName();
                if (targetGroup.isSingular()) {
                    target = targetGroup.getTargets()[0];
                    string2 = target.getName();
                    break;
                }
            }
            for (int j = 0; j < targetGroupArray[i].getTargets().length; ++j) {
                if (targetGroupArray[i].getTargets()[j].getProvider().equals(attachWizardContext.getIntegrationProvider())) {
                    targetGroup = targetGroupArray[i];
                    target = targetGroupArray[i].getTargets()[j];
                    break block0;
                }
                if (!targetGroupArray[i].getTargets()[j].getName().equals(string2)) continue;
                target = targetGroupArray[i].getTargets()[j];
            }
        }
        this.model.setTargetGroup(targetGroup);
        this.model.setTarget(target);
        this.model.setAutomaticIntegration(attachWizardContext.isAutomatic());
        this.model.setManualIntegration(attachWizardContext.isManual());
        if (attachWizardContext.getAttachSettings().isDirect()) {
            this.model.setDirectAttach(true);
        } else if (attachWizardContext.getAttachSettings().isDynamic16()) {
            this.model.setDynamicAttach16(true);
        } else {
            throw new IllegalArgumentException("invalid attach settings " + attachWizardContext.getAttachSettings());
        }
        this.model.setRemote(attachWizardContext.getAttachSettings().isRemote());
        ((AttachSettingsPanelUI)this.getRenderPanel()).loadModel();
        this.setTrackUpdates(true);
    }

    @Override
    public void onExit(AttachWizardContext attachWizardContext) {
        this.storeSettings();
    }

    @Override
    public void onFinish(AttachWizardContext attachWizardContext) {
    }

    @Override
    public void onPanelShow() {
        ((AttachSettingsPanelUI)this.getRenderPanel()).applyCombos();
        ((AttachSettingsPanelUI)this.getRenderPanel()).loadModel();
    }

    @Override
    protected JPanel getRenderPanel() {
        if (this.panel == null) {
            this.panel = new AttachSettingsPanelUI(this.model);
        }
        return this.panel;
    }

    private void publishUpdate() {
        if (!this.isTrackUpdates()) {
            return;
        }
        if (this.storeSettings()) {
            this.publishUpdate(new ChangeEvent(this));
        }
    }

    private boolean storeSettings() {
        AttachWizardContext attachWizardContext = this.getContext();
        if (attachWizardContext == null) {
            return false;
        }
        if (this.model.getTarget() == null) {
            return true;
        }
        AttachSettings attachSettings = attachWizardContext.getAttachSettings();
        if (this.model.isLocal() || this.model.isRemote()) {
            attachSettings.setRemote(this.model.isRemote());
        }
        attachSettings.setDirect(this.model.isDirectAttach());
        attachSettings.setDynamic16(this.model.isDynamicAttach16());
        attachSettings.setTargetType(this.model.getTargetGroup().getName());
        attachSettings.setServerType(this.model.getTarget().getName());
        attachWizardContext.setIntegrationProvider(this.model.getTarget().getProvider());
        attachWizardContext.setAutomatic(attachWizardContext.getIntegrationProvider().supportsAutomation() && !attachWizardContext.getIntegrationProvider().supportsManual());
        attachWizardContext.setManual(attachWizardContext.getIntegrationProvider().supportsManual() && !attachWizardContext.getIntegrationProvider().supportsAutomation());
        attachWizardContext.setProviderSingular(this.model.getTargetGroup().isSingular());
        attachSettings.setHostOS(null);
        return true;
    }

    public class TargetGroup {
        private List<Target> targetList;
        private String name;
        private boolean dirty;
        private boolean nullGroup;
        private boolean singular;

        public TargetGroup(String string, boolean bl) {
            this(string, new Target[0], bl);
        }

        public TargetGroup(String string, Target[] targetArray, boolean bl) {
            this.name = string;
            this.singular = bl;
            this.targetList = new ArrayList<Target>(Arrays.asList(targetArray));
            Collections.sort(this.targetList);
            this.nullGroup = false;
            this.dirty = true;
        }

        public String getName() {
            return this.name;
        }

        public void setNull(boolean bl) {
            this.nullGroup = bl;
        }

        public boolean isNull() {
            return this.nullGroup;
        }

        public boolean isSingular() {
            return this.singular;
        }

        public Target[] getTargets() {
            if (this.dirty) {
                Collections.sort(this.targetList);
                this.dirty = false;
            }
            return this.targetList.toArray(new Target[0]);
        }

        public void addTarget(Target target) {
            this.targetList.add(target);
            this.dirty = true;
        }

        public String toString() {
            return this.name;
        }
    }

    public class Target
    implements Comparable {
        private String name;
        private WizardIntegrationProvider provider;
        private int priority;

        public Target(String string, WizardIntegrationProvider wizardIntegrationProvider, int n) {
            this.name = string;
            this.provider = wizardIntegrationProvider;
            this.priority = n;
        }

        public String getName() {
            return this.name;
        }

        public int getPriority() {
            return this.priority;
        }

        public WizardIntegrationProvider getProvider() {
            return this.provider;
        }

        public int compareTo(Object object) {
            if (object == null) {
                return 0;
            }
            if (!(object instanceof Target)) {
                return 0;
            }
            int n = this.priority;
            int n2 = ((Target)object).getPriority();
            if (n > n2) {
                return 1;
            }
            if (n < n2) {
                return -1;
            }
            return 0;
        }

        public boolean supportsAutomation() {
            return this.provider.supportsAutomation();
        }

        public boolean supportsDirectAttach() {
            return this.provider.supportsDirect();
        }

        public boolean supportsDynamicAttach() {
            return this.provider.supportsDynamic();
        }

        public boolean supportsLocalProfiling() {
            return this.provider.supportsLocal();
        }

        public boolean supportsRemoteProfiling() {
            return this.provider.supportsRemote();
        }

        public String toString() {
            return this.name;
        }
    }

    public class PanelModel {
        private Target target = null;
        private TargetGroup targetGroup = null;
        private WizardIntegrationProvider dummyProvider = new WizardIntegrationProvider.NullIntegrationProvider();
        private TargetGroup[] targets = null;
        private boolean automaticIntegration;
        private boolean directAttach;
        private boolean dynamicAttach16;
        private boolean local;
        private boolean manualIntegration;
        private boolean remote;

        public PanelModel() {
            Collection collection = Lookup.getDefault().lookupAll(IntegrationProvider.class);
            final TargetGroup targetGroup = new TargetGroup(APPLICATION_STRING, true);
            final TargetGroup targetGroup2 = new TargetGroup(APPLET_STRING, true);
            final TargetGroup targetGroup3 = new TargetGroup(J2EE_STRING, false);
            IntegrationCategorizer integrationCategorizer = new IntegrationCategorizer(){

                @Override
                public void addApplet(IntegrationProvider integrationProvider, int n) {
                    targetGroup2.addTarget(new Target(integrationProvider.getTitle(), (WizardIntegrationProvider)integrationProvider, n));
                }

                @Override
                public void addApplication(IntegrationProvider integrationProvider, int n) {
                    targetGroup.addTarget(new Target(integrationProvider.getTitle(), (WizardIntegrationProvider)integrationProvider, n));
                }

                @Override
                public void addAppserver(IntegrationProvider integrationProvider, int n) {
                    targetGroup3.addTarget(new Target(integrationProvider.getTitle(), (WizardIntegrationProvider)integrationProvider, n));
                }
            };
            for (WizardIntegrationProvider wizardIntegrationProvider : collection) {
                wizardIntegrationProvider.categorize(integrationCategorizer);
                wizardIntegrationProvider.getSettingsPersistor().loadSettings();
            }
            if (targetGroup.getTargets().length == 0) {
                targetGroup.addTarget(new Target(this.dummyProvider.getTitle(), this.dummyProvider, 0));
                targetGroup.setNull(true);
            }
            if (targetGroup2.getTargets().length == 0) {
                targetGroup2.addTarget(new Target(this.dummyProvider.getTitle(), this.dummyProvider, 0));
                targetGroup2.setNull(true);
            }
            if (targetGroup3.getTargets().length == 0) {
                targetGroup3.addTarget(new Target(this.dummyProvider.getTitle(), this.dummyProvider, 0));
                targetGroup3.setNull(true);
            }
            this.targets = new TargetGroup[]{targetGroup, targetGroup2, targetGroup3};
        }

        public void setAutomaticIntegration(boolean bl) {
            this.automaticIntegration = bl;
            this.manualIntegration = !bl;
            AttachSettingsPanel.this.publishUpdate();
        }

        public boolean isAutomaticIntegration() {
            return this.automaticIntegration;
        }

        public void setDirectAttach(boolean bl) {
            this.directAttach = bl;
            this.dynamicAttach16 = !bl;
            AttachSettingsPanel.this.publishUpdate();
        }

        public boolean isDirectAttach() {
            return this.directAttach;
        }

        public boolean isDynamicAttach16() {
            return this.dynamicAttach16;
        }

        public String getHints() {
            StringBuffer stringBuffer = new StringBuffer();
            if (!this.targetGroup.isNull()) {
                if (this.isLocal()) {
                    stringBuffer.append(this.getLocalHint()).append("<br>");
                }
                if (this.isRemote()) {
                    stringBuffer.append(this.getRemoteHint()).append("<br>");
                }
                if (this.isDirectAttach()) {
                    stringBuffer.append(this.getDirectHint()).append("<br>");
                }
                if (this.isDynamicAttach16()) {
                    stringBuffer.append(this.getDynamicHint()).append("<br>");
                }
            } else {
                stringBuffer.append("No provider registered!");
            }
            return stringBuffer.toString();
        }

        public void setLocal(boolean bl) {
            this.local = bl;
            this.remote = !bl;
            AttachSettingsPanel.this.publishUpdate();
        }

        public boolean isLocal() {
            return this.local;
        }

        public void setManualIntegration(boolean bl) {
            this.manualIntegration = bl;
            this.automaticIntegration = !bl;
            AttachSettingsPanel.this.publishUpdate();
        }

        public boolean isManualIntegration() {
            return this.manualIntegration;
        }

        public void setRemote(boolean bl) {
            this.remote = bl;
            this.local = !bl;
            AttachSettingsPanel.this.publishUpdate();
        }

        public boolean isRemote() {
            return this.remote;
        }

        public void setTarget(Target target) {
            this.target = target;
            AttachSettingsPanel.this.publishUpdate();
        }

        public Target getTarget() {
            return this.target;
        }

        public void setTargetGroup(TargetGroup targetGroup) {
            this.targetGroup = targetGroup;
            AttachSettingsPanel.this.publishUpdate();
        }

        public TargetGroup getTargetGroup() {
            return this.targetGroup;
        }

        public TargetGroup[] getTargetGroups() {
            return this.targets;
        }

        void setDynamicAttach16(boolean bl) {
            this.dynamicAttach16 = bl;
            this.directAttach = !bl;
            AttachSettingsPanel.this.publishUpdate();
        }

        private String getDirectHint() {
            StringBuffer stringBuffer = new StringBuffer();
            if (AttachSettingsPanel.this.model.isLocal()) {
                if (AttachSettingsPanel.this.getContext().getIntegrationProvider().supportsDirect()) {
                    stringBuffer.append(MessageFormat.format(DIRECT_HELP_STRING, this.getTargetGroup().getName()));
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(' ');
                }
                if (AttachSettingsPanel.this.getContext().getIntegrationProvider().supportsDynamic()) {
                    stringBuffer.append(MessageFormat.format(DYNAMIC_HELP_STRING, this.getTargetGroup().getName()));
                } else {
                    stringBuffer.append(MessageFormat.format(DYNAMIC_NOSUPP_HELP_STRING, this.getTarget().getName()));
                }
            }
            return stringBuffer.toString();
        }

        private String getDynamicHint() {
            return new StringBuffer(this.getDirectHint()).append(' ').append(MessageFormat.format(DYNAMIC_JVM_HELP_STRING, "JDK 6.0/7.0")).toString();
        }

        private String getLocalHint() {
            StringBuffer stringBuffer = new StringBuffer();
            if (AttachSettingsPanel.this.getContext().getIntegrationProvider().supportsLocal()) {
                stringBuffer.append(MessageFormat.format(LOCAL_HELP_STRING, this.getTargetGroup().getName()));
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            if (AttachSettingsPanel.this.getContext().getIntegrationProvider().supportsRemote()) {
                stringBuffer.append(MessageFormat.format(REMOTE_HELP_STRING, this.getTargetGroup().getName()));
            } else {
                stringBuffer.append(MessageFormat.format(REMOTE_NOSUPP_HELP_STRING, this.getTarget().getName()));
            }
            return stringBuffer.toString();
        }

        private String getRemoteHint() {
            return new StringBuffer(this.getLocalHint()).append(' ').append(REMOTE_PACKS_HELP_STRING).toString();
        }
    }
}

