/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.updater.Localization;
import org.netbeans.updater.ModuleUpdater;
import org.netbeans.updater.UpdatingContext;
import org.netbeans.updater.XMLUtil;

public final class UpdaterInternal {
    public static final String RUNNING = "RUNNING";
    public static final String FINISHED = "FINISHED";

    private UpdaterInternal() {
    }

    public static void update(final Collection<File> collection, final PropertyChangeListener propertyChangeListener, String string) throws InterruptedException {
        Localization.setBranding(string);
        class Context
        implements UpdatingContext {
            private Map<File, Long> modified = new HashMap<File, Long>();

            Context() {
            }

            @Override
            public Collection<File> forInstall() {
                return collection;
            }

            @Override
            public boolean isFromIDE() {
                return true;
            }

            @Override
            public void unpackingIsRunning() {
                this.firePropertyChange(UpdaterInternal.RUNNING, null, null);
            }

            @Override
            public void unpackingFinished() {
                this.runningFinished();
            }

            @Override
            public void runningFinished() {
                this.firePropertyChange(UpdaterInternal.FINISHED, null, this.modified);
            }

            @Override
            public void setProgressValue(long l) {
            }

            @Override
            public void setLabel(String string) {
            }

            @Override
            public void setProgressRange(long l, long l2) {
            }

            @Override
            public void disposeSplash() {
            }

            private void firePropertyChange(String string, Object object, Object object2) {
                if (propertyChangeListener != null) {
                    PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
                    propertyChangeListener.propertyChange(propertyChangeEvent);
                }
            }

            @Override
            public OutputStream createOS(final File file) throws FileNotFoundException {
                if (this.modified.get(file) == null) {
                    this.modified.put(file, file.lastModified());
                }
                XMLUtil.LOG.log(Level.FINE, "Creating output stream for {0}", file);
                return new FileOutputStream(file){
                    boolean closed;

                    @Override
                    public void close() throws IOException {
                        if (this.closed) {
                            return;
                        }
                        this.closed = true;
                        XMLUtil.LOG.log(Level.FINE, "Closing output stream for {0}", file);
                        super.close();
                        XMLUtil.LOG.log(Level.INFO, "File installed {0}@{1}", new Object[]{file, modified.get(file)});
                    }
                };
            }
        }
        Context context = new Context();
        ModuleUpdater moduleUpdater = new ModuleUpdater(context);
        moduleUpdater.start();
        moduleUpdater.join();
    }
}

