/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.jmx;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.datasupport.Utils;
import com.sun.tools.visualvm.jmx.CredentialsProvider;
import com.sun.tools.visualvm.jmx.EnvironmentProvider;
import com.sun.tools.visualvm.jmx.JmxApplicationException;
import com.sun.tools.visualvm.jmx.impl.JmxApplicationProvider;
import java.io.File;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public final class JmxApplicationsSupport {
    private static final String STORAGE_DIRNAME = "jmxapplications";
    private static final Object storageDirectoryLock = new Object();
    private static File storageDirectory;
    private static final Object storageDirectoryStringLock;
    private static String storageDirectoryString;
    private static JmxApplicationsSupport instance;
    private JmxApplicationProvider applicationProvider = new JmxApplicationProvider();

    public static synchronized JmxApplicationsSupport getInstance() {
        if (instance == null) {
            instance = new JmxApplicationsSupport();
        }
        return instance;
    }

    public Application createJmxApplication(String connectionString, String displayName, String username, String password) throws JmxApplicationException {
        return this.createJmxApplication(connectionString, displayName, username, password, false, false);
    }

    public Application createJmxApplication(String connectionString, String displayName, String username, String password, boolean saveCredentials, boolean persistent) throws JmxApplicationException {
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = "";
        }
        String suggestedName = JmxApplicationProvider.getSuggestedName(displayName, connectionString, username);
        CredentialsProvider.Custom epr = new CredentialsProvider.Custom(username, password.toCharArray(), saveCredentials);
        return this.createJmxApplicationImpl(connectionString, displayName, suggestedName, epr, persistent);
    }

    public Application createJmxApplication(String connectionString, String displayName, EnvironmentProvider provider, boolean persistent) throws JmxApplicationException {
        String username = JmxApplicationsSupport.getUsername(provider);
        String suggestedName = JmxApplicationProvider.getSuggestedName(displayName, connectionString, username);
        return this.createJmxApplicationImpl(connectionString, displayName, suggestedName, provider, persistent);
    }

    public Application createJmxApplicationInteractive(String connectionString, String displayName, String username, String password) {
        return this.createJmxApplicationInteractive(connectionString, displayName, username, password, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Application createJmxApplicationInteractive(String connectionString, String displayName, String username, String password, boolean saveCredentials, boolean persistent) {
        Application application;
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = "";
        }
        final ProgressHandle[] pHandle = new ProgressHandle[1];
        try {
            final String suggestedName = JmxApplicationProvider.getSuggestedName(displayName, connectionString, username);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    pHandle[0] = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(JmxApplicationsSupport.class, (String)"LBL_Adding", (Object)suggestedName));
                    pHandle[0].setInitialDelay(0);
                    pHandle[0].start();
                }
            });
            CredentialsProvider.Custom epr = new CredentialsProvider.Custom(username, password.toCharArray(), saveCredentials);
            application = this.createJmxApplicationImpl(connectionString, displayName, suggestedName, epr, persistent);
        }
        catch (JmxApplicationException e) {
            try {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(pHandle){
                    final /* synthetic */ ProgressHandle[] val$pHandle;
                    {
                        this.val$pHandle = progressHandleArray;
                    }

                    public void run() {
                        if (this.val$pHandle[0] != null) {
                            this.val$pHandle[0].finish();
                        }
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            return null;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        return application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Application createJmxApplicationInteractive(String connectionString, String displayName, EnvironmentProvider provider, boolean persistent) {
        Application application;
        final ProgressHandle[] pHandle = new ProgressHandle[1];
        try {
            String username = JmxApplicationsSupport.getUsername(provider);
            final String suggestedName = JmxApplicationProvider.getSuggestedName(displayName, connectionString, username);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    pHandle[0] = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(JmxApplicationsSupport.class, (String)"LBL_Adding", (Object)suggestedName));
                    pHandle[0].setInitialDelay(0);
                    pHandle[0].start();
                }
            });
            application = this.createJmxApplicationImpl(connectionString, displayName, suggestedName, provider, persistent);
        }
        catch (JmxApplicationException e) {
            try {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(pHandle){
                    final /* synthetic */ ProgressHandle[] val$pHandle;
                    {
                        this.val$pHandle = progressHandleArray;
                    }

                    public void run() {
                        if (this.val$pHandle[0] != null) {
                            this.val$pHandle[0].finish();
                        }
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            return null;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        return application;
    }

    private Application createJmxApplicationImpl(String connectionString, String displayName, String suggestedName, EnvironmentProvider provider, boolean persistent) throws JmxApplicationException {
        return this.applicationProvider.createJmxApplication(connectionString, displayName, suggestedName, provider, persistent);
    }

    private static String getUsername(EnvironmentProvider provider) {
        return provider instanceof CredentialsProvider ? ((CredentialsProvider)provider).getUsername(null) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getStorageDirectoryString() {
        Object object = storageDirectoryStringLock;
        synchronized (object) {
            if (storageDirectoryString == null) {
                storageDirectoryString = Storage.getPersistentStorageDirectoryString() + File.separator + STORAGE_DIRNAME;
            }
            return storageDirectoryString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getStorageDirectory() {
        Object object = storageDirectoryLock;
        synchronized (object) {
            if (storageDirectory == null) {
                String storageString = JmxApplicationsSupport.getStorageDirectoryString();
                storageDirectory = new File(storageString);
                if (storageDirectory.exists() && storageDirectory.isFile()) {
                    throw new IllegalStateException("Cannot create hosts storage directory " + storageString + ", file in the way");
                }
                if (!(!storageDirectory.exists() || storageDirectory.canRead() && storageDirectory.canWrite())) {
                    throw new IllegalStateException("Cannot access hosts storage directory " + storageString + ", read&write permission required");
                }
                if (!Utils.prepareDirectory((File)storageDirectory)) {
                    throw new IllegalStateException("Cannot create hosts storage directory " + storageString);
                }
            }
            return storageDirectory;
        }
    }

    public static boolean storageDirectoryExists() {
        return new File(JmxApplicationsSupport.getStorageDirectoryString()).isDirectory();
    }

    private JmxApplicationsSupport() {
        this.applicationProvider.initialize();
    }

    static {
        storageDirectoryStringLock = new Object();
    }
}

