/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.internal.toolkit.builders;

import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.EnumConstantWriter;
import com.javafx.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import com.javafx.tools.doclets.internal.toolkit.builders.XMLNode;
import com.javafx.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.ProgramElementDoc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumConstantBuilder
extends AbstractMemberBuilder {
    private ClassDoc classDoc;
    private VisibleMemberMap visibleMemberMap;
    private EnumConstantWriter writer;
    private List<ProgramElementDoc> enumConstants;
    private int currentEnumConstantsIndex;

    private EnumConstantBuilder(Configuration configuration) {
        super(configuration);
    }

    public static EnumConstantBuilder getInstance(Configuration configuration, ClassDoc classDoc, EnumConstantWriter writer) {
        EnumConstantBuilder builder = new EnumConstantBuilder(configuration);
        builder.classDoc = classDoc;
        builder.writer = writer;
        builder.visibleMemberMap = new VisibleMemberMap(classDoc, 1, configuration.nodeprecated);
        builder.enumConstants = new ArrayList<ProgramElementDoc>(builder.visibleMemberMap.getMembersFor(classDoc));
        if (configuration.getMemberComparator() != null) {
            Collections.sort(builder.enumConstants, configuration.getMemberComparator());
        }
        return builder;
    }

    @Override
    public String getName() {
        return "EnumConstantDetails";
    }

    public List<ProgramElementDoc> members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    @Override
    public boolean hasMembersToDocument() {
        return this.enumConstants.size() > 0;
    }

    public void buildEnumConstant(XMLNode node, Content memberDetailsTree) {
        if (this.writer == null) {
            return;
        }
        int size = this.enumConstants.size();
        if (size > 0) {
            Content enumConstantsDetailsTree = this.writer.getEnumConstantsDetailsTreeHeader(this.classDoc, memberDetailsTree);
            this.currentEnumConstantsIndex = 0;
            while (this.currentEnumConstantsIndex < size) {
                Content enumConstantsTree = this.writer.getEnumConstantsTreeHeader((FieldDoc)this.enumConstants.get(this.currentEnumConstantsIndex), enumConstantsDetailsTree);
                this.buildChildren(node, enumConstantsTree);
                enumConstantsDetailsTree.addContent(this.writer.getEnumConstants(enumConstantsTree, this.currentEnumConstantsIndex == size - 1));
                ++this.currentEnumConstantsIndex;
            }
            memberDetailsTree.addContent(this.writer.getEnumConstantsDetails(enumConstantsDetailsTree));
        }
    }

    public void buildSignature(XMLNode node, Content enumConstantsTree) {
        enumConstantsTree.addContent(this.writer.getSignature((FieldDoc)this.enumConstants.get(this.currentEnumConstantsIndex)));
    }

    public void buildDeprecationInfo(XMLNode node, Content enumConstantsTree) {
        this.writer.addDeprecated((FieldDoc)this.enumConstants.get(this.currentEnumConstantsIndex), enumConstantsTree);
    }

    public void buildEnumConstantComments(XMLNode node, Content enumConstantsTree) {
        if (!this.configuration.nocomment) {
            this.writer.addComments((FieldDoc)this.enumConstants.get(this.currentEnumConstantsIndex), enumConstantsTree);
        }
    }

    public void buildTagInfo(XMLNode node, Content enumConstantsTree) {
        this.writer.addTags((FieldDoc)this.enumConstants.get(this.currentEnumConstantsIndex), enumConstantsTree);
    }

    public EnumConstantWriter getWriter() {
        return this.writer;
    }
}

