/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.AbstractMemberWriter;
import com.javafx.tools.doclets.formats.html.LinkInfoImpl;
import com.javafx.tools.doclets.formats.html.SubWriterHolderWriter;
import com.javafx.tools.doclets.formats.html.markup.HtmlConstants;
import com.javafx.tools.doclets.formats.html.markup.HtmlStyle;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.formats.html.markup.RawHtml;
import com.javafx.tools.doclets.formats.html.markup.StringContent;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.FieldWriter;
import com.javafx.tools.doclets.internal.toolkit.MemberSummaryWriter;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.ProgramElementDoc;
import java.io.IOException;

public class FieldWriterImpl
extends AbstractMemberWriter
implements FieldWriter,
MemberSummaryWriter {
    public FieldWriterImpl(SubWriterHolderWriter writer, ClassDoc classdoc) {
        super(writer, classdoc);
    }

    public FieldWriterImpl(SubWriterHolderWriter writer) {
        super(writer);
    }

    public Content getMemberSummaryHeader(ClassDoc classDoc, Content memberSummaryTree) {
        memberSummaryTree.addContent(HtmlConstants.START_OF_FIELD_SUMMARY);
        Content memberTree = this.writer.getMemberTreeHeader();
        this.writer.addSummaryHeader(this, classDoc, memberTree);
        return memberTree;
    }

    public Content getFieldDetailsTreeHeader(ClassDoc classDoc, Content memberDetailsTree) {
        memberDetailsTree.addContent(HtmlConstants.START_OF_FIELD_DETAILS);
        Content fieldDetailsTree = this.writer.getMemberTreeHeader();
        fieldDetailsTree.addContent(this.writer.getMarkerAnchor("field_detail"));
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.DETAILS_HEADING, this.writer.fieldDetailsLabel);
        fieldDetailsTree.addContent(heading);
        return fieldDetailsTree;
    }

    public Content getFieldDocTreeHeader(FieldDoc field, Content fieldDetailsTree) {
        fieldDetailsTree.addContent(this.writer.getMarkerAnchor(field.name()));
        Content fieldDocTree = this.writer.getMemberTreeHeader();
        HtmlTree heading = new HtmlTree(HtmlConstants.MEMBER_HEADING);
        ((Content)heading).addContent(field.name());
        fieldDocTree.addContent(heading);
        return fieldDocTree;
    }

    public Content getSignature(FieldDoc field) {
        HtmlTree pre = new HtmlTree(HtmlTag.PRE);
        this.writer.addAnnotationInfo((ProgramElementDoc)field, (Content)pre);
        this.addModifiers((MemberDoc)field, pre);
        RawHtml fieldlink = new RawHtml(this.writer.getLink(new LinkInfoImpl(3, field.type())));
        ((Content)pre).addContent(fieldlink);
        ((Content)pre).addContent(" ");
        if (this.configuration().linksource) {
            StringContent fieldName = new StringContent(field.name());
            this.writer.addSrcLink((ProgramElementDoc)field, fieldName, pre);
        } else {
            this.addName(field.name(), pre);
        }
        return pre;
    }

    public void addDeprecated(FieldDoc field, Content fieldDocTree) {
        this.addDeprecatedInfo((ProgramElementDoc)field, fieldDocTree);
    }

    public void addComments(FieldDoc field, Content fieldDocTree) {
        ClassDoc holder = field.containingClass();
        if (field.inlineTags().length > 0) {
            if (holder.equals(this.classdoc) || !holder.isPublic() && !Util.isLinkable(holder, this.configuration())) {
                this.writer.addInlineComment((Doc)field, fieldDocTree);
            } else {
                RawHtml link = new RawHtml(this.writer.getDocLink(30, holder, (MemberDoc)field, holder.isIncluded() ? holder.typeName() : holder.qualifiedTypeName(), false));
                HtmlTree codeLink = HtmlTree.CODE(link);
                HtmlTree strong = HtmlTree.STRONG(holder.isClass() ? this.writer.descfrmClassLabel : this.writer.descfrmInterfaceLabel);
                ((Content)strong).addContent(this.writer.getSpace());
                ((Content)strong).addContent(codeLink);
                fieldDocTree.addContent(HtmlTree.DIV(HtmlStyle.block, strong));
                this.writer.addInlineComment((Doc)field, fieldDocTree);
            }
        }
    }

    public void addTags(FieldDoc field, Content fieldDocTree) {
        this.writer.addTagsInfo((Doc)field, fieldDocTree);
    }

    public Content getFieldDetails(Content fieldDetailsTree) {
        return this.getMemberTree(fieldDetailsTree);
    }

    public Content getFieldDoc(Content fieldDocTree, boolean isLastContent) {
        return this.getMemberTree(fieldDocTree, isLastContent);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public int getMemberKind() {
        return 2;
    }

    public void addSummaryLabel(Content memberTree) {
        HtmlTree label = HtmlTree.HEADING(HtmlConstants.SUMMARY_HEADING, this.writer.getResource("doclet.Field_Summary"));
        memberTree.addContent(label);
    }

    public String getTableSummary() {
        return this.configuration().getText("doclet.Member_Table_Summary", this.configuration().getText("doclet.Field_Summary"), this.configuration().getText("doclet.fields"));
    }

    public String getCaption() {
        return this.configuration().getText("doclet.Fields");
    }

    public String[] getSummaryTableHeader(ProgramElementDoc member) {
        String[] header = new String[]{this.writer.getModifierTypeHeader(), this.configuration().getText("doclet.0_and_1", this.configuration().getText("doclet.Field"), this.configuration().getText("doclet.Description"))};
        return header;
    }

    public void addSummaryAnchor(ClassDoc cd, Content memberTree) {
        memberTree.addContent(this.writer.getMarkerAnchor("field_summary"));
    }

    public void addInheritedSummaryAnchor(ClassDoc cd, Content inheritedTree) {
        inheritedTree.addContent(this.writer.getMarkerAnchor("fields_inherited_from_class_" + this.configuration().getClassName(cd)));
    }

    public void addInheritedSummaryLabel(ClassDoc cd, Content inheritedTree) {
        RawHtml classLink = new RawHtml(this.writer.getPreQualifiedClassLink(3, cd, false));
        StringContent label = new StringContent(cd.isClass() ? this.configuration().getText("doclet.Fields_Inherited_From_Class") : this.configuration().getText("doclet.Fields_Inherited_From_Interface"));
        HtmlTree labelHeading = HtmlTree.HEADING(HtmlConstants.INHERITED_SUMMARY_HEADING, label);
        ((Content)labelHeading).addContent(this.writer.getSpace());
        ((Content)labelHeading).addContent(classLink);
        inheritedTree.addContent(labelHeading);
    }

    protected void addSummaryLink(int context, ClassDoc cd, ProgramElementDoc member, Content tdSummary) {
        HtmlTree strong = HtmlTree.STRONG(new RawHtml(this.writer.getDocLink(context, cd, (MemberDoc)member, member.name(), false)));
        HtmlTree code = HtmlTree.CODE(strong);
        tdSummary.addContent(code);
    }

    protected void addInheritedSummaryLink(ClassDoc cd, ProgramElementDoc member, Content linksTree) {
        linksTree.addContent(new RawHtml(this.writer.getDocLink(3, cd, (MemberDoc)member, member.name(), false)));
    }

    protected void addSummaryType(ProgramElementDoc member, Content tdSummaryType) {
        FieldDoc field = (FieldDoc)member;
        this.addModifierAndType((ProgramElementDoc)field, field.type(), tdSummaryType);
    }

    protected Content getDeprecatedLink(ProgramElementDoc member) {
        return this.writer.getDocLink(3, (MemberDoc)member, ((FieldDoc)member).qualifiedName());
    }

    protected Content getNavSummaryLink(ClassDoc cd, boolean link) {
        if (link) {
            return this.writer.getHyperLink("", cd == null ? "field_summary" : "fields_inherited_from_class_" + this.configuration().getClassName(cd), this.writer.getResource("doclet.navField"));
        }
        return this.writer.getResource("doclet.navField");
    }

    protected void addNavDetailLink(boolean link, Content liNav) {
        if (link) {
            liNav.addContent(this.writer.getHyperLink("", "field_detail", this.writer.getResource("doclet.navField")));
        } else {
            liNav.addContent(this.writer.getResource("doclet.navField"));
        }
    }
}

