/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.keyring;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.spi.keyring.KeyringProvider;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public class Keyring {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.keyring");
    private static KeyringProvider PROVIDER;

    private Keyring() {
    }

    private static synchronized KeyringProvider provider() {
        if (PROVIDER == null) {
            for (KeyringProvider keyringProvider : Lookup.getDefault().lookupAll(KeyringProvider.class)) {
                if (!keyringProvider.enabled()) continue;
                PROVIDER = keyringProvider;
                break;
            }
            if (PROVIDER == null) {
                PROVIDER = new DummyKeyringProvider();
            }
            LOG.log(Level.FINE, "Using provider: {0}", PROVIDER);
        }
        return PROVIDER;
    }

    public static synchronized char[] read(String string) {
        Parameters.notNull((CharSequence)"key", (Object)string);
        LOG.log(Level.FINEST, "reading: {0}", string);
        return Keyring.provider().read(string);
    }

    public static synchronized void save(String string, char[] cArray, String string2) {
        Parameters.notNull((CharSequence)"key", (Object)string);
        Parameters.notNull((CharSequence)"password", (Object)cArray);
        LOG.log(Level.FINEST, "saving: {0}", string);
        Keyring.provider().save(string, cArray, string2);
        Arrays.fill(cArray, '\u0000');
    }

    public static synchronized void delete(String string) {
        Parameters.notNull((CharSequence)"key", (Object)string);
        LOG.log(Level.FINEST, "deleting: {0}", string);
        Keyring.provider().delete(string);
    }

    private static byte[] chars2Bytes(char[] cArray) {
        byte[] byArray = new byte[cArray.length * 2];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i * 2] = (byte)(cArray[i] / 256);
            byArray[i * 2 + 1] = (byte)(cArray[i] % 256);
        }
        return byArray;
    }

    private static char[] bytes2Chars(byte[] byArray) {
        char[] cArray = new char[byArray.length / 2];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)(byArray[i * 2] * 256 + byArray[i * 2 + 1]);
        }
        return cArray;
    }

    private static class DummyKeyringProvider
    implements KeyringProvider {
        private final Map<String, byte[]> passwords = new HashMap<String, byte[]>();

        private DummyKeyringProvider() {
        }

        @Override
        public boolean enabled() {
            return true;
        }

        @Override
        public char[] read(String string) {
            byte[] byArray = this.passwords.get(string);
            return byArray != null ? Keyring.bytes2Chars(byArray) : null;
        }

        @Override
        public void save(String string, char[] cArray, String string2) {
            this.passwords.put(string, Keyring.chars2Bytes(cArray));
        }

        @Override
        public void delete(String string) {
            this.passwords.remove(string);
        }
    }
}

