/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.modules.appui.options;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import org.netbeans.api.keyring.Keyring;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

class NetworkOptionsModel {
    static final String PROXY_HTTP_HOST = "proxyHttpHost";
    static final String PROXY_HTTP_PORT = "proxyHttpPort";
    static final String PROXY_HTTPS_HOST = "proxyHttpsHost";
    static final String PROXY_HTTPS_PORT = "proxyHttpsPort";
    static final String PROXY_SOCKS_HOST = "proxySocksHost";
    static final String PROXY_SOCKS_PORT = "proxySocksPort";
    static final String NOT_PROXY_HOSTS = "proxyNonProxyHosts";
    static final String PROXY_TYPE = "proxyType";
    static final String USE_PROXY_AUTHENTICATION = "useProxyAuthentication";
    static final String PROXY_AUTHENTICATION_USERNAME = "proxyAuthenticationUsername";
    static final String PROXY_AUTHENTICATION_PASSWORD = "proxyAuthenticationPassword";
    static final String USE_PROXY_ALL_PROTOCOLS = "useProxyAllProtocols";
    static final String DIRECT = "DIRECT";
    private static String presetNonProxyHosts;
    private final Preferences PREFERENCES = NbPreferences.root().node("org/netbeans/core");
    static final int DIRECT_CONNECTION = 0;
    static final int AUTO_DETECT_PROXY = 1;
    static final int MANUAL_SET_PROXY = 2;

    NetworkOptionsModel() {
    }

    String getHttpHost() {
        return NetworkOptionsModel.normalizeProxyHost(this.PREFERENCES.get(PROXY_HTTP_HOST, ""));
    }

    void setHttpHost(String proxyHost) {
        if (!proxyHost.equals(this.getHttpHost())) {
            this.PREFERENCES.put(PROXY_HTTP_HOST, proxyHost);
        }
    }

    String getHttpPort() {
        return this.PREFERENCES.get(PROXY_HTTP_PORT, "0");
    }

    void setHttpPort(String proxyPort) {
        if (!proxyPort.equals(this.getHttpPort())) {
            this.PREFERENCES.put(PROXY_HTTP_PORT, NetworkOptionsModel.validatePort(proxyPort) ? proxyPort : "");
        }
    }

    String getHttpsHost() {
        if (this.useProxyAllProtocols()) {
            return this.getHttpHost();
        }
        return this.PREFERENCES.get(PROXY_HTTPS_HOST, "");
    }

    void setHttpsHost(String proxyHost) {
        if (!proxyHost.equals(this.getHttpsHost())) {
            this.PREFERENCES.put(PROXY_HTTPS_HOST, proxyHost);
        }
    }

    String getHttpsPort() {
        if (this.useProxyAllProtocols()) {
            return this.getHttpPort();
        }
        return this.PREFERENCES.get(PROXY_HTTPS_PORT, "0");
    }

    void setHttpsPort(String proxyPort) {
        if (!proxyPort.equals(this.getHttpsPort())) {
            this.PREFERENCES.put(PROXY_HTTPS_PORT, NetworkOptionsModel.validatePort(proxyPort) ? proxyPort : "");
        }
    }

    String getSocksHost() {
        if (this.useProxyAllProtocols()) {
            return this.getHttpHost();
        }
        return this.PREFERENCES.get(PROXY_SOCKS_HOST, "");
    }

    void setSocksHost(String proxyHost) {
        if (!proxyHost.equals(this.getSocksHost())) {
            this.PREFERENCES.put(PROXY_SOCKS_HOST, proxyHost);
        }
    }

    String getSocksPort() {
        if (this.useProxyAllProtocols()) {
            return this.getHttpPort();
        }
        return this.PREFERENCES.get(PROXY_SOCKS_PORT, "0");
    }

    void setSocksPort(String proxyPort) {
        if (!proxyPort.equals(this.getSocksPort())) {
            this.PREFERENCES.put(PROXY_SOCKS_PORT, NetworkOptionsModel.validatePort(proxyPort) ? proxyPort : "");
        }
    }

    String getNonProxyHosts() {
        return NetworkOptionsModel.code2view(this.PREFERENCES.get(NOT_PROXY_HOSTS, NetworkOptionsModel.getDefaultUserNonProxyHosts()));
    }

    void setNonProxyHosts(String nonProxy) {
        if (!nonProxy.equals(this.getNonProxyHosts())) {
            this.PREFERENCES.put(NOT_PROXY_HOSTS, NetworkOptionsModel.view2code(nonProxy));
        }
    }

    int getProxyType() {
        return this.PREFERENCES.getInt(PROXY_TYPE, 1);
    }

    void setProxyType(int proxyType) {
        if (proxyType != this.getProxyType()) {
            this.PREFERENCES.putInt(PROXY_TYPE, proxyType);
        }
    }

    boolean useAuthentication() {
        return this.PREFERENCES.getBoolean(USE_PROXY_AUTHENTICATION, false);
    }

    void setUseAuthentication(boolean use) {
        if (use != this.useAuthentication()) {
            this.PREFERENCES.putBoolean(USE_PROXY_AUTHENTICATION, use);
        }
    }

    boolean useProxyAllProtocols() {
        return this.PREFERENCES.getBoolean(USE_PROXY_ALL_PROTOCOLS, true);
    }

    void setUseProxyAllProtocols(boolean use) {
        if (use != this.useProxyAllProtocols()) {
            this.PREFERENCES.putBoolean(USE_PROXY_ALL_PROTOCOLS, use);
        }
    }

    String getAuthenticationUsername() {
        return this.PREFERENCES.get(PROXY_AUTHENTICATION_USERNAME, "");
    }

    void setAuthenticationUsername(String username) {
        this.PREFERENCES.put(PROXY_AUTHENTICATION_USERNAME, username);
    }

    char[] getAuthenticationPassword() {
        char[] pwd;
        String old = this.PREFERENCES.get(PROXY_AUTHENTICATION_PASSWORD, null);
        if (old != null) {
            this.PREFERENCES.remove(PROXY_AUTHENTICATION_PASSWORD);
            this.setAuthenticationPassword(old.toCharArray());
        }
        return (pwd = Keyring.read((String)PROXY_AUTHENTICATION_PASSWORD)) != null ? pwd : new char[]{};
    }

    void setAuthenticationPassword(char[] password) {
        Keyring.save((String)PROXY_AUTHENTICATION_PASSWORD, (char[])password, (String)NbBundle.getMessage(NetworkOptionsModel.class, (String)"NetworkOptionsPanel_Password_Description"));
    }

    private static String getSystemNonProxyHosts() {
        String systemProxy = System.getProperty("netbeans.system_http_non_proxy_hosts");
        return systemProxy == null ? "" : systemProxy;
    }

    private static String getPresetNonProxyHosts() {
        if (presetNonProxyHosts == null) {
            presetNonProxyHosts = System.getProperty("http.nonProxyHosts", "");
        }
        return presetNonProxyHosts;
    }

    private static String getDefaultUserNonProxyHosts() {
        return NetworkOptionsModel.getModifiedNonProxyHosts(NetworkOptionsModel.getSystemNonProxyHosts());
    }

    private static String getModifiedNonProxyHosts(String systemPreset) {
        String fromUser;
        String fromSystem = systemPreset.replaceAll(";", "|").replaceAll(",", "|");
        String string = fromUser = NetworkOptionsModel.getPresetNonProxyHosts() == null ? "" : NetworkOptionsModel.getPresetNonProxyHosts().replaceAll(";", "|").replaceAll(",", "|");
        if (Utilities.isWindows()) {
            fromSystem = NetworkOptionsModel.addReguralToNonProxyHosts(fromSystem);
        }
        String nonProxy = fromUser + (fromUser.length() == 0 ? "" : "|") + fromSystem + (fromSystem.length() == 0 ? "" : "|") + "localhost|127.0.0.1";
        String localhost = "";
        try {
            localhost = InetAddress.getLocalHost().getHostName();
            if (!"localhost".equals(localhost)) {
                nonProxy = nonProxy + "|" + localhost;
            }
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        return NetworkOptionsModel.compactNonProxyHosts(nonProxy);
    }

    private static String compactNonProxyHosts(String nonProxyHost) {
        StringTokenizer st = new StringTokenizer(nonProxyHost, "|");
        HashSet<String> s = new HashSet<String>();
        StringBuilder compactedProxyHosts = new StringBuilder();
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (!s.add(t.toLowerCase(Locale.US))) continue;
            if (compactedProxyHosts.length() > 0) {
                compactedProxyHosts.append('|');
            }
            compactedProxyHosts.append(t);
        }
        return compactedProxyHosts.toString();
    }

    private static String addReguralToNonProxyHosts(String nonProxyHost) {
        StringTokenizer st = new StringTokenizer(nonProxyHost, "|");
        StringBuilder reguralProxyHosts = new StringBuilder();
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.indexOf(42) == -1) {
                t = t + '*';
            }
            if (reguralProxyHosts.length() > 0) {
                reguralProxyHosts.append('|');
            }
            reguralProxyHosts.append(t);
        }
        return reguralProxyHosts.toString();
    }

    private static String normalizeProxyHost(String proxyHost) {
        if (proxyHost.toLowerCase(Locale.US).startsWith("http://")) {
            return proxyHost.substring(7, proxyHost.length());
        }
        return proxyHost;
    }

    private static boolean validatePort(String port) {
        boolean ok;
        block3: {
            if (port.trim().length() == 0) {
                return true;
            }
            ok = false;
            try {
                Integer.parseInt(port);
                ok = true;
            }
            catch (NumberFormatException nfe) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)nfe);
            }
        }
        return ok;
    }

    private static String code2view(String code) {
        return code == null ? code : code.replace("|", ", ");
    }

    private static String view2code(String view) {
        return view == null ? view : view.replace(", ", "|");
    }
}

