/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.AllClassesFrameWriter;
import com.javafx.tools.doclets.formats.html.ClassUseWriter;
import com.javafx.tools.doclets.formats.html.ConfigurationImpl;
import com.javafx.tools.doclets.formats.html.DeprecatedListWriter;
import com.javafx.tools.doclets.formats.html.FrameOutputWriter;
import com.javafx.tools.doclets.formats.html.HelpWriter;
import com.javafx.tools.doclets.formats.html.PackageFrameWriter;
import com.javafx.tools.doclets.formats.html.PackageIndexFrameWriter;
import com.javafx.tools.doclets.formats.html.PackageIndexWriter;
import com.javafx.tools.doclets.formats.html.PackageTreeWriter;
import com.javafx.tools.doclets.formats.html.SingleIndexWriter;
import com.javafx.tools.doclets.formats.html.SourceToHTMLConverter;
import com.javafx.tools.doclets.formats.html.SplitIndexWriter;
import com.javafx.tools.doclets.formats.html.TreeWriter;
import com.javafx.tools.doclets.internal.toolkit.AbstractDoclet;
import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.javafx.tools.doclets.internal.toolkit.util.ClassTree;
import com.javafx.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.javafx.tools.doclets.internal.toolkit.util.IndexBuilder;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Type;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public class HtmlDoclet
extends AbstractDoclet {
    public ConfigurationImpl configuration = (ConfigurationImpl)this.configuration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean start(RootDoc root) {
        try {
            HtmlDoclet doclet = new HtmlDoclet();
            boolean bl = doclet.start(doclet, root);
            return bl;
        }
        finally {
            ConfigurationImpl.reset();
        }
    }

    public Configuration configuration() {
        return ConfigurationImpl.getInstance();
    }

    protected void generateOtherFiles(RootDoc root, ClassTree classtree) throws Exception {
        super.generateOtherFiles(root, classtree);
        if (this.configuration.linksource) {
            if (this.configuration.destDirName.length() > 0) {
                SourceToHTMLConverter.convertRoot(this.configuration, root, this.configuration.destDirName + File.separator + "src-html/");
            } else {
                SourceToHTMLConverter.convertRoot(this.configuration, root, "src-html/");
            }
        }
        if (this.configuration.topFile.length() == 0) {
            this.configuration.standardmessage.error("doclet.No_Non_Deprecated_Classes_To_Document", new Object[0]);
            return;
        }
        boolean nodeprecated = this.configuration.nodeprecated;
        String configdestdir = this.configuration.destDirName;
        String confighelpfile = this.configuration.helpfile;
        String configstylefile = this.configuration.stylesheetfile;
        this.performCopy(configdestdir, confighelpfile);
        this.performCopy(configdestdir, configstylefile);
        Util.copyResourceFile(this.configuration, "background.gif", false);
        Util.copyResourceFile(this.configuration, "tab.gif", false);
        Util.copyResourceFile(this.configuration, "titlebar.gif", false);
        Util.copyResourceFile(this.configuration, "titlebar_end.gif", false);
        if (this.configuration.classuse) {
            ClassUseWriter.generate(this.configuration, classtree);
        }
        IndexBuilder indexbuilder = new IndexBuilder(this.configuration, nodeprecated);
        if (this.configuration.createtree) {
            TreeWriter.generate(this.configuration, classtree);
        }
        if (this.configuration.createindex) {
            if (this.configuration.splitindex) {
                SplitIndexWriter.generate(this.configuration, indexbuilder);
            } else {
                SingleIndexWriter.generate(this.configuration, indexbuilder);
            }
        }
        if (!this.configuration.nodeprecatedlist && !nodeprecated) {
            DeprecatedListWriter.generate(this.configuration);
        }
        AllClassesFrameWriter.generate(this.configuration, new IndexBuilder(this.configuration, nodeprecated, true));
        FrameOutputWriter.generate(this.configuration);
        if (this.configuration.createoverview) {
            PackageIndexWriter.generate(this.configuration);
        }
        if (this.configuration.helpfile.length() == 0 && !this.configuration.nohelp) {
            HelpWriter.generate(this.configuration);
        }
        if (this.configuration.stylesheetfile.length() == 0) {
            Util.copyFile(this.configuration, "stylesheet.css", "resources", configdestdir.isEmpty() ? System.getProperty("user.dir") : configdestdir, false, true);
        }
    }

    protected void generateClassFiles(ClassDoc[] arr, ClassTree classtree) {
        Arrays.sort(arr);
        for (int i = 0; i < arr.length; ++i) {
            if (!this.configuration.isGeneratedDoc(arr[i]) || !arr[i].isIncluded()) continue;
            ClassDoc prev = i == 0 ? null : arr[i - 1];
            ClassDoc curr = arr[i];
            ClassDoc next = i + 1 == arr.length ? null : arr[i + 1];
            try {
                if (curr.isAnnotationType()) {
                    AbstractBuilder annotationTypeBuilder = this.configuration.getBuilderFactory().getAnnotationTypeBuilder((AnnotationTypeDoc)curr, (Type)prev, (Type)next);
                    annotationTypeBuilder.build();
                    continue;
                }
                AbstractBuilder classBuilder = this.configuration.getBuilderFactory().getClassBuilder(curr, prev, next, classtree);
                classBuilder.build();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DocletAbortException();
            }
        }
    }

    protected void generatePackageFiles(ClassTree classtree) throws Exception {
        PackageDoc[] packages = this.configuration.packages;
        if (packages.length > 1) {
            PackageIndexFrameWriter.generate(this.configuration);
        }
        PackageDoc prev = null;
        for (int i = 0; i < packages.length; ++i) {
            if (this.configuration.nodeprecated && Util.isDeprecated((Doc)packages[i])) continue;
            PackageFrameWriter.generate(this.configuration, packages[i]);
            PackageDoc next = i + 1 < packages.length && packages[i + 1].name().length() > 0 ? packages[i + 1] : null;
            next = i + 2 < packages.length && next == null ? packages[i + 2] : next;
            AbstractBuilder packageSummaryBuilder = this.configuration.getBuilderFactory().getPackageSummaryBuilder(packages[i], prev, next);
            packageSummaryBuilder.build();
            if (this.configuration.createtree) {
                PackageTreeWriter.generate(this.configuration, packages[i], prev, next, this.configuration.nodeprecated);
            }
            prev = packages[i];
        }
    }

    public static int optionLength(String option) {
        return ConfigurationImpl.getInstance().optionLength(option);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        return ConfigurationImpl.getInstance().validOptions(options, reporter);
    }

    private void performCopy(String configdestdir, String filename) {
        try {
            String destdir;
            String string = destdir = configdestdir.length() > 0 ? configdestdir + File.separatorChar : "";
            if (filename.length() > 0) {
                File helpstylefile = new File(filename);
                String parent = helpstylefile.getParent();
                String helpstylefilename = parent == null ? filename : filename.substring(parent.length() + 1);
                File desthelpfile = new File(destdir + helpstylefilename);
                if (!desthelpfile.getCanonicalPath().equals(helpstylefile.getCanonicalPath())) {
                    this.configuration.message.notice((SourcePosition)null, "doclet.Copying_File_0_To_File_1", helpstylefile.toString(), desthelpfile.toString());
                    Util.copyFile(desthelpfile, helpstylefile);
                }
            }
        }
        catch (IOException exc) {
            this.configuration.message.error((SourcePosition)null, "doclet.perform_copy_exception_encountered", exc.toString());
            throw new DocletAbortException();
        }
    }
}

