/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.uisupport;

import com.sun.tools.visualvm.uisupport.HorizontalLayout;
import com.sun.tools.visualvm.uisupport.UISupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class TransparentToolBar
extends JPanel {
    private static Boolean NEEDS_PANEL;
    private static Boolean CUSTOM_FILLER;
    private final JToolBar toolbar;
    private final ItemListener listener = new ItemListener();

    public TransparentToolBar() {
        this.toolbar = TransparentToolBar.needsPanel() ? null : new JToolBar();
        this.setOpaque(false);
        if (this.toolbar == null) {
            this.setLayout(new HorizontalLayout(false));
        } else {
            this.toolbar.setBorderPainted(false);
            this.toolbar.setFloatable(false);
            this.toolbar.setRollover(true);
            this.toolbar.setOpaque(false);
            this.toolbar.setBorder(BorderFactory.createEmptyBorder());
            this.setLayout(new BorderLayout());
            this.add((Component)this.toolbar, "Center");
        }
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && TransparentToolBar.this.isShowing()) {
                    TransparentToolBar.this.removeHierarchyListener(this);
                    for (Component c : TransparentToolBar.this.getComponents()) {
                        if (!(c instanceof AbstractButton)) continue;
                        TransparentToolBar.this.listener.refresh((AbstractButton)c);
                    }
                }
            }
        });
    }

    public void addItem(JComponent c) {
        c.setOpaque(false);
        if (c instanceof JButton) {
            ((JButton)c).setDefaultCapable(false);
        }
        if (this.toolbar != null) {
            this.toolbar.add(c);
        } else {
            this.add(c);
            if (c instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)c;
                b.addMouseListener(this.listener);
                b.addChangeListener(this.listener);
                b.addFocusListener(this.listener);
                b.setRolloverEnabled(true);
            }
        }
    }

    public void removeItem(JComponent c) {
        if (this.toolbar != null) {
            this.toolbar.remove(c);
        } else {
            if (c instanceof AbstractButton) {
                c.removeMouseListener(this.listener);
                ((AbstractButton)c).removeChangeListener(this.listener);
                c.removeFocusListener(this.listener);
            }
            this.remove(c);
        }
    }

    public void addSeparator() {
        JToolBar.Separator separator = new JToolBar.Separator();
        separator.setOrientation(1);
        this.addItem(separator);
    }

    public void addFiller() {
        Dimension minDim = new Dimension(0, 0);
        Dimension maxDim = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        final boolean customFiller = TransparentToolBar.customFiller();
        Box.Filler filler = new Box.Filler(minDim, minDim, maxDim){

            public Dimension getPreferredSize() {
                if (customFiller) {
                    int currentWidth = TransparentToolBar.this.getSize().width;
                    int minimumWidth = TransparentToolBar.this.getMinimumSize().width;
                    int extraWidth = currentWidth - minimumWidth;
                    return new Dimension(Math.max(extraWidth, 0), 0);
                }
                return super.getPreferredSize();
            }

            protected void paintComponent(Graphics g) {
            }
        };
        this.addItem(filler);
    }

    private static boolean needsPanel() {
        if (NEEDS_PANEL == null) {
            NEEDS_PANEL = UISupport.isGTKLookAndFeel();
        }
        return NEEDS_PANEL;
    }

    private static boolean customFiller() {
        if (CUSTOM_FILLER == null) {
            CUSTOM_FILLER = UISupport.isGTKLookAndFeel() || UISupport.isNimbusLookAndFeel();
        }
        return CUSTOM_FILLER;
    }

    private static final class ItemListener
    extends MouseAdapter
    implements ChangeListener,
    FocusListener {
        private static final String PROP_HOVERED = "BUTTON_HOVERED";

        private ItemListener() {
        }

        public void mouseEntered(MouseEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            b.putClientProperty(PROP_HOVERED, Boolean.TRUE);
            this.refresh(b);
        }

        public void mouseExited(MouseEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            b.putClientProperty(PROP_HOVERED, Boolean.FALSE);
            this.refresh(b);
        }

        public void stateChanged(ChangeEvent e) {
            this.refresh((AbstractButton)e.getSource());
        }

        public void focusGained(FocusEvent e) {
            this.refresh((AbstractButton)e.getSource());
        }

        public void focusLost(FocusEvent e) {
            this.refresh((AbstractButton)e.getSource());
        }

        private void refresh(AbstractButton b) {
            b.setBackground(UISupport.getDefaultBackground());
            boolean hovered = Boolean.TRUE.equals(b.getClientProperty(PROP_HOVERED));
            boolean filled = b.isEnabled() && (hovered || b.isSelected() || b.isFocusOwner());
            b.setOpaque(filled);
            b.setContentAreaFilled(filled);
            b.repaint();
        }
    }
}

