/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.binding;

import com.sun.javafx.binding.StringFormatter;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public abstract class BooleanExpression
implements ObservableBooleanValue {
    @Override
    public Boolean getValue() {
        return this.get();
    }

    public static BooleanExpression booleanExpression(final ObservableBooleanValue observableBooleanValue) {
        if (observableBooleanValue == null) {
            throw new NullPointerException("Value must be specified.");
        }
        return observableBooleanValue instanceof BooleanExpression ? (BooleanExpression)observableBooleanValue : new BooleanBinding(){
            {
                super.bind(observableBooleanValue);
            }

            @Override
            public void dispose() {
                super.unbind(observableBooleanValue);
            }

            @Override
            protected boolean computeValue() {
                return observableBooleanValue.get();
            }

            @Override
            public ObservableList<ObservableBooleanValue> getDependencies() {
                return FXCollections.singletonObservableList(observableBooleanValue);
            }
        };
    }

    public BooleanBinding and(ObservableBooleanValue observableBooleanValue) {
        return Bindings.and(this, observableBooleanValue);
    }

    public BooleanBinding or(ObservableBooleanValue observableBooleanValue) {
        return Bindings.or(this, observableBooleanValue);
    }

    public BooleanBinding not() {
        return Bindings.not(this);
    }

    public BooleanBinding isEqualTo(ObservableBooleanValue observableBooleanValue) {
        return Bindings.equal(this, observableBooleanValue);
    }

    public BooleanBinding isNotEqualTo(ObservableBooleanValue observableBooleanValue) {
        return Bindings.notEqual(this, observableBooleanValue);
    }

    public StringBinding asString() {
        return (StringBinding)StringFormatter.convert(this);
    }
}

