/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio;

import com.sun.javafx.iio.ImageFormatDescription;
import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageLoadListener;
import com.sun.javafx.iio.ImageLoader;
import com.sun.javafx.iio.ImageLoaderFactory;
import com.sun.javafx.iio.ImageStorageException;
import com.sun.javafx.iio.bmp.BMPImageLoaderFactory;
import com.sun.javafx.iio.common.ImageTools;
import com.sun.javafx.iio.gif.GIFImageLoaderFactory;
import com.sun.javafx.iio.jpeg.JPEGImageLoaderFactory;
import com.sun.javafx.iio.png.PNGImageLoaderFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ImageStorage {
    private static HashMap<byte[], ImageLoaderFactory> loaderFactoriesBySignature;
    private static int maxSignatureLength;
    private static ImageLoaderFactory[] loaderFactories;

    public static ImageFormatDescription[] getSupportedDescriptions() {
        ImageFormatDescription[] imageFormatDescriptionArray = new ImageFormatDescription[loaderFactories.length];
        for (int i = 0; i < loaderFactories.length; ++i) {
            imageFormatDescriptionArray[i] = loaderFactories[i].getFormatDescription();
        }
        return imageFormatDescriptionArray;
    }

    public static int getNumBands(ImageType imageType) {
        int n = -1;
        switch (imageType) {
            case GRAY: 
            case PALETTE: 
            case PALETTE_ALPHA: 
            case PALETTE_ALPHA_PRE: 
            case PALETTE_TRANS: {
                n = 1;
                break;
            }
            case GRAY_ALPHA: 
            case GRAY_ALPHA_PRE: {
                n = 2;
                break;
            }
            case RGB: {
                n = 3;
                break;
            }
            case RGBA: 
            case RGBA_PRE: {
                n = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ImageType " + (Object)((Object)imageType));
            }
        }
        return n;
    }

    public static void addImageLoaderFactory(ImageLoaderFactory imageLoaderFactory) {
        ImageFormatDescription imageFormatDescription = imageLoaderFactory.getFormatDescription();
        byte[][] byArray = imageFormatDescription.getSignatures();
        for (int i = 0; i < byArray.length; ++i) {
            loaderFactoriesBySignature.put(byArray[i], imageLoaderFactory);
        }
    }

    public static ImageFrame[] loadAll(InputStream inputStream, ImageLoadListener imageLoadListener, int n, int n2, boolean bl, boolean bl2) throws ImageStorageException {
        ImageLoader imageLoader = null;
        try {
            imageLoader = ImageStorage.getLoaderBySignature(inputStream, imageLoadListener);
        }
        catch (IOException iOException) {
            throw new ImageStorageException(iOException.getMessage(), iOException);
        }
        ImageFrame[] imageFrameArray = null;
        if (imageLoader != null) {
            imageFrameArray = ImageStorage.loadAll(imageLoader, n, n2, bl, bl2);
        }
        return imageFrameArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageFrame[] loadAll(String string, ImageLoadListener imageLoadListener, int n, int n2, boolean bl, boolean bl2) throws ImageStorageException {
        ImageFrame[] imageFrameArray = null;
        InputStream inputStream = null;
        ImageLoader imageLoader = null;
        try {
            try {
                inputStream = ImageTools.createInputStream(string);
                imageLoader = ImageStorage.getLoaderBySignature(inputStream, imageLoadListener);
            }
            catch (IOException iOException) {
                throw new ImageStorageException(iOException.getMessage(), iOException);
            }
            if (imageLoader != null) {
                imageFrameArray = ImageStorage.loadAll(imageLoader, n, n2, bl, bl2);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return imageFrameArray;
    }

    private static ImageFrame[] loadAll(ImageLoader imageLoader, int n, int n2, boolean bl, boolean bl2) throws ImageStorageException {
        ImageFrame[] imageFrameArray = null;
        ArrayList<ImageFrame> arrayList = new ArrayList<ImageFrame>();
        int n3 = 0;
        ImageFrame imageFrame = null;
        while (true) {
            try {
                imageFrame = imageLoader.load(n3++, n, n2, bl, bl2);
            }
            catch (Exception exception) {
                throw new ImageStorageException(exception.getMessage(), exception);
            }
            if (imageFrame == null) break;
            arrayList.add(imageFrame);
        }
        int n4 = arrayList.size();
        if (n4 > 0) {
            imageFrameArray = new ImageFrame[n4];
            arrayList.toArray(imageFrameArray);
        }
        return imageFrameArray;
    }

    private static ImageLoader getLoaderBySignature(InputStream inputStream, ImageLoadListener imageLoadListener) throws IOException {
        Object object;
        ImageLoader imageLoader = null;
        byte[] byArray = new byte[maxSignatureLength];
        inputStream.read(byArray);
        Iterator<byte[]> iterator = loaderFactoriesBySignature.keySet().iterator();
        ImageLoaderFactory imageLoaderFactory = null;
        while (iterator.hasNext()) {
            object = iterator.next();
            int n = ((byte[])object).length;
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                if (byArray[i] == object[i]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            imageLoaderFactory = loaderFactoriesBySignature.get(object);
            break;
        }
        if (imageLoaderFactory != null) {
            object = new ByteArrayInputStream(byArray);
            SequenceInputStream sequenceInputStream = new SequenceInputStream((InputStream)object, inputStream);
            imageLoader = imageLoaderFactory.createImageLoader(sequenceInputStream);
            if (imageLoadListener != null) {
                imageLoader.addListener(imageLoadListener);
            }
        }
        return imageLoader;
    }

    private ImageStorage() {
    }

    static {
        int n;
        maxSignatureLength = 0;
        loaderFactories = new ImageLoaderFactory[]{GIFImageLoaderFactory.getInstance(), JPEGImageLoaderFactory.getInstance(), PNGImageLoaderFactory.getInstance(), BMPImageLoaderFactory.getInstance()};
        int n2 = 0;
        int n3 = loaderFactories.length;
        for (n = 0; n < n3; ++n) {
            ImageFormatDescription imageFormatDescription = loaderFactories[n].getFormatDescription();
            n2 += imageFormatDescription.getExtensions().length;
            byte[][] byArray = imageFormatDescription.getSignatures();
            for (int i = 0; i < byArray.length; ++i) {
                maxSignatureLength = Math.max(byArray[i].length, maxSignatureLength);
            }
        }
        loaderFactoriesBySignature = new HashMap(loaderFactories.length);
        for (n = 0; n < n3; ++n) {
            ImageStorage.addImageLoaderFactory(loaderFactories[n]);
        }
    }

    public static enum ImageType {
        GRAY,
        GRAY_ALPHA,
        GRAY_ALPHA_PRE,
        PALETTE,
        PALETTE_ALPHA,
        PALETTE_ALPHA_PRE,
        PALETTE_TRANS,
        RGB,
        RGBA,
        RGBA_PRE;

    }
}

