/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.providers;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.netbeans.modules.profiler.api.JavaPlatform;
import org.netbeans.modules.profiler.attach.providers.TargetPlatformEnum;

public class TargetPlatform {
    private static List supportedPlatforms = null;
    private String version;
    private String displayName;
    private String javaHome;
    private boolean defaultFlag;
    private boolean validFlag;

    public TargetPlatform(JavaPlatform javaPlatform) {
        this(javaPlatform, false);
    }

    public TargetPlatform(JavaPlatform javaPlatform, boolean bl) {
        this.defaultFlag = bl;
        try {
            String string = javaPlatform.getPlatformJavaFile();
            this.displayName = javaPlatform.getDisplayName();
            this.version = javaPlatform.getVersion();
            this.javaHome = new File(string).getParentFile().getParent();
            this.validFlag = true;
        }
        catch (Exception exception) {
            this.validFlag = false;
        }
    }

    public static final List getPlatformList(boolean bl) {
        List list = TargetPlatform.getSupportedPlatforms(bl);
        return list;
    }

    public static final List getPlatformList(TargetPlatformFilter targetPlatformFilter, boolean bl) {
        List list = TargetPlatform.getSupportedPlatforms(bl);
        Vector<TargetPlatform> vector = new Vector<TargetPlatform>();
        for (TargetPlatform targetPlatform : list) {
            if (!targetPlatformFilter.isSupported(targetPlatform)) continue;
            vector.add(targetPlatform);
        }
        return vector;
    }

    public static void refresh() {
        TargetPlatform.getSupportedPlatforms(false);
    }

    public TargetPlatformEnum getAsEnum() {
        if (this.version.startsWith("1.5") || this.version.startsWith("5")) {
            return TargetPlatformEnum.JDK5;
        }
        if (this.version.startsWith("1.6") || this.version.startsWith("6")) {
            return TargetPlatformEnum.JDK6;
        }
        if (this.version.startsWith("1.7") || this.version.startsWith("7")) {
            return TargetPlatformEnum.JDK7;
        }
        return TargetPlatformEnum.JDK5;
    }

    public boolean isDefault() {
        return this.defaultFlag;
    }

    public String getHomePath() {
        return this.javaHome;
    }

    public String getName() {
        return this.getAsEnum().toString();
    }

    public boolean isValid() {
        return this.validFlag;
    }

    public boolean equals(Object object) {
        if (this.getHomePath() == null || object == null) {
            return false;
        }
        if (object instanceof String) {
            return this.getHomePath().equals(object) || this.toString().equals(object);
        }
        if (!(object instanceof TargetPlatform)) {
            return false;
        }
        return this.getHomePath().equals(((TargetPlatform)object).getHomePath());
    }

    public int hashCode() {
        return this.getHomePath().hashCode();
    }

    public String toString() {
        return this.displayName;
    }

    private static List getSupportedPlatforms(boolean bl) {
        if (supportedPlatforms == null || !bl) {
            Object object;
            supportedPlatforms = new LinkedList();
            try {
                object = JavaPlatform.getDefaultPlatform();
                if (object != null) {
                    supportedPlatforms.add(new TargetPlatform((JavaPlatform)object, true));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            object = JavaPlatform.getPlatforms();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                JavaPlatform javaPlatform = (JavaPlatform)iterator.next();
                TargetPlatform targetPlatform = new TargetPlatform(javaPlatform);
                if (!targetPlatform.isValid() || supportedPlatforms.contains(targetPlatform)) continue;
                supportedPlatforms.add(targetPlatform);
            }
        }
        return supportedPlatforms;
    }

    public static interface TargetPlatformFilter {
        public boolean isSupported(TargetPlatform var1);
    }
}

