/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu.cct.nodes;

import org.netbeans.lib.profiler.results.cpu.cct.CPUCCTNodeFactory;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.BaseCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.RuntimeCPUCCTNode;

public abstract class TimedCPUCCTNode
extends BaseCPUCCTNode
implements Cloneable,
RuntimeCPUCCTNode {
    public static final int FILTERED_NO = 0;
    public static final int FILTERED_YES = 2;
    public static final int FILTERED_MAYBE = 1;
    private TimingData timingData;
    private char filteredStatus;
    private int nCalls;
    private int nCallsDiff;
    private long lastWaitOrSleepStamp;

    public TimedCPUCCTNode(CPUCCTNodeFactory cPUCCTNodeFactory, boolean bl) {
        super(cPUCCTNodeFactory);
        this.timingData = bl ? new TimingDataExtended() : new TimingDataSimple();
    }

    public synchronized void setFilteredStatus(int n) {
        this.filteredStatus = (char)(n & 0xFF);
    }

    public synchronized int getFilteredStatus() {
        return this.filteredStatus;
    }

    public synchronized void setLastWaitOrSleepStamp(long l) {
        this.lastWaitOrSleepStamp = l;
    }

    public synchronized long getLastWaitOrSleepStamp() {
        return this.lastWaitOrSleepStamp;
    }

    public synchronized void setNCalls(int n) {
        this.nCalls = n;
    }

    public synchronized int getNCalls() {
        return this.nCalls;
    }

    public synchronized void setNCallsDiff(int n) {
        this.nCallsDiff = n;
    }

    public synchronized int getNCallsDiff() {
        return this.nCallsDiff;
    }

    public void setNetTime0(long l) {
        this.timingData.setNetTime0(l);
    }

    public long getNetTime0() {
        return this.timingData.getNetTime0();
    }

    public void setNetTime1(long l) {
        this.timingData.setNetTime1(l);
    }

    public long getNetTime1() {
        return this.timingData.getNetTime1();
    }

    public void setSleepTime0(long l) {
        this.timingData.setSleepTime0(l);
    }

    public long getSleepTime0() {
        return this.timingData.getSleepTime0();
    }

    public void setWaitTime0(long l) {
        this.timingData.setWaitTime0(l);
    }

    public synchronized long getWaitTime0() {
        return this.timingData.getWaitTime0();
    }

    public synchronized int addNCalls(int n) {
        this.nCalls += n;
        return this.nCalls;
    }

    public synchronized int addNCallsDiff(int n) {
        this.nCallsDiff += n;
        return this.nCallsDiff;
    }

    public long addNetTime0(long l) {
        return this.timingData.addNetTime0(l);
    }

    public long addNetTime1(long l) {
        return this.timingData.addNetTime1(l);
    }

    public long addSleepTime0(long l) {
        return this.timingData.addSleepTime0(l);
    }

    public long addWaitTime0(long l) {
        return this.timingData.addWaitTime0(l);
    }

    public synchronized Object clone() {
        TimedCPUCCTNode timedCPUCCTNode = this.createSelfInstance();
        timedCPUCCTNode.setNCalls(this.getNCalls());
        timedCPUCCTNode.setNetTime0(this.getNetTime0());
        timedCPUCCTNode.setNetTime1(this.getNetTime1());
        timedCPUCCTNode.setSleepTime0(this.getSleepTime0());
        timedCPUCCTNode.setWaitTime0(this.getWaitTime0());
        timedCPUCCTNode.setFilteredStatus(this.getFilteredStatus());
        timedCPUCCTNode.setNCallsDiff(0);
        return timedCPUCCTNode;
    }

    protected abstract TimedCPUCCTNode createSelfInstance();

    private static class TimingDataSimple
    implements TimingData {
        private long netTime0;
        private long sleepTime0;
        private long waitTime0;

        private TimingDataSimple() {
        }

        @Override
        public synchronized void setNetTime0(long l) {
            this.netTime0 = l;
        }

        @Override
        public synchronized long getNetTime0() {
            return this.netTime0;
        }

        @Override
        public void setNetTime1(long l) {
        }

        @Override
        public long getNetTime1() {
            return 0L;
        }

        @Override
        public synchronized void setSleepTime0(long l) {
            this.sleepTime0 = l;
        }

        @Override
        public synchronized long getSleepTime0() {
            return this.sleepTime0;
        }

        @Override
        public synchronized void setWaitTime0(long l) {
            this.waitTime0 = l;
        }

        @Override
        public synchronized long getWaitTime0() {
            return this.waitTime0;
        }

        @Override
        public synchronized long addNetTime0(long l) {
            this.netTime0 += l;
            return this.netTime0;
        }

        @Override
        public long addNetTime1(long l) {
            return 0L;
        }

        @Override
        public synchronized long addSleepTime0(long l) {
            this.sleepTime0 += l;
            return this.sleepTime0;
        }

        @Override
        public synchronized long addWaitTime0(long l) {
            this.waitTime0 += l;
            return this.waitTime0;
        }
    }

    private static class TimingDataExtended
    extends TimingDataSimple {
        private long netTime1;

        private TimingDataExtended() {
        }

        @Override
        public synchronized void setNetTime1(long l) {
            this.netTime1 = l;
        }

        @Override
        public synchronized long getNetTime1() {
            return this.netTime1;
        }

        @Override
        public synchronized long addNetTime1(long l) {
            this.netTime1 += l;
            return this.netTime1;
        }
    }

    private static interface TimingData {
        public void setNetTime0(long var1);

        public long getNetTime0();

        public void setNetTime1(long var1);

        public long getNetTime1();

        public void setSleepTime0(long var1);

        public long getSleepTime0();

        public void setWaitTime0(long var1);

        public long getWaitTime0();

        public long addNetTime0(long var1);

        public long addNetTime1(long var1);

        public long addSleepTime0(long var1);

        public long addWaitTime0(long var1);
    }
}

