/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.ClassDumpSegment;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.LoadClass;
import org.netbeans.lib.profiler.heap.TagBounds;

class LoadClassSegment
extends TagBounds {
    HprofHeap hprofHeap;
    final int classIDOffset;
    final int classSerialNumberOffset;
    final int lengthOffset;
    final int nameStringIDOffset;
    final int stackTraceSerialOffset;
    final int timeOffset;

    LoadClassSegment(HprofHeap hprofHeap, long l, long l2) {
        super(2, l, l2);
        int n = hprofHeap.dumpBuffer.getIDSize();
        this.hprofHeap = hprofHeap;
        this.timeOffset = 1;
        this.lengthOffset = this.timeOffset + 4;
        this.classSerialNumberOffset = this.lengthOffset + 4;
        this.classIDOffset = this.classSerialNumberOffset + 4;
        this.stackTraceSerialOffset = this.classIDOffset + n;
        this.nameStringIDOffset = this.stackTraceSerialOffset + 4;
    }

    LoadClass getClassByID(long l) {
        long[] lArray = new long[]{this.startOffset};
        while (lArray[0] < this.endOffset) {
            long l2 = lArray[0];
            long l3 = this.readLoadClassID(lArray);
            if (l3 != l) continue;
            return new LoadClass(this, l2);
        }
        return null;
    }

    LoadClass getClassBySerialNumber(int n) {
        long[] lArray = new long[]{this.startOffset};
        while (lArray[0] < this.endOffset) {
            long l = lArray[0];
            int n2 = this.readLoadClassSerialNumber(lArray);
            if (n2 != n) continue;
            return new LoadClass(this, l);
        }
        return null;
    }

    void setLoadClassOffsets() {
        ClassDumpSegment classDumpSegment = this.hprofHeap.getClassDumpSegment();
        long[] lArray = new long[]{this.startOffset};
        while (lArray[0] < this.endOffset) {
            long l = lArray[0];
            long l2 = this.readLoadClassID(lArray);
            ClassDump classDump = classDumpSegment.getClassDumpByID(l2);
            if (classDump == null) continue;
            classDump.setClassLoadOffset(l);
        }
    }

    private HprofByteBuffer getDumpBuffer() {
        HprofByteBuffer hprofByteBuffer = this.hprofHeap.dumpBuffer;
        return hprofByteBuffer;
    }

    private int readLoadClassSerialNumber(long[] lArray) {
        long l = lArray[0];
        if (this.hprofHeap.readTag(lArray) != 2) {
            return 0;
        }
        return this.getDumpBuffer().getInt(l + (long)this.classSerialNumberOffset);
    }

    private long readLoadClassID(long[] lArray) {
        long l = lArray[0];
        if (this.hprofHeap.readTag(lArray) != 2) {
            return 0L;
        }
        return this.getDumpBuffer().getID(l + (long)this.classIDOffset);
    }
}

