/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.awt;

import java.awt.event.ActionListener;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Completions;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.openide.awt.ActionID;
import org.openide.awt.ActionReference;
import org.openide.awt.ActionReferences;
import org.openide.awt.ActionRegistration;
import org.openide.awt.DynamicMenuContent;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public final class ActionProcessor
extends LayerGeneratingProcessor {
    private static final String IDENTIFIER = "(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)";
    private static final Pattern FQN = Pattern.compile("(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)(?:[.](?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*))*");
    private static final String[] DEFAULT_COMPLETIONS = new String[]{"Menu", "Toolbars", "Shortcuts", "Loaders"};
    private Processor COMPLETIONS;

    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(ActionRegistration.class.getCanonicalName());
        hashSet.add(ActionID.class.getCanonicalName());
        hashSet.add(ActionReference.class.getCanonicalName());
        hashSet.add(ActionReferences.class.getCanonicalName());
        return hashSet;
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotationMirror, ExecutableElement executableElement, String string) {
        if (annotationMirror.getAnnotationType().asElement().getSimpleName().toString().contains(ActionReference.class.getSimpleName()) && executableElement.getSimpleName().contentEquals("path")) {
            if (string == null) {
                string = "";
            }
            if (string.startsWith("\"")) {
                string = string.substring(1);
            }
            HashSet<Completion> hashSet = new HashSet<Completion>();
            for (String string2 : DEFAULT_COMPLETIONS) {
                if (!string2.startsWith(string)) continue;
                hashSet.add(Completions.of("\"" + string2 + '/', NbBundle.getMessage(ActionProcessor.class, (String)("HINT_" + string2))));
            }
            if (!hashSet.isEmpty()) {
                return hashSet;
            }
            if (this.COMPLETIONS == null) {
                String string3 = System.getProperty(ActionReference.class.getName() + ".completion");
                if (string3 != null) {
                    void var7_10;
                    ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                    if (classLoader == null) {
                        ClassLoader completion = Thread.currentThread().getContextClassLoader();
                    }
                    if (var7_10 == null) {
                        ClassLoader classLoader2 = ActionProcessor.class.getClassLoader();
                    }
                    try {
                        void var7_12;
                        this.COMPLETIONS = (Processor)Class.forName(string3, true, (ClassLoader)var7_12).newInstance();
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                        this.COMPLETIONS = this;
                    }
                } else {
                    return hashSet;
                }
            }
            if (this.COMPLETIONS != null && this.COMPLETIONS != this) {
                this.COMPLETIONS.init(this.processingEnv);
                for (Completion completion : this.COMPLETIONS.getCompletions(element, annotationMirror, executableElement, string)) {
                    hashSet.add(completion);
                }
            }
            return hashSet;
        }
        return Collections.emptyList();
    }

    protected boolean handleProcess(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) throws LayerGenerationException {
        Object object;
        Object object2;
        Annotation annotation;
        TypeMirror typeMirror = this.type(ActionListener.class);
        TypeMirror typeMirror2 = this.type(Presenter.Menu.class);
        TypeMirror typeMirror3 = this.type(Presenter.Toolbar.class);
        TypeMirror typeMirror4 = this.type(Presenter.Popup.class);
        TypeMirror typeMirror5 = this.type(ContextAwareAction.class);
        TypeMirror typeMirror6 = this.type(DynamicMenuContent.class);
        for (Element element : roundEnvironment.getElementsAnnotatedWith(ActionRegistration.class)) {
            ActionReferences actionReferences;
            boolean bl;
            String string;
            Object object3;
            String string2;
            annotation = element.getAnnotation(ActionRegistration.class);
            if (annotation == null) continue;
            object2 = element.getAnnotation(ActionID.class);
            if (object2 == null) {
                throw new LayerGenerationException("@ActionRegistration can only be used together with @ActionID annotation", element, this.processingEnv, annotation);
            }
            if (object2.id() == null) continue;
            if (object2.category().startsWith("Actions/")) {
                throw new LayerGenerationException("@ActionID category() cannot contain /", element, this.processingEnv, (Annotation)object2, "category");
            }
            if (!FQN.matcher(object2.id()).matches()) {
                throw new LayerGenerationException("@ActionID id() must be valid fully qualified name", element, this.processingEnv, (Annotation)object2, "id");
            }
            String string3 = object2.id().replace('.', '-');
            LayerBuilder layerBuilder = this.layer(new Element[]{element});
            LayerBuilder.File file = layerBuilder.file("Actions/" + object2.category() + "/" + string3 + ".instance");
            file.bundlevalue("displayName", annotation.displayName(), annotation, "displayName");
            object = annotation.menuText();
            if (!((String)object).isEmpty()) {
                file.bundlevalue("menuText", (String)object, annotation, "menuText");
            }
            if (!(string2 = annotation.popupText()).isEmpty()) {
                file.bundlevalue("popupText", string2, annotation, "popupText");
            }
            boolean bl2 = true;
            if (element.getKind() == ElementKind.FIELD) {
                VariableElement variableElement = (VariableElement)element;
                object3 = this.type(String.class);
                if (!(element.asType() == object3 && element.getModifiers().contains((Object)Modifier.PUBLIC) && element.getModifiers().contains((Object)Modifier.STATIC) && element.getModifiers().contains((Object)Modifier.FINAL))) {
                    throw new LayerGenerationException("Only static string constant fields can be annotated", element, this.processingEnv, annotation);
                }
                if (annotation.key().length() != 0) {
                    throw new LayerGenerationException("When annotating field, one cannot define key()", element, this.processingEnv, annotation, "key");
                }
                bl2 = false;
                string = variableElement.getConstantValue().toString();
            } else if (element.getKind() == ElementKind.CLASS) {
                if (!this.isAssignable(element.asType(), typeMirror)) {
                    throw new LayerGenerationException("Class annotated with @ActionRegistration must implement java.awt.event.ActionListener!", element, this.processingEnv, annotation);
                }
                if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    throw new LayerGenerationException("Class has to be public", element, this.processingEnv, annotation);
                }
                string = annotation.key();
            } else {
                assert (element.getKind() == ElementKind.METHOD) : element;
                layerBuilder.instanceFile("dummy", null, ActionListener.class, annotation, null);
                string = annotation.key();
            }
            if (element.getKind() == ElementKind.FIELD) {
                bl = false;
            } else {
                object3 = element.getKind() == ElementKind.CLASS ? element.asType() : ((ExecutableElement)element).getReturnType();
                boolean bl3 = bl = this.isAssignable((TypeMirror)object3, typeMirror2) || this.isAssignable((TypeMirror)object3, typeMirror3) || this.isAssignable((TypeMirror)object3, typeMirror4) || this.isAssignable((TypeMirror)object3, typeMirror5) || this.isAssignable((TypeMirror)object3, typeMirror6);
            }
            if (bl) {
                if (string.length() != 0) {
                    throw new LayerGenerationException("Cannot specify key and implement Presenter interface", element, this.processingEnv, annotation, "key");
                }
                file.instanceAttribute("instanceCreate", Action.class);
            } else {
                if (string.length() == 0) {
                    file.methodvalue("instanceCreate", "org.openide.awt.Actions", "alwaysEnabled");
                } else {
                    file.methodvalue("instanceCreate", "org.openide.awt.Actions", "callback");
                    if (bl2) {
                        file.methodvalue("fallback", "org.openide.awt.Actions", "alwaysEnabled");
                    }
                    file.stringvalue("key", string);
                }
                if (bl2) {
                    try {
                        file.instanceAttribute("delegate", ActionListener.class, annotation, null);
                    }
                    catch (LayerGenerationException layerGenerationException) {
                        this.generateContext(element, file, (ActionRegistration)annotation);
                    }
                }
                if (annotation.iconBase().length() > 0) {
                    layerBuilder.validateResource(annotation.iconBase(), element, annotation, "iconBase", true);
                    file.stringvalue("iconBase", annotation.iconBase());
                }
                file.boolvalue("noIconInMenu", !annotation.iconInMenu());
                if (annotation.asynchronous()) {
                    file.boolvalue("asynchronous", true);
                }
                if (annotation.surviveFocusChange()) {
                    file.boolvalue("surviveFocusChange", true);
                }
            }
            file.write();
            object3 = element.getAnnotation(ActionReference.class);
            if (object3 != null) {
                this.processReferences(element, (ActionReference)object3, (ActionID)object2);
            }
            if ((actionReferences = element.getAnnotation(ActionReferences.class)) == null) continue;
            for (ActionReference actionReference : actionReferences.value()) {
                this.processReferences(element, actionReference, (ActionID)object2);
            }
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(ActionReference.class)) {
            if (element.getAnnotation(ActionRegistration.class) != null) continue;
            annotation = element.getAnnotation(ActionReference.class);
            object2 = element.getAnnotation(ActionID.class);
            if (object2 != null) {
                this.processReferences(element, (ActionReference)annotation, (ActionID)object2);
                continue;
            }
            throw new LayerGenerationException("Don't use @ActionReference without @ActionID", element, this.processingEnv, annotation);
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(ActionReferences.class)) {
            if (element.getAnnotation(ActionRegistration.class) != null) continue;
            annotation = element.getAnnotation(ActionReferences.class);
            if (element.getKind() != ElementKind.PACKAGE) {
                object2 = element.getAnnotation(ActionID.class);
                if (object2 == null) {
                    throw new LayerGenerationException("Don't use @ActionReferences without @ActionRegistration", element, this.processingEnv, annotation);
                }
                ActionReference[] actionReferenceArray = annotation.value();
                int n = actionReferenceArray.length;
                for (int i = 0; i < n; ++i) {
                    object = actionReferenceArray[i];
                    if (!object.id().id().isEmpty() || !object.id().category().isEmpty()) {
                        throw new LayerGenerationException("Don't specify additional id=@ActionID(...) when using @ActionID on the element", element, this.processingEnv, (Annotation)object.id());
                    }
                    this.processReferences(element, (ActionReference)object, (ActionID)object2);
                }
                continue;
            }
            for (ActionReference actionReference : annotation.value()) {
                if (actionReference.id().id().isEmpty() || actionReference.id().category().isEmpty()) {
                    throw new LayerGenerationException("Specify real id=@ActionID(...)", element, this.processingEnv, (Annotation)actionReference.id());
                }
                this.processReferences(element, actionReference, actionReference.id());
            }
        }
        return true;
    }

    private TypeMirror type(Class<?> clazz) {
        TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement(clazz.getCanonicalName());
        return typeElement == null ? null : typeElement.asType();
    }

    private void generateContext(Element element, LayerBuilder.File file, ActionRegistration actionRegistration) throws LayerGenerationException {
        ExecutableElement executableElement = null;
        ExecutableElement executableElement2 = null;
        for (ExecutableElement annotatedConstruct2 : ElementFilter.constructorsIn(element.getEnclosedElements())) {
            if (annotatedConstruct2.getKind() != ElementKind.CONSTRUCTOR) continue;
            executableElement2 = annotatedConstruct2;
            if (!annotatedConstruct2.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            if (executableElement != null) {
                throw new LayerGenerationException("Only one public constructor allowed", element, this.processingEnv, (Annotation)actionRegistration);
            }
            executableElement = annotatedConstruct2;
        }
        if (executableElement == null || executableElement.getParameters().size() != 1) {
            if (executableElement2 != null) {
                throw new LayerGenerationException("Constructor has to be public with one argument", executableElement2);
            }
            throw new LayerGenerationException("Constructor must have one argument", (Element)executableElement);
        }
        VariableElement variableElement = executableElement.getParameters().get(0);
        DeclaredType declaredType = (DeclaredType)variableElement.asType();
        String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)declaredType.asElement()).toString();
        if ("java.util.List".equals(string)) {
            if (declaredType.getTypeArguments().isEmpty()) {
                throw new LayerGenerationException("Use List<SomeType>", (Element)executableElement);
            }
            file.stringvalue("type", ((Object)declaredType.getTypeArguments().get(0)).toString());
            file.methodvalue("delegate", "org.openide.awt.Actions", "inject");
            file.stringvalue("injectable", this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString());
            file.stringvalue("selectionType", "ANY");
            file.methodvalue("instanceCreate", "org.openide.awt.Actions", "context");
            return;
        }
        if (!declaredType.getTypeArguments().isEmpty()) {
            throw new LayerGenerationException("No type parameters allowed in ", (Element)executableElement);
        }
        file.stringvalue("type", ((Object)variableElement.asType()).toString());
        file.methodvalue("delegate", "org.openide.awt.Actions", "inject");
        file.stringvalue("injectable", this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString());
        file.stringvalue("selectionType", "EXACTLY_ONE");
        file.methodvalue("instanceCreate", "org.openide.awt.Actions", "context");
    }

    private boolean isAssignable(TypeMirror typeMirror, TypeMirror typeMirror2) {
        if (typeMirror2 == null) {
            return false;
        }
        return this.processingEnv.getTypeUtils().isAssignable(typeMirror, typeMirror2);
    }

    private void processReferences(Element element, ActionReference actionReference, ActionID actionID) throws LayerGenerationException {
        LayerBuilder.File file;
        LayerBuilder.File file2;
        if (!(actionReference.id().category().isEmpty() || actionReference.id().id().isEmpty() || actionID.id().equals(actionReference.id().id()) && actionID.category().equals(actionReference.id().category()))) {
            throw new LayerGenerationException("Can't specify id() attribute when @ActionID provided on the element", element, this.processingEnv, (Annotation)actionID);
        }
        String string = actionReference.name();
        if (string.isEmpty()) {
            string = actionID.id().replace('.', '-');
        }
        if (actionReference.path().startsWith("Shortcuts") && (file2 = Utilities.stringToKeys((String)string)) == null) {
            throw new LayerGenerationException("Registrations in Shortcuts folder need to represent a key. Specify value for 'name' attribute.\nSee org.openide.util.Utilities.stringToKeys for possible values. Current name=\"" + string + "\" is not valid.\n", element, this.processingEnv, (Annotation)actionReference, "path");
        }
        file2 = this.layer(new Element[]{element}).file(actionReference.path() + "/" + string + ".shadow");
        file2.stringvalue("originalFile", "Actions/" + actionID.category() + "/" + actionID.id().replace('.', '-') + ".instance");
        file2.position(actionReference.position());
        file2.write();
        if (actionReference.separatorAfter() != Integer.MAX_VALUE) {
            if (actionReference.position() == Integer.MAX_VALUE || actionReference.position() >= actionReference.separatorAfter()) {
                throw new LayerGenerationException("separatorAfter() must be greater than position()", element, this.processingEnv, (Annotation)actionReference);
            }
            file = this.layer(new Element[]{element}).file(actionReference.path() + "/" + string + "-separatorAfter.instance");
            file.newvalue("instanceCreate", JSeparator.class.getName());
            file.position(actionReference.separatorAfter());
            file.write();
        }
        if (actionReference.separatorBefore() != Integer.MAX_VALUE) {
            if (actionReference.position() == Integer.MAX_VALUE || actionReference.position() <= actionReference.separatorBefore()) {
                throw new LayerGenerationException("separatorBefore() must be lower than position()", element, this.processingEnv, (Annotation)actionReference);
            }
            file = this.layer(new Element[]{element}).file(actionReference.path() + "/" + string + "-separatorBefore.instance");
            file.newvalue("instanceCreate", JSeparator.class.getName());
            file.position(actionReference.separatorBefore());
            file.write();
        }
    }
}

