/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.netbeans.swing.tabcontrol.plaf.TabPainter;

final class WinClassicEditorTabCellRenderer
extends AbstractTabCellRenderer {
    private static final TabPainter leftClip = new WinClassicLeftClipPainter();
    private static final TabPainter rightClip = new WinClassicRightClipPainter();
    private static final TabPainter normal = new WinClassicPainter();
    private static final Color GTK_TABBED_PANE_BACKGROUND_1 = new Color(255, 255, 255);
    static final Color ATTENTION_COLOR = new Color(255, 238, 120);
    private static boolean isGenericUI = !"Windows".equals(UIManager.getLookAndFeel().getID());
    private static final Insets INSETS = new Insets(0, 2, 0, 10);

    public WinClassicEditorTabCellRenderer() {
        super(leftClip, normal, rightClip, new Dimension(28, 32));
    }

    @Override
    public Color getSelectedForeground() {
        return UIManager.getColor("textText");
    }

    @Override
    public Color getForeground() {
        return this.getSelectedForeground();
    }

    @Override
    public int getPixelsToAddToSelection() {
        return 4;
    }

    @Override
    protected int getCaptionYAdjustment() {
        return 0;
    }

    @Override
    public Dimension getPadding() {
        Dimension dimension = super.getPadding();
        dimension.width = this.isShowCloseButton() && !Boolean.getBoolean("nb.tabs.suppressCloseButton") ? 28 : 20;
        return dimension;
    }

    private static final Color getSelGradientColor() {
        if ("GTK".equals(UIManager.getLookAndFeel().getID())) {
            return GTK_TABBED_PANE_BACKGROUND_1;
        }
        return UIManager.getColor("winclassic_tab_sel_gradient");
    }

    private static final Color getSelGradientColor2() {
        return UIManager.getColor("TabbedPane.background");
    }

    private static class WinClassicRightClipPainter
    implements TabPainter {
        private WinClassicRightClipPainter() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public Polygon getInteriorPolygon(Component component) {
            WinClassicEditorTabCellRenderer winClassicEditorTabCellRenderer = (WinClassicEditorTabCellRenderer)component;
            Insets insets = this.getBorderInsets(component);
            Polygon polygon = new Polygon();
            int n = 0;
            int n2 = isGenericUI ? 0 : 1;
            int n3 = component.getWidth();
            int n4 = winClassicEditorTabCellRenderer.isSelected() ? component.getHeight() + 2 : component.getHeight() - 1;
            polygon.addPoint(n, n2 + insets.top + 2);
            polygon.addPoint(n + 2, n2 + insets.top);
            polygon.addPoint(n + n3 - 1, n2 + insets.top);
            polygon.addPoint(n + n3 - 1, n2 + n4 - 1);
            polygon.addPoint(n, n2 + n4 - 1);
            return polygon;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            WinClassicEditorTabCellRenderer winClassicEditorTabCellRenderer = (WinClassicEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(component);
            graphics.setColor(winClassicEditorTabCellRenderer.isSelected() ? UIManager.getColor("controlLtHighlight") : UIManager.getColor("controlHighlight"));
            int[] nArray = polygon.xpoints;
            int[] nArray2 = polygon.ypoints;
            graphics.drawLine(nArray[0], nArray2[0], nArray[polygon.npoints - 1], nArray2[polygon.npoints - 1]);
            for (int i = 0; i < polygon.npoints - 1; ++i) {
                graphics.drawLine(nArray[i], nArray2[i], nArray[i + 1], nArray2[i + 1]);
                if (winClassicEditorTabCellRenderer.isSelected() && i == polygon.npoints - 4) {
                    graphics.setColor(winClassicEditorTabCellRenderer.isActive() ? UIManager.getColor("Table.selectionBackground") : UIManager.getColor("control"));
                } else if (i == polygon.npoints - 4) break;
                if (i == polygon.npoints - 3) break;
            }
        }

        @Override
        public void paintInterior(Graphics graphics, Component component) {
            boolean bl;
            WinClassicEditorTabCellRenderer winClassicEditorTabCellRenderer = (WinClassicEditorTabCellRenderer)component;
            boolean bl2 = bl = winClassicEditorTabCellRenderer.isSelected() && winClassicEditorTabCellRenderer.isActive() || (winClassicEditorTabCellRenderer.isClipLeft() || winClassicEditorTabCellRenderer.isClipRight()) && winClassicEditorTabCellRenderer.isPressed();
            if (bl) {
                ((Graphics2D)graphics).setPaint(ColorUtil.getGradientPaint(0.0f, 0.0f, WinClassicEditorTabCellRenderer.getSelGradientColor(), winClassicEditorTabCellRenderer.getWidth(), 0.0f, WinClassicEditorTabCellRenderer.getSelGradientColor2()));
            } else if (!winClassicEditorTabCellRenderer.isAttention()) {
                graphics.setColor(winClassicEditorTabCellRenderer.isSelected() ? UIManager.getColor("TabbedPane.background") : UIManager.getColor("tab_unsel_fill"));
            } else {
                graphics.setColor(ATTENTION_COLOR);
            }
            Polygon polygon = this.getInteriorPolygon(component);
            graphics.fillPolygon(polygon);
        }

        @Override
        public boolean supportsCloseButton(JComponent jComponent) {
            return false;
        }

        @Override
        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            rectangle.setBounds(-20, -20, 0, 0);
        }
    }

    private static class WinClassicLeftClipPainter
    implements TabPainter {
        private WinClassicLeftClipPainter() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        @Override
        public Polygon getInteriorPolygon(Component component) {
            WinClassicEditorTabCellRenderer winClassicEditorTabCellRenderer = (WinClassicEditorTabCellRenderer)component;
            Insets insets = this.getBorderInsets(component);
            Polygon polygon = new Polygon();
            int n = -3;
            int n2 = isGenericUI ? 0 : 1;
            int n3 = component.getWidth() + 3;
            int n4 = winClassicEditorTabCellRenderer.isSelected() ? component.getHeight() + 2 : component.getHeight() - 1;
            polygon.addPoint(n, n2 + insets.top + 2);
            polygon.addPoint(n + 2, n2 + insets.top);
            polygon.addPoint(n + n3 - 3, n2 + insets.top);
            polygon.addPoint(n + n3 - 1, n2 + insets.top + 2);
            polygon.addPoint(n + n3 - 1, n2 + n4 - 1);
            polygon.addPoint(n, n2 + n4 - 1);
            return polygon;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            WinClassicEditorTabCellRenderer winClassicEditorTabCellRenderer = (WinClassicEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(component);
            graphics.setColor(winClassicEditorTabCellRenderer.isSelected() ? UIManager.getColor("controlLtHighlight") : UIManager.getColor("controlHighlight"));
            int[] nArray = polygon.xpoints;
            int[] nArray2 = polygon.ypoints;
            graphics.drawLine(nArray[0], nArray2[0], nArray[polygon.npoints - 1], nArray2[polygon.npoints - 1]);
            for (int i = 0; i < polygon.npoints - 1; ++i) {
                graphics.drawLine(nArray[i], nArray2[i], nArray[i + 1], nArray2[i + 1]);
                if (i != polygon.npoints - 4) continue;
                graphics.setColor(winClassicEditorTabCellRenderer.isSelected() ? UIManager.getColor("controlDkShadow") : UIManager.getColor("controlShadow"));
                graphics.drawLine(nArray[i] + 1, nArray2[i] + 1, nArray[i] + 2, nArray2[i] + 2);
            }
        }

        @Override
        public void paintInterior(Graphics graphics, Component component) {
            boolean bl;
            WinClassicEditorTabCellRenderer winClassicEditorTabCellRenderer = (WinClassicEditorTabCellRenderer)component;
            boolean bl2 = bl = winClassicEditorTabCellRenderer.isSelected() && winClassicEditorTabCellRenderer.isActive() || (winClassicEditorTabCellRenderer.isClipLeft() || winClassicEditorTabCellRenderer.isClipRight()) && winClassicEditorTabCellRenderer.isPressed();
            if (bl) {
                ((Graphics2D)graphics).setPaint(ColorUtil.getGradientPaint(0.0f, 0.0f, WinClassicEditorTabCellRenderer.getSelGradientColor(), winClassicEditorTabCellRenderer.getWidth(), 0.0f, WinClassicEditorTabCellRenderer.getSelGradientColor2()));
            } else if (!winClassicEditorTabCellRenderer.isAttention()) {
                graphics.setColor(winClassicEditorTabCellRenderer.isSelected() ? UIManager.getColor("TabbedPane.background") : UIManager.getColor("tab_unsel_fill"));
            } else {
                graphics.setColor(ATTENTION_COLOR);
            }
            Polygon polygon = this.getInteriorPolygon(component);
            graphics.fillPolygon(polygon);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            rectangle.setBounds(-20, -20, 0, 0);
        }

        @Override
        public boolean supportsCloseButton(JComponent jComponent) {
            return false;
        }
    }

    private static class WinClassicPainter
    implements TabPainter {
        private WinClassicPainter() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        @Override
        public Polygon getInteriorPolygon(Component component) {
            WinClassicEditorTabCellRenderer winClassicEditorTabCellRenderer = (WinClassicEditorTabCellRenderer)component;
            Insets insets = this.getBorderInsets(component);
            Polygon polygon = new Polygon();
            int n = winClassicEditorTabCellRenderer.isLeftmost() ? 1 : 0;
            int n2 = isGenericUI ? 0 : 1;
            int n3 = winClassicEditorTabCellRenderer.isLeftmost() ? component.getWidth() - 1 : component.getWidth();
            int n4 = winClassicEditorTabCellRenderer.isSelected() ? component.getHeight() + 2 : component.getHeight() - 1;
            polygon.addPoint(n, n2 + insets.top + 2);
            polygon.addPoint(n + 2, n2 + insets.top);
            polygon.addPoint(n + n3 - 3, n2 + insets.top);
            polygon.addPoint(n + n3 - 1, n2 + insets.top + 2);
            polygon.addPoint(n + n3 - 1, n2 + n4 - 2);
            polygon.addPoint(n, n2 + n4 - 2);
            return polygon;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            WinClassicEditorTabCellRenderer winClassicEditorTabCellRenderer = (WinClassicEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(component);
            graphics.setColor(winClassicEditorTabCellRenderer.isSelected() ? UIManager.getColor("controlLtHighlight") : UIManager.getColor("controlHighlight"));
            int[] nArray = polygon.xpoints;
            int[] nArray2 = polygon.ypoints;
            graphics.drawLine(nArray[0], nArray2[0], nArray[polygon.npoints - 1], nArray2[polygon.npoints - 1]);
            for (int i = 0; i < polygon.npoints - 1; ++i) {
                graphics.drawLine(nArray[i], nArray2[i], nArray[i + 1], nArray2[i + 1]);
                if (i != polygon.npoints - 4) continue;
                graphics.setColor(winClassicEditorTabCellRenderer.isSelected() ? UIManager.getColor("controlDkShadow") : UIManager.getColor("controlShadow"));
                graphics.drawLine(nArray[i] + 1, nArray2[i] + 1, nArray[i] + 2, nArray2[i] + 2);
            }
        }

        @Override
        public void paintInterior(Graphics graphics, Component component) {
            boolean bl;
            WinClassicEditorTabCellRenderer winClassicEditorTabCellRenderer = (WinClassicEditorTabCellRenderer)component;
            boolean bl2 = bl = winClassicEditorTabCellRenderer.isSelected() && winClassicEditorTabCellRenderer.isActive() || (winClassicEditorTabCellRenderer.isClipLeft() || winClassicEditorTabCellRenderer.isClipRight()) && winClassicEditorTabCellRenderer.isPressed();
            if (bl) {
                ((Graphics2D)graphics).setPaint(ColorUtil.getGradientPaint(0.0f, 0.0f, WinClassicEditorTabCellRenderer.getSelGradientColor(), winClassicEditorTabCellRenderer.getWidth(), 0.0f, WinClassicEditorTabCellRenderer.getSelGradientColor2()));
            } else if (!winClassicEditorTabCellRenderer.isAttention()) {
                graphics.setColor(winClassicEditorTabCellRenderer.isSelected() ? UIManager.getColor("TabbedPane.background") : UIManager.getColor("tab_unsel_fill"));
            } else {
                graphics.setColor(ATTENTION_COLOR);
            }
            Polygon polygon = this.getInteriorPolygon(component);
            graphics.fillPolygon(polygon);
            if (!this.supportsCloseButton((JComponent)component)) {
                return;
            }
            this.paintCloseButton(graphics, (JComponent)component);
        }

        @Override
        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            boolean bl;
            boolean bl2 = ((WinClassicEditorTabCellRenderer)jComponent).isClipRight();
            boolean bl3 = ((WinClassicEditorTabCellRenderer)jComponent).isClipLeft();
            boolean bl4 = bl = !((WinClassicEditorTabCellRenderer)jComponent).isShowCloseButton();
            if (bl3 || bl2 || bl) {
                rectangle.x = -100;
                rectangle.y = -100;
                rectangle.width = 0;
                rectangle.height = 0;
            } else {
                String string = this.findIconPath((WinClassicEditorTabCellRenderer)jComponent);
                Icon icon = TabControlButtonFactory.getIcon(string);
                int n = icon.getIconWidth();
                int n2 = icon.getIconHeight();
                rectangle.x = rectangle2.x + rectangle2.width - n - 2;
                rectangle.y = rectangle2.y + Math.max(0, rectangle2.height / 2 - n2 / 2);
                rectangle.width = n;
                rectangle.height = n2;
            }
        }

        private void paintCloseButton(Graphics graphics, JComponent jComponent) {
            if (((AbstractTabCellRenderer)jComponent).isShowCloseButton()) {
                Rectangle rectangle = new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight());
                Rectangle rectangle2 = new Rectangle();
                this.getCloseButtonRectangle(jComponent, rectangle2, rectangle);
                String string = this.findIconPath((WinClassicEditorTabCellRenderer)jComponent);
                Icon icon = TabControlButtonFactory.getIcon(string);
                icon.paintIcon(jComponent, graphics, rectangle2.x, rectangle2.y);
            }
        }

        private String findIconPath(WinClassicEditorTabCellRenderer winClassicEditorTabCellRenderer) {
            if (winClassicEditorTabCellRenderer.inCloseButton() && winClassicEditorTabCellRenderer.isPressed()) {
                return "org/openide/awt/resources/win_close_pressed.png";
            }
            if (winClassicEditorTabCellRenderer.inCloseButton()) {
                return "org/openide/awt/resources/win_close_rollover.png";
            }
            return "org/openide/awt/resources/win_close_enabled.png";
        }

        @Override
        public boolean supportsCloseButton(JComponent jComponent) {
            return ((AbstractTabCellRenderer)jComponent).isShowCloseButton();
        }
    }
}

