/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.agent.SnmpMibAgent;
import com.sun.jmx.snmp.agent.SnmpMibRequest;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class SnmpErrorHandlerAgent
extends SnmpMibAgent
implements Serializable {
    private static final long serialVersionUID = 7751082923508885650L;

    @Override
    public void init() throws IllegalAccessException {
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        return objectName;
    }

    @Override
    public long[] getRootOid() {
        return null;
    }

    @Override
    public void get(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpErrorHandlerAgent.class.getName(), "get", "Get in Exception");
        if (snmpMibRequest.getVersion() == 0) {
            throw new SnmpStatusException(2);
        }
        Enumeration enumeration = snmpMibRequest.getElements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            snmpVarBind.setNoSuchObject();
        }
    }

    @Override
    public void check(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpErrorHandlerAgent.class.getName(), "check", "Check in Exception");
        throw new SnmpStatusException(17);
    }

    @Override
    public void set(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpErrorHandlerAgent.class.getName(), "set", "Set in Exception, CANNOT be called");
        throw new SnmpStatusException(17);
    }

    @Override
    public void getNext(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpErrorHandlerAgent.class.getName(), "getNext", "GetNext in Exception");
        if (snmpMibRequest.getVersion() == 0) {
            throw new SnmpStatusException(2);
        }
        Enumeration enumeration = snmpMibRequest.getElements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            snmpVarBind.setEndOfMibView();
        }
    }

    @Override
    public void getBulk(SnmpMibRequest snmpMibRequest, int n, int n2) throws SnmpStatusException {
        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpErrorHandlerAgent.class.getName(), "getBulk", "GetBulk in Exception");
        if (snmpMibRequest.getVersion() == 0) {
            throw new SnmpStatusException(5, 0);
        }
        Enumeration enumeration = snmpMibRequest.getElements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            snmpVarBind.setEndOfMibView();
        }
    }
}

