/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.sampler.cpu;

import com.sun.tools.visualvm.sampler.AbstractSamplerSupport;
import com.sun.tools.visualvm.sampler.cpu.CPUSamplerSupport;
import com.sun.tools.visualvm.sampler.cpu.SampledLivePanel;
import com.sun.tools.visualvm.uisupport.TransparentToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

final class CPUView
extends JPanel {
    private final AbstractSamplerSupport.Refresher refresher;
    private boolean forceRefresh = false;
    private final CPUSamplerSupport.SnapshotDumper snapshotDumper;
    private final CPUSamplerSupport.ThreadDumper threadDumper;
    private SampledLivePanel resultsPanel;
    private AbstractButton snapshotButton;
    private AbstractButton pauseButton;
    private AbstractButton refreshButton;
    private AbstractButton threaddumpButton;
    private JLabel noDataLabel;

    CPUView(AbstractSamplerSupport.Refresher refresher, CPUSamplerSupport.SnapshotDumper snapshotDumper, CPUSamplerSupport.ThreadDumper threadDumper) {
        this.refresher = refresher;
        this.snapshotDumper = snapshotDumper;
        this.threadDumper = threadDumper;
        this.initComponents();
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && CPUView.this.isShowing()) {
                    CPUView.this.refresher.refresh();
                }
            }
        });
    }

    void initSession() {
        if (this.resultsPanel != null) {
            this.remove((Component)((Object)this.resultsPanel));
            this.resultsPanel = null;
        }
        this.snapshotButton.setEnabled(false);
        this.add((Component)this.noDataLabel, "Center");
        this.noDataLabel.invalidate();
        this.validate();
        this.repaint();
    }

    void setResultsPanel(SampledLivePanel resultsPanel) {
        this.resultsPanel = resultsPanel;
    }

    void refresh() {
        if (this.noDataLabel.getParent() == this) {
            this.remove(this.noDataLabel);
            this.resultsPanel.setPreferredSize(new Dimension(1, 1));
            JScrollPane resultsScroll = (JScrollPane)this.resultsPanel.getComponent(0);
            resultsScroll.setBorder(BorderFactory.createLoweredBevelBorder());
            resultsScroll.setViewportBorder(BorderFactory.createEmptyBorder());
            this.add((Component)((Object)this.resultsPanel), "Center");
            this.resultsPanel.invalidate();
            this.validate();
            this.repaint();
        }
        if (!this.isShowing() || this.pauseButton.isSelected() && !this.forceRefresh) {
            return;
        }
        this.forceRefresh = false;
        this.resultsPanel.updateLiveResults();
        this.snapshotButton.setEnabled(this.snapshotDumper != null);
    }

    void terminate() {
        this.pauseButton.setEnabled(false);
        this.refreshButton.setEnabled(false);
        this.threaddumpButton.setEnabled(false);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        TransparentToolBar toolBar = new TransparentToolBar();
        this.pauseButton = new JToggleButton(){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                boolean selected = CPUView.this.pauseButton.isSelected();
                CPUView.this.refreshButton.setEnabled(selected);
                if (!selected) {
                    CPUView.this.refresher.refresh();
                }
            }
        };
        this.pauseButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"com/sun/tools/visualvm/sampler/resources/pause.png", (boolean)true)));
        this.pauseButton.setToolTipText(NbBundle.getMessage(CPUView.class, (String)"TOOLTIP_Pause_results"));
        this.pauseButton.setOpaque(false);
        toolBar.addItem((JComponent)this.pauseButton);
        this.refreshButton = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                CPUView.this.forceRefresh = true;
                CPUView.this.refresher.refresh();
            }
        };
        this.refreshButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"com/sun/tools/visualvm/sampler/resources/update.png", (boolean)true)));
        this.refreshButton.setToolTipText(NbBundle.getMessage(CPUView.class, (String)"TOOLTIP_Update_results"));
        this.refreshButton.setEnabled(this.pauseButton.isSelected());
        this.refreshButton.setOpaque(false);
        toolBar.addItem((JComponent)this.refreshButton);
        toolBar.addSeparator();
        this.snapshotButton = new JButton(NbBundle.getMessage(CPUView.class, (String)"LBL_Snapshot"), new ImageIcon(ImageUtilities.loadImage((String)"com/sun/tools/visualvm/sampler/resources/snapshot.png", (boolean)true))){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                CPUView.this.snapshotDumper.takeSnapshot((event.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0);
            }
        };
        this.snapshotButton.setToolTipText(NbBundle.getMessage(CPUView.class, (String)"TOOLTIP_Snapshot"));
        this.snapshotButton.setOpaque(false);
        this.snapshotButton.setEnabled(false);
        toolBar.addItem((JComponent)this.snapshotButton);
        toolBar.addFiller();
        this.threaddumpButton = new JButton(NbBundle.getMessage(CPUView.class, (String)"LBL_Thread_dump")){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                CPUView.this.threadDumper.takeThreadDump((event.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0);
            }
        };
        this.threaddumpButton.setToolTipText(NbBundle.getMessage(CPUView.class, (String)"TOOLTIP_Thread_dump"));
        this.threaddumpButton.setOpaque(false);
        this.threaddumpButton.setEnabled(this.threadDumper != null);
        toolBar.addItem((JComponent)this.threaddumpButton);
        int maxHeight = this.pauseButton.getPreferredSize().height;
        maxHeight = Math.max(maxHeight, this.refreshButton.getPreferredSize().height);
        maxHeight = Math.max(maxHeight, this.snapshotButton.getPreferredSize().height);
        maxHeight = Math.max(maxHeight, this.threaddumpButton.getPreferredSize().height);
        int width = this.pauseButton.getPreferredSize().width;
        Dimension size = new Dimension(maxHeight, maxHeight);
        this.pauseButton.setMinimumSize(size);
        this.pauseButton.setPreferredSize(size);
        this.pauseButton.setMaximumSize(size);
        width = this.refreshButton.getPreferredSize().width;
        size = new Dimension(maxHeight, maxHeight);
        this.refreshButton.setMinimumSize(size);
        this.refreshButton.setPreferredSize(size);
        this.refreshButton.setMaximumSize(size);
        width = this.snapshotButton.getPreferredSize().width;
        size = new Dimension(width + 5, maxHeight);
        this.snapshotButton.setMinimumSize(size);
        this.snapshotButton.setPreferredSize(size);
        this.snapshotButton.setMaximumSize(size);
        width = this.threaddumpButton.getPreferredSize().width;
        size = new Dimension(width + 5, maxHeight);
        this.threaddumpButton.setMinimumSize(size);
        this.threaddumpButton.setPreferredSize(size);
        this.threaddumpButton.setMaximumSize(size);
        toolBar.setBorder(BorderFactory.createEmptyBorder(4, 4, 3, 4));
        this.add((Component)toolBar, "North");
        this.noDataLabel = new JLabel(NbBundle.getMessage(CPUView.class, (String)"LBL_No_data"), 0);
    }
}

