/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.text.NumberFormat;
import java.util.Locale;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjLivenessTermCCTNode;
import org.netbeans.lib.profiler.results.memory.SurvGenSet;

public class PresoObjLivenessCCTNode
extends PresoObjAllocCCTNode {
    static int currentEpoch;
    public static final int SORT_BY_LIVE_OBJ_SIZE = 1;
    public static final int SORT_BY_LIVE_OBJ_NUMBER = 2;
    public static final int SORT_BY_ALLOC_OBJ = 3;
    public static final int SORT_BY_AVG_AGE = 4;
    public static final int SORT_BY_SURV_GEN = 5;
    public static final int SORT_BY_NAME = 6;
    public static final int SORT_BY_TOTAL_ALLOC_OBJ = 7;
    private static boolean dontShowZeroLiveObjNodes;
    public final NumberFormat decimalFormat = NumberFormat.getInstance(Locale.ENGLISH);
    public float avgObjectAge;
    public int nLiveObjects;
    public int survGen;

    protected PresoObjLivenessCCTNode(RuntimeMemoryCCTNode runtimeMemoryCCTNode) {
        super(runtimeMemoryCCTNode);
    }

    public static PresoObjAllocCCTNode createPresentationCCTFromSnapshot(LivenessMemoryResultsSnapshot livenessMemoryResultsSnapshot, RuntimeMemoryCCTNode runtimeMemoryCCTNode, String string, int n, boolean bl) {
        currentEpoch = n;
        dontShowZeroLiveObjNodes = bl;
        SurvGenSet survGenSet = new SurvGenSet();
        PresoObjAllocCCTNode presoObjAllocCCTNode = PresoObjLivenessCCTNode.generateMirrorNode(runtimeMemoryCCTNode, survGenSet);
        if (presoObjAllocCCTNode != null) {
            PresoObjLivenessCCTNode.assignNamesToNodesFromSnapshot(livenessMemoryResultsSnapshot, presoObjAllocCCTNode, string);
        }
        return presoObjAllocCCTNode;
    }

    public static PresoObjAllocCCTNode createPresentationCCTFromVM(ProfilerClient profilerClient, RuntimeMemoryCCTNode runtimeMemoryCCTNode, String string, int n, boolean bl) throws ClientUtils.TargetAppOrVMTerminated {
        currentEpoch = n;
        dontShowZeroLiveObjNodes = bl;
        SurvGenSet survGenSet = new SurvGenSet();
        PresoObjAllocCCTNode presoObjAllocCCTNode = PresoObjLivenessCCTNode.generateMirrorNode(runtimeMemoryCCTNode, survGenSet);
        if (presoObjAllocCCTNode != null) {
            PresoObjLivenessCCTNode.assignNamesToNodesFromVM(profilerClient, presoObjAllocCCTNode, string);
        }
        return presoObjAllocCCTNode;
    }

    @Override
    public void sortChildren(int n, boolean bl) {
        int n2 = this.getNChildren();
        if (n2 == 0) {
            return;
        }
        for (int i = 0; i < n2; ++i) {
            this.children[i].sortChildren(n, bl);
        }
        if (n2 > 1) {
            switch (n) {
                case 1: {
                    this.sortChildrenByLiveObjSize(bl);
                    break;
                }
                case 2: {
                    this.sortChildrenByLiveObjNumber(bl);
                    break;
                }
                case 3: {
                    this.sortChildrenByAllocObjNumber(bl);
                    break;
                }
                case 4: {
                    this.sortChildrenByAvgAge(bl);
                    break;
                }
                case 5: {
                    this.sortChildrenBySurvGen(bl);
                    break;
                }
                case 6: {
                    this.sortChildrenByName(bl);
                }
            }
        }
    }

    protected static PresoObjAllocCCTNode generateMirrorNode(RuntimeMemoryCCTNode runtimeMemoryCCTNode, SurvGenSet survGenSet) {
        RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray;
        int n;
        Object object;
        PresoObjLivenessCCTNode presoObjLivenessCCTNode = null;
        if (runtimeMemoryCCTNode instanceof RuntimeObjLivenessTermCCTNode) {
            object = (RuntimeObjLivenessTermCCTNode)runtimeMemoryCCTNode;
            int n2 = ((RuntimeObjLivenessTermCCTNode)object).calculateTotalNLiveObjects();
            if (dontShowZeroLiveObjNodes && n2 == 0 && runtimeMemoryCCTNode.children == null) {
                return null;
            }
            presoObjLivenessCCTNode = new PresoObjLivenessCCTNode(runtimeMemoryCCTNode);
            presoObjLivenessCCTNode.nLiveObjects = n2;
            RuntimeObjLivenessTermCCTNode.calculateTotalNumberOfSurvGens((RuntimeMemoryCCTNode)object, survGenSet);
            presoObjLivenessCCTNode.survGen = survGenSet.getTotalNoOfAges();
            presoObjLivenessCCTNode.avgObjectAge = RuntimeObjLivenessTermCCTNode.calculateAvgObjectAgeForAllPaths((RuntimeMemoryCCTNode)object, currentEpoch);
            if (runtimeMemoryCCTNode.children != null) {
                n = runtimeMemoryCCTNode.children instanceof RuntimeMemoryCCTNode ? 1 : ((RuntimeMemoryCCTNode[])runtimeMemoryCCTNode.children).length;
                presoObjLivenessCCTNode.children = new PresoObjAllocCCTNode[n];
            }
        }
        if ((object = runtimeMemoryCCTNode.children) != null && (n = (runtimeMemoryCCTNodeArray = object instanceof RuntimeMemoryCCTNode ? new RuntimeMemoryCCTNode[]{(RuntimeMemoryCCTNode)object} : (RuntimeMemoryCCTNode[])object).length) > 0) {
            double d = 0.0;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                SurvGenSet survGenSet2 = n == 1 ? survGenSet : new SurvGenSet();
                PresoObjLivenessCCTNode presoObjLivenessCCTNode2 = (PresoObjLivenessCCTNode)PresoObjLivenessCCTNode.generateMirrorNode(runtimeMemoryCCTNodeArray[i], survGenSet2);
                if (presoObjLivenessCCTNode2 == null) continue;
                if (presoObjLivenessCCTNode == null) {
                    presoObjLivenessCCTNode = new PresoObjLivenessCCTNode(runtimeMemoryCCTNode);
                    presoObjLivenessCCTNode.children = new PresoObjAllocCCTNode[n];
                }
                presoObjLivenessCCTNode.children[n3++] = presoObjLivenessCCTNode2;
                presoObjLivenessCCTNode2.parent = presoObjLivenessCCTNode;
                presoObjLivenessCCTNode.nCalls += presoObjLivenessCCTNode2.nCalls;
                presoObjLivenessCCTNode.totalObjSize += presoObjLivenessCCTNode2.totalObjSize;
                presoObjLivenessCCTNode.nLiveObjects += presoObjLivenessCCTNode2.nLiveObjects;
                d += (double)(presoObjLivenessCCTNode2.avgObjectAge * (float)presoObjLivenessCCTNode2.nLiveObjects);
                if (n <= 1) continue;
                survGenSet.mergeWith(survGenSet2);
            }
            if (dontShowZeroLiveObjNodes && (presoObjLivenessCCTNode == null || presoObjLivenessCCTNode.nLiveObjects == 0)) {
                return null;
            }
            if (n3 < n) {
                PresoObjAllocCCTNode[] presoObjAllocCCTNodeArray = new PresoObjAllocCCTNode[n3];
                System.arraycopy(presoObjLivenessCCTNode.children, 0, presoObjAllocCCTNodeArray, 0, n3);
                presoObjLivenessCCTNode.children = presoObjAllocCCTNodeArray;
            }
            presoObjLivenessCCTNode.avgObjectAge = presoObjLivenessCCTNode.nLiveObjects > 0 ? (float)(d / (double)presoObjLivenessCCTNode.nLiveObjects) : 0.0f;
            presoObjLivenessCCTNode.survGen = survGenSet.getTotalNoOfAges();
        }
        return presoObjLivenessCCTNode;
    }

    protected void sortChildrenByAvgAge(boolean bl) {
        int n = this.children.length;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = ((PresoObjLivenessCCTNode)this.children[i]).avgObjectAge;
        }
        this.sortFloats(fArray, bl);
    }

    protected void sortChildrenByLiveObjNumber(boolean bl) {
        int n = this.children.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = ((PresoObjLivenessCCTNode)this.children[i]).nLiveObjects;
        }
        this.sortInts(nArray, bl);
    }

    protected void sortChildrenByLiveObjSize(boolean bl) {
        this.sortChildrenByAllocObjSize(bl);
    }

    protected void sortChildrenBySurvGen(boolean bl) {
        int n = this.children.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = ((PresoObjLivenessCCTNode)this.children[i]).survGen;
        }
        this.sortInts(nArray, bl);
    }

    @Override
    public void exportXMLData(ExportDataDumper exportDataDumper, String string) {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(string + "<Node>" + string2);
        stringBuffer.append(string + " <Name>" + this.replaceHTMLCharacters(this.getNodeName()) + "<Name>" + string2);
        stringBuffer.append(string + " <Parent>" + this.replaceHTMLCharacters(this.getParent() == null ? "none" : ((PresoObjAllocCCTNode)this.getParent()).getNodeName()) + "<Parent>" + string2);
        stringBuffer.append(string + " <Live_Bytes>" + this.totalObjSize + "</Live_Bytes>" + string2);
        stringBuffer.append(string + " <Live_Objects>" + this.nLiveObjects + "</Live_Objects>" + string2);
        stringBuffer.append(string + " <Allocated_Objects>" + this.nCalls + "</Allocated_Objects>" + string2);
        stringBuffer.append(string + " <Avg_Age>" + this.avgObjectAge + "</Avg_Age>" + string2);
        stringBuffer.append(string + " <Generations>" + this.survGen + "</Generations>" + string2);
        exportDataDumper.dumpData(stringBuffer);
        if (this.children != null) {
            for (int i = 0; i < this.getNChildren(); ++i) {
                this.children[i].exportXMLData(exportDataDumper, string + " ");
            }
        }
        stringBuffer = new StringBuffer(string + "</Node>");
        exportDataDumper.dumpData(stringBuffer);
    }

    @Override
    public void exportHTMLData(ExportDataDumper exportDataDumper, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("<tr><td class=\"method\"><pre class=\"method\">");
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(".");
        }
        stringBuffer.append(this.replaceHTMLCharacters(this.getNodeName()) + "</pre></td><td class=\"right\">" + this.totalObjSize + "</td><td class=\"right\">" + this.nLiveObjects + "</td><td class=\"right\">" + this.nCalls + "</td><td class=\"right\">" + this.avgObjectAge + "</td><td class=\"right\">" + this.survGen + "</td><td class=\"parent\"><pre class=\"parent\">" + this.replaceHTMLCharacters(this.getParent() == null ? "none" : ((PresoObjAllocCCTNode)this.getParent()).getNodeName()) + "</pre></td></tr>");
        exportDataDumper.dumpData(stringBuffer);
        if (this.children != null) {
            for (n2 = 0; n2 < this.children.length; ++n2) {
                this.children[n2].exportHTMLData(exportDataDumper, n + 1);
            }
        }
    }

    private String replaceHTMLCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public void exportCSVData(String string, int n, ExportDataDumper exportDataDumper) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "\r\n";
        String string3 = "\"";
        String string4 = " ";
        stringBuffer.append(string3);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string4);
        }
        stringBuffer.append(this.nodeName == null ? this.className : this.nodeName).append(string3).append(string);
        stringBuffer.append(string3).append(this.totalObjSize).append(string3).append(string);
        StringBuffer stringBuffer2 = stringBuffer.append(string3).append(this.nLiveObjects).append(string3).append(string);
        stringBuffer.append(string3).append(this.nCalls).append(string3).append(string);
        stringBuffer.append(string3).append(this.decimalFormat.format(this.avgObjectAge)).append(string3).append(string);
        stringBuffer.append(string3).append(this.survGen).append(string3).append(string);
        stringBuffer.append(string3).append(this.getParent() == null ? "none" : ((PresoObjAllocCCTNode)this.getParent()).getNodeName()).append(string2);
        exportDataDumper.dumpData(stringBuffer);
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ((PresoObjLivenessCCTNode)this.children[i]).exportCSVData(string, n + 1, exportDataDumper);
            }
        }
    }

    public void setDecimalFormat() {
        this.decimalFormat.setMinimumFractionDigits(3);
        this.decimalFormat.setMaximumFractionDigits(3);
    }
}

