/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;

public final class HeapProgress {
    public static final int PROGRESS_MAX = 1000;
    private static ThreadLocal progressThreadLocal = new ThreadLocal();

    private HeapProgress() {
    }

    public static BoundedRangeModel getProgress() {
        BoundedRangeModel boundedRangeModel = (BoundedRangeModel)progressThreadLocal.get();
        if (boundedRangeModel == null) {
            boundedRangeModel = new DefaultBoundedRangeModel(0, 0, 0, 1000);
            progressThreadLocal.set(boundedRangeModel);
        }
        return boundedRangeModel;
    }

    static void progress(long l, long l2, long l3, long l4) {
        if (l % 100000L == 0L) {
            HeapProgress.progress(l3, l4, l2);
        }
    }

    static void progress(long l, long l2) {
        HeapProgress.progress(l, 0L, l, l2);
    }

    private static void progress(long l, long l2, long l3) {
        BoundedRangeModel boundedRangeModel = (BoundedRangeModel)progressThreadLocal.get();
        if (boundedRangeModel != null) {
            long l4 = 1000L * (l - l3) / (l2 - l3);
            boundedRangeModel.setValue((int)l4);
        }
    }

    static void progressFinish() {
        BoundedRangeModel boundedRangeModel = (BoundedRangeModel)progressThreadLocal.get();
        if (boundedRangeModel != null) {
            boundedRangeModel.setValue(1000);
            progressThreadLocal.remove();
        }
    }
}

