/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.ConfigurationImpl;
import com.javafx.tools.doclets.formats.html.HtmlDocletWriter;
import com.javafx.tools.doclets.formats.html.LinkInfoImpl;
import com.javafx.tools.doclets.formats.html.markup.HtmlConstants;
import com.javafx.tools.doclets.formats.html.markup.HtmlStyle;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.formats.html.markup.RawHtml;
import com.javafx.tools.doclets.formats.html.markup.StringContent;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.PackageSummaryWriter;
import com.javafx.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Tag;
import java.io.IOException;
import java.util.Arrays;

public class PackageWriterImpl
extends HtmlDocletWriter
implements PackageSummaryWriter {
    protected PackageDoc prev;
    protected PackageDoc next;
    protected PackageDoc packageDoc;
    private static final String OUTPUT_FILE_NAME = "package-summary.html";

    public PackageWriterImpl(ConfigurationImpl configuration, PackageDoc packageDoc, PackageDoc prev, PackageDoc next) throws IOException {
        super(configuration, DirectoryManager.getDirectoryPath(packageDoc), OUTPUT_FILE_NAME, DirectoryManager.getRelativePath(packageDoc.name()));
        this.prev = prev;
        this.next = next;
        this.packageDoc = packageDoc;
    }

    public String getOutputFileName() {
        return OUTPUT_FILE_NAME;
    }

    public Content getPackageHeader(String heading) {
        String pkgName = this.packageDoc.name();
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(pkgName));
        this.addTop(bodyTree);
        this.addNavLinks(true, bodyTree);
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.header);
        HtmlTree annotationContent = new HtmlTree(HtmlTag.P);
        this.addAnnotationInfo(this.packageDoc, (Content)annotationContent);
        div.addContent(annotationContent);
        HtmlTree tHeading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, true, HtmlStyle.title, this.packageLabel);
        ((Content)tHeading).addContent(this.getSpace());
        RawHtml packageHead = new RawHtml(heading);
        ((Content)tHeading).addContent(packageHead);
        div.addContent(tHeading);
        this.addDeprecationInfo(div);
        if (this.packageDoc.inlineTags().length > 0 && !this.configuration.nocomment) {
            HtmlTree docSummaryDiv = new HtmlTree(HtmlTag.DIV);
            docSummaryDiv.addStyle(HtmlStyle.docSummary);
            this.addSummaryComment((Doc)this.packageDoc, docSummaryDiv);
            div.addContent(docSummaryDiv);
            Content space = this.getSpace();
            Content descLink = this.getHyperLink("", "package_description", this.descriptionLabel, "", "");
            HtmlTree descPara = new HtmlTree(HtmlTag.P, this.seeLabel, space, descLink);
            div.addContent(descPara);
        }
        ((Content)bodyTree).addContent(div);
        return bodyTree;
    }

    public Content getContentHeader() {
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.contentContainer);
        return div;
    }

    public void addDeprecationInfo(Content div) {
        Tag[] deprs = this.packageDoc.tags("deprecated");
        if (Util.isDeprecated((Doc)this.packageDoc)) {
            Tag[] commentTags;
            HtmlTree deprDiv = new HtmlTree(HtmlTag.DIV);
            deprDiv.addStyle(HtmlStyle.deprecatedContent);
            HtmlTree deprPhrase = HtmlTree.SPAN(HtmlStyle.strong, this.deprecatedPhrase);
            deprDiv.addContent(deprPhrase);
            if (deprs.length > 0 && (commentTags = deprs[0].inlineTags()).length > 0) {
                this.addInlineDeprecatedComment((Doc)this.packageDoc, deprs[0], deprDiv);
            }
            div.addContent(deprDiv);
        }
    }

    public Content getSummaryHeader() {
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.blockList);
        return ul;
    }

    public void addClassesSummary(ClassDoc[] classes, String label, String tableSummary, String[] tableHeader, Content summaryContentTree) {
        if (classes.length > 0) {
            Arrays.sort(classes);
            Content caption = this.getTableCaption(label);
            HtmlTree table = HtmlTree.TABLE(HtmlStyle.packageSummary, 0, 3, 0, tableSummary, caption);
            ((Content)table).addContent(this.getSummaryTableHeader(tableHeader, "col"));
            HtmlTree tbody = new HtmlTree(HtmlTag.TBODY);
            for (int i = 0; i < classes.length; ++i) {
                if (!Util.isCoreClass(classes[i]) || !this.configuration.isGeneratedDoc(classes[i])) continue;
                RawHtml classContent = new RawHtml(this.getLink(new LinkInfoImpl(9, classes[i], false)));
                HtmlTree tdClass = HtmlTree.TD(HtmlStyle.colFirst, classContent);
                HtmlTree tr = HtmlTree.TR(tdClass);
                if (i % 2 == 0) {
                    tr.addStyle(HtmlStyle.altColor);
                } else {
                    tr.addStyle(HtmlStyle.rowColor);
                }
                HtmlTree tdClassDescription = new HtmlTree(HtmlTag.TD);
                tdClassDescription.addStyle(HtmlStyle.colLast);
                if (Util.isDeprecated((Doc)classes[i])) {
                    tdClassDescription.addContent(this.deprecatedLabel);
                    if (classes[i].tags("deprecated").length > 0) {
                        this.addSummaryDeprecatedComment((Doc)classes[i], classes[i].tags("deprecated")[0], tdClassDescription);
                    }
                } else {
                    this.addSummaryComment((Doc)classes[i], tdClassDescription);
                }
                tr.addContent(tdClassDescription);
                ((Content)tbody).addContent(tr);
            }
            ((Content)table).addContent(tbody);
            HtmlTree li = HtmlTree.LI(HtmlStyle.blockList, table);
            summaryContentTree.addContent(li);
        }
    }

    public void addPackageDescription(Content packageContentTree) {
        if (this.packageDoc.inlineTags().length > 0) {
            packageContentTree.addContent(this.getMarkerAnchor("package_description"));
            StringContent h2Content = new StringContent(this.configuration.getText("doclet.Package_Description", this.packageDoc.name()));
            packageContentTree.addContent(HtmlTree.HEADING(HtmlConstants.PACKAGE_HEADING, true, (Content)h2Content));
            this.addInlineComment((Doc)this.packageDoc, packageContentTree);
        }
    }

    public void addPackageTags(Content packageContentTree) {
        this.addTagsInfo((Doc)this.packageDoc, packageContentTree);
    }

    public void addPackageFooter(Content contentTree) {
        this.addNavLinks(false, contentTree);
        this.addBottom(contentTree);
    }

    public void printDocument(Content contentTree) {
        this.printHtmlDocument(this.configuration.metakeywords.getMetaKeywords(this.packageDoc), true, contentTree);
    }

    protected Content getNavLinkClassUse() {
        Content useLink = this.getHyperLink("package-use.html", "", this.useLabel, "", "");
        HtmlTree li = HtmlTree.LI(useLink);
        return li;
    }

    public Content getNavLinkPrevious() {
        HtmlTree li;
        if (this.prev == null) {
            li = HtmlTree.LI(this.prevpackageLabel);
        } else {
            String path = DirectoryManager.getRelativePath(this.packageDoc.name(), this.prev.name());
            li = HtmlTree.LI(this.getHyperLink(path + OUTPUT_FILE_NAME, "", this.prevpackageLabel, "", ""));
        }
        return li;
    }

    public Content getNavLinkNext() {
        HtmlTree li;
        if (this.next == null) {
            li = HtmlTree.LI(this.nextpackageLabel);
        } else {
            String path = DirectoryManager.getRelativePath(this.packageDoc.name(), this.next.name());
            li = HtmlTree.LI(this.getHyperLink(path + OUTPUT_FILE_NAME, "", this.nextpackageLabel, "", ""));
        }
        return li;
    }

    protected Content getNavLinkTree() {
        Content useLink = this.getHyperLink("package-tree.html", "", this.treeLabel, "", "");
        HtmlTree li = HtmlTree.LI(useLink);
        return li;
    }

    protected Content getNavLinkPackage() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.packageLabel);
        return li;
    }
}

