/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import sun.tools.jconsole.Resources;

class Formatter {
    static final long SECOND = 1000L;
    static final long MINUTE = 60000L;
    static final long HOUR = 3600000L;
    static final long DAY = 86400000L;
    static final String cr = System.getProperty("line.separator");
    static final DateFormat timeDF = new SimpleDateFormat("HH:mm");
    private static final DateFormat timeWithSecondsDF = new SimpleDateFormat("HH:mm:ss");
    private static final DateFormat dateDF = new SimpleDateFormat("yyyy-MM-dd");
    private static final String decimalZero = new DecimalFormatSymbols().getDecimalSeparator() + "0";

    Formatter() {
    }

    static String formatTime(long l) {
        String string;
        if (l < 60000L) {
            String string2 = String.format("%.3f", (double)l / 1000.0);
            string = Resources.getText("DurationSeconds", string2);
        } else {
            long l2 = l;
            long l3 = l2 / 86400000L;
            long l4 = (l2 %= 86400000L) / 3600000L;
            long l5 = (l2 %= 3600000L) / 60000L;
            string = l >= 86400000L ? Resources.getText("DurationDaysHoursMinutes", l3, l4, l5) : (l >= 3600000L ? Resources.getText("DurationHoursMinutes", l4, l5) : Resources.getText("DurationMinutes", l5));
        }
        return string;
    }

    static String formatNanoTime(long l) {
        long l2 = l / 1000000L;
        return Formatter.formatTime(l2);
    }

    static String formatClockTime(long l) {
        return timeDF.format(l);
    }

    static String formatDate(long l) {
        return dateDF.format(l);
    }

    static String formatDateTime(long l) {
        return dateDF.format(l) + " " + timeWithSecondsDF.format(l);
    }

    static DateFormat getDateTimeFormat(String string) {
        String string2 = Resources.getText(string, new Object[0]);
        int n = -1;
        int n2 = -1;
        if (string2.startsWith("SHORT")) {
            n = 3;
        } else if (string2.startsWith("MEDIUM")) {
            n = 2;
        } else if (string2.startsWith("LONG")) {
            n = 1;
        } else if (string2.startsWith("FULL")) {
            n = 0;
        }
        if (string2.endsWith("SHORT")) {
            n2 = 3;
        } else if (string2.endsWith("MEDIUM")) {
            n2 = 2;
        } else if (string2.endsWith("LONG")) {
            n2 = 1;
        } else if (string2.endsWith("FULL")) {
            n2 = 0;
        }
        if (n != -1 && n2 != -1) {
            return DateFormat.getDateTimeInstance(n, n2);
        }
        if (string2.length() > 0) {
            return new SimpleDateFormat(string2);
        }
        return DateFormat.getDateTimeInstance();
    }

    static double toExcelTime(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(1899, 11, 30);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTimeInMillis(l);
        int n = gregorianCalendar2.get(16);
        if (n > 0) {
            gregorianCalendar.set(16, n);
        }
        long l2 = l - gregorianCalendar.getTimeInMillis();
        double d = (double)l2 / 8.64E7;
        return d;
    }

    static String[] formatKByteStrings(long ... lArray) {
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            if (lArray[i] <= 0L) continue;
            int n2 = i;
            lArray[n2] = lArray[n2] / 1024L;
        }
        String[] stringArray = Formatter.formatLongs(lArray);
        for (int i = 0; i < n; ++i) {
            stringArray[i] = Resources.getText("kbytes", stringArray[i]);
        }
        return stringArray;
    }

    static String formatKBytes(long l) {
        if (l == -1L) {
            return Resources.getText("kbytes", "-1");
        }
        long l2 = l / 1024L;
        return Resources.getText("kbytes", Formatter.justify(l2, 10));
    }

    static String formatBytes(long l, boolean bl) {
        return Formatter.formatBytes(l, l, bl);
    }

    static String formatBytes(long l, long l2) {
        return Formatter.formatBytes(l, l2, false);
    }

    static String formatBytes(long l, long l2, boolean bl) {
        int n = (int)Math.log10(l2);
        String string = n < 3 ? Resources.getText("Size Bytes", l) : (n < 6 ? Resources.getText("Size Kb", Formatter.trimDouble((double)l / Math.pow(10.0, 3.0))) : (n < 9 ? Resources.getText("Size Mb", Formatter.trimDouble((double)l / Math.pow(10.0, 6.0))) : Resources.getText("Size Gb", Formatter.trimDouble((double)l / Math.pow(10.0, 9.0)))));
        if (bl) {
            string = string.replace(" ", "&nbsp;");
        }
        return string;
    }

    private static String trimDouble(double d) {
        String string = String.format("%.1f", d);
        if (string.length() > 3 && string.endsWith(decimalZero)) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    static String formatLong(long l) {
        return String.format("%,d", l);
    }

    static String[] formatLongs(long ... lArray) {
        int n;
        int n2 = lArray.length;
        int n3 = 0;
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = Formatter.formatLong(lArray[n]);
            n3 = Math.max(n3, stringArray[n].length());
        }
        for (n = 0; n < n2; ++n) {
            stringArray[n] = Formatter.justify(stringArray[n], n3);
        }
        return stringArray;
    }

    static String justify(long l, int n) {
        return Formatter.justify(Formatter.formatLong(l), n);
    }

    static String justify(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<TT>");
        int n2 = n - string.length();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append("&nbsp;");
        }
        stringBuffer.append(string);
        stringBuffer.append("</TT>");
        return stringBuffer.toString();
    }

    static String newRow(String string, String string2) {
        return Formatter.newRow(string, string2, 2);
    }

    static String newRow(String string, String string2, int n) {
        string = string == null ? "" : string + ":&nbsp;";
        string = "<th nowrap align=right valign=top>" + string;
        string2 = "<td colspan=" + (n - 1) + "> <font size =-1>" + string2;
        return "<tr>" + string + string2 + "</tr>";
    }

    static String newRow(String string, String string2, String string3, String string4) {
        string = "<th nowrap align=right valign=top>" + string + ":&nbsp;";
        string2 = "<td><font size =-1>" + string2;
        string3 = "<th nowrap align=right valign=top>" + string3 + ":&nbsp;";
        string4 = "<td><font size =-1>" + string4;
        return "<tr>" + string + string2 + string3 + string4 + "</tr>";
    }
}

