/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.xdg;

import com.sun.deploy.association.Association;
import com.sun.deploy.association.AssociationAlreadyRegisteredException;
import com.sun.deploy.association.AssociationNotRegisteredException;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.association.utility.AppAssociationWriter;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.xdg.Associations;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Iterator;

public class XDGAppAssociationWriter
implements AppAssociationWriter {
    public XDGAppAssociationWriter(LocalApplicationProperties localApplicationProperties) {
    }

    public void checkAssociationValidForRegistration(Association association) throws IllegalArgumentException {
        if (association.getName() == null || association.getMimeType() == null) {
            throw new IllegalArgumentException("The given association is invalid. It should specify both the name and mimeType fields to perform this operation.");
        }
    }

    public void checkAssociationValidForUnregistration(Association association) throws IllegalArgumentException {
        if (association.getName() == null) {
            throw new IllegalArgumentException("The given association is invalid. It should specify the name field to perform this operation.");
        }
    }

    public boolean isAssociationExist(Association association, int n) {
        Associations associations = Associations.getInstance();
        return associations.isAssociationExist(association, n);
    }

    public void registerAssociation(Association association, int n) throws AssociationAlreadyRegisteredException, RegisterFailedException {
        Trace.println("XDGAppAssociationWriter.registerAssociation " + association.getMimeType(), TraceLevel.TEMP);
        this.writeMimetype(association, n);
        this.updateMimeDatabase(n);
        this.makeApplicationDefault(association, n);
        this.updateDesktopDatabase(n);
    }

    private void writeMimetype(Association association, int n) throws RegisterFailedException {
        File file = Associations.getMimeTypeFile(association, n);
        Trace.println("XDGAppAssociationWriter.writeMimetype " + file, TraceLevel.TEMP);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write("<?xml version=\"1.0\"?>\n");
            bufferedWriter.write("<mime-info xmlns='http://www.freedesktop.org/standards/shared-mime-info'>\n");
            bufferedWriter.write("<mime-type type=\"" + association.getMimeType() + "\">\n");
            bufferedWriter.write("<comment>" + association.getDescription() + "</comment>\n");
            Iterator iterator = association.getFileExtList().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                bufferedWriter.write("<glob pattern=\"*" + string + "\"/>");
            }
            bufferedWriter.write("\n");
            bufferedWriter.write("</mime-type>\n");
            bufferedWriter.write("</mime-info>\n");
            bufferedWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Trace.ignored(fileNotFoundException);
            throw new RegisterFailedException();
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
            throw new RegisterFailedException();
        }
    }

    private void updateMimeDatabase(int n) throws RegisterFailedException {
        Trace.println("XDGAppAssociationWriter.updateMimeDatabase ", TraceLevel.TEMP);
        try {
            String[] stringArray = Associations.getMimeBasePaths(n);
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = new String[]{"update-mime-database", stringArray[i]};
                Process process = Runtime.getRuntime().exec(stringArray2);
                process.waitFor();
            }
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
            throw new RegisterFailedException();
        }
    }

    private void updateDesktopDatabase(int n) throws RegisterFailedException {
        Trace.println("XDGAppAssociationWriter.updateDesktopDatabase ", TraceLevel.TEMP);
        try {
            String[] stringArray = Associations.getAppBasePaths(n);
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = new String[]{"update-desktop-database", stringArray[i]};
                Process process = Runtime.getRuntime().exec(stringArray2);
                process.waitFor();
            }
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
            throw new RegisterFailedException();
        }
    }

    private void makeApplicationDefault(Association association, int n) throws RegisterFailedException {
        Trace.println("XDGAppAssociationWriter.makeApplicationDefault ", TraceLevel.TEMP);
        try {
            File file = Associations.getDesktopEntryFile(association, n);
            String[] stringArray = new String[]{"xdg-mime", "default", file.getName(), association.getMimeType()};
            Process process = Runtime.getRuntime().exec(stringArray);
            int n2 = process.waitFor();
            if (n2 != 0) {
                Trace.println(" xdg-mime default fails, exitValue == " + n2);
                throw new RegisterFailedException();
            }
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
            throw new RegisterFailedException();
        }
    }

    public void unregisterAssociation(Association association, int n) throws AssociationNotRegisteredException, RegisterFailedException {
        Trace.println("XDGAppAssociationWriter.unregisterAssociation " + association.getMimeType(), TraceLevel.TEMP);
        File file = Associations.getMimeTypeFile(association, n);
        if (!file.exists()) {
            Trace.print("mime-info file doesn't exist, path == " + file.getAbsolutePath(), TraceLevel.TEMP);
        } else {
            file.delete();
        }
        this.updateMimeDatabase(n);
        this.updateDesktopDatabase(n);
    }
}

