/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FilterComponent;
import org.netbeans.lib.profiler.ui.components.HTMLLabel;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.JExtendedTable;
import org.netbeans.lib.profiler.ui.components.JTitledPanel;
import org.netbeans.lib.profiler.ui.components.table.ClassNameTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.DiffBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.ExtendedTableModel;
import org.netbeans.lib.profiler.ui.components.table.JExtendedTablePanel;
import org.netbeans.lib.profiler.ui.components.table.LabelBracketTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.SortableTableModel;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.ClassesListController;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ClassesListControllerUI
extends JTitledPanel {
    private static final String VIEW_TITLE = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ViewTitle");
    private static final String NO_INSTANCES_MSG = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_NoInstancesMsg");
    private static final String NO_CLASS_IN_BASE_MSG = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_NoClassInBaseMsg");
    private static final String FILTER_STARTS_WITH = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_FilterStartsWith");
    private static final String FILTER_CONTAINS = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_FilterContains");
    private static final String FILTER_ENDS_WITH = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_FilterEndsWith");
    private static final String FILTER_REGEXP = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_FilterRegexp");
    private static final String FILTER_IMPLEMENTATION = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_FilterImplementation");
    private static final String FILTER_SUBCLASS = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_FilterSubclass");
    private static final String DEFAULT_FILTER_TEXT = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_DefaultFilterText");
    private static final String SHOW_IN_INSTANCES_STRING = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ShowInInstancesString");
    private static final String SHOW_IMPLEMENTATIONS_STRING = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ShowImplementationsString");
    private static final String SHOW_SUBCLASSES_STRING = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ShowSubclassesString");
    private static final String GO_TO_SOURCE_STRING = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_GoToSourceString");
    private static final String SHOW_HIDE_COLUMNS_STRING = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ShowHideColumnsString");
    private static final String FILTER_CHECKBOX_TEXT = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_FilterCheckboxText");
    private static final String CLASSNAME_COLUMN_TEXT = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ClassNameColumnText");
    private static final String CLASSNAME_COLUMN_DESCR = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ClassNameColumnDescr");
    private static final String INSTANCES_REL_COLUMN_TEXT = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_InstancesRelColumnText");
    private static final String INSTANCES_REL_COLUMN_DESCR = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_InstancesRelColumnDescr");
    private static final String INSTANCES_COLUMN_TEXT = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_InstancesColumnText");
    private static final String INSTANCES_COLUMN_DESCR = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_InstancesColumnDescr");
    private static final String SIZE_COLUMN_TEXT = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_SizeColumnText");
    private static final String SIZE_COLUMN_DESCR = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_SizeColumnDescr");
    private static final String FITERING_PROGRESS_TEXT = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_FilteringProgressText");
    private static final String CLASSES_TABLE_ACCESS_NAME = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ClassesTableAccessName");
    private static final String CLASSES_TABLE_ACCESS_DESCR = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ClassesTableAccessDescr");
    private static final String COMPARE_WITH_ANOTHER_TEXT = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_CompareWithAnotherText");
    private static final String COMPARING_MSG = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ComparingMsg");
    private static Icon ICON_CLASSES = Icons.getIcon((String)"HeapWalkerIcons.Classes");
    private static String filterValue = "";
    private static int filterType = 20;
    private static final String DATA = "Data";
    private static final String NO_DATA = "No data";
    private CardLayout contents;
    private ClassesListController classesListController;
    private ClassesListTableModel realClassesListTableModel = new ClassesListTableModel();
    private ExtendedTableModel classesListTableModel = new ExtendedTableModel((SortableTableModel)this.realClassesListTableModel);
    private FilterComponent filterComponent;
    private JExtendedTable classesListTable;
    private JPanel contentsPanel;
    private JPopupMenu cornerPopup;
    private JPopupMenu tablePopup;
    private String selectedRowContents;
    private TableCellRenderer[] columnRenderers;
    private int[] columnWidths;
    private boolean hasProjectContext;
    private boolean internalCornerButtonClick = false;
    private boolean selectionSaved = false;
    private boolean showZeroInstances = true;
    private boolean showZeroSize = true;
    private boolean isDiff = false;
    private HTMLLabel l;
    private JLabel w;
    private JProgressBar p;

    public ClassesListControllerUI(final ClassesListController classesListController) {
        super(VIEW_TITLE, ICON_CLASSES, true);
        this.classesListController = classesListController;
        this.hasProjectContext = classesListController.getClassesController().getHeapFragmentWalker().getHeapDumpProject() != null;
        this.classesListTableModel.setInitialSorting(this.realClassesListTableModel.getSortingColumn(), this.realClassesListTableModel.getSortingOrder());
        this.initColumnsData();
        this.initComponents();
        this.realClassesListTableModel.addPropertyChangeListener("selectedRow", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                if (n != -1) {
                    ClassesListControllerUI.this.classesListTable.setRowSelectionInterval(n, n);
                    ClassesListControllerUI.this.classesListTable.ensureRowVisible(n);
                    classesListController.classSelected(ClassesListControllerUI.this.realClassesListTableModel.getSelectedClass());
                } else {
                    ClassesListControllerUI.this.classesListTable.clearSelection();
                    classesListController.classSelected(null);
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClassesListControllerUI.this.adjustRenderers();
                ClassesListControllerUI.this.restoreSelection();
                if (ClassesListControllerUI.this.contents != null) {
                    ClassesListControllerUI.this.contents.show(ClassesListControllerUI.this.contentsPanel, ClassesListControllerUI.DATA);
                }
            }
        });
    }

    public void setColumnVisibility(int n, boolean bl) {
        boolean bl2 = this.classesListTableModel.isRealColumnVisible(n);
        if (bl2 == bl) {
            return;
        }
        this.saveSelection();
        boolean bl3 = false;
        int n2 = this.classesListTableModel.getSortingColumn();
        int n3 = this.classesListTableModel.getRealColumn(n2);
        if (bl2 && n == n3) {
            n2 = n2 + 1 == this.classesListTableModel.getColumnCount() ? n2 - 1 : n2 + 1;
            n3 = this.classesListTableModel.getRealColumn(n2);
            bl3 = true;
        }
        this.classesListTableModel.setRealColumnVisibility(n, bl);
        this.classesListTable.createDefaultColumnsFromModel();
        this.classesListTableModel.setTable((JTable)this.classesListTable);
        n2 = this.classesListTableModel.getVirtualColumn(n3);
        if (bl3) {
            this.realClassesListTableModel.resetDisplayCache();
        }
        this.classesListTableModel.setInitialSorting(n2, this.classesListTableModel.getSortingOrder());
        this.classesListTable.getTableHeader().repaint();
        this.setColumnsData(true);
        this.restoreSelection();
    }

    public void ensureWillBeVisible(JavaClass javaClass) {
        if (ClassesListController.matchesFilter(javaClass, FilterComponent.getFilterStrings((String)filterValue), filterType, this.showZeroInstances, this.showZeroSize)) {
            return;
        }
        this.filterComponent.setFilterString("");
    }

    public void selectClass(JavaClass javaClass) {
        this.realClassesListTableModel.setSelectedClass(javaClass);
    }

    public void updateData() {
        this.updateTableRenderers();
        this.realClassesListTableModel.resetDisplayCache();
    }

    protected void initColumnSelectorItems() {
        this.cornerPopup.removeAll();
        for (int i = 0; i < this.realClassesListTableModel.getColumnCount(); ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.realClassesListTableModel.getColumnName(i));
            jCheckBoxMenuItem.setActionCommand(Integer.valueOf(i).toString());
            this.addMenuItemListener(jCheckBoxMenuItem);
            if (this.classesListTable != null) {
                jCheckBoxMenuItem.setState(this.classesListTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    jCheckBoxMenuItem.setEnabled(false);
                }
            } else {
                jCheckBoxMenuItem.setState(true);
            }
            this.cornerPopup.add(jCheckBoxMenuItem);
        }
        this.cornerPopup.addSeparator();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(FILTER_CHECKBOX_TEXT);
        jCheckBoxMenuItem.setActionCommand("Filter");
        this.addMenuItemListener(jCheckBoxMenuItem);
        if (this.filterComponent == null) {
            jCheckBoxMenuItem.setState(true);
        } else {
            jCheckBoxMenuItem.setState(this.filterComponent.isVisible());
        }
        this.cornerPopup.add(jCheckBoxMenuItem);
        this.cornerPopup.pack();
    }

    protected void saveColumnsData() {
        TableColumnModel tableColumnModel = this.classesListTable.getColumnModel();
        for (int i = 0; i < this.classesListTableModel.getColumnCount(); ++i) {
            int n = this.classesListTableModel.getRealColumn(i);
            if (n == 0) continue;
            this.columnWidths[n - 1] = tableColumnModel.getColumn(i).getPreferredWidth();
        }
    }

    private void setColumnsData(boolean bl) {
        TableColumnModel tableColumnModel = this.classesListTable.getColumnModel();
        for (int i = 0; i < this.classesListTableModel.getColumnCount(); ++i) {
            int n = this.classesListTableModel.getRealColumn(i);
            if (bl && n != 0) {
                tableColumnModel.getColumn(i).setPreferredWidth(this.columnWidths[n - 1]);
            }
            tableColumnModel.getColumn(i).setCellRenderer(this.columnRenderers[n]);
        }
    }

    private void addMenuItemListener(JCheckBoxMenuItem jCheckBoxMenuItem) {
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("Filter")) {
                    ClassesListControllerUI.this.filterComponent.setVisible(!ClassesListControllerUI.this.filterComponent.isVisible());
                    return;
                }
                int n = Integer.parseInt(actionEvent.getActionCommand());
                ClassesListControllerUI.this.setColumnVisibility(n, !ClassesListControllerUI.this.classesListTableModel.isRealColumnVisible(n));
            }
        });
    }

    private JButton createHeaderPopupCornerButton(final JPopupMenu jPopupMenu) {
        final JButton jButton = new JButton(Icons.getIcon((String)"GeneralIcons.HideColumn"));
        jButton.setToolTipText(SHOW_HIDE_COLUMNS_STRING);
        jButton.setDefaultCapable(false);
        if (UIUtils.isWindowsClassicLookAndFeel()) {
            jButton.setMargin(new Insets(0, 0, 2, 2));
        } else if (UIUtils.isWindowsXPLookAndFeel()) {
            jButton.setMargin(new Insets(0, 0, 0, 1));
        } else if (UIUtils.isMetalLookAndFeel()) {
            jButton.setMargin(new Insets(0, 0, 2, 1));
        }
        jButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    ClassesListControllerUI.this.showColumnSelectionPopup(jPopupMenu, jButton);
                }
            }
        });
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (jPopupMenu.isVisible()) {
                    ClassesListControllerUI.this.internalCornerButtonClick = true;
                    jButton.getModel().setArmed(false);
                } else {
                    ClassesListControllerUI.this.internalCornerButtonClick = false;
                    if (mouseEvent.getModifiers() == 4) {
                        ClassesListControllerUI.this.showColumnSelectionPopup(jPopupMenu, jButton);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() == 16 && !ClassesListControllerUI.this.internalCornerButtonClick) {
                    ClassesListControllerUI.this.showColumnSelectionPopup(jPopupMenu, jButton);
                }
            }
        });
        return jButton;
    }

    private JPopupMenu createTablePopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(SHOW_IN_INSTANCES_STRING);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassesListControllerUI.this.performDefaultAction();
            }
        });
        jMenuItem.setFont(jPopupMenu.getFont().deriveFont(1));
        JMenuItem jMenuItem2 = new JMenuItem(this.hasProjectContext ? SHOW_IMPLEMENTATIONS_STRING : SHOW_SUBCLASSES_STRING);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ClassesListControllerUI.this.classesListTable.getSelectedRow();
                if (n != -1) {
                    ClassesListControllerUI.this.showSubclassesForClass(ClassesListControllerUI.this.realClassesListTableModel.getSelectedClass());
                }
            }
        });
        JMenuItem jMenuItem3 = null;
        if (GoToSource.isAvailable()) {
            jMenuItem3 = new JMenuItem(GO_TO_SOURCE_STRING);
            jMenuItem3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ClassesListControllerUI.this.classesListTable.getSelectedRow();
                    if (n != -1) {
                        String string = ClassesListControllerUI.this.realClassesListTableModel.getSelectedClassName();
                        while (string.endsWith("[]")) {
                            string = string.substring(0, string.length() - 2);
                        }
                        Lookup.Provider provider = ClassesListControllerUI.this.classesListController.getClassesController().getHeapFragmentWalker().getHeapDumpProject();
                        GoToSource.openSource((Lookup.Provider)provider, (String)string, null, null);
                    }
                }
            });
        }
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        if (jMenuItem3 != null) {
            jPopupMenu.addSeparator();
            jPopupMenu.add(jMenuItem3);
        }
        return jPopupMenu;
    }

    private void initColumnsData() {
        int n = this.classesListTableModel.getColumnCount();
        this.columnWidths = new int[n - 1];
        this.columnRenderers = new TableCellRenderer[n];
        int n2 = this.getFontMetrics(this.getFont()).charWidth('W') * 12;
        ClassNameTableCellRenderer classNameTableCellRenderer = new ClassNameTableCellRenderer();
        CustomBarCellRenderer customBarCellRenderer = new CustomBarCellRenderer(0L, 100L);
        LabelBracketTableCellRenderer labelBracketTableCellRenderer = new LabelBracketTableCellRenderer(11);
        this.columnRenderers[0] = classNameTableCellRenderer;
        this.columnWidths[0] = n2;
        this.columnRenderers[1] = customBarCellRenderer;
        this.columnWidths[1] = n2;
        this.columnRenderers[2] = labelBracketTableCellRenderer;
        this.columnWidths[2] = n2;
        this.columnRenderers[3] = labelBracketTableCellRenderer;
    }

    protected Component[] getAdditionalControls() {
        if (this.l == null) {
            this.l = new HTMLLabel(){

                protected void showURL(URL uRL) {
                    if (ClassesListControllerUI.this.classesListController.isDiff()) {
                        ClassesListControllerUI.this.classesListController.resetDiffAction();
                    } else {
                        ClassesListControllerUI.this.classesListController.compareAction();
                    }
                }
            };
            this.l.setBorder(BorderFactory.createEmptyBorder());
            this.l.setFont(UIManager.getFont("ToolTip.font"));
            this.l.setText("<nobr><a href='#'>" + COMPARE_WITH_ANOTHER_TEXT + "</a></nobr>");
        }
        if (this.w == null) {
            this.w = new JLabel(COMPARING_MSG);
            this.w.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.w.setFont(UIManager.getFont("ToolTip.font"));
        }
        if (this.p == null) {
            this.p = new JProgressBar(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension dimension = ClassesListControllerUI.this.l.getPreferredSize();
                    dimension.width = 130;
                    return dimension;
                }

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
            this.p.setIndeterminate(true);
        }
        JPanel jPanel = new JPanel(null);
        jPanel.setOpaque(false);
        jPanel.setPreferredSize(new Dimension(5, 5));
        jPanel.setMinimumSize(jPanel.getPreferredSize());
        this.w.setVisible(false);
        this.p.setVisible(false);
        this.l.setVisible(true);
        return new Component[]{this.w, this.p, this.l, jPanel};
    }

    public void showDiffProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClassesListControllerUI.this.w.setVisible(true);
                ClassesListControllerUI.this.p.setVisible(true);
                ClassesListControllerUI.this.l.setVisible(false);
            }
        });
    }

    public void hideDiffProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClassesListControllerUI.this.w.setVisible(false);
                ClassesListControllerUI.this.p.setVisible(false);
                if (ClassesListControllerUI.this.classesListController.isDiff()) {
                    ClassesListControllerUI.this.l.setText("<nobr>" + NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ShowingDiffText", (Object)"<a href='#'>", (Object)"</a>") + "</nobr>");
                } else {
                    ClassesListControllerUI.this.l.setText("<nobr><a href='#'>" + COMPARE_WITH_ANOTHER_TEXT + "</a></nobr>");
                }
                ClassesListControllerUI.this.l.setVisible(true);
            }
        });
    }

    private void initComponents() {
        this.classesListTable = new JExtendedTable((TableModel)this.classesListTableModel){

            public void doLayout() {
                int n = 0;
                int n2 = -1;
                TableColumnModel tableColumnModel = this.getColumnModel();
                for (int i = 0; i < ClassesListControllerUI.this.classesListTableModel.getColumnCount(); ++i) {
                    if (ClassesListControllerUI.this.classesListTableModel.getRealColumn(i) == 0) {
                        n2 = i;
                        continue;
                    }
                    n += tableColumnModel.getColumn(i).getPreferredWidth();
                }
                if (n2 != -1) {
                    tableColumnModel.getColumn(n2).setPreferredWidth(this.getWidth() - n);
                }
                super.doLayout();
            }
        };
        this.classesListTable.setSelectionMode(0);
        this.classesListTable.addMouseListener((MouseListener)new ClassesListTableMouseListener());
        this.classesListTable.addKeyListener((KeyListener)new ClassesListTableKeyListener());
        this.classesListTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.classesListTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.classesListTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.classesListTable.setShowHorizontalLines(false);
        this.classesListTable.setShowVerticalLines(true);
        this.classesListTable.setRowMargin(0);
        this.classesListTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.classesListTableModel.setTable((JTable)this.classesListTable);
        this.classesListTable.getColumnModel().getColumn(0).setMinWidth(150);
        this.classesListTable.getAccessibleContext().setAccessibleName(CLASSES_TABLE_ACCESS_NAME);
        this.classesListTable.getAccessibleContext().setAccessibleDescription(CLASSES_TABLE_ACCESS_DESCR);
        this.classesListTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.classesListTable.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassesListControllerUI.this.performDefaultAction();
            }
        });
        HashSet<KeyStroke> hashSet = new HashSet<KeyStroke>(this.classesListTable.getFocusTraversalKeys(0));
        hashSet.add(KeyStroke.getKeyStroke(9, 0));
        this.classesListTable.setFocusTraversalKeys(0, hashSet);
        hashSet = new HashSet(this.classesListTable.getFocusTraversalKeys(1));
        hashSet.add(KeyStroke.getKeyStroke(9, 1));
        this.classesListTable.setFocusTraversalKeys(1, hashSet);
        this.setColumnsData(true);
        this.filterComponent = new FilterComponent();
        this.filterComponent.addFilterItem(Icons.getImageIcon((String)"GeneralIcons.FilterStartsWith"), FILTER_STARTS_WITH, 10);
        this.filterComponent.addFilterItem(Icons.getImageIcon((String)"GeneralIcons.FilterContains"), FILTER_CONTAINS, 20);
        this.filterComponent.addFilterItem(Icons.getImageIcon((String)"GeneralIcons.FilterEndsWith"), FILTER_ENDS_WITH, 30);
        this.filterComponent.addFilterItem(Icons.getImageIcon((String)"GeneralIcons.FilterRegExp"), FILTER_REGEXP, 50);
        this.filterComponent.addFilterItem(Icons.getImageIcon((String)"LanguageIcons.Class"), this.hasProjectContext ? FILTER_IMPLEMENTATION : FILTER_SUBCLASS, 1001);
        this.filterComponent.setEmptyFilterText(DEFAULT_FILTER_TEXT);
        this.filterComponent.setFilterValues(filterValue, filterType);
        this.filterComponent.addFilterListener(new FilterComponent.FilterListener(){

            public void filterChanged() {
                JavaClass javaClass = ClassesListControllerUI.this.realClassesListTableModel.getSelectedClass();
                filterValue = ClassesListControllerUI.this.filterComponent.getFilterString();
                filterType = ClassesListControllerUI.this.filterComponent.getFilterType();
                ClassesListControllerUI.this.realClassesListTableModel.resetDisplayCache();
                ClassesListControllerUI.this.realClassesListTableModel.preselect(javaClass);
                ClassesListControllerUI.this.classesListTableModel.fireTableDataChanged();
            }
        });
        this.tablePopup = this.createTablePopup();
        this.cornerPopup = new JPopupMenu();
        JExtendedTablePanel jExtendedTablePanel = new JExtendedTablePanel(this.classesListTable);
        jExtendedTablePanel.setCorner("UPPER_RIGHT_CORNER", (Component)this.createHeaderPopupCornerButton(this.cornerPopup));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        HTMLTextArea hTMLTextArea = new HTMLTextArea();
        hTMLTextArea.setBorder(BorderFactory.createEmptyBorder(10, 8, 8, 8));
        String string = Icons.getResource((String)"HeapWalkerIcons.Progress");
        String string2 = "<img border='0' align='bottom' src='nbresloc:/" + string + "'>&nbsp;&nbsp;" + FITERING_PROGRESS_TEXT;
        hTMLTextArea.setText(string2);
        jPanel.add((Component)hTMLTextArea, "Center");
        this.contents = new CardLayout();
        this.contentsPanel = new JPanel(this.contents);
        this.contentsPanel.add((Component)jExtendedTablePanel, DATA);
        this.contentsPanel.add((Component)jPanel, NO_DATA);
        this.contents.show(this.contentsPanel, NO_DATA);
        this.add(this.contentsPanel, "Center");
        this.add((Component)this.filterComponent, "South");
        this.classesListTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ClassesListControllerUI.this.restoreSelection();
            }
        });
    }

    private void performDefaultAction() {
        int n = this.classesListTable.getSelectedRow();
        if (n != -1) {
            this.showInstancesForClass(this.realClassesListTableModel.getSelectedClass());
        }
    }

    private void restoreSelection() {
        if (this.selectedRowContents != null) {
            this.classesListTable.selectRowByContents(this.selectedRowContents, 0, true);
            this.selectedRowContents = null;
        }
        this.selectionSaved = false;
    }

    private void saveSelection() {
        if (this.selectionSaved) {
            return;
        }
        this.selectedRowContents = this.realClassesListTableModel.getSelectedClassName();
        this.selectionSaved = true;
    }

    private void showColumnSelectionPopup(JPopupMenu jPopupMenu, JButton jButton) {
        this.initColumnSelectorItems();
        jPopupMenu.show(jButton, jButton.getWidth() - jPopupMenu.getPreferredSize().width, jButton.getHeight());
    }

    private void showInstancesForClass(JavaClass javaClass) {
        if (this.classesListController.isDiff() && javaClass == null) {
            ProfilerDialogs.displayInfo((String)NO_CLASS_IN_BASE_MSG);
        } else if (javaClass.getInstancesCount() == 0) {
            ProfilerDialogs.displayInfo((String)MessageFormat.format(NO_INSTANCES_MSG, javaClass.getName()));
        } else {
            this.classesListController.getClassesController().getHeapFragmentWalker().showInstancesForClass(javaClass);
        }
    }

    private void showSubclassesForClass(JavaClass javaClass) {
        this.saveSelection();
        this.filterComponent.setFilterValues(javaClass.getName(), 1001);
    }

    private void adjustRenderers() {
        if (this.isDiff != this.classesListController.isDiff()) {
            this.isDiff = !this.isDiff;
            DiffBarCellRenderer diffBarCellRenderer = this.isDiff ? new DiffBarCellRenderer(this.classesListController.minDiff, this.classesListController.maxDiff) : new CustomBarCellRenderer(0L, 100L);
            this.columnRenderers[1] = diffBarCellRenderer;
            LabelTableCellRenderer labelTableCellRenderer = this.isDiff ? new LabelTableCellRenderer(11) : new LabelBracketTableCellRenderer(11);
            this.columnRenderers[2] = labelTableCellRenderer;
            this.columnRenderers[3] = labelTableCellRenderer;
            this.setColumnsData(false);
        }
        this.classesListTableModel.fireTableDataChanged();
    }

    private void updateTableRenderers() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClassesListControllerUI.this.adjustRenderers();
            }
        });
    }

    private class ClassesListTableMouseListener
    extends MouseAdapter {
        private final AtomicBoolean handled = new AtomicBoolean();

        private ClassesListTableMouseListener() {
        }

        private void updateSelection(int n, boolean bl) {
            int n2;
            if (bl && (n2 = ClassesListControllerUI.this.realClassesListTableModel.getSelectedRow()) == n) {
                ClassesListControllerUI.this.realClassesListTableModel.setSelectedRow(-1);
                return;
            }
            ClassesListControllerUI.this.realClassesListTableModel.setSelectedRow(n);
        }

        private boolean isToggle(MouseEvent mouseEvent) {
            return (mouseEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) > 0;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.handled.set(true);
                int n = ClassesListControllerUI.this.classesListTable.rowAtPoint(mouseEvent.getPoint());
                this.updateSelection(n, this.isToggle(mouseEvent));
                ClassesListControllerUI.this.tablePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.handled.compareAndSet(false, true)) {
                int n = ClassesListControllerUI.this.classesListTable.rowAtPoint(mouseEvent.getPoint());
                this.updateSelection(n, this.isToggle(mouseEvent));
                if (mouseEvent.isPopupTrigger()) {
                    ClassesListControllerUI.this.tablePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
                this.handled.set(false);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && (n = ClassesListControllerUI.this.classesListTable.rowAtPoint(mouseEvent.getPoint())) != -1) {
                ClassesListControllerUI.this.showInstancesForClass(ClassesListControllerUI.this.realClassesListTableModel.getClassForRow(n));
            }
        }
    }

    private class ClassesListTableModel
    extends SortableTableModel {
        static final String SELECTED_ROW_PROPERTY = "selectedRow";
        private final Object displayCacheLock = new Object();
        private final Object sortingLock = new Object();
        private Object[][] displayCache = null;
        private int sortingColumn = 1;
        private boolean sortingOrder = false;
        private int selectedRow = -1;
        private static final int columnCount = 4;
        private final String[] columnNames;
        private final String[] columnToolTips;
        private JavaClass preselectedClass = null;
        final PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);

        public ClassesListTableModel() {
            this.columnNames = new String[4];
            this.columnToolTips = new String[4];
            this.columnNames[0] = CLASSNAME_COLUMN_TEXT;
            this.columnToolTips[0] = CLASSNAME_COLUMN_DESCR;
            this.columnNames[1] = INSTANCES_REL_COLUMN_TEXT;
            this.columnToolTips[1] = INSTANCES_REL_COLUMN_DESCR;
            this.columnNames[2] = INSTANCES_COLUMN_TEXT;
            this.columnToolTips[2] = INSTANCES_COLUMN_DESCR;
            this.columnNames[3] = SIZE_COLUMN_TEXT;
            this.columnToolTips[3] = SIZE_COLUMN_DESCR;
        }

        public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(string, propertyChangeListener);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }

        public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(string, propertyChangeListener);
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return Object.class;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public String getColumnToolTipText(int n) {
            return this.columnToolTips[n];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getSortingColumn() {
            Object object = this.sortingLock;
            synchronized (object) {
                return this.sortingColumn;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getSortingOrder() {
            Object object = this.sortingLock;
            synchronized (object) {
                return this.sortingOrder;
            }
        }

        public boolean getInitialSorting(int n) {
            switch (n) {
                case 0: {
                    return true;
                }
            }
            return false;
        }

        public int getRowCount() {
            return this.getDisplayCache().length;
        }

        public Object getValueAt(int n, int n2) {
            return this.getDisplayCache()[n][n2];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sortByColumn(int n, boolean bl) {
            Object object = this.sortingLock;
            synchronized (object) {
                this.sortingColumn = n;
                this.sortingOrder = bl;
            }
            this.resetDisplayCache();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClassesListControllerUI.this.repaint();
                }
            });
        }

        public JavaClass getClassForRow(int n) {
            return n == -1 ? null : (JavaClass)this.getDisplayCache()[n][4];
        }

        public JavaClass getSelectedClass() {
            return this.getClassForRow(this.getSelectedRow());
        }

        public String getSelectedClassName() {
            return this.selectedRow == -1 ? null : (String)this.getDisplayCache()[this.selectedRow][0];
        }

        public void setSelectedClass(JavaClass javaClass) {
            if (javaClass != null) {
                Object[][] objectArray = this.getDisplayCache();
                int n = 0;
                for (Object[] objectArray2 : objectArray) {
                    if (objectArray2[4].equals(javaClass)) {
                        this.setSelectedRow(n);
                        break;
                    }
                    ++n;
                }
            } else {
                this.setSelectedRow(-1);
            }
        }

        public void preselect(JavaClass javaClass) {
            this.preselectedClass = javaClass;
        }

        private void setSelectedRow(int n) {
            int n2 = this.selectedRow;
            this.selectedRow = n;
            this.pcs.firePropertyChange(SELECTED_ROW_PROPERTY, n2, this.selectedRow);
        }

        private int getSelectedRow() {
            return this.selectedRow;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object[][] getDisplayCache() {
            Object object = this.displayCacheLock;
            synchronized (object) {
                if (this.displayCache == null) {
                    final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (ClassesListControllerUI.this.contents != null && atomicBoolean.get()) {
                                        ClassesListControllerUI.this.contents.show(ClassesListControllerUI.this.contentsPanel, ClassesListControllerUI.NO_DATA);
                                    }
                                }
                            });
                        }
                    }, 100);
                    this.displayCache = ClassesListControllerUI.this.classesListController.getData(FilterComponent.getFilterStrings((String)filterValue), filterType, ClassesListControllerUI.this.showZeroInstances, ClassesListControllerUI.this.showZeroSize, this.sortingColumn, this.sortingOrder, 4);
                    atomicBoolean.set(false);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (ClassesListTableModel.this.preselectedClass != null) {
                                ClassesListTableModel.this.setSelectedClass(ClassesListTableModel.this.preselectedClass);
                                ClassesListTableModel.this.preselectedClass = null;
                            }
                        }
                    });
                }
                return this.displayCache;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetDisplayCache() {
            Object object = this.displayCacheLock;
            synchronized (object) {
                this.displayCache = null;
                this.setSelectedRow(-1);
            }
        }
    }

    private class ClassesListTableKeyListener
    extends KeyAdapter {
        private ClassesListTableKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n;
            if ((keyEvent.getKeyCode() == 525 || keyEvent.getKeyCode() == 121 && keyEvent.getModifiers() == 1) && (n = ClassesListControllerUI.this.classesListTable.getSelectedRow()) != -1) {
                Rectangle rectangle = ClassesListControllerUI.this.classesListTable.getCellRect(n, 0, true);
                ClassesListControllerUI.this.tablePopup.show((Component)ClassesListControllerUI.this.classesListTable, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            }
        }
    }
}

