/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.javafx.geom.Rectangle;
import com.sun.prism.GraphicsResource;
import com.sun.prism.Presentable;
import com.sun.prism.RTTexture;
import com.sun.prism.es2.ES2Context;
import com.sun.prism.es2.ES2Graphics;
import com.sun.prism.es2.GLContext;
import com.sun.prism.es2.GLDrawable;
import com.sun.prism.impl.PrismSettings;

class ES2SwapChain
implements Presentable,
GraphicsResource {
    private final ES2Context context;
    private final View view;
    private GLDrawable drawable;
    private boolean needsResize;
    private boolean opaque = false;
    private int w;
    private int h;
    long nativeDestHandle = 0L;
    private RTTexture stableBackbuffer;
    private boolean copyFullBuffer;

    @Override
    public boolean recreateOnResize() {
        return false;
    }

    @Override
    public boolean isOpaque() {
        if (this.stableBackbuffer != null) {
            return this.stableBackbuffer.isOpaque();
        }
        return this.opaque;
    }

    @Override
    public void setOpaque(boolean bl) {
        if (this.stableBackbuffer != null) {
            this.stableBackbuffer.setOpaque(bl);
        } else {
            this.opaque = bl;
        }
    }

    void setNeedsResize(boolean bl) {
        this.needsResize = bl;
    }

    ES2SwapChain(ES2Context eS2Context, View view) {
        this.context = eS2Context;
        this.view = view;
    }

    @Override
    public boolean prepare(Rectangle rectangle) {
        try {
            ES2Graphics eS2Graphics = ES2Graphics.create(this.context, this);
            if (this.stableBackbuffer != null) {
                if (this.needsResize) {
                    eS2Graphics.forceRenderTarget();
                    this.needsResize = false;
                }
                if (rectangle == null || this.copyFullBuffer) {
                    this.w = this.getPhysicalWidth();
                    this.h = this.getPhysicalHeight();
                    eS2Graphics.copyTexture(this.stableBackbuffer, 0.0f, 0.0f, this.w, this.h, 0.0f, 0.0f, this.w, this.h);
                    this.copyFullBuffer = false;
                } else {
                    eS2Graphics.copyTexture(this.stableBackbuffer, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                }
            }
            this.context.getVertexBuffer().flush();
            this.drawable = this.context.getCurrentRenderingContext().getDrawable();
            return this.drawable != null;
        }
        catch (Throwable throwable) {
            if (PrismSettings.verbose) {
                throwable.printStackTrace();
            }
            return false;
        }
    }

    @Override
    public boolean present() {
        this.drawable.swapBuffers(this.context.getGLContext());
        return true;
    }

    @Override
    public ES2Graphics createGraphics() {
        GLContext gLContext = this.context.getGLContext();
        this.nativeDestHandle = gLContext.getBoundFBO();
        boolean bl = this.needsResize = this.w != this.getPhysicalWidth() || this.h != this.getPhysicalHeight();
        if (this.stableBackbuffer == null || this.needsResize) {
            if (this.stableBackbuffer != null) {
                this.stableBackbuffer.dispose();
                this.stableBackbuffer = null;
            } else {
                ES2Graphics.create(this.context, this);
            }
            this.w = this.getPhysicalWidth();
            this.h = this.getPhysicalHeight();
            this.stableBackbuffer = this.context.getResourceFactory().createRTTexture(this.w, this.h);
            this.copyFullBuffer = true;
        }
        return ES2Graphics.create(this.context, this.stableBackbuffer);
    }

    @Override
    public long getNativeDestHandle() {
        return this.nativeDestHandle;
    }

    @Override
    public Screen getAssociatedScreen() {
        return this.context.getAssociatedScreen();
    }

    @Override
    public int getPhysicalWidth() {
        return this.view.getWidth();
    }

    @Override
    public int getPhysicalHeight() {
        return this.view.getHeight();
    }

    @Override
    public int getContentX() {
        return 0;
    }

    @Override
    public int getContentY() {
        return 0;
    }

    @Override
    public int getContentWidth() {
        return this.view.getWidth();
    }

    @Override
    public int getContentHeight() {
        return this.view.getHeight();
    }

    @Override
    public void dispose() {
        if (this.stableBackbuffer != null) {
            this.stableBackbuffer.dispose();
            this.stableBackbuffer = null;
        }
    }
}

