/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.FocusableTextField;
import com.sun.javafx.scene.control.WeakListChangeListener;
import com.sun.javafx.scene.control.behavior.ComboBoxListViewBehavior;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl;
import com.sun.javafx.scene.control.skin.ListViewSkin;
import com.sun.javafx.scene.control.skin.VirtualContainerBase;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Control;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class ComboBoxListViewSkin<T>
extends ComboBoxPopupControl<T> {
    private static final String COMBO_BOX_ROWS_TO_MEASURE_WIDTH_KEY = "comboBoxRowsToMeasureWidth";
    private final ComboBox<T> comboBox;
    private ListCell<T> buttonCell;
    private Callback<ListView<T>, ListCell<T>> cellFactory;
    private TextField textField;
    private final ListView<T> listView;
    private ObservableList<T> listViewItems;
    private boolean listSelectionLock = false;
    private boolean listViewSelectionDirty = false;
    private boolean itemCountDirty;
    private final ListChangeListener listViewItemsListener = new ListChangeListener(){

        public void onChanged(ListChangeListener.Change change) {
            ComboBoxListViewSkin.this.itemCountDirty = true;
            ComboBoxListViewSkin.this.requestLayout();
        }
    };
    private final WeakListChangeListener weakListViewItemsListener = new WeakListChangeListener(this.listViewItemsListener);

    public ComboBoxListViewSkin(final ComboBox<T> comboBox) {
        super(comboBox, new ComboBoxListViewBehavior<T>(comboBox));
        this.comboBox = comboBox;
        this.listView = this.createListView();
        this.textField = this.getEditableInputNode();
        this.listView.setManaged(false);
        this.getChildren().add(this.listView);
        this.updateListViewItems();
        this.updateCellFactory();
        this.updateButtonCell();
        comboBox.focusedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                ComboBoxListViewSkin.this.updateFakeFocus(comboBox.isFocused());
            }
        });
        comboBox.addEventFilter(InputEvent.ANY, new EventHandler<InputEvent>(){

            @Override
            public void handle(InputEvent inputEvent) {
                if (ComboBoxListViewSkin.this.textField == null) {
                    return;
                }
                if (inputEvent instanceof KeyEvent) {
                    KeyEvent keyEvent = (KeyEvent)inputEvent;
                    if (keyEvent.getCode() == KeyCode.ENTER) {
                        ComboBoxListViewSkin.this.setTextFromTextFieldIntoComboBoxValue();
                        inputEvent.consume();
                        return;
                    }
                    if (keyEvent.getCode() == KeyCode.F4 && keyEvent.getEventType() == KeyEvent.KEY_RELEASED) {
                        if (comboBox.isShowing()) {
                            comboBox.hide();
                        } else {
                            comboBox.show();
                        }
                        inputEvent.consume();
                        return;
                    }
                    if (keyEvent.getCode() == KeyCode.F10 || keyEvent.getCode() == KeyCode.ESCAPE) {
                        inputEvent.consume();
                        return;
                    }
                }
                ComboBoxListViewSkin.this.textField.fireEvent(inputEvent);
            }
        });
        this.updateValue();
        this.registerChangeListener(comboBox.itemsProperty(), "ITEMS");
        this.registerChangeListener(comboBox.promptTextProperty(), "PROMPT_TEXT");
        this.registerChangeListener(comboBox.cellFactoryProperty(), "CELL_FACTORY");
        this.registerChangeListener(comboBox.visibleRowCountProperty(), "VISIBLE_ROW_COUNT");
        this.registerChangeListener(comboBox.converterProperty(), "CONVERTER");
        this.registerChangeListener(comboBox.editorProperty(), "EDITOR");
        this.registerChangeListener(comboBox.buttonCellProperty(), "BUTTON_CELL");
        this.registerChangeListener(comboBox.valueProperty(), "VALUE");
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        if (string == "SHOWING") {
            if (((ComboBoxBase)this.getSkinnable()).isShowing()) {
                this.listView.setManaged(true);
            } else {
                this.listView.setManaged(false);
            }
        }
        super.handleControlPropertyChanged(string);
        if (string == "ITEMS") {
            this.updateListViewItems();
        } else if ("PROMPT_TEXT".equals(string)) {
            this.updateDisplayNode();
        } else if ("CELL_FACTORY".equals(string)) {
            this.updateCellFactory();
        } else if ("VISIBLE_ROW_COUNT".equals(string)) {
            if (this.listView == null) {
                return;
            }
            this.listView.setPrefHeight(this.getListViewPrefHeight());
        } else if ("CONVERTER".equals(string)) {
            this.updateListViewItems();
        } else if ("EDITOR".equals(string)) {
            this.getEditableInputNode();
        } else if ("BUTTON_CELL".equals(string)) {
            this.updateButtonCell();
        } else if ("VALUE".equals(string)) {
            this.updateValue();
        }
    }

    @Override
    public Node getDisplayNode() {
        Control control = this.comboBox.isEditable() ? this.textField : this.buttonCell;
        this.updateDisplayNode();
        return control;
    }

    public void updateListViewItems() {
        if (this.listViewItems != null) {
            this.listViewItems.removeListener(this.weakListViewItemsListener);
        }
        this.listViewItems = this.comboBox.getItems();
        this.listView.setItems(null);
        this.listView.setItems(this.listViewItems);
        if (this.listViewItems != null) {
            this.listViewItems.addListener(this.weakListViewItemsListener);
        }
        this.itemCountDirty = true;
        this.requestLayout();
    }

    @Override
    public Node getPopupContent() {
        return this.listView;
    }

    @Override
    protected double computePrefWidth(double d) {
        double d2 = this.listView.prefWidth(d);
        this.reconfigurePopup();
        return d2;
    }

    @Override
    protected double computeMinWidth(double d) {
        return 50.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void layoutChildren() {
        if (this.listViewSelectionDirty) {
            try {
                this.listSelectionLock = true;
                Object t = this.comboBox.getSelectionModel().getSelectedItem();
                this.listView.getSelectionModel().clearSelection();
                this.listView.getSelectionModel().select(t);
            }
            finally {
                this.listSelectionLock = false;
                this.listViewSelectionDirty = false;
            }
        }
        super.layoutChildren();
    }

    private void updateValue() {
        Object t = this.comboBox.getValue();
        MultipleSelectionModel multipleSelectionModel = this.listView.getSelectionModel();
        if (t == null) {
            multipleSelectionModel.clearSelection();
        } else {
            int n = this.getIndexOfComboBoxValueInItemsList();
            if (n == -1) {
                this.listSelectionLock = true;
                multipleSelectionModel.clearSelection();
                this.listSelectionLock = false;
            } else {
                int n2 = this.comboBox.getSelectionModel().getSelectedIndex();
                if (n2 >= 0 && n2 < this.comboBox.getItems().size()) {
                    Object e = this.comboBox.getItems().get(n2);
                    if (e != null && e.equals(t)) {
                        multipleSelectionModel.select(n2);
                    } else {
                        multipleSelectionModel.select(t);
                    }
                } else {
                    int n3 = this.listView.getItems().indexOf(t);
                    if (n3 == -1) {
                        this.updateDisplayNode();
                    } else {
                        multipleSelectionModel.select(n3);
                    }
                }
            }
        }
    }

    private TextField getEditableInputNode() {
        if (this.textField != null) {
            return this.textField;
        }
        this.textField = this.comboBox.getEditor();
        this.textField.setFocusTraversable(true);
        this.textField.promptTextProperty().bind(this.comboBox.promptTextProperty());
        this.textField.focusedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (bl2.booleanValue()) {
                    Platform.runLater(new Runnable(){

                        @Override
                        public void run() {
                            ComboBoxListViewSkin.this.comboBox.requestFocus();
                        }
                    });
                }
                ComboBoxListViewSkin.this.updateFakeFocus(bl2);
                if (!bl2.booleanValue()) {
                    ComboBoxListViewSkin.this.setTextFromTextFieldIntoComboBoxValue();
                }
            }
        });
        return this.textField;
    }

    private void updateFakeFocus(boolean bl) {
        if (this.textField == null) {
            return;
        }
        if (!(this.textField instanceof FocusableTextField)) {
            return;
        }
        ((FocusableTextField)this.textField).setFakeFocus(bl);
    }

    private void updateDisplayNode() {
        StringConverter stringConverter = this.comboBox.getConverter();
        if (stringConverter == null) {
            return;
        }
        Object t = this.comboBox.getValue();
        if (this.comboBox.isEditable()) {
            String string = stringConverter.toString(t);
            if (t == null || string == null) {
                this.textField.setText("");
            } else if (!string.equals(this.textField.getText())) {
                this.textField.setText(string);
            }
        } else {
            int n = this.getIndexOfComboBoxValueInItemsList();
            this.buttonCell.setItem(null);
            this.buttonCell.updateListView(this.listView);
            this.buttonCell.updateIndex(n);
            if (n == -1) {
                this.updateDisplayText(this.buttonCell, t, false);
            }
        }
    }

    private void updateDisplayText(ListCell<T> listCell, T t, boolean bl) {
        if (bl) {
            if (this.buttonCell == null) {
                return;
            }
            listCell.setGraphic(null);
            listCell.setText(this.comboBox.getPromptText() == null ? null : this.comboBox.getPromptText());
        } else if (t instanceof Node) {
            Node node = this.buttonCell.getGraphic();
            Node node2 = (Node)t;
            if (node == null || !node.equals(node2)) {
                listCell.setText(null);
                listCell.setGraphic(node2);
            }
        } else {
            StringConverter<T> stringConverter = this.comboBox.getConverter();
            String string = t == null ? this.comboBox.getPromptText() : (stringConverter == null ? t.toString() : stringConverter.toString(t));
            listCell.setText(string);
            listCell.setGraphic(null);
        }
    }

    private void setTextFromTextFieldIntoComboBoxValue() {
        if (!this.comboBox.isEditable()) {
            return;
        }
        StringConverter<T> stringConverter = this.comboBox.getConverter();
        if (stringConverter == null) {
            return;
        }
        Object t = this.comboBox.getValue();
        T t2 = stringConverter.fromString(this.textField.getText());
        if (t2 == null && t == null || t2 != null && t2.equals(t)) {
            return;
        }
        this.comboBox.setValue(t2);
    }

    private int getIndexOfComboBoxValueInItemsList() {
        Object t = this.comboBox.getValue();
        int n = this.comboBox.getItems().indexOf(t);
        return n;
    }

    private void updateButtonCell() {
        this.buttonCell = this.comboBox.getButtonCell() != null ? this.comboBox.getButtonCell() : this.getDefaultCellFactory().call(this.listView);
        this.buttonCell.setMouseTransparent(true);
    }

    private void updateCellFactory() {
        Callback<ListView<T>, ListCell<T>> callback = this.comboBox.getCellFactory();
        this.cellFactory = callback != null ? callback : this.getDefaultCellFactory();
        this.listView.setCellFactory(this.cellFactory);
    }

    private Callback<ListView<T>, ListCell<T>> getDefaultCellFactory() {
        return new Callback<ListView<T>, ListCell<T>>(){

            @Override
            public ListCell<T> call(ListView<T> listView) {
                return new ListCell<T>(){

                    @Override
                    public void updateItem(T t, boolean bl) {
                        super.updateItem(t, bl);
                        ComboBoxListViewSkin.this.updateDisplayText(this, t, bl);
                    }
                };
            }
        };
    }

    private ListView<T> createListView() {
        final ListView listView = new ListView<T>(){
            private boolean isFirstSizeCalculation = true;

            @Override
            protected double computeMinHeight(double d) {
                return 30.0;
            }

            @Override
            protected double computePrefWidth(double d) {
                double d2;
                this.doCSSCheck();
                if (this.getSkin() instanceof ListViewSkin) {
                    ListViewSkin listViewSkin = (ListViewSkin)this.getSkin();
                    if (ComboBoxListViewSkin.this.itemCountDirty) {
                        listViewSkin.updateCellCount();
                        ComboBoxListViewSkin.this.itemCountDirty = false;
                    }
                    int n = -1;
                    if (ComboBoxListViewSkin.this.comboBox.getProperties().containsKey(ComboBoxListViewSkin.COMBO_BOX_ROWS_TO_MEASURE_WIDTH_KEY)) {
                        n = (Integer)ComboBoxListViewSkin.this.comboBox.getProperties().get(ComboBoxListViewSkin.COMBO_BOX_ROWS_TO_MEASURE_WIDTH_KEY);
                    }
                    d2 = Math.max(ComboBoxListViewSkin.this.comboBox.getWidth(), listViewSkin.getMaxCellWidth(n) + 30.0);
                } else {
                    d2 = Math.max(100.0, ComboBoxListViewSkin.this.comboBox.getWidth());
                }
                return Math.max(50.0, d2);
            }

            @Override
            protected double computePrefHeight(double d) {
                this.doCSSCheck();
                return ComboBoxListViewSkin.this.getListViewPrefHeight();
            }

            private void doCSSCheck() {
                Parent parent = ComboBoxListViewSkin.this.getPopup().getScene().getRoot();
                if ((this.isFirstSizeCalculation || this.getSkin() == null) && parent.getScene() != null) {
                    parent.impl_processCSS(true);
                    this.isFirstSizeCalculation = false;
                }
            }
        };
        listView.setId("list-view");
        listView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        listView.getSelectionModel().selectedIndexProperty().addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                if (ComboBoxListViewSkin.this.listSelectionLock) {
                    return;
                }
                int n = listView.getSelectionModel().getSelectedIndex();
                ComboBoxListViewSkin.this.comboBox.getSelectionModel().select(n);
                ComboBoxListViewSkin.this.updateDisplayNode();
            }
        });
        this.comboBox.getSelectionModel().selectedItemProperty().addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                ComboBoxListViewSkin.this.listViewSelectionDirty = true;
            }
        });
        listView.addEventFilter(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                ObservableList<String> observableList;
                EventTarget eventTarget = mouseEvent.getTarget();
                if (eventTarget instanceof Parent && ((observableList = ((Parent)eventTarget).getStyleClass()).contains("thumb") || observableList.contains("track") || observableList.contains("decrement-arrow") || observableList.contains("increment-arrow"))) {
                    return;
                }
                ComboBoxListViewSkin.this.comboBox.hide();
            }
        });
        listView.setOnKeyPressed(new EventHandler<KeyEvent>(){

            @Override
            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.ENTER || keyEvent.getCode() == KeyCode.SPACE || keyEvent.getCode() == KeyCode.ESCAPE) {
                    ComboBoxListViewSkin.this.comboBox.hide();
                }
            }
        });
        return listView;
    }

    private double getListViewPrefHeight() {
        double d;
        if (this.listView.getSkin() instanceof VirtualContainerBase) {
            int n = this.comboBox.getVisibleRowCount();
            VirtualContainerBase virtualContainerBase = (VirtualContainerBase)this.listView.getSkin();
            d = virtualContainerBase.getVirtualFlowPreferredHeight(n);
        } else {
            double d2 = this.comboBox.getItems().size() * 25;
            d = Math.min(d2, 200.0);
        }
        return d;
    }

    public ListView<T> getListView() {
        return this.listView;
    }
}

