/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.api.nodes;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.selector.api.nodes.ConstructorNode;
import org.netbeans.modules.profiler.selector.api.nodes.ConstructorsNode;
import org.netbeans.modules.profiler.selector.api.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.api.nodes.InnerClassesNode;
import org.netbeans.modules.profiler.selector.api.nodes.MethodNode;
import org.netbeans.modules.profiler.selector.api.nodes.MethodsNode;
import org.netbeans.modules.profiler.selector.api.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.api.nodes.SelectorNode;
import org.openide.util.NbBundle;

public class ClassNode
extends ContainerNode {
    private SourceClassInfo cInfo;
    private ClientUtils.SourceCodeSelection signature;
    public static final Comparator COMPARATOR = new Comparator<ClassNode>(){

        @Override
        public int compare(ClassNode classNode, ClassNode classNode2) {
            return classNode.toString().compareTo(classNode2.toString());
        }
    };

    public ClassNode(SourceClassInfo sourceClassInfo, String string, Icon icon, ContainerNode containerNode) {
        super(sourceClassInfo != null ? sourceClassInfo.getQualifiedName() : NbBundle.getMessage(ClassNode.class, (String)"LBL_Unknown"), string, icon, containerNode);
        this.cInfo = sourceClassInfo;
        if (this.isAnonymous()) {
            String string2 = null;
            Set set = sourceClassInfo.getInterfaces();
            if (set.size() == 1) {
                string2 = ((SourceClassInfo)set.iterator().next()).getQualifiedName();
            } else {
                SourceClassInfo sourceClassInfo2 = sourceClassInfo.getSuperType();
                if (!sourceClassInfo2.getQualifiedName().equals(Object.class.getName())) {
                    string2 = sourceClassInfo2.getQualifiedName();
                }
            }
            if (string2 != null) {
                this.updateDisplayName(string + " [" + string2 + "]");
            }
        }
        this.signature = new ClientUtils.SourceCodeSelection(sourceClassInfo.getQualifiedName() + "$**", null, null);
    }

    public ClassNode(SourceClassInfo sourceClassInfo, ContainerNode containerNode) {
        this(sourceClassInfo, sourceClassInfo.getSimpleName(), Icons.getIcon((String)"LanguageIcons.Class"), containerNode);
    }

    @Override
    protected final SelectorChildren getChildren() {
        return new ClassChildren();
    }

    @Override
    public ClientUtils.SourceCodeSelection getSignature() {
        return this.signature;
    }

    public final boolean isAnonymous() {
        return this.cInfo.isAnonymous();
    }

    protected ConstructorsNode getConstructorsNode() {
        return new ConstructorsNode(this){

            @Override
            protected List<SelectorNode> getConstructorNodes(ConstructorsNode constructorsNode) {
                ArrayList<SelectorNode> arrayList = new ArrayList<SelectorNode>();
                for (SourceMethodInfo sourceMethodInfo : ClassNode.this.cInfo.getConstructors()) {
                    ConstructorNode constructorNode = new ConstructorNode(sourceMethodInfo, constructorsNode);
                    arrayList.add(constructorNode);
                }
                return arrayList;
            }
        };
    }

    protected MethodsNode getMethodsNode() {
        return new MethodsNode(this){

            @Override
            protected List<MethodNode> getMethodNodes(MethodsNode methodsNode) {
                ArrayList<MethodNode> arrayList = new ArrayList<MethodNode>();
                for (SourceMethodInfo sourceMethodInfo : ClassNode.this.cInfo.getMethods(false)) {
                    arrayList.add(new MethodNode(sourceMethodInfo, methodsNode));
                }
                return arrayList;
            }
        };
    }

    private InnerClassesNode getInnerClassesNode() {
        return new InnerClassesNode(this){

            @Override
            protected Set<ClassNode> getInnerClassNodes(InnerClassesNode innerClassesNode) {
                HashSet<ClassNode> hashSet = new HashSet<ClassNode>();
                for (SourceClassInfo sourceClassInfo : ClassNode.this.cInfo.getInnerClases()) {
                    hashSet.add(new ClassNode(sourceClassInfo, innerClassesNode));
                }
                return hashSet;
            }
        };
    }

    private static class ClassChildren
    extends SelectorChildren<ClassNode> {
        private ClassChildren() {
        }

        @Override
        protected List<SelectorNode> prepareChildren(ClassNode classNode) {
            ArrayList<SelectorNode> arrayList = new ArrayList<SelectorNode>();
            ContainerNode containerNode = null;
            if (!classNode.isAnonymous() && (containerNode = classNode.getConstructorsNode()) != null && !containerNode.isLeaf()) {
                arrayList.add(containerNode);
            }
            if ((containerNode = classNode.getMethodsNode()) != null && !containerNode.isLeaf()) {
                arrayList.add(containerNode);
            }
            if ((containerNode = classNode.getInnerClassesNode()) != null && !containerNode.isLeaf()) {
                arrayList.add(containerNode);
            }
            return arrayList;
        }
    }
}

