/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup.implspi;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ActiveQueue {
    private static final Logger LOGGER = Logger.getLogger(ActiveQueue.class.getName());
    private static Impl activeReferenceQueue;

    private ActiveQueue() {
    }

    public static synchronized ReferenceQueue<Object> queue() {
        if (activeReferenceQueue == null) {
            activeReferenceQueue = new Impl();
        }
        activeReferenceQueue.ping();
        return activeReferenceQueue;
    }

    private static final class Impl
    extends ReferenceQueue<Object>
    implements Runnable {
        private int count;

        Impl() {
        }

        @Override
        public Reference<Object> poll() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reference<Object> remove(long l) throws IllegalArgumentException, InterruptedException {
            throw new InterruptedException();
        }

        @Override
        public Reference<Object> remove() throws InterruptedException {
            throw new InterruptedException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object;
                try {
                    while (true) {
                        object = super.remove(0L);
                        LOGGER.finer("dequeued reference");
                        if (object instanceof Runnable) break;
                        LOGGER.log(Level.WARNING, "A reference not implementing runnable has been added to the Utilities.activeReferenceQueue(): {0}", object.getClass());
                    }
                    try {
                        ((Runnable)object).run();
                    }
                    catch (ThreadDeath threadDeath) {
                        throw threadDeath;
                    }
                    catch (Throwable throwable) {
                        LOGGER.log(Level.WARNING, "Cannot process " + object, throwable);
                    }
                    finally {
                        object = null;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                object = this;
                synchronized (object) {
                    assert (this.count > 0);
                    --this.count;
                    if (this.count == 0) {
                        LOGGER.fine("stopping thread");
                        break;
                    }
                }
            }
        }

        synchronized void ping() {
            if (this.count == 0) {
                Thread thread = new Thread((Runnable)this, "Active Reference Queue Daemon");
                thread.setPriority(1);
                thread.setDaemon(true);
                thread.start();
                LOGGER.fine("starting thread");
                this.count = 1;
            } else {
                ++this.count;
                LOGGER.log(Level.FINER, "enqued references = {0}", this.count);
            }
        }
    }
}

