/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.EventListenerList;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.WaitableResult;

final class SimpleProxyLookup
extends Lookup {
    private Lookup.Provider provider;
    private Lookup delegate;
    private WeakHashMap<Lookup.Template<?>, Reference<ProxyResult<?>>> results;

    SimpleProxyLookup(Lookup.Provider provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lookup checkLookup() {
        Lookup lookup = this.provider.getLookup();
        Iterator<Reference<ProxyResult<?>>> iterator = null;
        Object object = this;
        synchronized (object) {
            if (lookup != this.delegate) {
                this.delegate = lookup;
                if (this.results != null) {
                    iterator = new ArrayList(this.results.values()).iterator();
                }
            }
        }
        if (iterator != null) {
            LookupListener lookupListener;
            Reference<ProxyResult<?>> reference;
            object = new ArrayList();
            Iterator<Reference<ProxyResult<Object>>> iterator2 = iterator;
            while (iterator2.hasNext()) {
                reference = iterator2.next();
                if (reference == null || (lookupListener = reference.get()) == null || !((ProxyResult)lookupListener).updateLookup(((ProxyResult)lookupListener).delegate, lookup)) continue;
                ((ProxyResult)lookupListener).collectFires((Collection<Object>)object);
            }
            iterator2 = ((ArrayList)object).iterator();
            while (iterator2.hasNext()) {
                reference = (LookupEvent)((Object)iterator2.next());
                lookupListener = (LookupListener)((Object)iterator2.next());
                lookupListener.resultChanged((LookupEvent)((Object)reference));
            }
        }
        return this.delegate;
    }

    private static <T> ProxyResult<T> cast(ProxyResult<?> proxyResult) {
        return proxyResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        ProxyResult<T> proxyResult;
        SimpleProxyLookup simpleProxyLookup = this;
        synchronized (simpleProxyLookup) {
            Reference<ProxyResult<?>> reference;
            if (this.results == null) {
                this.results = new WeakHashMap();
            } else {
                ProxyResult<?> proxyResult2;
                reference = this.results.get(template);
                if (reference != null && (proxyResult2 = reference.get()) != null) {
                    return SimpleProxyLookup.cast(proxyResult2);
                }
            }
            proxyResult = new ProxyResult<T>(template);
            reference = new WeakReference(proxyResult);
            this.results.put(template, reference);
        }
        ((ProxyResult)proxyResult).checkResult();
        return proxyResult;
    }

    @Override
    public <T> T lookup(Class<T> clazz) {
        if (clazz == null) {
            this.checkLookup();
            return null;
        }
        return this.checkLookup().lookup(clazz);
    }

    @Override
    public <T> Lookup.Item<T> lookupItem(Lookup.Template<T> template) {
        return this.checkLookup().lookupItem(template);
    }

    private final class WeakResult<T>
    extends WaitableResult<T>
    implements LookupListener {
        private Lookup.Result source;
        private Reference<ProxyResult<T>> result;

        public WeakResult(ProxyResult<T> proxyResult, Lookup.Result<T> result) {
            this.result = new WeakReference<ProxyResult<ProxyResult<T>>>(proxyResult);
            this.source = result;
        }

        @Override
        protected void beforeLookup(Lookup.Template template) {
            ProxyResult<T> proxyResult = this.result.get();
            if (proxyResult != null) {
                proxyResult.beforeLookup(template);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        protected void collectFires(Collection<Object> collection) {
            ProxyResult<T> proxyResult = this.result.get();
            if (proxyResult != null) {
                proxyResult.collectFires(collection);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        public void addLookupListener(LookupListener lookupListener) {
            assert (false);
        }

        @Override
        public void removeLookupListener(LookupListener lookupListener) {
            assert (false);
        }

        @Override
        public Collection<T> allInstances() {
            assert (false);
            return null;
        }

        @Override
        public void resultChanged(LookupEvent lookupEvent) {
            ProxyResult<T> proxyResult = this.result.get();
            if (proxyResult != null) {
                proxyResult.resultChanged(lookupEvent);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            assert (false);
            return null;
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            assert (false);
            return null;
        }
    }

    private final class ProxyResult<T>
    extends WaitableResult<T>
    implements LookupListener {
        private Lookup.Template<T> template;
        private Lookup.Result<T> delegate;
        private EventListenerList listeners;
        private LookupListener lastListener;

        ProxyResult(Lookup.Template<T> template) {
            this.template = template;
        }

        private Lookup.Result<T> checkResult() {
            Lookup.Result<T> result = this.delegate;
            this.updateLookup(result, SimpleProxyLookup.this.checkLookup());
            return this.delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updateLookup(Lookup.Result result, Lookup lookup) {
            Lookup.Result<T> result2;
            ArrayList arrayList;
            Collection collection = null;
            if (result != null) {
                collection = result.allItems();
            }
            while (true) {
                LookupListener lookupListener;
                arrayList = this;
                synchronized (arrayList) {
                    if (this.delegate != null && this.lastListener != null) {
                        lookupListener = this.lastListener;
                        this.delegate.removeLookupListener(this.lastListener);
                    } else {
                        lookupListener = null;
                    }
                }
                arrayList = lookup.lookup(this.template);
                ProxyResult proxyResult = this;
                synchronized (proxyResult) {
                    if (lookupListener == this.lastListener) {
                        this.delegate = arrayList;
                        this.lastListener = new WeakResult<T>(this, this.delegate);
                        result2 = this.delegate;
                        break;
                    }
                }
            }
            result2.addLookupListener(this.lastListener);
            if (collection == null) {
                return false;
            }
            arrayList = this.delegate.allItems();
            if (!(collection instanceof List)) {
                collection = collection == Collections.EMPTY_SET ? Collections.emptyList() : new ArrayList(collection);
            }
            if (!(arrayList instanceof List)) {
                arrayList = new ArrayList(arrayList);
            }
            return !((Object)collection).equals(arrayList);
        }

        @Override
        public synchronized void addLookupListener(LookupListener lookupListener) {
            if (this.listeners == null) {
                this.listeners = new EventListenerList();
            }
            this.listeners.add(LookupListener.class, lookupListener);
        }

        @Override
        public synchronized void removeLookupListener(LookupListener lookupListener) {
            if (this.listeners != null) {
                this.listeners.remove(LookupListener.class, lookupListener);
            }
        }

        @Override
        public Collection<? extends T> allInstances() {
            return this.checkResult().allInstances();
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            return this.checkResult().allClasses();
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            return this.checkResult().allItems();
        }

        @Override
        protected void beforeLookup(Lookup.Template template) {
            Lookup.Result<T> result = this.checkResult();
            if (result instanceof WaitableResult) {
                ((WaitableResult)result).beforeLookup(template);
            }
        }

        @Override
        public void resultChanged(LookupEvent lookupEvent) {
            this.collectFires(null);
        }

        @Override
        protected void collectFires(Collection<Object> collection) {
            EventListenerList eventListenerList = this.listeners;
            if (eventListenerList == null) {
                return;
            }
            Object[] objectArray = eventListenerList.getListenerList();
            if (objectArray.length == 0) {
                return;
            }
            LookupEvent lookupEvent = new LookupEvent(this);
            AbstractLookup.notifyListeners(objectArray, lookupEvent, collection);
        }
    }
}

