/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.spi.actions.NbAction;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

final class MergeAction
extends NbAction
implements PropertyChangeListener {
    private NbAction[] actions;
    private Map<String, Object> knownValues = new HashMap<String, Object>();
    private Action delegateAction;
    private volatile boolean enabled;
    final boolean allowOnlyOne;
    boolean logged;

    public MergeAction(NbAction[] nbActionArray, boolean bl) {
        this.actions = nbActionArray;
        this.allowOnlyOne = bl;
        assert (nbActionArray.length > 0);
        assert (new HashSet<NbAction>(Arrays.asList(nbActionArray)).size() == nbActionArray.length) : "Duplicate actions in " + Arrays.asList(nbActionArray);
        for (int i = 0; i < nbActionArray.length; ++i) {
            Parameters.notNull((CharSequence)("Action " + i), (Object)nbActionArray[i]);
        }
        this.knownValues.put("Name", null);
        this.knownValues.put("AcceleratorKey", null);
        this.knownValues.put("LongDescription", null);
        this.knownValues.put("SmallIcon", null);
        this.knownValues.put("ShortDescription", null);
        this.knownValues.put("LongDescription", null);
        this.knownValues.put("SmallIcon", null);
        this.knownValues.put("MnemonicKey", null);
        this.knownValues.put("noIconInMenu", null);
        this.knownValues.put("enabled", null);
    }

    public MergeAction(NbAction[] nbActionArray) {
        this(nbActionArray, false);
    }

    public boolean equals(Object object) {
        return object != null && MergeAction.class == object.getClass() && Arrays.equals(((MergeAction)object).actions, this.actions);
    }

    public int hashCode() {
        return Arrays.hashCode(this.actions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Action updateDelegateAction() {
        MergeAction mergeAction = this;
        synchronized (mergeAction) {
            return this.setDelegateAction(this.findEnabledAction());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Action setDelegateAction(Action action) {
        assert (Thread.holdsLock(this));
        MergeAction mergeAction = this;
        synchronized (mergeAction) {
            Action action2 = this.delegateAction;
            if (action2 != action) {
                this.delegateAction = action;
                boolean bl = this.getDelegateAction().isEnabled();
                if (bl != this.enabled) {
                    this.enabled = bl;
                    this.firePropertyChange("enabled", !this.enabled, this.enabled);
                }
                if (action != null) {
                    this.sievePropertyChanges();
                }
            }
        }
        return action;
    }

    Action findEnabledAction() {
        NbAction nbAction = null;
        int n = 0;
        NbAction.ActionRunnable<Boolean> actionRunnable = new NbAction.ActionRunnable<Boolean>(){

            @Override
            public Boolean run(NbAction nbAction) {
                return nbAction.isEnabled();
            }
        };
        for (NbAction nbAction2 : this.actions) {
            if (!this.runActive(actionRunnable, nbAction2).booleanValue()) continue;
            ++n;
            if (!this.allowOnlyOne) {
                nbAction = nbAction2;
                break;
            }
            if (nbAction != null) continue;
            nbAction = nbAction2;
        }
        if (this.allowOnlyOne && n > 1 && nbAction != null) {
            nbAction = null;
        }
        return nbAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Action getDelegateAction() {
        Object object = null;
        MergeAction mergeAction = this;
        synchronized (mergeAction) {
            object = this.delegateAction;
            if (object == null || !object.isEnabled()) {
                object = this.attached() ? this.updateDelegateAction() : this.findEnabledAction();
            }
        }
        if (object == null) {
            object = this.actions[0];
        }
        return object;
    }

    private void sievePropertyChanges() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string : this.knownValues.keySet()) {
            Object object = this.knownValues.get(string);
            Object object2 = this.getValue(string);
            if (object2 == object) continue;
            hashMap.put(string, object2);
            this.firePropertyChange(string, object, object2);
        }
    }

    @Override
    protected synchronized void addNotify() {
        for (NbAction nbAction : this.actions) {
            nbAction.addPropertyChangeListener(this);
        }
        this.updateDelegateAction();
    }

    @Override
    protected synchronized void removeNotify() {
        for (NbAction nbAction : this.actions) {
            nbAction.removePropertyChangeListener(this);
        }
        this.setDelegateAction(null);
    }

    @Override
    protected NbAction internalCreateContextAwareInstance(Lookup lookup) {
        NbAction[] nbActionArray = new NbAction[this.actions.length];
        for (int i = 0; i < nbActionArray.length; ++i) {
            nbActionArray[i] = (NbAction)((Object)this.actions[i].createContextAwareInstance(lookup));
        }
        MergeAction mergeAction = new MergeAction(nbActionArray, this.allowOnlyOne);
        mergeAction.knownValues.putAll(this.knownValues);
        mergeAction.pairs.putAll(this.pairs);
        return mergeAction;
    }

    @Override
    public Object getValue(final String string) {
        Object object;
        Object object2 = super.getValue(string);
        if (object2 == null && this.isEnabled()) {
            object = this.getDelegateAction();
            object2 = object.getValue(string);
        }
        if (object2 == null) {
            NbAction nbAction;
            object = new NbAction.ActionRunnable<Object>(){

                @Override
                public Object run(NbAction nbAction) {
                    return nbAction.getValue(string);
                }
            };
            NbAction[] nbActionArray = this.actions;
            int n = nbActionArray.length;
            for (int i = 0; i < n && (object2 = this.runActive(object, nbAction = nbActionArray[i])) == null; ++i) {
            }
        }
        this.knownValues.put(string, object2);
        return object2;
    }

    @Override
    public void putValue(String string, Object object) {
        if (!this.logged) {
            Logger.getLogger(MergeAction.class.getName()).log(Level.INFO, "putValue (" + string + ',' + object + "called on merged action.  This is probably a mistake.");
        }
        super.putValue(string, object);
    }

    public boolean isEnabled() {
        boolean bl = this.updateEnabled();
        return bl;
    }

    boolean updateEnabled() {
        this.enabled = this.getDelegateAction().isEnabled();
        if (this.allowOnlyOne && this.enabled && this.findEnabledAction() == null) {
            this.enabled = false;
        }
        return this.enabled;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Action action = this.getDelegateAction();
        if (action == null) {
            throw new IllegalStateException("Not enabled or no delegate: " + this);
        }
        action.actionPerformed(actionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = this.enabled;
        MergeAction mergeAction = this;
        synchronized (mergeAction) {
            if (this.attached()) {
                this.updateDelegateAction();
            }
        }
        boolean bl2 = this.isEnabled();
        if (!"enabled".equals(propertyChangeEvent.getPropertyName())) {
            Object object = this.knownValues.get(propertyChangeEvent.getPropertyName());
            Object object2 = this.getValue(propertyChangeEvent.getPropertyName());
            if (object2 != object) {
                this.firePropertyChange(propertyChangeEvent.getPropertyName(), object, object2);
            }
            this.knownValues.put(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getNewValue());
        }
        if (bl != bl2) {
            this.firePropertyChange("enabled", bl, bl2);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append('[');
        for (int i = 0; i < this.actions.length; ++i) {
            stringBuilder.append(this.actions[i]);
            if (i == this.actions.length - 1) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

