/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.nodes.AsynchChildren;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.EntrySupport;
import org.openide.nodes.Node;
import org.openide.nodes.SynchChildren;
import org.openide.util.Enumerations;
import org.openide.util.Mutex;
import org.openide.util.Parameters;

public abstract class Children {
    static final Mutex.Privileged PR = new Mutex.Privileged();
    public static final Mutex MUTEX = new Mutex(PR, (Executor)new ProjectManagerDeadlockDetector());
    public static final Children LEAF = new Empty();
    static final Logger LOG = Logger.getLogger(Children.class.getName());
    private EntrySupport entrySupport;
    Node parent;
    boolean lazySupport;

    public Children() {
        this(false);
    }

    Children(boolean bl) {
        this.lazySupport = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EntrySupport entrySupport() {
        Class<Children> clazz = Children.class;
        synchronized (Children.class) {
            if (this.getEntrySupport() == null) {
                LOG.finer("Initializing entrySupport");
                EntrySupport entrySupport = this.lazySupport ? new EntrySupport.Lazy(this) : new EntrySupport.Default(this);
                this.setEntrySupport(entrySupport);
                this.postInitializeEntrySupport(entrySupport);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.getEntrySupport();
        }
    }

    boolean isLazy() {
        return this.lazySupport;
    }

    void checkSupport() {
    }

    void postInitializeEntrySupport(EntrySupport entrySupport) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void attachTo(Node node) throws IllegalStateException {
        if (this == LEAF) {
            return;
        }
        Node[] nodeArray = this;
        synchronized (this) {
            if (this.parent != null) {
                throw new IllegalStateException("An instance of Children may not be used for more than one parent node.");
            }
            this.parent = node;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            nodeArray = this.testNodes();
            if (nodeArray == null) {
                return;
            }
            try {
                PR.enterReadAccess();
                nodeArray = super.testNodes();
                if (nodeArray == null) {
                    return;
                }
                for (int i = 0; i < nodeArray.length; ++i) {
                    Node node2 = nodeArray[i];
                    node2.assignTo((Children)this, i);
                    node2.fireParentNodeChange(null, this.parent);
                }
            }
            finally {
                PR.exitReadAccess();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void detachFrom() {
        if (this == LEAF) {
            return;
        }
        Node node = null;
        Node[] nodeArray = this;
        synchronized (this) {
            if (this.parent == null) {
                throw new IllegalStateException("Trying to detach children which do not have parent");
            }
            node = this.parent;
            this.parent = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                PR.enterReadAccess();
                nodeArray = this.testNodes();
                if (nodeArray == null) {
                    return;
                }
                for (int i = 0; i < nodeArray.length; ++i) {
                    Node node2 = nodeArray[i];
                    node2.deassignFrom((Children)this);
                    node2.fireParentNodeChange(node, null);
                }
            }
            finally {
                PR.exitReadAccess();
            }
            return;
        }
    }

    public static <T> Children create(ChildFactory<T> childFactory, boolean bl) {
        if (childFactory == null) {
            throw new NullPointerException("Null factory");
        }
        if (bl) {
            AsynchChildren<T> asynchChildren = new AsynchChildren<T>(childFactory);
            childFactory.setObserver(asynchChildren);
            return asynchChildren;
        }
        SynchChildren<T> synchChildren = new SynchChildren<T>(childFactory);
        childFactory.setObserver(synchChildren);
        return synchChildren;
    }

    public static Children createLazy(Callable<Children> callable) {
        return new LazyChildren(callable);
    }

    protected final Node getNode() {
        return this.parent;
    }

    final Object cloneHierarchy() throws CloneNotSupportedException {
        return this.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object clone() throws CloneNotSupportedException {
        Class<Children> clazz = Children.class;
        synchronized (Children.class) {
            Children children = (Children)super.clone();
            children.parent = null;
            children.setEntrySupport(null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return children;
        }
    }

    public abstract boolean add(Node[] var1);

    public abstract boolean remove(Node[] var1);

    public final Enumeration<Node> nodes() {
        return Enumerations.array((Object[])this.getNodes());
    }

    public Node findChild(String string) {
        Node[] nodeArray = this.getNodes();
        if (nodeArray.length == 0) {
            return null;
        }
        if (string == null) {
            return nodeArray[0];
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            if (!string.equals(nodeArray[i].getName())) continue;
            return nodeArray[i];
        }
        return null;
    }

    protected final boolean isInitialized() {
        return this.entrySupport().isInitialized();
    }

    public final Node getNodeAt(int n) {
        this.checkSupport();
        return this.entrySupport().getNodeAt(n);
    }

    public final Node[] getNodes() {
        this.checkSupport();
        return this.entrySupport().getNodes(false);
    }

    public Node[] getNodes(boolean bl) {
        this.checkSupport();
        return this.entrySupport().getNodes(bl);
    }

    public final int getNodesCount() {
        this.checkSupport();
        return this.entrySupport().getNodesCount(false);
    }

    public int getNodesCount(boolean bl) {
        this.checkSupport();
        return this.entrySupport().getNodesCount(bl);
    }

    public final List<Node> snapshot() {
        return this.entrySupport().snapshot();
    }

    static final int[] getSnapshotIdxs(List<Node> list) {
        int[] nArray = new int[list.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    protected void addNotify() {
    }

    protected void removeNotify() {
    }

    void callAddNotify() {
        this.addNotify();
    }

    final void callRemoveNotify() {
        this.removeNotify();
    }

    void destroyNodes(Node[] nodeArray) {
    }

    private Node[] testNodes() {
        return this.getEntrySupport() == null ? null : this.entrySupport().testNodes();
    }

    final EntrySupport getEntrySupport() {
        return this.entrySupport;
    }

    final void setEntrySupport(EntrySupport entrySupport) {
        assert (Thread.holdsLock(Children.class));
        this.entrySupport = entrySupport;
    }

    private static final class ProjectManagerDeadlockDetector
    implements Executor {
        private final Mutex FALLBACK = new Mutex();
        private final AtomicReference<WeakReference<Mutex>> pmMutexRef = new AtomicReference();

        private ProjectManagerDeadlockDetector() {
        }

        @Override
        public void execute(Runnable runnable) {
            Mutex mutex;
            boolean bl = false;
            if (!$assertionsDisabled) {
                bl = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (bl && (mutex = this.getPMMutex()) != null && (mutex.isReadAccess() || mutex.isWriteAccess())) {
                throw new IllegalStateException("Should not acquire Children.MUTEX while holding ProjectManager.mutex()");
            }
            runnable.run();
        }

        private Mutex getPMMutex() {
            block3: {
                Mutex mutex;
                WeakReference<Mutex> weakReference;
                WeakReference<Mutex> weakReference2;
                do {
                    mutex = null;
                    weakReference2 = this.pmMutexRef.get();
                    if (weakReference2 != null) {
                        mutex = (Mutex)weakReference2.get();
                    }
                    if (mutex != null) {
                        return mutex;
                    }
                    mutex = this.callPMMutexMethod();
                    if (mutex == null) break block3;
                } while (!this.pmMutexRef.compareAndSet(weakReference2, weakReference = new WeakReference<Mutex>(mutex)));
                return mutex;
            }
            return null;
        }

        private Mutex callPMMutexMethod() {
            Class<?> clazz = null;
            Method method = null;
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass("org.netbeans.api.project.ProjectManager");
                method = clazz.getMethod("mutex", new Class[0]);
                return (Mutex)method.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return this.FALLBACK;
            }
            catch (IllegalAccessException illegalAccessException) {
                return this.FALLBACK;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return this.FALLBACK;
            }
            catch (InvocationTargetException invocationTargetException) {
                return this.FALLBACK;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return this.FALLBACK;
            }
            catch (ClassCastException classCastException) {
                Class<?> clazz2 = method.getReturnType();
                LOG.log(Level.WARNING, "Reopen #175325 and save complete log: type=" + clazz2.getName() + " type.cl=" + clazz2.getClassLoader() + " Mutex.cl=" + Mutex.class.getClassLoader() + " clazz.cl=" + clazz.getClassLoader(), classCastException);
                return null;
            }
        }
    }

    static class LazyChildren
    extends Children {
        private Callable<Children> factory;
        private Children original;
        private final Object originalLock = new Object();

        LazyChildren(Callable<Children> callable) {
            this.factory = callable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Children getOriginal() {
            Object object = this.originalLock;
            synchronized (object) {
                if (this.original == null) {
                    try {
                        this.original = this.factory.call();
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
                return this.original;
            }
        }

        @Override
        public boolean add(Node[] nodeArray) {
            return this.getOriginal().add(nodeArray);
        }

        @Override
        public boolean remove(Node[] nodeArray) {
            return this.getOriginal().remove(nodeArray);
        }

        @Override
        protected void addNotify() {
            this.getOriginal().addNotify();
        }

        @Override
        protected void removeNotify() {
            this.getOriginal().removeNotify();
        }

        @Override
        EntrySupport entrySupport() {
            return this.getOriginal().entrySupport();
        }

        @Override
        public Node findChild(String string) {
            return this.getOriginal().findChild(string);
        }
    }

    private static abstract class Dupl<T>
    implements Cloneable,
    Entry {
        protected Object key;

        Dupl() {
        }

        public final void updateList(Collection<? extends T> collection, Collection<? super Dupl<T>> collection2) {
            HashMap hashMap = new HashMap(collection.size() * 2);
            for (T t : collection) {
                this.updateListAndMap(t, collection2, hashMap);
            }
        }

        public final void updateList(T[] TArray, Collection<? super Dupl<T>> collection) {
            HashMap hashMap = new HashMap(TArray.length * 2);
            for (T t : TArray) {
                this.updateListAndMap(t, collection, hashMap);
            }
        }

        public final void updateListAndMap(T t, Collection<? super Dupl<T>> collection, java.util.Map<T, Object> map) {
            Parameters.notNull((CharSequence)"obj", t);
            Object object = map.put(t, this);
            if (object == null) {
                collection.add(this.createInstance(t, 0));
                return;
            }
            if (object == this) {
                map.put(t, 1);
                collection.add(this.createInstance(t, 1));
                return;
            }
            int n = (Integer)object + 1;
            map.put(t, n);
            collection.add(this.createInstance(t, n));
        }

        public T getKey() {
            if (this.key instanceof Dupl) {
                return ((Dupl)this.key).getKey();
            }
            return (T)this.key;
        }

        public int getCnt() {
            int n = 0;
            Dupl dupl = this;
            while (dupl.key instanceof Dupl) {
                dupl = (Dupl)dupl.key;
                ++n;
            }
            return n;
        }

        private final Dupl<T> createInstance(Object object, int n) {
            try {
                Dupl dupl;
                Dupl dupl2 = dupl = (Dupl)this.clone();
                while (n-- > 0) {
                    Dupl dupl3 = (Dupl)this.clone();
                    dupl.key = dupl3;
                    dupl = dupl3;
                }
                dupl.key = object;
                return dupl2;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Dupl) {
                Dupl dupl = (Dupl)object;
                return this.getKey().equals(dupl.getKey()) && this.getCnt() == dupl.getCnt();
            }
            return false;
        }
    }

    public static abstract class Keys<T>
    extends Array {
        private static java.util.Map<Keys<?>, Runnable> lastRuns = new HashMap(11);
        boolean before;

        public Keys() {
            this(false);
        }

        protected Keys(boolean bl) {
            super(bl);
        }

        @Override
        public Object clone() {
            Keys keys = (Keys)super.clone();
            return keys;
        }

        @Override
        void checkSupport() {
            if (this.lazySupport && this.nodes != null && this.nodes.size() > 0) {
                this.fallbackToDefaultSupport();
            }
        }

        void fallbackToDefaultSupport() {
            LOG.warning("Fallbacking entry support from lazy to default - Children.Array method was used");
            this.switchSupport(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void switchSupport(boolean bl) {
            if (bl == this.lazySupport) {
                return;
            }
            try {
                Object object;
                PR.enterWriteAccess();
                List<Entry> list = this.entrySupport().getEntries();
                boolean bl2 = this.entrySupport().isInitialized();
                if (bl2 && this.parent != null && (object = this.getEntrySupport().snapshot()).size() > 0) {
                    int[] nArray = Keys.getSnapshotIdxs((List<Node>)object);
                    this.parent.fireSubNodesChangeIdx(false, nArray, null, Collections.<Node>emptyList(), (List<Node>)object);
                }
                object = Children.class;
                synchronized (Children.class) {
                    this.setEntrySupport(null);
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    this.lazySupport = bl;
                    if (bl) {
                        this.nodesEntry = null;
                    } else {
                        this.nodesEntry = this.createNodesEntry();
                        list.add(this.before ? 0 : list.size(), this.nodesEntry);
                    }
                    if (bl2) {
                        this.entrySupport().notifySetEntries();
                    }
                    this.entrySupport().setEntries(list);
                }
            }
            finally {
                PR.exitWriteAccess();
            }
            {
                return;
            }
        }

        @Override
        @Deprecated
        public boolean add(Node[] nodeArray) {
            if (this.lazySupport) {
                this.fallbackToDefaultSupport();
            }
            return super.add(nodeArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public boolean remove(Node[] nodeArray) {
            if (this.lazySupport) {
                return false;
            }
            try {
                PR.enterWriteAccess();
                if (this.nodes != null) {
                    for (int i = 0; i < nodeArray.length; ++i) {
                        if (this.nodes.contains(nodeArray[i])) continue;
                        nodeArray[i] = null;
                    }
                    super.remove(nodeArray);
                }
            }
            finally {
                PR.exitWriteAccess();
            }
            return true;
        }

        protected final void refreshKey(final T t) {
            MUTEX.postWriteRequest(new Runnable(){

                @Override
                public void run() {
                    Keys.this.entrySupport().refreshEntry(Keys.this.createEntryForKey(t));
                }
            });
        }

        Entry createEntryForKey(T t) {
            return new KE(t);
        }

        protected final void setKeys(Collection<? extends T> collection) {
            ArrayList<Object> arrayList;
            boolean bl = false;
            if (!$assertionsDisabled) {
                bl = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            int n = collection.size();
            if (bl && n < 10) {
                arrayList = new ArrayList<T>(collection);
                for (int i = 0; i < n - 1; ++i) {
                    Object e = arrayList.get(i);
                    for (int j = i + 1; j < n; ++j) {
                        Object e2 = arrayList.get(j);
                        assert (!e.equals(e2) || e.hashCode() == e2.hashCode()) : "bad equals/hashCode in " + e + " vs. " + e2 + " class: " + e2.getClass().getName();
                    }
                }
            }
            arrayList = new ArrayList(collection.size() + 1);
            KE kE = new KE();
            if (this.lazySupport) {
                kE.updateList(collection, arrayList);
            } else {
                if (this.before) {
                    arrayList.add(this.getNodesEntry());
                }
                kE.updateList(collection, arrayList);
                if (!this.before) {
                    arrayList.add(this.getNodesEntry());
                }
            }
            this.applyKeys(arrayList);
        }

        protected final void setKeys(T[] TArray) {
            KE kE;
            boolean bl = false;
            if (!$assertionsDisabled) {
                bl = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            int n = TArray.length;
            if (bl && n < 10) {
                for (int i = 0; i < n - 1; ++i) {
                    kE = TArray[i];
                    for (int j = i + 1; j < n; ++j) {
                        T t = TArray[j];
                        assert (!((Object)kE).equals(t) || ((Object)kE).hashCode() == t.hashCode()) : "bad equals/hashCode in " + kE + " vs. " + t;
                    }
                }
            }
            ArrayList<Entry> arrayList = new ArrayList<Entry>(TArray.length + 1);
            kE = new KE();
            if (this.lazySupport) {
                kE.updateList(TArray, arrayList);
            } else {
                if (this.before) {
                    arrayList.add(this.getNodesEntry());
                }
                kE.updateList(TArray, arrayList);
                if (!this.before) {
                    arrayList.add(this.getNodesEntry());
                }
            }
            this.applyKeys(arrayList);
        }

        private void applyKeys(final List<? extends Entry> list) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (Keys.keysCheck(Keys.this, this)) {
                        Keys.this.entrySupport().setEntries(list);
                        Keys.keysExit(Keys.this, this);
                    }
                }
            };
            Keys.keysEnter(this, runnable);
            MUTEX.postWriteRequest(runnable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void setBefore(boolean bl) {
            try {
                PR.enterWriteAccess();
                if (this.before != bl && !this.lazySupport) {
                    List<Entry> list = this.entrySupport().getEntries();
                    list.remove(this.getNodesEntry());
                    this.before = bl;
                    if (bl) {
                        list.add(0, this.getNodesEntry());
                    } else {
                        list.add(this.getNodesEntry());
                    }
                    this.entrySupport().setEntries(list);
                }
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        protected abstract Node[] createNodes(T var1);

        @Override
        protected void destroyNodes(Node[] nodeArray) {
            for (int i = 0; i < nodeArray.length; ++i) {
                nodeArray[i].fireNodeDestroyed();
            }
        }

        private static synchronized void keysEnter(Keys<?> keys, Runnable runnable) {
            lastRuns.put(keys, runnable);
        }

        private static synchronized void keysExit(Keys keys, Runnable runnable) {
            Runnable runnable2 = lastRuns.remove(keys);
            if (runnable2 != null && !runnable2.equals(runnable)) {
                lastRuns.put(keys, runnable2);
            }
        }

        private static synchronized boolean keysCheck(Keys keys, Runnable runnable) {
            return runnable == lastRuns.get(keys);
        }

        class KE
        extends Dupl<T> {
            public KE() {
            }

            public KE(T t) {
                this.key = t;
            }

            @Override
            public Collection<Node> nodes(Object object) {
                Node[] nodeArray = Keys.this.createNodes(this.getKey());
                if (nodeArray == null) {
                    return Collections.emptyList();
                }
                return new LinkedList<Node>(Arrays.asList(nodeArray));
            }

            public String toString() {
                String string = this.getKey().toString();
                if (string.length() > 80) {
                    string = string.substring(string.length() - 80);
                }
                return "Children.Keys.KE[" + string + "," + this.getCnt() + "]";
            }
        }
    }

    public static class SortedMap<T>
    extends Map<T> {
        private Comparator<? super Node> comp;

        public SortedMap() {
        }

        protected SortedMap(java.util.Map<T, Node> map) {
            super(map);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setComparator(Comparator<? super Node> comparator) {
            try {
                PR.enterWriteAccess();
                this.comp = comparator;
                this.refresh();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        public Comparator<? super Node> getComparator() {
            return this.comp;
        }

        @Override
        Collection<? extends Entry> createEntries(java.util.Map<T, Node> map) {
            TreeSet<Map.ME> treeSet = new TreeSet<Map.ME>(new SMComparator());
            for (Map.Entry<T, Node> entry : map.entrySet()) {
                treeSet.add(new Map.ME(entry.getKey(), entry.getValue()));
            }
            return treeSet;
        }

        final class SMComparator
        implements Comparator<Map.ME> {
            SMComparator() {
            }

            @Override
            public int compare(Map.ME mE, Map.ME mE2) {
                Comparator comparator = SortedMap.this.comp;
                if (comparator == null) {
                    int n = ((Comparable)mE.key).compareTo(mE2.key);
                    return n;
                }
                return comparator.compare(mE.node, mE2.node);
            }
        }
    }

    public static class SortedArray
    extends Array {
        private Comparator<? super Node> comp;

        public SortedArray() {
        }

        protected SortedArray(Collection<Node> collection) {
            super(collection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setComparator(Comparator<? super Node> comparator) {
            try {
                PR.enterWriteAccess();
                this.comp = comparator;
                this.refresh();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        public Comparator<? super Node> getComparator() {
            return this.comp;
        }

        @Override
        Entry createNodesEntry() {
            return new SAE();
        }

        private final class SAE
        implements Entry {
            @Override
            public Collection<Node> nodes(Object object) {
                ArrayList<Node> arrayList = new ArrayList<Node>(SortedArray.this.getCollection());
                Collections.sort(arrayList, SortedArray.this.comp);
                return arrayList;
            }
        }
    }

    public static class Map<T>
    extends Children {
        protected java.util.Map<T, Node> nodes;

        protected Map(java.util.Map<T, Node> map) {
            this.nodes = map;
        }

        public Map() {
        }

        final java.util.Map<T, Node> getMap() {
            if (this.nodes == null) {
                this.nodes = this.initMap();
            }
            return this.nodes;
        }

        @Override
        final void callAddNotify() {
            this.entrySupport().setEntries(this.createEntries(this.getMap()), true);
            super.callAddNotify();
        }

        Collection<? extends Entry> createEntries(java.util.Map<T, Node> map) {
            LinkedList<ME> linkedList = new LinkedList<ME>();
            for (Map.Entry<T, Node> entry : map.entrySet()) {
                linkedList.add(new ME(entry.getKey(), entry.getValue()));
            }
            return linkedList;
        }

        final void refreshImpl() {
            this.entrySupport().setEntries(this.createEntries(this.getMap()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void refresh() {
            try {
                PR.enterWriteAccess();
                this.refreshImpl();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        final void refreshKeyImpl(T t) {
            this.entrySupport().refreshEntry(new ME(t, null));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void refreshKey(T t) {
            try {
                PR.enterWriteAccess();
                this.refreshKeyImpl(t);
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void putAll(java.util.Map<? extends T, ? extends Node> map) {
            try {
                PR.enterWriteAccess();
                this.getMap().putAll(map);
                this.refreshImpl();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void put(T t, Node node) {
            try {
                PR.enterWriteAccess();
                if (this.getMap().put(t, node) != null) {
                    this.refreshKeyImpl(t);
                } else {
                    this.refreshImpl();
                }
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void removeAll(Collection<? extends T> collection) {
            try {
                PR.enterWriteAccess();
                this.getMap().keySet().removeAll(collection);
                this.refreshImpl();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void remove(T t) {
            try {
                PR.enterWriteAccess();
                if (this.nodes != null && this.nodes.remove(t) != null) {
                    this.refreshImpl();
                }
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        protected java.util.Map<T, Node> initMap() {
            return new HashMap(7);
        }

        @Override
        public boolean add(Node[] nodeArray) {
            return false;
        }

        @Override
        public boolean remove(Node[] nodeArray) {
            return false;
        }

        static final class ME
        implements Entry {
            public Object key;
            public Node node;

            public ME(Object object, Node node) {
                this.key = object;
                this.node = node;
            }

            @Override
            public Collection<Node> nodes(Object object) {
                return Collections.singleton(this.node);
            }

            public int hashCode() {
                return this.key.hashCode();
            }

            public boolean equals(Object object) {
                if (object instanceof ME) {
                    ME mE = (ME)object;
                    return this.key.equals(mE.key);
                }
                return false;
            }

            public String toString() {
                return "Key (" + this.key + ")";
            }
        }
    }

    public static class Array
    extends Children
    implements Cloneable {
        Entry nodesEntry;
        protected Collection<Node> nodes;
        private static final Object COLLECTION_LOCK = new Object();

        protected Array(Collection<Node> collection) {
            this();
            this.nodes = collection;
        }

        public Array() {
            this(false);
        }

        Array(boolean bl) {
            super(bl);
            if (!bl) {
                this.nodesEntry = this.createNodesEntry();
            }
        }

        @Override
        void postInitializeEntrySupport(EntrySupport entrySupport) {
            if (!this.lazySupport) {
                if (this.getNodesEntry() == null) {
                    this.nodesEntry = this.createNodesEntry();
                }
                entrySupport.setEntries(Collections.singleton(this.getNodesEntry()), true);
            } else if (this.getNodesEntry() != null) {
                this.nodesEntry = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object clone() {
            try {
                Array array = (Array)super.clone();
                try {
                    PR.enterReadAccess();
                    if (this.nodes != null) {
                        array.nodes = array.initCollection();
                        array.nodes.clear();
                        for (Node node : this.nodes) {
                            array.nodes.add(node.cloneNode());
                        }
                    }
                }
                finally {
                    PR.exitReadAccess();
                }
                return array;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        protected Collection<Node> initCollection() {
            return new ArrayList<Node>();
        }

        final void refreshImpl() {
            if (this.isInitialized()) {
                this.entrySupport().refreshEntry(this.getNodesEntry());
                this.entrySupport().getNodes(false);
            } else if (this.nodes != null) {
                for (Node node : this.nodes) {
                    node.assignTo(this, -1);
                }
            }
        }

        protected final void refresh() {
            this.checkSupport();
            if (this.lazySupport) {
                return;
            }
            MUTEX.postWriteRequest(new Runnable(){

                @Override
                public void run() {
                    Array.this.refreshImpl();
                }
            });
        }

        final Entry getNodesEntry() {
            return this.nodesEntry;
        }

        Entry createNodesEntry() {
            return new AE();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Collection<Node> getCollection() {
            Object object = COLLECTION_LOCK;
            synchronized (object) {
                if (this.nodes == null) {
                    this.nodes = this.initCollection();
                }
            }
            return this.nodes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(Node[] nodeArray) {
            Object object = COLLECTION_LOCK;
            synchronized (object) {
                if (!this.getCollection().addAll(Arrays.asList(nodeArray))) {
                    return false;
                }
            }
            this.refresh();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Node[] nodeArray) {
            Object object = COLLECTION_LOCK;
            synchronized (object) {
                if (!this.getCollection().removeAll(Arrays.asList(nodeArray))) {
                    return false;
                }
            }
            this.refresh();
            return true;
        }

        private final class AE
        implements Entry {
            AE() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Collection<Node> nodes(Object object) {
                Collection<Node> collection = Array.this.getCollection();
                if (collection.isEmpty()) {
                    return Collections.emptyList();
                }
                Object object2 = COLLECTION_LOCK;
                synchronized (object2) {
                    return new ArrayList<Node>(collection);
                }
            }

            public String toString() {
                return "Children.Array.AE" + Array.this.getCollection();
            }
        }
    }

    private static final class Empty
    extends Children {
        Empty() {
        }

        @Override
        public boolean add(Node[] nodeArray) {
            return false;
        }

        @Override
        public boolean remove(Node[] nodeArray) {
            return false;
        }
    }

    static interface Entry {
        public Collection<Node> nodes(Object var1);
    }
}

