/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.internal.toolkit.builders;

import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.PropertyWriter;
import com.javafx.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import com.javafx.tools.doclets.internal.toolkit.builders.XMLNode;
import com.javafx.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyBuilder
extends AbstractMemberBuilder {
    private ClassDoc classDoc;
    private VisibleMemberMap visibleMemberMap;
    private PropertyWriter writer;
    private List<ProgramElementDoc> fields;
    private int currentFieldIndex;

    private PropertyBuilder(Configuration configuration) {
        super(configuration);
    }

    public static PropertyBuilder getInstance(Configuration configuration, ClassDoc classDoc, PropertyWriter writer) {
        PropertyBuilder builder = new PropertyBuilder(configuration);
        builder.classDoc = classDoc;
        builder.writer = writer;
        builder.visibleMemberMap = new VisibleMemberMap(classDoc, 7, configuration.nodeprecated);
        builder.fields = new ArrayList<ProgramElementDoc>(builder.visibleMemberMap.getMembersFor(classDoc));
        if (configuration.getMemberComparator() != null) {
            Collections.sort(builder.fields, configuration.getMemberComparator());
        }
        return builder;
    }

    @Override
    public String getName() {
        return "PropertyDetails";
    }

    public List<ProgramElementDoc> members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    @Override
    public boolean hasMembersToDocument() {
        return this.fields.size() > 0;
    }

    public void buildPropertyDoc(XMLNode node, Content memberDetailsTree) {
        if (this.writer == null) {
            return;
        }
        int size = this.fields.size();
        if (size > 0) {
            Content fieldDetailsTree = this.writer.getFieldDetailsTreeHeader(this.classDoc, memberDetailsTree);
            this.currentFieldIndex = 0;
            while (this.currentFieldIndex < size) {
                Content fieldDocTree = this.writer.getFieldDocTreeHeader((MethodDoc)this.fields.get(this.currentFieldIndex), fieldDetailsTree);
                this.buildChildren(node, fieldDocTree);
                fieldDetailsTree.addContent(this.writer.getFieldDoc(fieldDocTree, this.currentFieldIndex == size - 1));
                ++this.currentFieldIndex;
            }
            memberDetailsTree.addContent(this.writer.getFieldDetails(fieldDetailsTree));
        }
    }

    public void buildSignature(XMLNode node, Content fieldDocTree) {
        fieldDocTree.addContent(this.writer.getSignature((MethodDoc)this.fields.get(this.currentFieldIndex)));
    }

    public void buildDeprecationInfo(XMLNode node, Content fieldDocTree) {
        this.writer.addDeprecated((MethodDoc)this.fields.get(this.currentFieldIndex), fieldDocTree);
    }

    public void buildPropertyComments(XMLNode node, Content fieldDocTree) {
        if (!this.configuration.nocomment) {
            this.writer.addComments((MethodDoc)this.fields.get(this.currentFieldIndex), fieldDocTree);
        }
    }

    public void buildTagInfo(XMLNode node, Content fieldDocTree) {
        this.writer.addTags((MethodDoc)this.fields.get(this.currentFieldIndex), fieldDocTree);
    }

    public PropertyWriter getWriter() {
        return this.writer;
    }
}

