/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.watcher;

import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import org.netbeans.modules.masterfs.watcher.Watcher;
import org.openide.filesystems.FileObject;

public abstract class Notifier<KEY> {
    public abstract KEY addWatch(String var1) throws IOException;

    public abstract void removeWatch(KEY var1) throws IOException;

    public abstract String nextEvent() throws IOException, InterruptedException;

    protected void stop() throws IOException {
    }

    class KeyRef
    extends WeakReference<FileObject> {
        private final KEY key;
        private final int hash;

        public KeyRef(FileObject fileObject, KEY KEY, ReferenceQueue<FileObject> referenceQueue) {
            super(fileObject, referenceQueue);
            this.key = KEY;
            this.hash = fileObject.hashCode();
            if (KEY != null) {
                Watcher.LOG.log(Level.FINE, "Adding watch for {0}", KEY);
            }
        }

        @Override
        public FileObject get() {
            return (FileObject)super.get();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            try {
                KeyRef keyRef = (KeyRef)object;
                FileObject fileObject = this.get();
                FileObject fileObject2 = keyRef.get();
                if (fileObject == null) {
                    return fileObject2 == null;
                }
                return fileObject.equals(fileObject2);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        final void removeWatch() throws IOException {
            Watcher.LOG.log(Level.FINE, "Removing watch for {0}", this.key);
            Notifier.this.removeWatch(this.key);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

