/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.etable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.ETableColumn;
import org.netbeans.swing.etable.ETableColumnModel;

class ETableHeader
extends JTableHeader {
    public ETableHeader() {
    }

    public ETableHeader(TableColumnModel tableColumnModel) {
        super(tableColumnModel);
    }

    @Override
    public void setDefaultRenderer(TableCellRenderer tableCellRenderer) {
        super.setDefaultRenderer(new ETableHeaderRenderer(tableCellRenderer));
    }

    private static Icon mergeIcons(Icon icon, Icon icon2, int n, int n2, Component component) {
        int n3 = 0;
        int n4 = 0;
        if (icon != null) {
            n3 = icon.getIconWidth();
            n4 = icon.getIconHeight();
        }
        if (icon2 != null) {
            n3 = icon2.getIconWidth() + n > n3 ? icon2.getIconWidth() + n : n3;
            int n5 = n4 = icon2.getIconHeight() + n2 > n4 ? icon2.getIconHeight() + n2 : n4;
        }
        if (n3 < 1) {
            n3 = 16;
        }
        if (n4 < 1) {
            n4 = 16;
        }
        ColorModel colorModel = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(2);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n3, n4), colorModel.isAlphaPremultiplied(), null);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (icon != null) {
            icon.paintIcon(component, graphics2D, 0, 0);
        }
        if (icon2 != null) {
            icon2.paintIcon(component, graphics2D, n, n2);
        }
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    private static class SortUpIcon
    implements Icon {
        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.BLACK);
            graphics.drawLine(n, n2 + 6, n + 8, n2 + 6);
            graphics.drawLine(n, n2 + 6, n + 4, n2 + 2);
            graphics.drawLine(n + 8, n2 + 6, n + 4, n2 + 2);
        }
    }

    private static class SortDownIcon
    implements Icon {
        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.BLACK);
            graphics.drawLine(n, n2 + 2, n + 8, n2 + 2);
            graphics.drawLine(n, n2 + 2, n + 4, n2 + 6);
            graphics.drawLine(n + 8, n2 + 2, n + 4, n2 + 6);
        }
    }

    private class ETableHeaderRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        private TableCellRenderer headerRendererUI;
        private Map<ETableColumn, TableCellRenderer> defaultColumnHeaderRenderers = new HashMap<ETableColumn, TableCellRenderer>();

        private ETableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.headerRendererUI = tableCellRenderer;
        }

        @Override
        public void setBorder(Border border) {
            super.setBorder(border);
            if (this.headerRendererUI instanceof JComponent) {
                ((JComponent)((Object)this.headerRendererUI)).setBorder(border);
            }
        }

        private TableCellRenderer getColumnHeaderRenderer(TableColumn tableColumn) {
            if (tableColumn instanceof ETableColumn) {
                TableCellRenderer tableCellRenderer;
                ETableColumn eTableColumn = (ETableColumn)tableColumn;
                if (!this.defaultColumnHeaderRenderers.containsKey(eTableColumn)) {
                    TableCellRenderer tableCellRenderer2 = eTableColumn.createDefaultHeaderRenderer();
                    if (tableCellRenderer2 instanceof ETableColumn.ETableColumnHeaderRendererDelegate) {
                        this.defaultColumnHeaderRenderers.put(eTableColumn, null);
                        tableCellRenderer = null;
                    } else {
                        eTableColumn.setTableHeaderRendererDelegate(this.headerRendererUI);
                        tableCellRenderer = tableCellRenderer2;
                    }
                } else {
                    tableCellRenderer = this.defaultColumnHeaderRenderers.get(eTableColumn);
                }
                if (tableCellRenderer != null) {
                    return tableCellRenderer;
                }
                return this.headerRendererUI;
            }
            return this.headerRendererUI;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            TableColumn tableColumn = ETableHeader.this.getColumnModel().getColumn(n2);
            TableCellRenderer tableCellRenderer = this.getColumnHeaderRenderer(tableColumn);
            Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel) {
                Object object2;
                Object object3;
                JLabel jLabel = (JLabel)component;
                LabelUI labelUI = jLabel.getUI();
                labelUI.installUI(jLabel);
                String string = "";
                if (object != null) {
                    string = object.toString();
                }
                if (jTable instanceof ETable) {
                    object3 = (ETable)jTable;
                    string = ((ETable)object3).getColumnDisplayName(string);
                }
                object3 = null;
                List<TableColumn> list = ((ETableColumnModel)jTable.getColumnModel()).getSortedColumns();
                int n3 = 0;
                boolean bl3 = false;
                Icon icon = null;
                if (tableColumn instanceof ETableColumn) {
                    object2 = (ETableColumn)tableColumn;
                    n3 = ((ETableColumn)object2).getSortRank();
                    bl3 = ((ETableColumn)object2).isAscending();
                    icon = ((ETableColumn)object2).getCustomIcon();
                }
                if (n3 != 0) {
                    if (list.size() > 1) {
                        string = string == null || string.isEmpty() ? Integer.toString(n3) : n3 + " " + string;
                    }
                    jLabel.setFont(new Font(this.getFont().getName(), 1, this.getFont().getSize()));
                    if (bl3) {
                        object3 = UIManager.getIcon("ETableHeader.ascendingIcon");
                        if (object3 == null) {
                            object3 = new SortUpIcon();
                        }
                    } else {
                        object3 = UIManager.getIcon("ETableHeader.descendingIcon");
                        if (object3 == null) {
                            object3 = new SortDownIcon();
                        }
                    }
                }
                jLabel.setText(string);
                if (object3 == null) {
                    if (icon == null) {
                        object2 = new Icon(){

                            @Override
                            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                            }

                            @Override
                            public int getIconWidth() {
                                return 0;
                            }

                            @Override
                            public int getIconHeight() {
                                return 0;
                            }
                        };
                        jLabel.setIcon((Icon)object2);
                    } else {
                        jLabel.setIcon(icon);
                    }
                } else if (icon == null) {
                    jLabel.setIcon((Icon)object3);
                } else {
                    jLabel.setIcon(ETableHeader.mergeIcons(icon, (Icon)object3, 16, 0, this));
                }
            }
            return component;
        }
    }
}

