/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.etable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.ETableColumn;
import org.netbeans.swing.etable.TableColumnSelector;

public class ETableColumnModel
extends DefaultTableColumnModel {
    private static final String NUMBER_OF_COLUMNS = "ColumnsNumber";
    private static final String NUMBER_OF_HIDDEN_COLUMNS = "HiddenColumnsNumber";
    private static final String PROP_HIDDEN_PREFIX = "Hidden";
    private static final String PROP_HIDDEN_POSITION_PREFIX = "HiddenPosition";
    protected transient List<TableColumn> sortedColumns = new ArrayList<TableColumn>();
    protected List<TableColumn> hiddenColumns = new ArrayList<TableColumn>();
    List<Integer> hiddenColumnsPosition = new ArrayList<Integer>();
    private TableColumnSelector.TreeNode columnHierarchyRoot;

    public void readSettings(Properties properties, String string, ETable eTable) {
        Object object;
        int n;
        this.tableColumns = new Vector();
        this.sortedColumns = new ArrayList<TableColumn>();
        String string2 = properties.getProperty(string + NUMBER_OF_COLUMNS);
        int n2 = Integer.parseInt(string2);
        for (int i = 0; i < n2; ++i) {
            ETableColumn eTableColumn = (ETableColumn)eTable.createColumn(i);
            eTableColumn.readSettings(properties, i, string);
            this.addColumn(eTableColumn);
            if (eTableColumn.getComparator() == null) continue;
            for (n = 0; n < this.sortedColumns.size() && ((ETableColumn)(object = (ETableColumn)this.sortedColumns.get(n))).getSortRank() <= eTableColumn.getSortRank(); ++n) {
            }
            this.sortedColumns.add(n, eTableColumn);
        }
        this.hiddenColumns = new ArrayList<TableColumn>();
        String string3 = properties.getProperty(string + NUMBER_OF_HIDDEN_COLUMNS);
        int n3 = Integer.parseInt(string3);
        for (n = 0; n < n3; ++n) {
            object = new ETableColumn(eTable);
            ((ETableColumn)object).readSettings(properties, n, string + PROP_HIDDEN_PREFIX);
            this.hiddenColumns.add((TableColumn)object);
        }
        this.hiddenColumnsPosition = new ArrayList<Integer>();
        for (n = 0; n < n3; ++n) {
            object = string + PROP_HIDDEN_POSITION_PREFIX + "ETableColumn-" + Integer.toString(n);
            String string4 = properties.getProperty((String)object);
            int n4 = Integer.parseInt(string4);
            this.hiddenColumnsPosition.add(n4);
        }
    }

    public void writeSettings(Properties properties, String string) {
        int n = 0;
        int n2 = this.tableColumns.size();
        properties.setProperty(string + NUMBER_OF_COLUMNS, Integer.toString(n2));
        for (Object object2 : this.tableColumns) {
            if (!(object2 instanceof ETableColumn)) continue;
            ETableColumn object3 = (ETableColumn)object2;
            object3.writeSettings(properties, n++, string);
        }
        n = 0;
        int n3 = this.hiddenColumns.size();
        properties.setProperty(string + NUMBER_OF_HIDDEN_COLUMNS, Integer.toString(n3));
        for (Object e : this.hiddenColumns) {
            if (!(e instanceof ETableColumn)) continue;
            ETableColumn eTableColumn = (ETableColumn)e;
            eTableColumn.writeSettings(properties, n++, string + PROP_HIDDEN_PREFIX);
        }
        for (n = 0; n < n3; ++n) {
            int n4 = this.hiddenColumnsPosition.get(n);
            String string2 = string + PROP_HIDDEN_POSITION_PREFIX + "ETableColumn-" + Integer.toString(n);
            properties.setProperty(string2, Integer.toString(n4));
        }
    }

    public Comparator<ETable.RowMapping> getComparator() {
        if (this.sortedColumns.isEmpty()) {
            return new ETable.OriginalRowComparator();
        }
        return new CompoundComparator();
    }

    public void setColumnSorted(ETableColumn eTableColumn, boolean bl, int n) {
        if (!eTableColumn.isSortingAllowed()) {
            return;
        }
        boolean bl2 = this.sortedColumns.contains(eTableColumn);
        if (bl2) {
            eTableColumn.setAscending(bl);
            eTableColumn.setSortRank(n);
            this.sortedColumns.remove(eTableColumn);
        } else {
            eTableColumn.setSorted(n, bl);
        }
        if (n > 0) {
            this.sortedColumns.add(n - 1, eTableColumn);
        }
    }

    void toggleSortedColumn(ETableColumn eTableColumn, boolean bl) {
        if (!eTableColumn.isSortingAllowed()) {
            return;
        }
        boolean bl2 = this.sortedColumns.contains(eTableColumn);
        if (bl) {
            this.clearSortedColumns(eTableColumn);
        }
        if (bl2) {
            if (eTableColumn.isAscending()) {
                eTableColumn.setAscending(false);
            } else {
                this.sortedColumns.remove(eTableColumn);
                eTableColumn.setSorted(0, false);
            }
            this.updateRanks();
        } else {
            eTableColumn.setSorted(this.sortedColumns.size() + 1, true);
            this.sortedColumns.add(eTableColumn);
        }
    }

    @Override
    public void removeColumn(TableColumn tableColumn) {
        if (this.sortedColumns.remove(tableColumn)) {
            int n = 1;
            for (TableColumn tableColumn2 : this.sortedColumns) {
                if (tableColumn2 instanceof ETableColumn) {
                    ETableColumn eTableColumn = (ETableColumn)tableColumn2;
                    eTableColumn.setSorted(n, eTableColumn.isAscending());
                }
                ++n;
            }
        }
        if (this.removeHiddenColumn(tableColumn) < 0) {
            super.removeColumn(tableColumn);
        }
    }

    private int removeHiddenColumn(TableColumn tableColumn) {
        int n = -1;
        for (int i = 0; i < this.hiddenColumns.size(); ++i) {
            if (!tableColumn.equals(this.hiddenColumns.get(i))) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            this.hiddenColumns.remove(n);
            return this.hiddenColumnsPosition.remove(n);
        }
        return -1;
    }

    public void setColumnHidden(TableColumn tableColumn, boolean bl) {
        int n;
        if (bl) {
            int n2;
            if (!this.hiddenColumns.contains(tableColumn) && (n2 = this.tableColumns.indexOf(tableColumn)) >= 0) {
                this.removeColumn(tableColumn);
                this.hiddenColumns.add(tableColumn);
                for (Integer n3 : this.hiddenColumnsPosition) {
                    if (n3 > n2) continue;
                    ++n2;
                }
                while (this.hiddenColumnsPosition.contains(n2)) {
                    ++n2;
                }
                this.hiddenColumnsPosition.add(n2);
            }
        } else if (!this.tableColumns.contains(tableColumn) && (n = this.removeHiddenColumn(tableColumn)) >= 0) {
            for (Integer n4 : this.hiddenColumnsPosition) {
                if (n4 >= n) continue;
                --n;
            }
            n = Math.min(n, this.tableColumns.size());
            this.addColumn(tableColumn, n);
        }
    }

    private void addColumn(TableColumn tableColumn, int n) {
        if (tableColumn == null) {
            throw new IllegalArgumentException("Object is null");
        }
        this.tableColumns.insertElementAt(tableColumn, n);
        tableColumn.addPropertyChangeListener(this);
        this.totalColumnWidth = -1;
        this.fireColumnAdded(new TableColumnModelEvent(this, 0, n));
    }

    List<TableColumn> getAllColumns() {
        ArrayList<TableColumn> arrayList = Collections.list(this.getColumns());
        int n = this.hiddenColumns.size();
        for (int i = 0; i < n; ++i) {
            int n2 = this.hiddenColumnsPosition.get(i);
            n2 = Math.min(n2, arrayList.size());
            arrayList.add(n2, this.hiddenColumns.get(i));
        }
        return arrayList;
    }

    public boolean isColumnHidden(TableColumn tableColumn) {
        return this.hiddenColumns.contains(tableColumn);
    }

    public void clearSortedColumns() {
        for (TableColumn tableColumn : this.sortedColumns) {
            if (!(tableColumn instanceof ETableColumn)) continue;
            ETableColumn eTableColumn = (ETableColumn)tableColumn;
            eTableColumn.setSorted(0, false);
        }
        this.sortedColumns = new ArrayList<TableColumn>();
    }

    void clearSortedColumns(TableColumn tableColumn) {
        boolean bl = this.sortedColumns.contains(tableColumn);
        for (TableColumn tableColumn2 : this.sortedColumns) {
            if (!(tableColumn2 instanceof ETableColumn) || tableColumn2 == tableColumn) continue;
            ETableColumn eTableColumn = (ETableColumn)tableColumn2;
            eTableColumn.setSorted(0, false);
        }
        this.sortedColumns = new ArrayList<TableColumn>();
        if (bl) {
            this.sortedColumns.add(tableColumn);
        }
    }

    private void updateRanks() {
        int n = 1;
        for (TableColumn tableColumn : this.sortedColumns) {
            ETableColumn eTableColumn;
            if (tableColumn instanceof ETableColumn && (eTableColumn = (ETableColumn)tableColumn).isSorted()) {
                eTableColumn.setSortRank(n);
            }
            ++n;
        }
    }

    List<TableColumn> getSortedColumns() {
        return this.sortedColumns;
    }

    public void clean() {
        ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>(this.tableColumns.size() + this.hiddenColumns.size());
        arrayList.addAll(this.tableColumns);
        arrayList.addAll(this.hiddenColumns);
        for (TableColumn tableColumn : arrayList) {
            this.removeColumn(tableColumn);
        }
    }

    public TableColumnSelector.TreeNode getColumnHierarchyRoot() {
        return this.columnHierarchyRoot;
    }

    public void setColumnHierarchyRoot(TableColumnSelector.TreeNode treeNode) {
        this.columnHierarchyRoot = treeNode;
    }

    private class CompoundComparator
    implements Comparator<ETable.RowMapping> {
        private Comparator<ETable.RowMapping> original = new ETable.OriginalRowComparator();

        @Override
        public int compare(ETable.RowMapping rowMapping, ETable.RowMapping rowMapping2) {
            for (TableColumn tableColumn : ETableColumnModel.this.sortedColumns) {
                int n;
                ETableColumn eTableColumn;
                Comparator<ETable.RowMapping> comparator;
                if (!(tableColumn instanceof ETableColumn) || (comparator = (eTableColumn = (ETableColumn)tableColumn).getComparator()) == null || (n = comparator.compare(rowMapping, rowMapping2)) == 0) continue;
                return n;
            }
            return this.original.compare(rowMapping, rowMapping2);
        }
    }
}

