/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.etable;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.ETableColumn;
import org.netbeans.swing.etable.ETableColumnModel;
import org.netbeans.swing.etable.TableColumnSelector;

class ColumnSelectionPanel
extends JPanel {
    private static final String COLUMNS_SELECTOR_HINT = "ColumnsSelectorHint";
    private Map<ETableColumn, JCheckBox> checkBoxes = new HashMap<ETableColumn, JCheckBox>();
    private ETableColumnModel columnModel;

    public ColumnSelectionPanel(ETable eTable) {
        ETableColumnModel eTableColumnModel;
        TableColumnModel tableColumnModel = eTable.getColumnModel();
        if (!(tableColumnModel instanceof ETableColumnModel)) {
            return;
        }
        this.columnModel = eTableColumnModel = (ETableColumnModel)tableColumnModel;
        List<TableColumn> list = eTableColumnModel.getAllColumns();
        Collections.sort(list, ETableColumnComparator.DEFAULT);
        int n = 1;
        JPanel jPanel = this.layoutPanel(list, n, eTable);
        Dimension dimension = jPanel.getPreferredSize();
        final Rectangle rectangle = ColumnSelectionPanel.getUsableScreenBounds(ColumnSelectionPanel.getCurrentGraphicsConfiguration());
        JComponent jComponent = null;
        if (dimension.width > rectangle.width - 100 || dimension.height > rectangle.height - 100) {
            JScrollPane jScrollPane = new JScrollPane(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension dimension = new Dimension(super.getPreferredSize());
                    if (dimension.width > rectangle.width - 100) {
                        dimension.width = rectangle.width * 3 / 4;
                    }
                    if (dimension.height > rectangle.height - 100) {
                        dimension.height = rectangle.height * 3 / 4;
                    }
                    return dimension;
                }
            };
            jScrollPane.setViewportView(jPanel);
            jComponent = jScrollPane;
        } else {
            jComponent = jPanel;
        }
        this.add(jComponent);
    }

    private JPanel layoutPanel(List<TableColumn> list, int n, ETable eTable) {
        Object object;
        String string;
        ArrayList<Object> arrayList;
        Object object2;
        JPanel jPanel = new JPanel(new GridBagLayout());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            ETableColumn eTableColumn = (ETableColumn)list.get(i);
            Object object3 = new JCheckBox();
            Object object4 = eTable.transformValue(eTableColumn);
            String string2 = object4 == eTableColumn || object4 == null ? eTableColumn.getHeaderValue().toString() : object4.toString();
            ((AbstractButton)object3).setText(string2);
            object2 = (JCheckBox)eTable.transformValue(object3);
            if (object2 != null) {
                object3 = object2;
            }
            this.checkBoxes.put(eTableColumn, (JCheckBox)object3);
            ((AbstractButton)object3).setSelected(!this.columnModel.isColumnHidden(eTableColumn));
            ((AbstractButton)object3).setEnabled(eTableColumn.isHidingAllowed());
            if (!arrayList2.contains(string2)) {
                hashMap.put(string2, object3);
            } else {
                arrayList = null;
                string = hashMap.get(string2);
                if (string instanceof JCheckBox) {
                    object = (JCheckBox)((Object)string);
                    arrayList = new ArrayList<Object>();
                    arrayList.add(object);
                } else if (string instanceof ArrayList) {
                    arrayList = (ArrayList)((Object)string);
                } else {
                    throw new IllegalStateException("Wrong object theFirstOne is " + string);
                }
                arrayList.add(object3);
                hashMap.put(string2, arrayList);
            }
            arrayList2.add(string2);
        }
        String string3 = (String)arrayList2.remove(0);
        Collections.sort(arrayList2, Collator.getInstance());
        arrayList2.add(0, string3);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = list.size() / n;
        object2 = eTable.transformValue(COLUMNS_SELECTOR_HINT);
        if (object2 != null) {
            arrayList = new GridBagConstraints();
            ((GridBagConstraints)((Object)arrayList)).gridx = 0;
            ((GridBagConstraints)((Object)arrayList)).gridy = 0;
            ((GridBagConstraints)((Object)arrayList)).insets = new Insets(5, 12, 12, 12);
            ((GridBagConstraints)((Object)arrayList)).anchor = 18;
            jPanel.add((Component)new JLabel(object2.toString()), arrayList);
        }
        arrayList = arrayList2.iterator();
        while (arrayList.hasNext()) {
            Cloneable cloneable;
            if (n2 >= n5) {
                n2 = 0;
                ++n3;
            }
            string = (String)arrayList.next();
            object = hashMap.get(string);
            JCheckBox jCheckBox = null;
            if (object instanceof JCheckBox) {
                jCheckBox = (JCheckBox)object;
            } else if (object instanceof ArrayList) {
                cloneable = (ArrayList)object;
                if (n4 >= ((ArrayList)cloneable).size()) {
                    n4 = 0;
                }
                jCheckBox = (JCheckBox)((ArrayList)cloneable).get(n4++);
            } else {
                throw new IllegalStateException("Wrong object obj is " + object);
            }
            cloneable = new GridBagConstraints();
            ((GridBagConstraints)cloneable).gridx = n3;
            ((GridBagConstraints)cloneable).gridy = n2 + (object2 == null ? n2 : n2 + 1);
            ((GridBagConstraints)cloneable).insets = new Insets(0, 12, 0, 12);
            ((GridBagConstraints)cloneable).anchor = 18;
            ((GridBagConstraints)cloneable).weightx = 1.0;
            jPanel.add((Component)jCheckBox, cloneable);
            ++n2;
        }
        return jPanel;
    }

    public void changeColumnVisibility() {
        if (this.columnModel == null) {
            return;
        }
        Iterator<ETableColumn> iterator = this.checkBoxes.keySet().iterator();
        while (iterator.hasNext()) {
            ETableColumn eTableColumn;
            JCheckBox jCheckBox = this.checkBoxes.get(eTableColumn = iterator.next());
            this.columnModel.setColumnHidden(eTableColumn, !jCheckBox.isSelected());
        }
    }

    static void showColumnSelectionPopupOrDialog(Component component, ETable eTable) {
        if (eTable.isPopupUsedFromTheCorner()) {
            ColumnSelectionPanel.showColumnSelectionPopup(component, eTable);
        } else {
            ColumnSelectionPanel.showColumnSelectionDialog(eTable);
        }
    }

    static void showColumnSelectionPopup(Component component, ETable eTable) {
        ColumnSelectionPanel.showColumnSelectionPopup(component, 8, 8, eTable);
    }

    static void showColumnSelectionPopup(Component component, int n, int n2, final ETable eTable) {
        if (!eTable.isColumnHidingAllowed()) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        TableColumnModel tableColumnModel = eTable.getColumnModel();
        if (!(tableColumnModel instanceof ETableColumnModel)) {
            return;
        }
        TableColumnSelector tableColumnSelector = eTable.getColumnSelector();
        if (tableColumnSelector != null && !eTable.isPopupUsedFromTheCorner()) {
            JMenuItem jMenuItem = new JMenuItem(eTable.getSelectVisibleColumnsLabel());
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ColumnSelectionPanel.showColumnSelectionDialog(eTable);
                }
            });
            jPopupMenu.add(jMenuItem);
        } else {
            Object object;
            Object object2;
            Object object3;
            final ETableColumnModel eTableColumnModel = (ETableColumnModel)tableColumnModel;
            List<TableColumn> list = eTableColumnModel.getAllColumns();
            Collections.sort(list, ETableColumnComparator.DEFAULT);
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (final ETableColumn object4 : list) {
                Object object5 = new JCheckBoxMenuItem();
                object3 = eTable.transformValue(object4);
                object2 = object3 == object4 || object3 == null ? object4.getHeaderValue().toString() : object3.toString();
                ((AbstractButton)object5).setText((String)object2);
                object5 = (JCheckBoxMenuItem)eTable.transformValue(object5);
                ((AbstractButton)object5).setSelected(!eTableColumnModel.isColumnHidden(object4));
                ((JMenuItem)object5).setEnabled(object4.isHidingAllowed());
                object = object5;
                ((AbstractButton)object5).addActionListener(new ActionListener((JCheckBoxMenuItem)object, eTable){
                    final /* synthetic */ JCheckBoxMenuItem val$finalChB;
                    final /* synthetic */ ETable val$table;
                    {
                        this.val$finalChB = jCheckBoxMenuItem;
                        this.val$table = eTable;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        eTableColumnModel.setColumnHidden(object4, !this.val$finalChB.isSelected());
                        this.val$table.updateColumnSelectionMouseListener();
                    }
                });
                if (!arrayList.contains(object2)) {
                    hashMap.put(object2, object5);
                } else {
                    ArrayList<Object> arrayList2 = null;
                    Object v = hashMap.get(object2);
                    if (v instanceof JCheckBoxMenuItem) {
                        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)v;
                        arrayList2 = new ArrayList<Object>();
                        arrayList2.add(jCheckBoxMenuItem);
                    } else if (v instanceof ArrayList) {
                        arrayList2 = (ArrayList<Object>)v;
                    } else {
                        throw new IllegalStateException("Wrong object theFirstOne is " + v);
                    }
                    arrayList2.add(object5);
                    hashMap.put(object2, arrayList2);
                }
                arrayList.add(object2);
            }
            Collections.sort(arrayList, Collator.getInstance());
            int n3 = 0;
            for (Object object5 : arrayList) {
                object3 = hashMap.get(object5);
                object2 = null;
                if (object3 instanceof JCheckBoxMenuItem) {
                    object2 = (JCheckBoxMenuItem)object3;
                } else if (object3 instanceof ArrayList) {
                    object = (ArrayList)object3;
                    if (n3 >= ((ArrayList)object).size()) {
                        n3 = 0;
                    }
                    object2 = (JCheckBoxMenuItem)((ArrayList)object).get(n3++);
                } else {
                    throw new IllegalStateException("Wrong object obj is " + object3);
                }
                jPopupMenu.add((JMenuItem)object2);
            }
        }
        jPopupMenu.show(component, n, n2);
    }

    static void showColumnSelectionDialog(ETable eTable) {
        if (!eTable.isColumnHidingAllowed()) {
            return;
        }
        TableColumnSelector tableColumnSelector = eTable.getColumnSelector();
        if (tableColumnSelector != null) {
            ETableColumnModel eTableColumnModel = (ETableColumnModel)eTable.getColumnModel();
            TableColumnSelector.TreeNode treeNode = eTableColumnModel.getColumnHierarchyRoot();
            if (treeNode != null) {
                String[] stringArray = ColumnSelectionPanel.getAvailableColumnNames(eTable, true);
                String[] stringArray2 = tableColumnSelector.selectVisibleColumns(treeNode, stringArray);
                ColumnSelectionPanel.makeVisibleColumns(eTable, stringArray2);
            } else {
                String[] stringArray = ColumnSelectionPanel.getAvailableColumnNames(eTable, false);
                String[] stringArray3 = ColumnSelectionPanel.getAvailableColumnNames(eTable, true);
                String[] stringArray4 = tableColumnSelector.selectVisibleColumns(stringArray, stringArray3);
                ColumnSelectionPanel.makeVisibleColumns(eTable, stringArray4);
            }
            return;
        }
        ColumnSelectionPanel columnSelectionPanel = new ColumnSelectionPanel(eTable);
        int n = JOptionPane.showConfirmDialog(null, columnSelectionPanel, eTable.getSelectVisibleColumnsLabel(), 2);
        if (n == 0) {
            columnSelectionPanel.changeColumnVisibility();
            eTable.updateColumnSelectionMouseListener();
        }
    }

    private static void makeVisibleColumns(ETable eTable, String[] stringArray) {
        ETableColumn eTableColumn;
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        TableColumnModel tableColumnModel = eTable.getColumnModel();
        if (!(tableColumnModel instanceof ETableColumnModel)) {
            return;
        }
        ETableColumnModel eTableColumnModel = (ETableColumnModel)tableColumnModel;
        List<TableColumn> list = eTableColumnModel.getAllColumns();
        Collections.sort(list, ETableColumnComparator.DEFAULT);
        HashMap<String, ETableColumn> hashMap = new HashMap<String, ETableColumn>();
        Iterator<TableColumn> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = eTable.getColumnDisplayName((eTableColumn = (ETableColumn)iterator.next()).getHeaderValue().toString());
            eTableColumnModel.setColumnHidden(eTableColumn, !hashSet.contains(string));
            hashMap.put(string, eTableColumn);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            eTableColumn = (ETableColumn)hashMap.get(stringArray[i]);
            if (eTableColumn == null) {
                throw new IllegalStateException("Cannot find column with name " + stringArray[i]);
            }
            int n = eTableColumnModel.getColumnIndex(eTableColumn.getIdentifier());
            eTableColumnModel.moveColumn(n, i);
        }
    }

    private static String[] getAvailableColumnNames(ETable eTable, boolean bl) {
        TableColumnModel tableColumnModel = eTable.getColumnModel();
        if (!(tableColumnModel instanceof ETableColumnModel)) {
            return new String[0];
        }
        ETableColumnModel eTableColumnModel = (ETableColumnModel)tableColumnModel;
        List<TableColumn> list = bl ? Collections.list(eTableColumnModel.getColumns()) : eTableColumnModel.getAllColumns();
        Collections.sort(list, ETableColumnComparator.DEFAULT);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ETableColumn eTableColumn : list) {
            String string = eTable.getColumnDisplayName(eTableColumn.getHeaderValue().toString());
            arrayList.add(string);
        }
        Collections.sort(arrayList, Collator.getInstance());
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static GraphicsConfiguration getCurrentGraphicsConfiguration() {
        Window window;
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component != null && (window = SwingUtilities.getWindowAncestor(component)) != null) {
            return window.getGraphicsConfiguration();
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    private static Rectangle getUsableScreenBounds(GraphicsConfiguration graphicsConfiguration) {
        if (graphicsConfiguration == null) {
            graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        return new Rectangle(graphicsConfiguration.getBounds());
    }

    private static class ETableColumnComparator
    implements Comparator<TableColumn> {
        public static final ETableColumnComparator DEFAULT = new ETableColumnComparator();

        private ETableColumnComparator() {
        }

        @Override
        public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
            if (tableColumn instanceof ETableColumn && tableColumn2 instanceof ETableColumn) {
                ((ETableColumn)tableColumn).compareTo((ETableColumn)tableColumn2);
            }
            return 0;
        }
    }
}

