/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.applemenu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class ShowInFinder
implements ActionListener {
    private static final String APPLE_SCRIPT = "AppleScriptEngine";
    private static final String SCRIPT = "org/netbeans/modules/applemenu/resources/select_file.scpt";
    private static final Logger LOG = Logger.getLogger(ShowInFinder.class.getName());
    private static volatile String script;
    private final DataObject context;

    public ShowInFinder(DataObject dataObject) {
        this.context = dataObject;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        FileObject fileObject = this.context.getPrimaryFile();
        if (fileObject == null) {
            return;
        }
        LOG.log(Level.FINE, "Selected file: {0}", FileUtil.getFileDisplayName((FileObject)fileObject));
        if (FileUtil.getArchiveFile((FileObject)fileObject) != null) {
            fileObject = FileUtil.getArchiveFile((FileObject)fileObject);
        }
        LOG.log(Level.FINE, "File to select in Finder: {0}", FileUtil.getFileDisplayName((FileObject)fileObject));
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            LOG.log(Level.INFO, "Ignoring non local file: {0}", FileUtil.getFileDisplayName((FileObject)fileObject));
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ShowInFinder.class, (String)"TXT_NoLocalFile"));
            return;
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            LOG.log(Level.INFO, "Ignoring file with no parent: {0}", FileUtil.getFileDisplayName((FileObject)fileObject));
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ShowInFinder.class, (String)"TXT_NoLocalFile"));
            return;
        }
        String string = ShowInFinder.getScript();
        if (string == null) {
            LOG.log(Level.INFO, "Cannot load apple scipt program");
            return;
        }
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (classLoader == null) {
            LOG.log(Level.INFO, "No ClassLoader to load AppleScriptEngine");
            return;
        }
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager(classLoader);
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName(APPLE_SCRIPT);
        if (scriptEngine == null) {
            LOG.log(Level.INFO, "No AppleScriptEngine found");
            return;
        }
        try {
            scriptEngine.eval(MessageFormat.format(string, file2.getAbsolutePath(), file.getAbsolutePath()));
        }
        catch (ScriptException scriptException) {
            Exceptions.printStackTrace((Throwable)scriptException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getScript() {
        String string = script;
        if (string != null) {
            return string;
        }
        try {
            ClassLoader classLoader = ShowInFinder.class.getClassLoader();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(SCRIPT), "UTF-8"));
            try {
                int n;
                StringBuilder stringBuilder = new StringBuilder();
                char[] cArray = new char[512];
                while ((n = bufferedReader.read(cArray, 0, cArray.length)) > 0) {
                    stringBuilder.append(cArray, 0, n);
                }
                string = stringBuilder.toString();
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        script = string;
        return string;
    }
}

